/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.charteditor.UILocale;
import com.spss.java_client.ui.dialogs.base.edit.ChartsColorsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.drop_menu_button.ColorItemDescriptor;
import com.spss.uitools.drop_menu_button.ColorMenuPicker;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWellPanel
extends JPanel
implements ChangeListener,
ActionListener {
    static final int COLORWELL_WIDTH = 153;
    static final int COLORWELL_HEIGHT = 216;
    Color[] colors = null;
    Color[] rcolors = new Color[]{new Color(225, 188, 29), new Color(92, 202, 136), new Color(0, 180, 160), new Color(227, 215, 16), new Color(236, 230, 208), new Color(254, 130, 180), new Color(204, 134, 63), new Color(63, 235, 124), new Color(28, 205, 205), new Color(207, 172, 227), new Color(208, 202, 140), new Color(237, 75, 75), new Color(225, 139, 14), new Color(95, 195, 56), new Color(85, 150, 230), new Color(204, 127, 228), new Color(150, 145, 145), new Color(215, 0, 51), new Color(208, 83, 52), new Color(41, 134, 38), new Color(63, 90, 168), new Color(171, 73, 243), new Color(90, 100, 94), new Color(155, 0, 0), new Color(243, 103, 42), new Color(92, 113, 72), new Color(9, 38, 114), new Color(119, 55, 143), new Color(69, 70, 71)};
    protected ColorMenuPicker mPicker = null;
    protected ColorItemDescriptor[] mDescriptors = null;
    protected JLabel rgbLabel;
    protected JButton editButton;
    JButton resetButton;
    ChartsColorsDlg chartsDlg;

    public ColorWellPanel(BaseDialog baseDialog, Color color, Color[] colorArray) {
        this.colors = colorArray;
        if (baseDialog instanceof ChartsColorsDlg) {
            this.chartsDlg = (ChartsColorsDlg)baseDialog;
        }
        this.mDescriptors = this.getColorDescriptors(this.colors);
        this.mPicker = new ColorMenuPicker(this.mDescriptors);
        if (color == null) {
            color = colorArray[0];
        }
        this.mPicker.setSelectedColor(color);
        this.initColorWell();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.rgbLabel.setText("(" + n + ", " + n2 + ", " + n3 + ")");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetButton) {
            this.refreshDescriptorColors();
            this.mPicker.repaint();
            Color color = this.mPicker.getSelectedColor();
            if (color != null) {
                int n = color.getRed();
                int n2 = color.getGreen();
                int n3 = color.getBlue();
                this.rgbLabel.setText("(" + n + ", " + n2 + ", " + n3 + ")");
            }
        } else if (object == this.editButton) {
            this.popupColorChooser();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.mPicker.isEnabled()) {
            return;
        }
        if (this.mPicker.getSelIndex() == 0 || this.mPicker.getSelIndex() == 1 || this.mPicker.getSelIndex() == 2) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
        Color color = this.mPicker.getSelectedColor();
        if (color != null) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            this.rgbLabel.setText("(" + n + ", " + n2 + ", " + n3 + ")");
        }
    }

    public ColorMenuPicker getPicker() {
        return this.mPicker;
    }

    public JButton retEditButton() {
        return this.editButton;
    }

    public JButton retResetButton() {
        return this.resetButton;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mPicker.setEnabled(bl);
        this.editButton.setEnabled(bl && this.mPicker.getSelIndex() > 2);
        this.resetButton.setEnabled(bl);
        this.rgbLabel.setEnabled(bl);
    }

    public void refreshColors(Color[] colorArray) {
        for (int i = 0; i < colorArray.length; ++i) {
            this.mPicker.updateColorWellColor(i + 3, colorArray[i]);
        }
    }

    private void refreshDescriptorColors() {
        this.mDescriptors[0].setColor(Color.WHITE);
        this.mDescriptors[1].setColor(Color.BLACK);
        this.mDescriptors[2].setColor(new Color(255, 255, 255, 0));
        for (int i = 0; i < this.rcolors.length; ++i) {
            this.mDescriptors[i + 3].setColor(this.rcolors[i]);
        }
    }

    private ColorItemDescriptor[] getColorDescriptors(Color[] colorArray) {
        Dimension dimension = new Dimension(23, 23);
        Dimension dimension2 = new Dimension(47, 23);
        Point point = new Point(1, 1);
        int n = 0;
        int n2 = 0;
        int n3 = colorArray.length;
        Color[] colorArray2 = new Color[]{Color.WHITE, Color.BLACK, new Color(255, 255, 255, 0)};
        ColorItemDescriptor[] colorItemDescriptorArray = new ColorItemDescriptor[n3 + 3];
        for (int i = 0; i < n3 + 3; ++i) {
            Dimension dimension3;
            Color color;
            if (i < 3) {
                color = colorArray2[i];
                dimension3 = dimension2;
            } else {
                color = colorArray[i - 3];
                dimension3 = dimension;
            }
            colorItemDescriptorArray[i] = new ColorItemDescriptor(dimension3, n, n2, color);
            colorItemDescriptorArray[i].setLocation(point);
            if (dimension3.equals(dimension2)) {
                ++n2;
            }
            if (++n2 >= 6) {
                n2 = 0;
                ++n;
            }
            point.x = n2 * dimension.width + (n2 + 1) * 1;
            point.y = n * dimension.height + (n + 1) * 1;
        }
        return colorItemDescriptorArray;
    }

    private void initColorWell() {
        this.rgbLabel = new JLabel();
        this.editButton = new JButton(UIToolResUtil.getString((String)"IDS_COLOR_WELL_PANEL_EDIT"));
        this.resetButton = new JButton(UIToolResUtil.getString((String)"IDS_COLOR_WELL_PANEL_RESET"));
        this.editButton.setPreferredSize(this.resetButton.getMinimumSize());
        int n = this.editButton.getPreferredSize().width + this.resetButton.getPreferredSize().width;
        int n2 = Math.max(n, 153);
        this.setPreferredSize(new Dimension(n2, 216));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.editButton.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDK_COLOR_WELL_PANEL_EDIT_KEY", (ResourceBundle)UIToolResUtil.getLabels()));
            this.resetButton.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDK_COLOR_WELL_PANEL_RESET_KEY", (ResourceBundle)UIToolResUtil.getLabels()));
        }
        this.mPicker.addChangeListener((ChangeListener)this);
        this.editButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.layingout();
    }

    protected void layingout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(n2, 0, 0, 0);
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        OptionsUtil.addUsingGBL(this, (JComponent)this.mPicker, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.set(n3, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(this, this.editButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n3, n3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(this, this.resetButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n3, 0, n3, 0);
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, n3 * 5, n3, 0);
        OptionsUtil.addUsingGBL(this, this.rgbLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private void popupColorChooser() {
        Color color = JColorChooser.showDialog(null, UILocale.getLabel((String)"PDColorChooserTitleKey"), this.colors[1]);
        if (color != null) {
            this.mPicker.updateColorWellColor(this.mPicker.getSelIndex(), color);
            this.mPicker.repaint();
            Color color2 = this.mPicker.getSelectedColor();
            int n = color2.getRed();
            int n2 = color2.getGreen();
            int n3 = color2.getBlue();
            this.rgbLabel.setText("(" + n + ", " + n2 + ", " + n3 + ")");
            this.uponColorEdit();
        }
    }

    protected void uponColorEdit() {
        if (this.chartsDlg == null) {
            return;
        }
        this.chartsDlg.setListSelectedColor(this.mPicker.getSelectedColor(), this.chartsDlg.getGroupList());
        this.chartsDlg.getGroupList().repaint();
    }
}

