/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.ChartsColorsDlg;
import com.spss.java_client.ui.dialogs.base.edit.ChartsFillsDlg;
import com.spss.java_client.ui.dialogs.base.edit.ChartsLinesDlg;
import com.spss.java_client.ui.dialogs.base.edit.ChartsMarkersDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DecimalFormatSymbols;
import java.util.Formatter;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ChartsOptionPanel
extends OptionPanel {
    private static final double MIN_VAL = 0.1;
    private static final double MAX_VAL = 10.0;
    private static final int PRECISION_VAL = 15;
    private static final String DEF_ASPECT_RATIO_VAL = "1.25";
    String mSimpleColorsStr;
    String mSimpleLinesStr;
    String mSimpleMarkersStr;
    String mSimpleFillsStr;
    int CYCLE_LENGTH = 30;
    String[] mColorsCategs;
    String[] mLinesCategs;
    String[] mMarkersCategs;
    String[] mFillsCategs;
    Color[] mSwatchColors = new Color[30];
    private JRadioButton mUseCurrentRadio;
    private JRadioButton mUseTemplateRadio;
    private FocusableTextArea mTempPathTextField;
    private JButton mBrowseBtn;
    private FloatTextField mAspectRatioTxt;
    private static final double MINBEGINYEAR = 0.1;
    private static final double MAXBEGINYEAR = 10.0;
    private JComboBox mFontCombo;
    private JComboBox mStyleCyclePrefCombo;
    private JCheckBox mOutFrame;
    private JCheckBox mInnerFrame;
    private JCheckBox mScaleAxis;
    private JCheckBox mCategAxis;
    private JButton mColorsBtn;
    private JButton mLinesBtn;
    private JButton mMarkersBtn;
    private JButton mFillsBtn;
    private String mTemplatePathStr = "None";
    private String[] mCycleThrough = new String[]{this.getResString("IDS_CYCLE_COLORS"), this.getResString("IDS_CYCLE_PATTERNS")};
    private JPanel mFontPanel;
    private JPanel mFramePanel;
    private JPanel mGridLinesPanel;
    private JPanel mCurrentSettingPanel;

    public ChartsOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
        this.setOpaque(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_graphics";
    }

    @Override
    protected void initVars() {
        this.mUseCurrentRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_USE_CURRENT", (ActionListener)this);
        this.mUseTemplateRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_USE_CHART", (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUseCurrentRadio);
        spssButtonGroup.add(this.mUseTemplateRadio);
        this.mUseCurrentRadio.setSelected(true);
        this.mTempPathTextField = new FocusableTextArea(this.getResString("IDS_NONE"), null);
        this.mBrowseBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_USE_BROWSE_3DOT", this);
        this.mAspectRatioTxt = new FloatTextField(0.1, 10.0, 15, true);
        this.mAspectRatioTxt.setColumns(6);
        Formatter formatter = new Formatter().format(ResUtil.getLocale(), DEF_ASPECT_RATIO_VAL, new Object[0]);
        this.mAspectRatioTxt.setText(formatter.toString());
        this.mFontCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.mStyleCyclePrefCombo = new JComboBox<String>(this.mCycleThrough);
        this.mOutFrame = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_OUTER", (ActionListener)this);
        this.mInnerFrame = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_INNER", (ActionListener)this);
        this.mScaleAxis = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_SCALE_AXIS", (ActionListener)this);
        this.mCategAxis = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_CATEG_AXIS", (ActionListener)this);
        this.mColorsBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_COLORS", this);
        this.mLinesBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_LINES", this);
        this.mMarkersBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_MARKERS", this);
        this.mFillsBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_FILLS", this);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mOutFrame);
        spssButtonGroup2.add(this.mInnerFrame);
        SpssButtonGroup spssButtonGroup3 = new SpssButtonGroup();
        spssButtonGroup3.add(this.mScaleAxis);
        spssButtonGroup3.add(this.mCategAxis);
        this.mFontPanel = new JPanel(new GridBagLayout());
        this.mFramePanel = new JPanel();
        this.mGridLinesPanel = new JPanel();
        this.mCurrentSettingPanel = new JPanel();
        this.mCurrentSettingPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CURRENT_SETTINGS_PANEL")));
        this.mCurrentSettingPanel.setLayout(new GridBagLayout());
        this.mComponentOrder.add(spssButtonGroup);
        this.mComponentOrder.add(this.mBrowseBtn);
        this.mComponentOrder.add(this.mTempPathTextField);
        this.mComponentOrder.add(this.mFontCombo);
        this.mComponentOrder.add(this.mStyleCyclePrefCombo);
        this.mComponentOrder.add(this.mOutFrame);
        this.mComponentOrder.add(this.mInnerFrame);
        this.mComponentOrder.add(this.mScaleAxis);
        this.mComponentOrder.add(this.mCategAxis);
        this.mComponentOrder.add(this.mAspectRatioTxt);
        this.mComponentOrder.add(this.mColorsBtn);
        this.mComponentOrder.add(this.mLinesBtn);
        this.mComponentOrder.add(this.mMarkersBtn);
        this.mComponentOrder.add(this.mFillsBtn);
        for (Component component : this.mOptionDialog.getCmdButtonPanel().getComponents()) {
            this.mComponentOrder.add(component);
        }
    }

    @Override
    protected void readPrefs() {
        Object object;
        Object object2;
        Preferences preferences = this.mOptionsPrefs;
        String string = preferences.get("use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
        if (IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0].equals(string)) {
            this.mUseTemplateRadio.setSelected(true);
            this.mTempPathTextField.setEnabled(true);
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.mTempPathTextField.setOpaque(true);
            }
            this.mTemplatePathStr = preferences.get("custom_template_path", "None");
        } else {
            this.mUseCurrentRadio.setSelected(true);
            this.mBrowseBtn.setEnabled(false);
            this.mTempPathTextField.setEnabled(false);
            this.mTempPathTextField.setOpaque(false);
        }
        string = preferences.get("aspect_ratio", PrefDefaults.DEF_CHART_ASPECT_RATIO);
        if (string != null && string.length() > 0) {
            String string2 = this.getCurrentLocaleString(string);
            this.mAspectRatioTxt.setText(string2);
            if (this.mAspectRatioTxt.getText().length() == 0) {
                object2 = new Formatter().format(ResUtil.getLocale(), DEF_ASPECT_RATIO_VAL, new Object[0]);
                this.mAspectRatioTxt.setText(((Formatter)object2).toString());
            }
        }
        if ((string = preferences.get("font_family", PrefDefaults.DEF_CHART_FONT)) != null && string.length() > 0) {
            int n = DialogUtil.getIndexOfItem(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(), string);
            this.mFontCombo.setSelectedIndex(n);
        } else {
            this.mFontCombo.setSelectedIndex(0);
        }
        int n = preferences.getInt("cycle_option", 0);
        this.mStyleCyclePrefCombo.setSelectedIndex(n);
        if (preferences.getBoolean("show_outer_frame", false)) {
            this.mOutFrame.setSelected(true);
        } else {
            this.mOutFrame.setSelected(false);
        }
        if (preferences.getBoolean("show_inner_frame", false)) {
            this.mInnerFrame.setSelected(true);
        } else {
            this.mInnerFrame.setSelected(false);
        }
        if (preferences.getBoolean("grid_scale_axis", true)) {
            this.mScaleAxis.setSelected(true);
        } else {
            this.mScaleAxis.setSelected(false);
        }
        if (preferences.getBoolean("grid_category_axis", false)) {
            this.mCategAxis.setSelected(true);
        } else {
            this.mCategAxis.setSelected(false);
        }
        object2 = preferences.node("color_swatches");
        String[] stringArray = PrefDefaults.DEF_CHART_COLOR_SWATCHES;
        for (int i = 0; i < 30; ++i) {
            object = new int[3];
            int n2 = 0;
            String string3 = ((Preferences)object2).get(IOptionConstants.CHART_COLOR_PALETTE_KEY[i], stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                object[n2] = Integer.parseInt(string4);
                ++n2;
            }
            this.mSwatchColors[i] = new Color(object[0], (int)object[1], (int)object[2]);
        }
        try {
            int n3;
            object = new Vector();
            Preferences preferences2 = preferences.node("chart_colors");
            this.mSimpleColorsStr = preferences2.get("simple_color", "85,150,230");
            if (this.mSimpleColorsStr == null) {
                this.mSimpleColorsStr = "85,150,230";
            }
            if ((n3 = preferences2.keys().length) > 0) {
                for (int i = 0; i < n3 - 1; ++i) {
                    String string5 = String.format("%s%s", "Cat_", i);
                    ((Vector)object).add(preferences2.get(string5, ""));
                }
                if (((Vector)object).size() > 0) {
                    this.mColorsCategs = new String[((Vector)object).size()];
                    ((Vector)object).toArray(this.mColorsCategs);
                    ((Vector)object).clear();
                }
            }
            preferences2 = preferences.node("chart_lines");
            this.mSimpleLinesStr = preferences2.get("simple_line", "0");
            n3 = preferences2.keys().length;
            if (n3 > 0) {
                for (int i = 0; i < n3 - 1; ++i) {
                    String string6 = String.format("%s%s", "Cat_", i);
                    ((Vector)object).add(preferences2.get(string6, ""));
                }
                if (((Vector)object).size() > 0) {
                    this.mLinesCategs = new String[((Vector)object).size()];
                    ((Vector)object).toArray(this.mLinesCategs);
                    ((Vector)object).clear();
                }
            }
            preferences2 = preferences.node("chart_markers");
            this.mSimpleMarkersStr = preferences2.get("simple_marker", "5");
            n3 = preferences2.keys().length;
            if (n3 > 0) {
                for (int i = 0; i < n3 - 1; ++i) {
                    String string7 = String.format("%s%s", "Cat_", i);
                    ((Vector)object).add(preferences2.get(string7, ""));
                }
                if (((Vector)object).size() > 0) {
                    this.mMarkersCategs = new String[((Vector)object).size()];
                    ((Vector)object).toArray(this.mMarkersCategs);
                    ((Vector)object).clear();
                }
            }
            preferences2 = preferences.node("chart_patterns");
            this.mSimpleFillsStr = preferences2.get("simple_fill", "6");
            n3 = preferences2.keys().length;
            if (n3 > 0) {
                for (int i = 0; i < n3 - 1; ++i) {
                    String string8 = String.format("%s%s", "Cat_", i);
                    ((Vector)object).add(preferences2.get(string8, ""));
                }
                if (((Vector)object).size() > 0) {
                    this.mFillsCategs = new String[((Vector)object).size()];
                    ((Vector)object).toArray(this.mFillsCategs);
                    ((Vector)object).clear();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChartsOptionPanel.this.mTemplatePathStr.equals("None")) {
                    ChartsOptionPanel.this.mTempPathTextField.setText(ChartsOptionPanel.this.getResString("IDS_NONE"));
                } else {
                    ChartsOptionPanel.this.mTempPathTextField.setText(ChartsOptionPanel.this.mTemplatePathStr);
                }
                ChartsOptionPanel.this.addListeners();
            }
        });
    }

    @Override
    protected void savePrefs() {
        Object object;
        Preferences preferences = this.mOptionsPrefs;
        if (this.mUseTemplateRadio.isSelected()) {
            preferences.put("use_custom_template", IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]);
            preferences.put("custom_template_path", this.mTemplatePathStr);
        } else {
            preferences.put("use_custom_template", IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[1]);
        }
        if (this.mAspectRatioTxt.getText().length() > 0) {
            object = this.getEnglishLocaleString(this.mAspectRatioTxt.getText());
            preferences.put("aspect_ratio", (String)object);
        }
        if (this.mFontCombo.isEnabled()) {
            object = (String)this.mFontCombo.getSelectedItem();
            preferences.put("font_family", (String)object);
        }
        preferences.putInt("cycle_option", this.mStyleCyclePrefCombo.getSelectedIndex());
        if (this.mOutFrame.isEnabled()) {
            if (this.mOutFrame.isSelected()) {
                preferences.putBoolean("show_outer_frame", true);
            } else {
                preferences.putBoolean("show_outer_frame", false);
            }
        }
        if (this.mInnerFrame.isEnabled()) {
            if (this.mInnerFrame.isSelected()) {
                preferences.putBoolean("show_inner_frame", true);
            } else {
                preferences.putBoolean("show_inner_frame", false);
            }
        }
        if (this.mScaleAxis.isEnabled()) {
            if (this.mScaleAxis.isSelected()) {
                preferences.putBoolean("grid_scale_axis", true);
            } else {
                preferences.putBoolean("grid_scale_axis", false);
            }
        }
        if (this.mCategAxis.isEnabled()) {
            if (this.mCategAxis.isSelected()) {
                preferences.putBoolean("grid_category_axis", true);
            } else {
                preferences.putBoolean("grid_category_axis", false);
            }
        }
        object = preferences.node("color_swatches");
        for (int i = 0; i < 30; ++i) {
            String string = "" + this.mSwatchColors[i].getRed() + ", " + this.mSwatchColors[i].getGreen() + ", " + this.mSwatchColors[i].getBlue() + "";
            ((Preferences)object).put(IOptionConstants.CHART_COLOR_PALETTE_KEY[i], string);
        }
        try {
            Preferences preferences2 = preferences.node("chart_colors");
            if (this.mColorsCategs != null && this.mColorsCategs.length > 0) {
                preferences2.removeNode();
                preferences2 = preferences.node("chart_colors");
                for (int i = 0; i < this.mColorsCategs.length; ++i) {
                    preferences2.put("Cat_" + i, this.mColorsCategs[i]);
                }
            }
            if (this.mSimpleColorsStr != null && this.mSimpleColorsStr.length() > 0) {
                preferences2.put("simple_color", this.mSimpleColorsStr);
            }
            Preferences preferences3 = preferences.node("chart_lines");
            if (this.mLinesCategs != null && this.mLinesCategs.length > 0) {
                preferences3.removeNode();
                preferences3 = preferences.node("chart_lines");
                for (int i = 0; i < this.mLinesCategs.length; ++i) {
                    preferences3.put("Cat_" + i, this.mLinesCategs[i]);
                }
            }
            if (this.mSimpleLinesStr != null && this.mSimpleLinesStr.length() > 0) {
                preferences3.put("simple_line", this.mSimpleLinesStr);
            }
            Preferences preferences4 = preferences.node("chart_markers");
            if (this.mMarkersCategs != null && this.mMarkersCategs.length > 0) {
                preferences4.removeNode();
                preferences4 = preferences.node("chart_markers");
                for (int i = 0; i < this.mMarkersCategs.length; ++i) {
                    preferences4.put("Cat_" + i, this.mMarkersCategs[i]);
                }
            }
            if (this.mSimpleMarkersStr != null && this.mSimpleMarkersStr.length() > 0) {
                preferences4.put("simple_marker", this.mSimpleMarkersStr);
            }
            Preferences preferences5 = preferences.node("chart_patterns");
            if (this.mFillsCategs != null && this.mFillsCategs.length > 0) {
                preferences5.removeNode();
                preferences5 = preferences.node("chart_patterns");
                for (int i = 0; i < this.mFillsCategs.length; ++i) {
                    preferences5.put("Cat_" + i, this.mFillsCategs[i]);
                }
            }
            if (this.mSimpleFillsStr != null && this.mSimpleFillsStr.length() > 0) {
                preferences5.put("simple_fill", this.mSimpleFillsStr);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected int getId() {
        return 64;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        OptionsUtil.addUsingGBL(this, this.setupChartTemplatePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 * 6, n2, 0, 0);
        n = 10;
        OptionsUtil.addUsingGBL(this, this.setupChartAspectRatioPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 23;
        insets.set(n2, 0, 0, 0);
        this.setupCurrentSettingPanel();
        OptionsUtil.addUsingGBL(this, this.mCurrentSettingPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(this, this.setupStyleCyclesPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.onUseRadioSelection(this.mUseTemplateRadio.isSelected() ? this.mUseTemplateRadio : this.mUseCurrentRadio);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        this.onUseRadioSelection(object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseBtn) {
            if (this.doBrowse() == 0) {
                this.mTempPathTextField.setText(this.mTemplatePathStr);
            }
        } else if (object == this.mColorsBtn) {
            new ChartsColorsDlg(this, this.mOptionDialog, this.getResString("IDS_CHARTS_COLORS_TITLE"));
        } else if (object == this.mLinesBtn) {
            new ChartsLinesDlg(this, this.mOptionDialog, this.getResString("IDS_CHARTS_LINES_TITLE"));
        } else if (object == this.mMarkersBtn) {
            new ChartsMarkersDlg(this, this.mOptionDialog, this.getResString("IDS_CHARTS_MARKERS_TITLE"));
        } else if (object == this.mFillsBtn) {
            new ChartsFillsDlg(this, this.mOptionDialog, this.getResString("IDS_CHARTS_FILLS_TITLE"));
        }
        super.actionPerformed(actionEvent);
    }

    private void addListeners() {
        this.mUseCurrentRadio.addItemListener(this);
        this.mUseTemplateRadio.addItemListener(this);
        this.mAspectRatioTxt.addFocusListener((FocusListener)this);
        this.mAspectRatioTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ChartsOptionPanel.this.actionPerformed(new ActionEvent(ChartsOptionPanel.this.mAspectRatioTxt, 0, ""));
            }
        });
        this.mFontCombo.addActionListener(this);
        this.mStyleCyclePrefCombo.addActionListener(this);
    }

    private void onUseRadioSelection(Object object) {
        if (object == this.mUseCurrentRadio) {
            this.mTempPathTextField.setText(this.getResString("IDS_NONE"));
            this.mTempPathTextField.setEnabled(false);
            this.mTempPathTextField.setOpaque(false);
            ChartsOptionPanel.setComponentEnableState(this.mCurrentSettingPanel, true);
            this.mBrowseBtn.setEnabled(false);
        } else if (object == this.mUseTemplateRadio) {
            this.mTempPathTextField.setEnabled(true);
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.mTempPathTextField.setOpaque(true);
            }
            ChartsOptionPanel.setComponentEnableState(this.mCurrentSettingPanel, false);
            this.mBrowseBtn.setEnabled(true);
        }
    }

    private JPanel setupChartTemplatePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CHART_TEMPLATE_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mUseCurrentRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mUseTemplateRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2 * 6, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mBrowseBtn, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), n2 * 4, DialogUtil.getGroupBoxInnerMargin(), 0);
        OptionsUtil.addUsingGBL(jPanel, this.mTempPathTextField, gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupChartAspectRatioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_CHART_ASPECT_RATIO_PANEL");
        jLabel.setLabelFor((Component)this.mAspectRatioTxt);
        jPanel.add(jLabel);
        jPanel.add((Component)this.mAspectRatioTxt);
        return jPanel;
    }

    private void setupCurrentSettingPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_CS_FONT_PANEL");
        jLabel.setLabelFor(this.mFontCombo);
        this.mFramePanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FRAME_PANEL")));
        this.mFramePanel.setLayout(new GridBagLayout());
        OptionsUtil.addUsingGBL(this.mFramePanel, this.mOutFrame, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, 0, n2));
        OptionsUtil.addUsingGBL(this.mFramePanel, this.mInnerFrame, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, n2, n2, n2));
        JLabel jLabel2 = DialogUtil.createLabel(this.mOptionDialog, "IDS_STYLE_CYCLE_PREF_PANEL");
        jLabel2.setLabelFor(this.mStyleCyclePrefCombo);
        this.mGridLinesPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_GRID_LINES_PANEL")));
        this.mGridLinesPanel.setLayout(new GridBagLayout());
        OptionsUtil.addUsingGBL(this.mGridLinesPanel, this.mScaleAxis, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, 0, n2));
        OptionsUtil.addUsingGBL(this.mGridLinesPanel, this.mCategAxis, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, n2, n2, n2));
        this.createFontAndStylePanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(this.mCurrentSettingPanel, this.mFontPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, 0, 0));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(this.mCurrentSettingPanel, this.mFramePanel, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, n2, 0, n2));
        OptionsUtil.addUsingGBL(this.mCurrentSettingPanel, this.mGridLinesPanel, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, n2, n2, n2));
    }

    private void createFontAndStylePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_CS_FONT_PANEL");
        jLabel.setLabelFor(this.mFontCombo);
        JLabel jLabel2 = DialogUtil.createLabel(this.mOptionDialog, "IDS_STYLE_CYCLE_PREF_PANEL");
        jLabel2.setLabelFor(this.mStyleCyclePrefCombo);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(this.mFontPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(n2 + 4, n2, n2 + 4, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(this.mFontPanel, this.mFontCombo, gridBagConstraints, 1, 0, 1, 1, n, new Insets(n2 + 4, n2, n2 + 4, 0));
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(this.mFontPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(n2 + 4, n2, 0, 0));
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(this.mFontPanel, this.mStyleCyclePrefCombo, gridBagConstraints, 1, 1, 1, 1, n, new Insets(n2 + 4, n2, 0, 0));
    }

    private JPanel setupStyleCyclesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_STYLE_CYCLES_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, n2, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mColorsBtn, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mLinesBtn, gridBagConstraints, 1, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mMarkersBtn, gridBagConstraints, 2, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mFillsBtn, gridBagConstraints, 3, 0, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private int doBrowse() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_CHARTS_FILE_FILTER"), this.getResString("IDS_CHARTS_EXT"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            if (file != null && file.isFile()) {
                this.mTemplatePathStr = remoteFileChooser.getSelectedFilePath();
            }
        }
        return n;
    }

    private boolean isValueValid() {
        Boolean bl = false;
        String string = this.mAspectRatioTxt.getText();
        if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mAspectRatioTxt)) {
            OptionsDlg.sErrorMessagesDialogs.remove(this.mAspectRatioTxt);
        }
        try {
            float f = Float.parseFloat(string);
            if ((double)f < 0.1 || (double)f > 10.0) {
                OptionsDlg.sErrorMessagesDialogs.put(this.mAspectRatioTxt, this.getResString("ERR_ASPECT_RATIO_MSG"));
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_ASPECT_RATIO_NUMBERFORMAT_MSG"), VersionInfo.getAppVersionString());
            OptionsDlg.sErrorMessagesDialogs.put(this.mAspectRatioTxt, this.getResString("ERR_ASPECT_RATIO_NUMBERFORMAT_MSG"));
            bl = true;
        }
        if (bl.booleanValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartsOptionPanel.this.mAspectRatioTxt.requestFocusInWindow();
                    ChartsOptionPanel.this.mAspectRatioTxt.selectAll();
                }
            });
        }
        return bl == false;
    }

    public boolean handleFocus() {
        return this.isValueValid();
    }

    private String getEnglishLocaleString(String string) {
        int n;
        String string2 = string;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
        char c = decimalFormatSymbols.getDecimalSeparator();
        if (c != '.' && (n = string.indexOf(c)) >= 0) {
            string2 = string.replace(c, '.');
        }
        return string2;
    }

    private String getCurrentLocaleString(String string) {
        int n;
        String string2 = string;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
        char c = decimalFormatSymbols.getDecimalSeparator();
        if (c != '.' && (n = string.indexOf(46)) >= 0) {
            string2 = string.replace('.', c);
        }
        return string2;
    }
}

