/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.charteditor.component.DefaultIconPicker;
import com.spss.charteditor.uimodel.DefaultIconSelectionModel;
import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.ui.dialogs.base.edit.BaseChartsSubDialog;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;

public class ChartsMarkersDlg
extends BaseChartsSubDialog
implements ChangeListener {
    private static boolean sIsSimpleSelected = true;
    private DefaultIconPicker mMarkerTypePanel;
    private final int ROW_NUM = 5;
    private final int COL_NUM = 5;

    public ChartsMarkersDlg(ChartsOptionPanel chartsOptionPanel, BaseDialog baseDialog, String string) {
        super(chartsOptionPanel, baseDialog, string);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_idd_marker_dialog";
    }

    @Override
    protected JList getSimpleChartList() {
        String string = this.mChartsPanel.mSimpleMarkersStr;
        BaseChartsSubDialog.NameIconListModel nameIconListModel = new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new MarkerIcon[]{new MarkerIcon(string)});
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JList getGroupChartList() {
        BaseChartsSubDialog.NameIconListModel nameIconListModel = this.getGroupChartListModel();
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JPanel getAvailablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, n2, n2);
        JLabel jLabel = new JLabel(this.getResString("IDS_CHARTS_AVAILABLE_MARKERS"));
        ImageIcon[] imageIconArray = new ImageIcon[25];
        for (int i = 0; i < imageIconArray.length; ++i) {
            imageIconArray[i] = new ImageIcon(ResUtil.getImageResource((String)("marker" + i + ".gif")));
        }
        this.mMarkerTypePanel = new DefaultIconPicker(imageIconArray, 5, 5, false){

            public void setSelectedIndex(int n) {
                super.setSelectedIndex(n);
            }
        };
        this.mMarkerTypePanel.addChangeListener((ChangeListener)this);
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, (JComponent)this.mMarkerTypePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Object e = this.mSimpleChartList.getSelectedValue();
        if (e instanceof MarkerIcon) {
            MarkerIcon markerIcon = (MarkerIcon)e;
            int n3 = Integer.parseInt(markerIcon.getGlyphId());
            this.mMarkerTypePanel.setSelection(n3 / 5, n3 % 5);
        }
        return jPanel;
    }

    @Override
    protected void doContinue() {
        BaseChartsSubDialog.ChartsIcon chartsIcon = (BaseChartsSubDialog.ChartsIcon)this.mSimpleChartList.getSelectedValue();
        if (chartsIcon instanceof MarkerIcon) {
            MarkerIcon markerIcon = (MarkerIcon)chartsIcon;
            this.mChartsPanel.mSimpleMarkersStr = markerIcon.getGlyphId();
        }
        int n = this.mGroupChartList.getModel().getSize();
        this.mChartsPanel.mMarkersCategs = new String[n];
        for (int i = 0; i < n; ++i) {
            MarkerIcon markerIcon = (MarkerIcon)this.mGroupChartList.getModel().getElementAt(i);
            this.mChartsPanel.mMarkersCategs[i] = markerIcon.getGlyphId();
        }
    }

    @Override
    protected void setSubTabPolicy() {
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultGroupChartListModel() {
        int n = PrefDefaults.DEF_CHART_MARKER_CYCLE.length;
        BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new MarkerIcon[n];
        for (int i = 0; i < n; ++i) {
            chartsIconArray[i] = new MarkerIcon(PrefDefaults.DEF_CHART_MARKER_CYCLE[i]);
        }
        return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultSimpleChartListModel() {
        return new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new MarkerIcon[]{new MarkerIcon("5")});
    }

    protected BaseChartsSubDialog.NameIconListModel getGroupChartListModel() {
        if (this.mChartsPanel.mMarkersCategs != null) {
            int n = this.mChartsPanel.mMarkersCategs.length;
            BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new MarkerIcon[n];
            for (int i = 0; i < n; ++i) {
                chartsIconArray[i] = new MarkerIcon(this.mChartsPanel.mMarkersCategs[i]);
            }
            return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
        }
        return this.getDefaultGroupChartListModel();
    }

    @Override
    protected boolean getSimpleSelection() {
        return sIsSimpleSelected;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof DefaultIconSelectionModel) {
            int n = this.mMarkerTypePanel.getSelectedCol();
            int n2 = this.mMarkerTypePanel.getSelectedRow();
            int n3 = 5 * n2 + n;
            if (this.mSimpleChartRadio.isSelected()) {
                this.redrawSelectedIcon(n3, this.mSimpleChartList);
            } else if (this.mGroupChartRadio.isSelected()) {
                this.redrawSelectedIcon(n3, this.mGroupChartList);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.mInsertBtn && (n = this.mGroupChartList.getSelectedIndex()) >= 0) {
            BaseChartsSubDialog.NameIconListModel nameIconListModel = (BaseChartsSubDialog.NameIconListModel)this.mGroupChartList.getModel();
            nameIconListModel.insertElementAt(new MarkerIcon(this.getNextPrefId()), n);
            this.mGroupChartList.setSelectedIndex(n);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        super.valueChanged(listSelectionEvent);
        Object object = listSelectionEvent.getSource();
        if (object == this.mGroupChartList) {
            Object e2 = this.mGroupChartList.getSelectedValue();
            if (e2 instanceof MarkerIcon) {
                MarkerIcon markerIcon = (MarkerIcon)e2;
                int n = Integer.parseInt(markerIcon.getGlyphId());
                this.mMarkerTypePanel.setSelection(n / 5, n % 5);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChartsMarkersDlg.this.mGroupChartList.requestFocus();
                    }
                });
            }
        } else if (object == this.mSimpleChartList && (e = this.mSimpleChartList.getSelectedValue()) instanceof MarkerIcon) {
            MarkerIcon markerIcon = (MarkerIcon)e;
            int n = Integer.parseInt(markerIcon.getGlyphId());
            this.mMarkerTypePanel.setSelection(n / 5, n % 5);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartsMarkersDlg.this.mSimpleChartList.requestFocus();
                }
            });
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object == this.mSimpleChartRadio) {
            sIsSimpleSelected = true;
            Object e = this.mSimpleChartList.getSelectedValue();
            if (e instanceof MarkerIcon) {
                MarkerIcon markerIcon = (MarkerIcon)e;
                int n = Integer.parseInt(markerIcon.getGlyphId());
                this.mMarkerTypePanel.setSelection(n / 5, n % 5);
            }
        } else if (object == this.mGroupChartRadio) {
            sIsSimpleSelected = false;
            Object e = this.mGroupChartList.getSelectedValue();
            if (e instanceof MarkerIcon) {
                MarkerIcon markerIcon = (MarkerIcon)e;
                int n = Integer.parseInt(markerIcon.getGlyphId());
                this.mMarkerTypePanel.setSelection(n / 5, n % 5);
            }
        }
    }

    private void redrawSelectedIcon(int n, JList jList) {
        Object e = jList.getSelectedValue();
        if (e instanceof MarkerIcon) {
            MarkerIcon markerIcon = (MarkerIcon)e;
            markerIcon.setGlyphId(String.valueOf(n));
            jList.repaint();
        }
    }

    private String getNextPrefId() {
        int n;
        String string = "0";
        int n2 = this.mMarkerTypePanel.getImageList().length;
        int[] nArray = new int[n2];
        int n3 = this.mGroupChartList.getModel().getSize();
        for (n = 0; n < n3; ++n) {
            MarkerIcon markerIcon = (MarkerIcon)this.mGroupChartList.getModel().getElementAt(n);
            int n4 = Integer.parseInt(markerIcon.getGlyphId());
            nArray[n4] = nArray[n4] + 1;
        }
        n = 0;
        int n5 = 0;
        while (n == 0) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] > n5) continue;
                string = String.valueOf(i);
                n = 1;
                break;
            }
            ++n5;
        }
        return string;
    }

    public void doHelp() {
    }

    class MarkerIcon
    extends BaseChartsSubDialog.ChartsIcon {
        private String mGlyphId;

        MarkerIcon(String string) {
            this.mGlyphId = string.trim();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(Color.white);
            graphics2D.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.drawImage(new ImageIcon(ResUtil.getImageResource((String)("marker" + this.mGlyphId + ".gif"))).getImage(), 2, 0, 16, 16, (ImageObserver)((Object)ChartsMarkersDlg.this));
            if (!this.mIsEnabled) {
                graphics2D.setPaint(new Color(0.7f, 0.7f, 0.7f, 0.5f));
                graphics2D.fill(new Rectangle(0, 0, 18, 18));
            }
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }

        public String getGlyphId() {
            return this.mGlyphId;
        }

        public void setGlyphId(String string) {
            this.mGlyphId = string;
        }
    }
}

