/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.ui.dialogs.base.edit.BaseChartsSubDialog;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;

public class ChartsLinesDlg
extends BaseChartsSubDialog {
    private static boolean sIsSimpleSelected = true;
    private JList mLineTypeList;

    public ChartsLinesDlg(ChartsOptionPanel chartsOptionPanel, BaseDialog baseDialog, String string) {
        super(chartsOptionPanel, baseDialog, string);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_idd_lines_dialog";
    }

    @Override
    protected JList getSimpleChartList() {
        String string = this.mChartsPanel.mSimpleLinesStr;
        BaseChartsSubDialog.NameIconListModel nameIconListModel = new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new LineIcon[]{new LineIcon(string)});
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JList getGroupChartList() {
        BaseChartsSubDialog.NameIconListModel nameIconListModel = this.getGroupChartListModel();
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JPanel getAvailablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, n2, n2);
        JLabel jLabel = new JLabel(this.getResString("IDS_CHARTS_AVAILABLE_LINES"));
        int n3 = PrefDefaults.DEF_CHART_LINE_CYCLE.length;
        ImageIcon[] imageIconArray = new ImageIcon[n3];
        for (int i = 0; i < n3; ++i) {
            imageIconArray[i] = new ImageIcon(ResUtil.getImageResource((String)("LineStyle" + (i + 1) + ".gif")));
        }
        this.mLineTypeList = new JList<ImageIcon>(imageIconArray);
        this.mLineTypeList.setVisibleRowCount(9);
        this.mLineTypeList.addListSelectionListener(this);
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, new JScrollPane(this.mLineTypeList), gridBagConstraints, 0, 1, 1, 1, n, insets);
        Object e = this.mSimpleChartList.getSelectedValue();
        if (e instanceof LineIcon) {
            LineIcon lineIcon = (LineIcon)e;
            int n4 = Integer.parseInt(lineIcon.getGlyphId());
            this.mLineTypeList.setSelectedIndex(n4);
            this.mLineTypeList.scrollRectToVisible(this.mLineTypeList.getCellBounds(n4, n4));
        }
        return jPanel;
    }

    @Override
    protected void doContinue() {
        BaseChartsSubDialog.ChartsIcon chartsIcon = (BaseChartsSubDialog.ChartsIcon)this.mSimpleChartList.getSelectedValue();
        if (chartsIcon instanceof LineIcon) {
            LineIcon lineIcon = (LineIcon)chartsIcon;
            this.mChartsPanel.mSimpleLinesStr = lineIcon.getGlyphId();
        }
        int n = this.mGroupChartList.getModel().getSize();
        this.mChartsPanel.mLinesCategs = new String[n];
        for (int i = 0; i < n; ++i) {
            LineIcon lineIcon = (LineIcon)this.mGroupChartList.getModel().getElementAt(i);
            this.mChartsPanel.mLinesCategs[i] = lineIcon.getGlyphId();
        }
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultGroupChartListModel() {
        int n = PrefDefaults.DEF_CHART_LINE_CYCLE.length;
        BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new LineIcon[n];
        for (int i = 0; i < n; ++i) {
            chartsIconArray[i] = new LineIcon(PrefDefaults.DEF_CHART_LINE_CYCLE[i]);
        }
        return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultSimpleChartListModel() {
        return new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new LineIcon[]{new LineIcon("6")});
    }

    @Override
    protected void setSubTabPolicy() {
    }

    protected BaseChartsSubDialog.NameIconListModel getGroupChartListModel() {
        if (this.mChartsPanel.mLinesCategs != null) {
            int n = this.mChartsPanel.mLinesCategs.length;
            BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new LineIcon[n];
            for (int i = 0; i < n; ++i) {
                chartsIconArray[i] = new LineIcon(this.mChartsPanel.mLinesCategs[i]);
            }
            return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
        }
        return this.getDefaultGroupChartListModel();
    }

    @Override
    protected boolean getSimpleSelection() {
        return sIsSimpleSelected;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        super.valueChanged(listSelectionEvent);
        Object object = listSelectionEvent.getSource();
        if (object == this.mLineTypeList) {
            int n = this.mLineTypeList.getSelectedIndex();
            if (this.mSimpleChartRadio.isSelected()) {
                this.redrawSelectedIcon(n, this.mSimpleChartList);
            } else if (this.mGroupChartRadio.isSelected()) {
                this.redrawSelectedIcon(n, this.mGroupChartList);
            }
        } else if (object == this.mGroupChartList) {
            Object e2 = this.mGroupChartList.getSelectedValue();
            if (e2 instanceof LineIcon) {
                LineIcon lineIcon = (LineIcon)e2;
                int n = Integer.parseInt(lineIcon.getGlyphId());
                this.mLineTypeList.setSelectedIndex(n);
                this.mLineTypeList.scrollRectToVisible(this.mLineTypeList.getCellBounds(n, n));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChartsLinesDlg.this.mGroupChartList.requestFocus();
                    }
                });
            }
        } else if (object == this.mSimpleChartList && (e = this.mSimpleChartList.getSelectedValue()) instanceof LineIcon) {
            LineIcon lineIcon = (LineIcon)e;
            int n = Integer.parseInt(lineIcon.getGlyphId());
            this.mLineTypeList.setSelectedIndex(n);
            this.mLineTypeList.scrollRectToVisible(this.mLineTypeList.getCellBounds(n, n));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartsLinesDlg.this.mSimpleChartList.requestFocus();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.mInsertBtn && (n = this.mGroupChartList.getSelectedIndex()) >= 0) {
            BaseChartsSubDialog.NameIconListModel nameIconListModel = (BaseChartsSubDialog.NameIconListModel)this.mGroupChartList.getModel();
            nameIconListModel.insertElementAt(new LineIcon(this.getNextPrefId()), n);
            this.mGroupChartList.setSelectedIndex(n);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object == this.mSimpleChartRadio) {
            sIsSimpleSelected = true;
            Object e = this.mSimpleChartList.getSelectedValue();
            if (e instanceof LineIcon) {
                LineIcon lineIcon = (LineIcon)e;
                int n = Integer.parseInt(lineIcon.getGlyphId());
                this.mLineTypeList.setSelectedIndex(n);
                this.mLineTypeList.scrollRectToVisible(this.mLineTypeList.getCellBounds(n, n));
            }
        } else if (object == this.mGroupChartRadio) {
            sIsSimpleSelected = false;
            Object e = this.mGroupChartList.getSelectedValue();
            if (e instanceof LineIcon) {
                LineIcon lineIcon = (LineIcon)e;
                int n = Integer.parseInt(lineIcon.getGlyphId());
                this.mLineTypeList.setSelectedIndex(n);
                this.mLineTypeList.scrollRectToVisible(this.mLineTypeList.getCellBounds(n, n));
            }
        }
    }

    private void redrawSelectedIcon(int n, JList jList) {
        Object e = jList.getSelectedValue();
        if (e instanceof LineIcon) {
            LineIcon lineIcon = (LineIcon)e;
            lineIcon.setGlyphId(String.valueOf(n));
            jList.repaint();
        }
    }

    private String getNextPrefId() {
        int n;
        String string = "0";
        int n2 = this.mLineTypeList.getModel().getSize();
        int[] nArray = new int[n2];
        int n3 = this.mGroupChartList.getModel().getSize();
        for (n = 0; n < n3; ++n) {
            LineIcon lineIcon = (LineIcon)this.mGroupChartList.getModel().getElementAt(n);
            int n4 = Integer.parseInt(lineIcon.getGlyphId());
            nArray[n4] = nArray[n4] + 1;
        }
        n = 0;
        int n5 = 0;
        while (n == 0) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] > n5) continue;
                string = String.valueOf(i);
                n = 1;
                break;
            }
            ++n5;
        }
        return string;
    }

    public void doHelp() {
    }

    class LineIcon
    extends BaseChartsSubDialog.ChartsIcon {
        private String mGlyphId;

        LineIcon(String string) {
            this.mGlyphId = string.trim();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(Color.white);
            graphics2D.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            BufferedImage bufferedImage = new BufferedImage(100, 13, 12);
            Graphics graphics2 = bufferedImage.getGraphics();
            Image image = new ImageIcon(ResUtil.getImageResource((String)("LineStyle" + (Integer.parseInt(this.mGlyphId) + 1) + ".gif"))).getImage();
            graphics2.drawImage(image, 0, 0, 100, 13, (ImageObserver)((Object)ChartsLinesDlg.this));
            graphics2D.drawImage(bufferedImage.getSubimage(0, 0, 32, 13), 0, 2, 32, 13, (ImageObserver)((Object)ChartsLinesDlg.this));
            graphics2.dispose();
            if (!this.mIsEnabled) {
                graphics2D.setPaint(new Color(0.7f, 0.7f, 0.7f, 0.5f));
                graphics2D.fill(new Rectangle(0, 0, 32, this.getIconHeight()));
            }
        }

        @Override
        public int getIconWidth() {
            return 32;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        public String getGlyphId() {
            return this.mGlyphId;
        }

        public void setGlyphId(String string) {
            this.mGlyphId = string;
        }
    }
}

