/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.charteditor.component.DefaultIconPicker;
import com.spss.charteditor.uimodel.DefaultIconSelectionModel;
import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.ui.dialogs.base.edit.BaseChartsSubDialog;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;

public class ChartsFillsDlg
extends BaseChartsSubDialog
implements ChangeListener {
    private static boolean sIsSimpleSelected = true;
    private static final PatternGlyphMap mPatternGlyphMap = new PatternGlyphMap();
    private DefaultIconPicker mPatternTypePanel;
    private final int ROW_NUM = 5;
    private final int COL_NUM = 6;

    public ChartsFillsDlg(ChartsOptionPanel chartsOptionPanel, BaseDialog baseDialog, String string) {
        super(chartsOptionPanel, baseDialog, string);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_idd_pattern_dialog";
    }

    @Override
    protected JList getSimpleChartList() {
        String string = this.mChartsPanel.mSimpleFillsStr;
        FillIcon fillIcon = new FillIcon(mPatternGlyphMap.getGlyph(string));
        BaseChartsSubDialog.NameIconListModel nameIconListModel = new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new FillIcon[]{fillIcon});
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JList getGroupChartList() {
        BaseChartsSubDialog.NameIconListModel nameIconListModel = this.getGroupChartListModel();
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JPanel getAvailablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, n2, n2);
        JLabel jLabel = new JLabel(this.getResString("IDS_CHARTS_AVAILABLE_FILLS"));
        ImageIcon[] imageIconArray = new ImageIcon[30];
        for (int i = 0; i < imageIconArray.length; ++i) {
            imageIconArray[i] = new ImageIcon(ResUtil.getImageResource((String)("pattern" + i + ".gif")));
        }
        this.mPatternTypePanel = new DefaultIconPicker(imageIconArray, 5, 6, false){

            public void setSelectedIndex(int n) {
                super.setSelectedIndex(n);
            }
        };
        this.mPatternTypePanel.addChangeListener((ChangeListener)this);
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, (JComponent)this.mPatternTypePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Object e = this.mSimpleChartList.getSelectedValue();
        if (e instanceof FillIcon) {
            FillIcon fillIcon = (FillIcon)e;
            int n3 = Integer.parseInt(fillIcon.getGlyphId());
            this.mPatternTypePanel.setSelection(n3 / 6, n3 % 6);
        }
        return jPanel;
    }

    @Override
    protected void doContinue() {
        BaseChartsSubDialog.ChartsIcon chartsIcon = (BaseChartsSubDialog.ChartsIcon)this.mSimpleChartList.getSelectedValue();
        if (chartsIcon instanceof FillIcon) {
            FillIcon fillIcon = (FillIcon)chartsIcon;
            this.mChartsPanel.mSimpleFillsStr = mPatternGlyphMap.getPattern(fillIcon.getGlyphId());
        }
        int n = this.mGroupChartList.getModel().getSize();
        this.mChartsPanel.mFillsCategs = new String[n];
        for (int i = 0; i < n; ++i) {
            FillIcon fillIcon = (FillIcon)this.mGroupChartList.getModel().getElementAt(i);
            this.mChartsPanel.mFillsCategs[i] = mPatternGlyphMap.getPattern(fillIcon.getGlyphId());
        }
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultGroupChartListModel() {
        int n = PrefDefaults.DEF_CHART_PATTERN_CYCLE.length;
        BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new FillIcon[n];
        for (int i = 0; i < n; ++i) {
            chartsIconArray[i] = new FillIcon(mPatternGlyphMap.getGlyph(PrefDefaults.DEF_CHART_PATTERN_CYCLE[i]));
        }
        return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultSimpleChartListModel() {
        FillIcon fillIcon = new FillIcon(mPatternGlyphMap.getGlyph("6"));
        return new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new FillIcon[]{fillIcon});
    }

    @Override
    protected void setSubTabPolicy() {
    }

    protected BaseChartsSubDialog.NameIconListModel getGroupChartListModel() {
        if (this.mChartsPanel.mFillsCategs != null) {
            int n = this.mChartsPanel.mFillsCategs.length;
            BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new FillIcon[n];
            for (int i = 0; i < n; ++i) {
                chartsIconArray[i] = new FillIcon(mPatternGlyphMap.getGlyph(this.mChartsPanel.mFillsCategs[i]));
            }
            return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
        }
        return this.getDefaultGroupChartListModel();
    }

    @Override
    protected boolean getSimpleSelection() {
        return sIsSimpleSelected;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof DefaultIconSelectionModel) {
            int n = this.mPatternTypePanel.getSelectedCol();
            int n2 = this.mPatternTypePanel.getSelectedRow();
            int n3 = 6 * n2 + n;
            if (this.mSimpleChartRadio.isSelected()) {
                this.redrawSelectedIcon(n3, this.mSimpleChartList);
            } else if (this.mGroupChartRadio.isSelected()) {
                this.redrawSelectedIcon(n3, this.mGroupChartList);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.mInsertBtn && (n = this.mGroupChartList.getSelectedIndex()) >= 0) {
            BaseChartsSubDialog.NameIconListModel nameIconListModel = (BaseChartsSubDialog.NameIconListModel)this.mGroupChartList.getModel();
            nameIconListModel.insertElementAt(new FillIcon(this.getNextPrefId()), n);
            this.mGroupChartList.setSelectedIndex(n);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        super.valueChanged(listSelectionEvent);
        Object object = listSelectionEvent.getSource();
        if (object == this.mGroupChartList) {
            Object e2 = this.mGroupChartList.getSelectedValue();
            if (e2 instanceof FillIcon) {
                FillIcon fillIcon = (FillIcon)e2;
                int n = Integer.parseInt(fillIcon.getGlyphId());
                this.mPatternTypePanel.setSelection(n / 6, n % 6);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChartsFillsDlg.this.mGroupChartList.requestFocus();
                    }
                });
            }
        } else if (object == this.mSimpleChartList && (e = this.mSimpleChartList.getSelectedValue()) instanceof FillIcon) {
            FillIcon fillIcon = (FillIcon)e;
            int n = Integer.parseInt(fillIcon.getGlyphId());
            this.mPatternTypePanel.setSelection(n / 6, n % 6);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartsFillsDlg.this.mSimpleChartList.requestFocus();
                }
            });
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object == this.mSimpleChartRadio) {
            sIsSimpleSelected = true;
            Object e = this.mSimpleChartList.getSelectedValue();
            if (e instanceof FillIcon) {
                FillIcon fillIcon = (FillIcon)e;
                int n = Integer.parseInt(fillIcon.getGlyphId());
                this.mPatternTypePanel.setSelection(n / 6, n % 6);
            }
        } else if (object == this.mGroupChartRadio) {
            sIsSimpleSelected = false;
            Object e = this.mGroupChartList.getSelectedValue();
            if (e instanceof FillIcon) {
                FillIcon fillIcon = (FillIcon)e;
                int n = Integer.parseInt(fillIcon.getGlyphId());
                this.mPatternTypePanel.setSelection(n / 6, n % 6);
            }
        }
    }

    private void redrawSelectedIcon(int n, JList jList) {
        Object e = jList.getSelectedValue();
        if (e instanceof FillIcon) {
            FillIcon fillIcon = (FillIcon)e;
            fillIcon.setGlyphId(String.valueOf(n));
            jList.repaint();
        }
    }

    private String getNextPrefId() {
        int n;
        String string = "0";
        int n2 = this.mPatternTypePanel.getImageList().length;
        int[] nArray = new int[n2];
        int n3 = this.mGroupChartList.getModel().getSize();
        for (n = 0; n < n3; ++n) {
            FillIcon fillIcon = (FillIcon)this.mGroupChartList.getModel().getElementAt(n);
            int n4 = Integer.parseInt(fillIcon.getGlyphId());
            nArray[n4] = nArray[n4] + 1;
        }
        n = 0;
        int n5 = 0;
        while (n == 0) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] > n5) continue;
                string = String.valueOf(i);
                n = 1;
                break;
            }
            ++n5;
        }
        return string;
    }

    public void doHelp() {
    }

    static class PatternGlyphMap {
        private static final int SIZE = 30;
        private HashMap<String, String> mGlyph = new HashMap(30);
        private HashMap<String, String> mPattern;

        public PatternGlyphMap() {
            this.mGlyph.put("0", "0");
            this.mGlyph.put("1", "6");
            this.mGlyph.put("2", "2");
            this.mGlyph.put("3", "3");
            this.mGlyph.put("4", "4");
            this.mGlyph.put("5", "5");
            this.mGlyph.put("6", "12");
            this.mGlyph.put("7", "7");
            this.mGlyph.put("8", "8");
            this.mGlyph.put("9", "9");
            this.mGlyph.put("10", "10");
            this.mGlyph.put("11", "11");
            this.mGlyph.put("12", "1");
            this.mGlyph.put("13", "24");
            this.mGlyph.put("14", "14");
            this.mGlyph.put("15", "21");
            this.mGlyph.put("16", "16");
            this.mGlyph.put("17", "17");
            this.mGlyph.put("18", "18");
            this.mGlyph.put("19", "19");
            this.mGlyph.put("20", "20");
            this.mGlyph.put("21", "27");
            this.mGlyph.put("22", "22");
            this.mGlyph.put("23", "23");
            this.mGlyph.put("24", "13");
            this.mGlyph.put("25", "25");
            this.mGlyph.put("26", "26");
            this.mGlyph.put("27", "15");
            this.mGlyph.put("28", "28");
            this.mGlyph.put("29", "29");
            Set<Map.Entry<String, String>> set = this.mGlyph.entrySet();
            this.mPattern = new HashMap(30);
            for (Map.Entry<String, String> entry : set) {
                this.mPattern.put(entry.getValue(), entry.getKey());
            }
        }

        public String getGlyph(String string) {
            return this.mGlyph.get(string.trim());
        }

        public String getPattern(String string) {
            return this.mPattern.get(string.trim());
        }
    }

    class FillIcon
    extends BaseChartsSubDialog.ChartsIcon {
        private String mGlyphId;

        FillIcon(String string) {
            this.mGlyphId = string.trim();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(Color.white);
            graphics2D.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.drawImage(new ImageIcon(ResUtil.getImageResource((String)("pattern" + this.mGlyphId + ".gif"))).getImage(), 2, 0, 16, 16, (ImageObserver)((Object)ChartsFillsDlg.this));
            if (!this.mIsEnabled) {
                graphics2D.setPaint(new Color(0.7f, 0.7f, 0.7f, 0.5f));
                graphics2D.fill(new Rectangle(0, 0, 18, 18));
            }
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }

        public String getGlyphId() {
            return this.mGlyphId;
        }

        public void setGlyphId(String string) {
            this.mGlyphId = string;
        }
    }
}

