/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.edit.BaseChartsSubDialog;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.ColorWellPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.drop_menu_button.ColorItemDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;

public class ChartsColorsDlg
extends BaseChartsSubDialog
implements ChangeListener {
    private static boolean sIsSimpleSelected = true;
    private ColorWellPanel mColorWellPanel;

    public ChartsColorsDlg(ChartsOptionPanel chartsOptionPanel, BaseDialog baseDialog, String string) {
        super(chartsOptionPanel, baseDialog, string);
    }

    public void setListSelectedColor(Color color, JList jList) {
        if (color == null) {
            return;
        }
        Object e = jList.getSelectedValue();
        if (e instanceof ColorIcon) {
            ColorIcon colorIcon = (ColorIcon)e;
            colorIcon.setColor(color);
            jList.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.mInsertBtn && (n = this.mGroupChartList.getSelectedIndex()) >= 0) {
            BaseChartsSubDialog.NameIconListModel nameIconListModel = (BaseChartsSubDialog.NameIconListModel)this.mGroupChartList.getModel();
            nameIconListModel.insertElementAt(new ColorIcon(this.getNextColor()), n);
            this.mGroupChartList.setSelectedIndex(n);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        super.valueChanged(listSelectionEvent);
        Object object = listSelectionEvent.getSource();
        if (object == this.mGroupChartList && (e = this.mGroupChartList.getSelectedValue()) instanceof ColorIcon) {
            ColorIcon colorIcon = (ColorIcon)e;
            this.mColorWellPanel.mPicker.setSelectedColor(colorIcon.getColor());
            if (this.mColorWellPanel.mPicker.getSelIndex() == -1 || this.mColorWellPanel.mPicker.getSelIndex() == 0 || this.mColorWellPanel.mPicker.getSelIndex() == 1 || this.mColorWellPanel.mPicker.getSelIndex() == 2) {
                this.mColorWellPanel.retEditButton().setEnabled(false);
            } else {
                this.mColorWellPanel.retEditButton().setEnabled(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartsColorsDlg.this.mGroupChartList.requestFocus();
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.mColorWellPanel.retEditButton().setEnabled(true);
        this.setListSelectedColor(this.mColorWellPanel.mPicker.getSelectedColor(), this.mGroupChartList);
        this.mGroupChartList.repaint();
    }

    @Override
    protected JList getSimpleChartList() {
        return null;
    }

    public JList getGroupList() {
        return this.mGroupChartList;
    }

    public void doHelp() {
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_idd_colors_dialog";
    }

    @Override
    protected JList getGroupChartList() {
        BaseChartsSubDialog.NameIconListModel nameIconListModel = this.getGroupChartListModel();
        JList jList = new JList(nameIconListModel);
        jList.setCellRenderer(new BaseChartsSubDialog.NameIconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    @Override
    protected JPanel getAvailablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, 3, n2);
        JLabel jLabel = new JLabel(this.getResString("IDS_CHARTS_AVAILABLE_COLORS"));
        Color color = this.mChartsPanel.mSimpleColorsStr != null ? this.getColorFromString(this.mChartsPanel.mSimpleColorsStr) : null;
        this.mColorWellPanel = new ColorWellPanel(this, color, this.mChartsPanel.mSwatchColors);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mColorWellPanel.setPreferredSize(new Dimension(this.mColorWellPanel.getPreferredSize().width + 10, this.mColorWellPanel.getPreferredSize().height + 10));
        } else {
            jLabel.setDisplayedMnemonic(this.getResInt("IDK_CHARTS_AVAILABLE_COLORS_KEY"));
            jLabel.setLabelFor((Component)this.mColorWellPanel.getPicker());
        }
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, this.mColorWellPanel, gridBagConstraints, 0, 1, 1, 4, n, insets);
        this.mColorWellPanel.getPicker().addChangeListener((ChangeListener)this);
        return jPanel;
    }

    @Override
    protected void doContinue() {
        int n = this.mGroupChartList.getModel().getSize();
        this.mChartsPanel.mColorsCategs = new String[n];
        Color color = null;
        for (int i = 0; i < n; ++i) {
            ColorIcon colorIcon = (ColorIcon)this.mGroupChartList.getModel().getElementAt(i);
            Color color2 = colorIcon.mColor;
            if (i == 0) {
                color = color2;
            }
            this.mChartsPanel.mColorsCategs[i] = color2.getAlpha() == 0 ? "transparent" : color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue();
        }
        if (color != null) {
            this.mChartsPanel.mSimpleColorsStr = color.getAlpha() == 0 ? "transparent" : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        ColorItemDescriptor[] colorItemDescriptorArray = this.mColorWellPanel.getPicker().getColorDesc();
        colorItemDescriptorArray[0].setColor(Color.WHITE);
        colorItemDescriptorArray[1].setColor(Color.BLACK);
        colorItemDescriptorArray[2].setColor(new Color(255, 255, 255, 0));
        for (int i = 0; i < this.mChartsPanel.mSwatchColors.length; ++i) {
            this.mChartsPanel.mSwatchColors[i] = colorItemDescriptorArray[i + 3].getColor();
        }
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultGroupChartListModel() {
        int n = 30;
        BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new ColorIcon[n];
        for (int i = 0; i < n; ++i) {
            chartsIconArray[i] = new ColorIcon(this.getColorFromString(PrefDefaults.DEF_CHART_COLOR_CYCLE[i]));
        }
        return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
    }

    @Override
    protected BaseChartsSubDialog.NameIconListModel getDefaultSimpleChartListModel() {
        return new BaseChartsSubDialog.NameIconListModel(this.getResString("IDS_CHARTS_ALL_DATA"), new ColorIcon[]{new ColorIcon(new Color(211, 206, 151))});
    }

    @Override
    protected void setSubTabPolicy() {
        this.mTabOrder.add(this.mColorWellPanel.getPicker());
        this.mTabOrder.add(this.mColorWellPanel.retEditButton());
        this.mTabOrder.add(this.mColorWellPanel.retResetButton());
    }

    protected BaseChartsSubDialog.NameIconListModel getGroupChartListModel() {
        if (this.mChartsPanel.mColorsCategs != null) {
            int n = this.mChartsPanel.mColorsCategs.length;
            BaseChartsSubDialog.ChartsIcon[] chartsIconArray = new ColorIcon[n];
            for (int i = 0; i < n; ++i) {
                chartsIconArray[i] = new ColorIcon(this.getColorFromString(this.mChartsPanel.mColorsCategs[i]));
            }
            return new BaseChartsSubDialog.NameIconListModel(chartsIconArray);
        }
        return this.getDefaultGroupChartListModel();
    }

    @Override
    protected boolean getSimpleSelection() {
        return sIsSimpleSelected;
    }

    private Color getColorFromString(String string) {
        if ("transparent".equals(string)) {
            return new Color(255, 255, 255, 0);
        }
        int n = 0;
        Object[] objectArray = new String[4];
        Arrays.fill(objectArray, "255");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n++] = stringTokenizer.nextToken();
        }
        return new Color(Integer.parseInt(((String)objectArray[0]).trim()), Integer.parseInt(((String)objectArray[1]).trim()), Integer.parseInt(((String)objectArray[2]).trim()));
    }

    private Color getNextColor() {
        int n;
        int n2;
        Color color = new Color(255, 255, 255);
        ColorItemDescriptor[] colorItemDescriptorArray = this.mColorWellPanel.mPicker.getColorDesc();
        int n3 = colorItemDescriptorArray.length;
        int[] nArray = new int[n3];
        int n4 = this.mGroupChartList.getModel().getSize();
        block0: for (n2 = 0; n2 < n4; ++n2) {
            ColorIcon colorIcon = (ColorIcon)this.mGroupChartList.getModel().getElementAt(n2);
            for (n = 0; n < n3; ++n) {
                if (!colorItemDescriptorArray[n].getColor().equals(colorIcon.getColor())) continue;
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
                continue block0;
            }
        }
        n2 = 0;
        int n6 = 0;
        while (n2 == 0) {
            for (n = 0; n < n3; ++n) {
                if (nArray[n] > n6) continue;
                color = colorItemDescriptorArray[n].getColor();
                n2 = 1;
                break;
            }
            ++n6;
        }
        return color;
    }

    class ColorIcon
    extends BaseChartsSubDialog.ChartsIcon {
        private Color mColor;

        ColorIcon(Color color) {
            this.mColor = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(Color.white);
            graphics2D.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.setPaint(this.mColor);
            graphics2D.fill(new Rectangle(2, 0, 16, 16));
            if (!this.mIsEnabled) {
                graphics2D.setPaint(new Color(0.7f, 0.7f, 0.7f, 0.5f));
                graphics2D.fill(new Rectangle(0, 0, 18, 18));
            }
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setColor(Color color) {
            this.mColor = color;
        }
    }
}

