/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.ChartsColorsDlg;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class BaseChartsSubDialog
extends BaseDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    protected ContinueAction mContinueAction;
    protected CancelAction mCancelAction;
    protected HelpAction mHelpAction;
    protected SpssButtonGroup mStylesEditGroup;
    protected JRadioButton mSimpleChartRadio;
    protected JRadioButton mGroupChartRadio;
    protected JList mSimpleChartList;
    protected JList mGroupChartList;
    protected JButton mInsertBtn;
    protected JButton mRemoveBtn;
    protected JButton mResetSeqBtn;
    protected JButton mUpArrowBtn;
    protected JButton mDownArrowBtn;
    protected JScrollPane mScrollPane;
    protected String mCategoryStr = this.getResString("IDS_CHARTS_CAT");
    protected ChartsOptionPanel mChartsPanel;
    protected Vector<Object> mTabOrder;
    private JButton mContinueBtn;
    private JButton mCancelBtn;
    private JButton mHelpBtn;

    public BaseChartsSubDialog(ChartsOptionPanel chartsOptionPanel, BaseDialog baseDialog, String string) {
        super(baseDialog, string, true, com.spss.java_client.ui.resources.ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), com.spss.java_client.ui.resources.ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mChartsPanel = chartsOptionPanel;
        JPanel jPanel = this.getViewPanel();
        this.buildDialog(jPanel);
        this.initDialog();
        this.pack();
        this.setLocationRelativeTo((Component)baseDialog);
        this.setVisible(true);
    }

    protected void buildDialog(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(jPanel, this.getStylesToEditPanel(), gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        OptionsUtil.addUsingGBL(jPanel, this.getAvailablePanel(), gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, 0, n2, 0));
        this.setTabPolicy();
    }

    protected JPanel getStylesToEditPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CHARTS_STYLES_EDIT")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        boolean bl = this instanceof ChartsColorsDlg;
        if (!bl) {
            this.mSimpleChartRadio = DialogUtil.createRadioButton(this, "IDS_CHARTS_STYLES_SIMPLE", (ActionListener)this);
            this.mSimpleChartList = this.getSimpleChartList();
            this.mSimpleChartList.addListSelectionListener(this);
            this.mSimpleChartRadio.setSelected(true);
            this.mSimpleChartRadio.addItemListener(this);
        }
        this.mGroupChartRadio = DialogUtil.createRadioButton(this, "IDS_CHARTS_STYLES_GROUP", (ActionListener)this);
        this.mStylesEditGroup = new SpssButtonGroup();
        this.mStylesEditGroup.add(this.mSimpleChartRadio);
        this.mStylesEditGroup.add(this.mGroupChartRadio);
        this.mGroupChartRadio.addItemListener(this);
        this.mGroupChartList = this.getGroupChartList();
        this.mGroupChartList.addListSelectionListener(this);
        this.mInsertBtn = DialogUtil.createButton(this, "IDS_CHARTS_STYLES_INSERT", this);
        this.mRemoveBtn = DialogUtil.createButton(this, "IDS_CHARTS_STYLES_REMOVE", this);
        this.mResetSeqBtn = DialogUtil.createButton(this, "IDS_CHARTS_STYLES_RESET_SEQ", this);
        this.mUpArrowBtn = new JButton();
        this.mUpArrowBtn.addActionListener(this);
        this.mUpArrowBtn.setMaximumSize(new Dimension(18, 20));
        this.mUpArrowBtn.setMinimumSize(new Dimension(18, 20));
        this.mUpArrowBtn.setPreferredSize(new Dimension(18, 20));
        this.mUpArrowBtn.setIcon(new ImageIcon(ResUtil.getImageResource((String)"upArrow.gif")));
        this.mDownArrowBtn = new JButton();
        this.mDownArrowBtn.addActionListener(this);
        this.mDownArrowBtn.setMaximumSize(new Dimension(18, 20));
        this.mDownArrowBtn.setMinimumSize(new Dimension(18, 20));
        this.mDownArrowBtn.setPreferredSize(new Dimension(18, 20));
        this.mDownArrowBtn.setIcon(new ImageIcon(ResUtil.getImageResource((String)"downArrow.gif")));
        this.mScrollPane = new JScrollPane(this.mGroupChartList, 20, 31);
        this.mScrollPane.setPreferredSize(new Dimension(this.mGroupChartList.getPreferredSize().width + 20, 170));
        int n3 = Math.max(this.mInsertBtn.getPreferredSize().width, this.mRemoveBtn.getPreferredSize().width);
        int n4 = Math.max(this.mResetSeqBtn.getPreferredSize().width, this.mGroupChartList.getPreferredSize().width + 30);
        int n5 = Math.max(n3, n4 / 2);
        this.mInsertBtn.setPreferredSize(new Dimension(n5, this.mInsertBtn.getPreferredSize().height));
        this.mRemoveBtn.setPreferredSize(new Dimension(n5, this.mRemoveBtn.getPreferredSize().height));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        if (!bl) {
            OptionsUtil.addUsingGBL(jPanel, this.mSimpleChartRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
            OptionsUtil.addUsingGBL(jPanel, this.mGroupChartRadio, gridBagConstraints, 0, 2, 3, 1, n, insets);
            gridBagConstraints.fill = 2;
            OptionsUtil.addUsingGBL(jPanel, this.mSimpleChartList, gridBagConstraints, 0, 1, 3, 1, n, new Insets(0, 20, n2, n2));
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            OptionsUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 3, 2, 2, n, new Insets(0, 20, n2, 0));
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            OptionsUtil.addUsingGBL(jPanel, this.mUpArrowBtn, gridBagConstraints, 2, 3, 1, 1, 25, new Insets(0, n2, 5, n2));
            OptionsUtil.addUsingGBL(jPanel, this.mDownArrowBtn, gridBagConstraints, 2, 4, 1, 1, 23, new Insets(0, n2, 0, n2));
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsUtil.addUsingGBL(jPanel, this.mInsertBtn, gridBagConstraints, 0, 5, 1, 1, n, new Insets(0, 20, 0, n2));
            OptionsUtil.addUsingGBL(jPanel, this.mRemoveBtn, gridBagConstraints, 1, 5, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            OptionsUtil.addUsingGBL(jPanel, this.mResetSeqBtn, gridBagConstraints, 0, 6, 2, 1, n, new Insets(n2, 20, n2, 0));
        } else {
            Insets insets2 = DialogUtil.getStandardControlInsets();
            JLabel jLabel = DialogUtil.createLabel(this, "IDS_CHARTS_STYLES_GROUP");
            OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 3, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            OptionsUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 2, 2, n, insets2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            OptionsUtil.addUsingGBL(jPanel, this.mUpArrowBtn, gridBagConstraints, 2, 1, 1, 1, 25, new Insets(0, n2, 5, n2));
            OptionsUtil.addUsingGBL(jPanel, this.mDownArrowBtn, gridBagConstraints, 2, 2, 1, 1, 23, new Insets(0, n2, 0, n2));
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsUtil.addUsingGBL(jPanel, this.mInsertBtn, gridBagConstraints, 0, 3, 1, 1, n, new Insets(n2, 20, 0, n2));
            OptionsUtil.addUsingGBL(jPanel, this.mRemoveBtn, gridBagConstraints, 1, 3, 1, 1, n, new Insets(n2, 10, 0, 0));
            gridBagConstraints.weighty = 1.0;
            OptionsUtil.addUsingGBL(jPanel, this.mResetSeqBtn, gridBagConstraints, 0, 4, 2, 1, n, new Insets(n2, 20, n2, 0));
        }
        return jPanel;
    }

    protected void initDialog() {
        if (this instanceof ChartsColorsDlg) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (BaseChartsSubDialog.this.getSimpleSelection()) {
                        BaseChartsSubDialog.this.mSimpleChartRadio.doClick();
                    } else {
                        BaseChartsSubDialog.this.mGroupChartRadio.doClick();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        this.mContinueAction = new ContinueAction();
        this.mCancelAction = new CancelAction();
        this.mHelpAction = new HelpAction();
        this.mContinueBtn = new JButton(this.mContinueAction);
        this.mCancelBtn = new JButton(this.mCancelAction);
        this.mHelpBtn = new JButton(this.mHelpAction);
        DialogUtil.setupMacHelpButton(this.mHelpBtn);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mHelpBtn, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelBtn, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mContinueBtn, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mContinueBtn);
            jPanel.add(this.mCancelBtn);
            jPanel.add(this.mHelpBtn);
        }
        this.getRootPane().setDefaultButton(this.mContinueBtn);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void setTabPolicy() {
        this.mTabOrder = new Vector();
        this.mTabOrder.add(this.mStylesEditGroup);
        if (this.mSimpleChartList != null) {
            this.mTabOrder.add(this.mSimpleChartList);
        }
        this.mTabOrder.add(this.mGroupChartList);
        this.mTabOrder.add(this.mInsertBtn);
        this.mTabOrder.add(this.mRemoveBtn);
        this.mTabOrder.add(this.mResetSeqBtn);
        this.mTabOrder.add(this.mUpArrowBtn);
        this.mTabOrder.add(this.mDownArrowBtn);
        this.setSubTabPolicy();
        this.mTabOrder.add(this.mContinueBtn);
        this.mTabOrder.add(this.mCancelBtn);
        this.mTabOrder.add(this.mHelpBtn);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    protected abstract String getDialogHelpID();

    protected abstract JList getSimpleChartList();

    protected abstract JList getGroupChartList();

    protected abstract JPanel getAvailablePanel();

    protected abstract void doContinue();

    protected abstract NameIconListModel getDefaultGroupChartListModel();

    protected abstract NameIconListModel getDefaultSimpleChartListModel();

    protected abstract void setSubTabPolicy();

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSimpleChartRadio) {
            OptionPanel.setComponentEnableState(this.mSimpleChartList, true);
            OptionPanel.setComponentEnableState(this.mScrollPane, false);
            this.mInsertBtn.setEnabled(false);
            this.mRemoveBtn.setEnabled(false);
            this.mUpArrowBtn.setEnabled(false);
            this.mDownArrowBtn.setEnabled(false);
        } else if (object == this.mGroupChartRadio) {
            OptionPanel.setComponentEnableState(this.mSimpleChartList, false);
            OptionPanel.setComponentEnableState(this.mScrollPane, true);
            this.mInsertBtn.setEnabled(true);
            this.mRemoveBtn.setEnabled(true);
            int n = this.mGroupChartList.getSelectedIndex();
            if (n == 0) {
                this.mUpArrowBtn.setEnabled(false);
            } else {
                this.mUpArrowBtn.setEnabled(true);
            }
            if (n == this.mGroupChartList.getModel().getSize() - 1) {
                this.mDownArrowBtn.setEnabled(false);
            } else {
                this.mDownArrowBtn.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.mSimpleChartRadio) {
            OptionPanel.setComponentEnableState(this.mSimpleChartList, true);
            OptionPanel.setComponentEnableState(this.mScrollPane, false);
            this.mInsertBtn.setEnabled(false);
            this.mRemoveBtn.setEnabled(false);
            this.mUpArrowBtn.setEnabled(false);
            this.mDownArrowBtn.setEnabled(false);
        } else if (object == this.mGroupChartRadio) {
            OptionPanel.setComponentEnableState(this.mSimpleChartList, false);
            OptionPanel.setComponentEnableState(this.mScrollPane, true);
            this.mInsertBtn.setEnabled(true);
            this.mRemoveBtn.setEnabled(true);
            int n2 = this.mGroupChartList.getSelectedIndex();
            if (n2 == 0) {
                this.mUpArrowBtn.setEnabled(false);
            } else {
                this.mUpArrowBtn.setEnabled(true);
            }
            if (n2 == this.mGroupChartList.getModel().getSize() - 1) {
                this.mDownArrowBtn.setEnabled(false);
            } else {
                this.mDownArrowBtn.setEnabled(true);
            }
        } else if (object == this.mUpArrowBtn) {
            int n3 = this.mGroupChartList.getSelectedIndex();
            if (n3 > 0) {
                NameIconListModel nameIconListModel = (NameIconListModel)this.mGroupChartList.getModel();
                ChartsIcon chartsIcon = (ChartsIcon)nameIconListModel.elementAt(n3);
                nameIconListModel.removeElementAt(n3);
                nameIconListModel.insertElementAt(chartsIcon, n3 - 1);
                this.mGroupChartList.setSelectedIndex(n3 - 1);
                int n4 = n3;
                int n5 = n3 - 1;
                this.mGroupChartList.addSelectionInterval(n4, n5);
                this.mGroupChartList.ensureIndexIsVisible(n3 - 1);
            }
        } else if (object == this.mDownArrowBtn) {
            int n6 = this.mGroupChartList.getSelectedIndex();
            if (n6 < this.mGroupChartList.getModel().getSize() - 1) {
                NameIconListModel nameIconListModel = (NameIconListModel)this.mGroupChartList.getModel();
                ChartsIcon chartsIcon = (ChartsIcon)nameIconListModel.elementAt(n6);
                nameIconListModel.removeElementAt(n6);
                nameIconListModel.insertElementAt(chartsIcon, n6 + 1);
                this.mGroupChartList.setSelectedIndex(n6 + 1);
                int n7 = n6;
                int n8 = n6 + 1;
                this.mGroupChartList.addSelectionInterval(n7, n8);
                this.mGroupChartList.ensureIndexIsVisible(n8);
            }
        } else if (object == this.mRemoveBtn) {
            int n9 = this.mGroupChartList.getSelectedIndex();
            if (n9 != -1) {
                NameIconListModel nameIconListModel = (NameIconListModel)this.mGroupChartList.getModel();
                if (nameIconListModel.getSize() > 2) {
                    nameIconListModel.removeElementAt(n9);
                    if (n9 >= this.mGroupChartList.getModel().getSize()) {
                        --n9;
                    }
                    this.mGroupChartList.setSelectedIndex(n9);
                } else {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("IDS_CHARTS_TWO_ITEMS_WARNING"), VersionInfo.getAppVersionString());
                }
            }
        } else if (object == this.mResetSeqBtn && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_CHARTS_RESET_DEFAULT_WARN"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1) {
            if (this instanceof ChartsColorsDlg) {
                NameIconListModel nameIconListModel = this.getDefaultGroupChartListModel();
                this.mGroupChartList.setModel(nameIconListModel);
                this.mGroupChartList.setSelectedIndex(0);
            } else {
                NameIconListModel nameIconListModel;
                if (this.mGroupChartRadio.isSelected()) {
                    nameIconListModel = this.getDefaultGroupChartListModel();
                    this.mGroupChartList.setModel(nameIconListModel);
                    this.mGroupChartList.setSelectedIndex(0);
                }
                if (this.mSimpleChartRadio.isSelected()) {
                    nameIconListModel = this.getDefaultSimpleChartListModel();
                    this.mSimpleChartList.setModel(nameIconListModel);
                    this.mSimpleChartList.setSelectedIndex(0);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.mGroupChartList) {
            int n = this.mGroupChartList.getSelectedIndex();
            if (n == 0) {
                this.mUpArrowBtn.setEnabled(false);
            } else {
                this.mUpArrowBtn.setEnabled(true);
            }
            if (n == this.mGroupChartList.getModel().getSize() - 1) {
                this.mDownArrowBtn.setEnabled(false);
            } else {
                this.mDownArrowBtn.setEnabled(true);
            }
        }
    }

    protected abstract boolean getSimpleSelection();

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", com.spss.java_client.ui.resources.ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, BaseChartsSubDialog.this.getDialogHelpID());
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", com.spss.java_client.ui.resources.ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseChartsSubDialog.this.dispose();
        }
    }

    private class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", com.spss.java_client.ui.resources.ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseChartsSubDialog.this.doContinue();
            BaseChartsSubDialog.this.dispose();
        }
    }

    abstract class ChartsIcon
    implements Icon,
    Cloneable {
        protected boolean mIsEnabled = true;

        ChartsIcon() {
        }

        public void setEnable(boolean bl) {
            this.mIsEnabled = bl;
        }

        public ChartsIcon clone() throws CloneNotSupportedException {
            return (ChartsIcon)super.clone();
        }
    }

    class NameIconListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        NameIconListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            NameIconListModel nameIconListModel = (NameIconListModel)jList.getModel();
            if (nameIconListModel.getName() == null) {
                this.setText(BaseChartsSubDialog.this.mCategoryStr + (n + 1));
            } else {
                this.setText(nameIconListModel.getName());
            }
            this.setIcon((ChartsIcon)object);
            this.setEnabled(jList.isEnabled());
            try {
                object2 = ((ChartsIcon)object).clone();
                ((ChartsIcon)object2).setEnable(false);
                this.setDisabledIcon((Icon)object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setForeground(jList.getSelectionForeground());
                        this.setBackground(jList.getSelectionBackground());
                    } else {
                        this.setForeground(Color.black);
                        this.setBackground(Color.lightGray);
                    }
                } else {
                    this.setForeground(jList.getForeground());
                    this.setBackground(jList.getBackground());
                }
            } else {
                this.setOpaque(false);
            }
            object2 = null;
            if (bl2) {
                if (bl) {
                    object2 = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                object2 = new EmptyBorder(1, 1, 1, 1);
            }
            this.setBorder((Border)object2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class NameIconListModel
    extends DefaultListModel {
        private String mNameStr;

        NameIconListModel(ChartsIcon[] chartsIconArray) {
            this(null, chartsIconArray);
        }

        NameIconListModel(String string, ChartsIcon[] chartsIconArray) {
            this.mNameStr = string;
            for (ChartsIcon chartsIcon : chartsIconArray) {
                this.addElement(chartsIcon);
            }
        }

        public String getName() {
            return this.mNameStr;
        }
    }
}

