/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.select_cases;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SelectCasesSample
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    public static final String APPROX_RADIO_KEY = "IDS_SELECT_CASES_APPROXIMATELY";
    public static final String EXACT_RADIO_KEY = "IDS_SELECT_CASES_EXACTLY";
    public static final String APPROXIMATE_TEXT_KEY = "APPROXIMATE_VALUE";
    public static final String EXACT_FROM_TEXT_KEY = "EXACT_FROM_VALUE";
    public static final String EXACT_TO_TEXT_KEY = "EXACT_TO_VALUE";
    public static final String SAMPLE_TEXT = "SAMPLE_TEXT";
    private IntTextField mApproximateText;
    private IntTextField mExactFromText;
    private IntTextField mExactToText;
    private boolean mIsExactSelected;
    private JRadioButton mExactlyRadio;
    private JRadioButton mApproximatelyRB;
    private JLabel mExactTolabel;
    private Vector<Object> mTabOrder;
    SpssButtonGroup mGroup;

    public SelectCasesSample(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_SELECT_CASES_SAMPLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mApproximatelyRB.isSelected() && (n = Integer.parseInt(this.mApproximateText.getText())) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SELECT_CASES_ERROR_MESSAGE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mApproximateText.requestFocus();
            this.mApproximateText.selectAll();
            return false;
        }
        if (this.mIsExactSelected) {
            String string = this.mExactFromText.getText();
            String string2 = this.mExactToText.getText();
            int n2 = Integer.parseInt(this.mExactFromText.getText());
            if (n2 == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SELECT_CASES_ERROR_MESSAGE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mExactFromText.requestFocus();
                this.mExactFromText.selectAll();
                return false;
            }
            if (Integer.parseInt(string) >= Integer.parseInt(string2)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SELECT_CASES_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
                this.mExactFromText.requestFocus();
                this.mExactFromText.selectAll();
                return false;
            }
        }
        return super.continuePressed();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateData();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateData();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mIsExactSelected = this.mExactlyRadio.isSelected();
        this.enableApproximateText(!this.mIsExactSelected);
        this.enableExactText(this.mIsExactSelected);
        this.validateData();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sele_samp";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SELECT_CASES_SAMPLE_SIZE")));
        this.setupViewPanel(jPanel);
        this.enableContinue(false);
        this.enableApproximateText(!this.mIsExactSelected);
        this.enableExactText(this.mIsExactSelected);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(SAMPLE_TEXT, this.getFinalString());
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Boolean bl = dialogDataModel.getBoolean(EXACT_RADIO_KEY);
        this.mIsExactSelected = null == bl ? false : bl;
        this.enableApproximateText(!this.mIsExactSelected);
        this.enableExactText(this.mIsExactSelected);
    }

    private void initVars() {
        this.mApproximateText = new IntTextField(1, 99, true);
        this.mApproximateText.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        this.mApproximateText.getDocument().addDocumentListener(this);
        this.mApproximateText.setAction((Action)new TextFieldAction(this, APPROXIMATE_TEXT_KEY));
        this.mExactFromText = new IntTextField(true);
        this.mExactFromText.setDocument((Document)new FixedLengthNumericDocument(7, true, false));
        this.mExactFromText.getDocument().addDocumentListener(this);
        this.mExactToText = new IntTextField(true);
        this.mExactToText.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mExactToText.getDocument().addDocumentListener(this);
        this.mExactFromText.setAction((Action)new TextFieldAction(this, EXACT_FROM_TEXT_KEY));
        this.mExactToText.setAction((Action)new TextFieldAction(this, EXACT_TO_TEXT_KEY));
        this.mExactTolabel = DialogUtil.createLabel(this, "IDS_SELECT_CASES_EXACT_LABEL_FIRST");
        this.mExactTolabel.setLabelFor((Component)this.mExactToText);
        this.mApproximatelyRB = new JRadioButton(new ToggleButtonAction(this, APPROX_RADIO_KEY));
        this.mExactlyRadio = new JRadioButton(new ToggleButtonAction(this, EXACT_RADIO_KEY));
        this.mExactlyRadio.addItemListener(this);
        this.mApproximatelyRB.addItemListener(this);
        this.mApproximatelyRB.setSelected(!this.mIsExactSelected);
        this.mTabOrder = new Vector();
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mExactlyRadio);
        this.mGroup.add(this.mApproximatelyRB);
    }

    private void enableApproximateText(boolean bl) {
        this.mApproximateText.setEnabled(bl);
        this.mApproximateText.setOpaque(bl);
    }

    private void enableExactText(boolean bl) {
        this.mExactFromText.setEnabled(bl);
        this.mExactToText.setEnabled(bl);
        this.mExactFromText.setOpaque(bl);
        this.mExactToText.setOpaque(bl);
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = this.setupApproxPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupExactPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupApproxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n, 0);
        int n3 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_SELECT_CASES_APPROXIMATE_PERCENT"));
        DialogUtil.addUsingGBL(jPanel, this.mApproximatelyRB, gridBagConstraints, 0, 0, 2, 1, n3, insets);
        this.mApproximateText.setColumns(2);
        insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mApproximateText, gridBagConstraints, 2, 0, 1, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 3, 0, 4, 1, n3, insets);
        return jPanel;
    }

    private JPanel setupExactPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n, 0);
        int n3 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_SELECT_CASES_EXACT_LABEL_LAST"));
        jLabel.setLabelFor((Component)this.mExactToText);
        DialogUtil.addUsingGBL(jPanel, this.mExactlyRadio, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mExactFromText, gridBagConstraints, 1, 0, 2, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mExactTolabel, gridBagConstraints, 3, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mExactToText, gridBagConstraints, 4, 0, 2, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 6, 0, 1, 1, n3, insets);
        return jPanel;
    }

    private String getFinalString() {
        String string;
        if (this.mIsExactSelected) {
            String string2 = this.mExactFromText.getText();
            String string3 = this.mExactToText.getText();
            string = this.getResString("IDS_SELECT_CASES_EXACT_FORMAT");
            string = MessageFormat.format(string, string2, string3);
        } else {
            string = this.getResString("IDS_SELECT_CASES_APP_FORMAT");
            string = MessageFormat.format(string, this.mApproximateText.getText());
        }
        return string;
    }

    private void validateData() {
        boolean bl = false;
        if (this.mIsExactSelected) {
            if (this.mExactFromText.getText().length() > 0 && this.mExactToText.getText().length() > 0) {
                bl = true;
            }
        } else if (this.mApproximateText.getText().length() > 0) {
            bl = true;
        }
        this.enableContinue(bl);
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mGroup);
        this.mTabOrder.add(this.mApproximateText);
        this.mTabOrder.add(this.mExactFromText);
        this.mTabOrder.add(this.mExactToText);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

