/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.select_cases;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.base.data.select_cases.SelectCasesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SelectCasesRange
extends BaseSubDialog
implements DocumentListener {
    protected static final String RANGE_TEXT = "RANGE_TEXT";
    protected static final String STATUS_LINE_ONE_KEY = "STATUS_LINE_ONE_KEY";
    protected static final String STATUS_LINE_TWO_KEY = "STATUS_LINE_TWO_KEY";
    protected static final String FIRST_TEXT_KEY = "FIRST_TEXT_KEY";
    protected static final String LAST_TEXT_KEY = "LAST_TEXT_KEY";
    static final String LABEL_HOUR = "IDS_HOURS";
    static final String LABEL_MINITE = "IDS_MINUTES";
    static final String LABEL_SECOND = "IDS_SECONDS";
    private List<String> mAllLabels;
    private IntTextField[] mFirst;
    private IntTextField[] mLast;
    private static ResourceBundle sResourceBundle;

    public SelectCasesRange(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_SELECT_CASES_RANGE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        sResourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        for (int i = 0; i < this.mFirst.length; ++i) {
            if (this.mFirst[i].getText().length() != 0 && Integer.parseInt(this.mFirst[i].getText()) == 0 && !this.isZeroAllowed(i)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SELECT_CASES_ERROR_MESSAGE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.focusAndSelect(this.mFirst[i]);
                bl = false;
            }
            if (!bl || this.mLast[i].getText().length() == 0 || Integer.parseInt(this.mLast[i].getText()) != 0) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_SELECT_CASES_ERROR_MESSAGE_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.focusAndSelect(this.mLast[i]);
            bl = false;
        }
        if (bl && this.hasDateDefined()) {
            String string;
            SrcVariableList srcVariableList = ((SelectCasesDlg)((Object)this.getParent())).getSourceList();
            int n = DateFactory.getDateVariableLabels(srcVariableList).size();
            if (n > 1 && (this.mFirst[0].getText().length() == 0 && this.mFirst[1].getText().length() > 0 || this.mLast[0].getText().length() == 0 && this.mLast[1].getText().length() > 0 || this.mFirst[1].getText().length() == 0 && this.mFirst[0].getText().length() > 0 || this.mLast[1].getText().length() == 0 && this.mLast[0].getText().length() > 0)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_HIGHERDATE_EMPTY_WARNING"), VersionInfo.getAppVersionString());
                string = this.mFirst[0].getText().length() == 0 && this.mFirst[1].getText().length() > 0 ? this.mFirst[0] : (this.mLast[0].getText().length() == 0 && this.mLast[1].getText().length() > 0 ? this.mLast[0] : (this.mFirst[1].getText().length() == 0 && this.mFirst[0].getText().length() > 0 ? this.mFirst[1] : this.mLast[1]));
                this.focusAndSelect((IntTextField)string);
                bl = false;
            }
            if (bl) {
                List<Integer> list = DateFactory.getPeriodicity(srcVariableList);
                List<String> list2 = DateFactory.getDateVariableNames(srcVariableList);
                for (int i = 0; bl && i < n; ++i) {
                    string = this.mFirst[i].getText();
                    String string2 = this.mLast[i].getText();
                    int n2 = list.get(i);
                    if (n2 <= 0) continue;
                    if (!this.isTimePeriod(list2, i)) {
                        ++n2;
                    }
                    if (string.length() > 0 && Integer.parseInt(string) >= n2) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXCEED_PERIODICITY_WARNING"), VersionInfo.getAppVersionString());
                        this.focusAndSelect(this.mFirst[i]);
                        bl = false;
                        break;
                    }
                    if (string2.length() <= 0 || Integer.parseInt(string2) < n2) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXCEED_PERIODICITY_WARNING"), VersionInfo.getAppVersionString());
                    this.focusAndSelect(this.mLast[i]);
                    bl = false;
                }
            }
            if (bl && n > 1 && this.mFirst[0].getText().length() > 0 && this.mLast[0].getText().length() > 0) {
                int n3 = this.compareValues(this.mFirst[0].getText(), this.mLast[0].getText());
                int n4 = this.compareValues(this.mFirst[1].getText(), this.mLast[1].getText());
                if (n3 == 3 || n3 == 1 && n4 == 3) {
                    bl = false;
                    this.showMessageBox("ERR_SELECT_CASES_RANGE_ERROR_MESSAGE", this.mFirst[0]);
                }
            }
        }
        if (bl) {
            bl = super.continuePressed();
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mFirst[0].getText().length() > 0 || this.mLast[0].getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mFirst[0].getText().length() > 0 || this.mLast[0].getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sele_date";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = this.setupViewPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.enableContinue(false);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            String string = this.getFinalString();
            boolean bl2 = bl = string != null;
            if (bl) {
                dialogDataModel.putString(RANGE_TEXT, string);
            }
        }
        return bl;
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_SELECT_CASES_RANGE_FIRST_LABEL"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_SELECT_CASES_RANGE_LAST_LABEL"));
        this.mAllLabels = DateFactory.getDateVariableLabels(((SelectCasesDlg)((Object)this.getParent())).getSourceList());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        this.mLast = new IntTextField[this.mAllLabels.size()];
        this.mFirst = new IntTextField[this.mAllLabels.size()];
        int n2 = 0;
        for (String string : this.mAllLabels) {
            JLabel jLabel3 = new JLabel(string);
            this.mLast[n2] = new IntTextField(true);
            this.mFirst[n2] = new IntTextField(true);
            this.mFirst[n2].setColumns(4);
            this.mLast[n2].setColumns(4);
            if (this.hasDateDefined()) {
                this.mFirst[n2].setDocument((Document)new FixedLengthNumericDocument(4, true, false));
                this.mLast[n2].setDocument((Document)new FixedLengthNumericDocument(4, true, false));
            } else {
                this.mFirst[n2].setDocument((Document)new FixedLengthNumericDocument(9, true, false));
                this.mLast[n2].setDocument((Document)new FixedLengthNumericDocument(9, true, false));
            }
            this.mFirst[n2].setAction((Action)new TextFieldAction(this, "FIRST_TEXT_KEY_" + n2));
            this.mLast[n2].setAction((Action)new TextFieldAction(this, "LAST_TEXT_KEY_" + n2));
            gridBagConstraints.weightx = 0.0;
            n = 12;
            DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, n2 + 1, 1, 1, n, insets);
            n = 23;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFirst[n2], gridBagConstraints, 1, n2 + 1, 1, 1, n, insets);
            this.mFirst[n2].getDocument().addDocumentListener(this);
            jLabel3.setLabelFor((Component)this.mFirst[n2]);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLast[n2], gridBagConstraints, 2, n2 + 1, 1, 1, n, insets);
            this.mLast[n2].getDocument().addDocumentListener(this);
            ++n2;
        }
        return jPanel;
    }

    private void showMessageBox(String string, IntTextField intTextField) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString(string), VersionInfo.getAppVersionString());
        this.focusAndSelect(intTextField);
    }

    private boolean isTimePeriod(List<String> list, int n) {
        if (n < 0 || n >= list.size()) {
            return false;
        }
        String string = list.get(n);
        return string.equals("HOUR_") || string.equals("MINUTE_") || string.equals("SECOND_");
    }

    private void focusAndSelect(final IntTextField intTextField) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                intTextField.requestFocus();
                intTextField.selectAll();
            }
        });
    }

    private String getFinalString() {
        String string = "{0} thru {1}";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        SrcVariableList srcVariableList = ((SelectCasesDlg)((Object)this.getParent())).getSourceList();
        if (this.hasDateDefined()) {
            List<String> list = DateFactory.getDateSyntaxString(srcVariableList);
            for (String string2 : list) {
                String string3 = this.mFirst[n3].getText();
                String string4 = this.mLast[n3].getText();
                string2 = string2.replaceAll(":", "");
                if (string3.trim().length() == 0) {
                    if (n == -1) {
                        n = n3;
                    }
                    if (string4.trim().length() == 0) {
                        ++n3;
                        continue;
                    }
                } else {
                    stringBuffer2.append(string2).append(" ");
                    stringBuffer3.append(string2).append(" ");
                    if (n != -1) {
                        this.showMessageBox("ERR_SELECT_CASES_RANGE_ERROR_MESSAGE", this.mFirst[n]);
                        return null;
                    }
                }
                if (string4.trim().length() == 0) {
                    if (n2 == -1) {
                        n2 = n3;
                    }
                    stringBuffer2.append(string3).append(" ");
                    ++n3;
                    continue;
                }
                stringBuffer.append(string2).append(" ");
                stringBuffer4.append(string2).append(" ");
                stringBuffer2.append(string3).append(" ");
                if (n3 == list.size() - 1) {
                    stringBuffer3.append(string3).append(" ");
                } else {
                    stringBuffer3.append(string3).append(", ");
                }
                stringBuffer.append(string4).append(" ");
                if (n3 == list.size() - 1) {
                    stringBuffer4.append(string4).append(" ");
                } else {
                    stringBuffer4.append(string4).append(", ");
                }
                if (n2 != -1) {
                    this.showMessageBox("ERR_SELECT_CASES_RANGE_ERROR_MESSAGE", this.mLast[n2]);
                    return null;
                }
                ++n3;
            }
            stringBuffer2 = stringBuffer2.toString().trim().length() == 0 ? new StringBuffer("first") : stringBuffer2;
            stringBuffer = stringBuffer.toString().trim().length() == 0 ? new StringBuffer("last") : stringBuffer;
            string = MessageFormat.format(string, stringBuffer2.toString().toLowerCase().trim(), stringBuffer.toString().toLowerCase().trim());
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            dialogDataModel.putString(STATUS_LINE_ONE_KEY, stringBuffer3.toString().trim());
            dialogDataModel.putString(STATUS_LINE_TWO_KEY, "-" + stringBuffer4.toString().trim());
        } else {
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            String string5 = DateFactory.getDateVariableLabels(srcVariableList).get(n3);
            string5 = string5.replaceAll(":", " ");
            String string6 = this.mFirst[n3].getText();
            if (string6.length() == 0) {
                string6 = "first";
                dialogDataModel.putString(STATUS_LINE_ONE_KEY, string6);
            } else {
                dialogDataModel.putString(STATUS_LINE_ONE_KEY, string5 + string6.trim());
            }
            String string7 = this.mLast[n3].getText();
            if (string7.length() == 0) {
                string7 = "last";
                dialogDataModel.putString(STATUS_LINE_TWO_KEY, "-" + string7);
            } else {
                dialogDataModel.putString(STATUS_LINE_TWO_KEY, "-" + string5 + string7.trim());
            }
            string = MessageFormat.format(string, string6.trim(), string7.trim());
        }
        return string;
    }

    private int compareValues(String string, String string2) {
        int n = -1;
        int n2 = -1;
        if (string.length() > 0) {
            n = Integer.parseInt(string);
        }
        if (string2.length() > 0) {
            n2 = Integer.parseInt(string2);
        }
        int n3 = n == n2 ? 1 : (n2 == -1 || n < n2 ? 2 : 3);
        return n3;
    }

    private boolean hasDateDefined() {
        SrcVariableList srcVariableList = ((SelectCasesDlg)((Object)this.getParent())).getSourceList();
        return DateFactory.getDateVariableNames(srcVariableList).size() > 0;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(Arrays.asList(this.mFirst));
        vector.addAll(Arrays.asList(this.mLast));
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean isZeroAllowed(int n) {
        return this.mAllLabels.get(n).equalsIgnoreCase(ResUtil.getString(sResourceBundle, LABEL_HOUR)) || this.mAllLabels.get(n).equalsIgnoreCase(ResUtil.getString(sResourceBundle, LABEL_MINITE)) || this.mAllLabels.get(n).equalsIgnoreCase(ResUtil.getString(sResourceBundle, LABEL_SECOND));
    }
}

