/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.select_cases;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectCasesIf
extends BaseSubDialog
implements DocumentListener,
KeyListener,
MouseListener {
    protected static final String IF_CONDITION_TEXT = "IF_CONDITION_TEXT";
    private SrcVariableList mSrcVarList;
    private ExpressionBuilderTextArea mTargetArea;
    private CalcWidget mCalcPanel;
    private ExpressionAreaArrowButton mArrowButton;
    private JTextArea mDescriptionTextArea;
    private JList mFunctionGrpList;
    private JList mFunctionSpecialVarsList;
    private ArrowButton mFunctionListArrowButton;
    private FunctionListControls mFunctionListControls;

    public SelectCasesIf(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_SELECT_CASES_IF"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public boolean continuePressed() {
        if (!this.mTargetArea.validateContents() || !this.isValidComputeExpression()) {
            this.mTargetArea.requestFocus();
            this.mTargetArea.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sele_if";
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)this.getFocusTraversalPolicy();
            Component component = (Component)keyEvent.getSource();
            Component component2 = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)this), component) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)this), component);
            keyEvent.consume();
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals((Object)this.mTargetArea) && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            int n = this.mTargetArea.getSelectionStart();
            int n2 = this.mTargetArea.getSelectionEnd();
            this.mTargetArea.select(n, n2);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mTargetArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
        }
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(IF_CONDITION_TEXT, this.mTargetArea.getText());
        }
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mSrcVarList.setSelectedIndex(0);
        String string = dialogDataModel.getString(IF_CONDITION_TEXT);
        string = string != null ? string : "";
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
        this.mTargetArea.setText(string);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("IfSourceList");
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mTargetArea = new ExpressionBuilderTextArea(3, 30);
        this.mTargetArea.setLineWrap(true);
        this.mTargetArea.setWrapStyleWord(true);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mTargetArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mFunctionListControls.setSrcList(this.mSrcVarList);
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mTargetArea));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in If");
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionListControls.setFunctionListIdentifier("Function list in If");
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents((JComponent)((Object)this.mTargetArea), SpssArrowButton.ButtonOrientation.left);
        this.enableButtons();
    }

    private void setupViewPanel(JPanel jPanel) {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        JLabel jLabel = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        jLabel.setLabelFor(this.mFunctionGrpList);
        JLabel jLabel2 = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        jLabel2.setLabelFor(this.mFunctionSpecialVarsList);
        JScrollPane jScrollPane3 = new JScrollPane(this.mFunctionGrpList);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JScrollPane jScrollPane4 = new JScrollPane(this.mFunctionSpecialVarsList);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mTargetArea.getDocument().addDocumentListener(this);
        this.mTargetArea.addKeyListener(this);
        this.mTargetArea.addMouseListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_SELECT_CASES_IF_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 3, 9, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 3, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane((Component)((Object)this.mTargetArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 4, 1, 7, 2, n, null);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets = new Insets(n2 * 2, insets3.left, 0, n2 * 3);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 3, 7, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 4, 4, 1, 3, n, DialogUtil.getStandardControlInsets());
        insets.set(n2 * 2, insets3.left, 0, n2 * 3);
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 5, 5, 1, 2, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 6, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 6, 4, 1, 1, n, null);
        insets.set(n2, 0, 0, 0);
        n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 6, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 6, 6, 1, 2, n, null);
    }

    private void enableButtons() {
        String string = this.mTargetArea.getText();
        this.enableContinue(string.trim().length() > 0 && !this.hasUnquotedQuestionMark(string));
    }

    private boolean hasUnquotedQuestionMark(String string) {
        int n = string.indexOf("'");
        int n2 = string.indexOf("\"");
        int n3 = string.indexOf("?");
        if (n3 > -1) {
            int n4 = Math.min(n > -1 ? n : 65535, n2 > -1 ? n2 : 65535);
            return n3 < n4;
        }
        return false;
    }

    private boolean isValidComputeExpression() {
        ExpressionValidator expressionValidator = new ExpressionValidator();
        String string = this.mTargetArea.getText();
        boolean bl = expressionValidator.validateIfExpression(string);
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), expressionValidator.checkError(), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add((Object)this.mTargetArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGrpList);
        vector.add(this.mFunctionSpecialVarsList);
        vector.add(this.mFunctionListArrowButton);
        vector.add(this.mDescriptionTextArea);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

