/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.select_cases;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.base.data.select_cases.SelectCasesIf;
import com.spss.java_client.ui.dialogs.base.data.select_cases.SelectCasesRange;
import com.spss.java_client.ui.dialogs.base.data.select_cases.SelectCasesSample;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SelectCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private static final String DATASET_TEXT = "DATASET_TEXT";
    private static final String ALL_RADIO_KEY = "IDS_ALL_RADIO";
    private static final String IF_CONDITION_RADIO_KEY = "IDS_IF_CONDITION_RADIO";
    private static final String RANDOM_SAMPLE_RADIO_KEY = "IDS_RANDOM_SAMPLE_RADIO";
    private static final String BASED_RADIO_KEY = "IDS_BASED_RADIO";
    private static final String USE_FILTER_RADIO_KEY = "IDS_FILTER_RADIO";
    private static final String FILTER_OUT_RADIO_KEY = "IDS_FILTER_OUT_RADIO";
    private static final String COPY_RADIO_KEY = "IDS_COPY_RADIO";
    private static final String DELETE_RADIO_KEY = "IDS_DELETE_RADIO";
    private static String FILTER_NAME = "";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JButton mIfButton;
    private JButton mRandomButton;
    private JButton mRangeButton;
    private ArrowButton mArrowButton;
    private JRadioButton mFilterRadio;
    private JRadioButton mCopyRadio;
    private JRadioButton mDeleteRadio;
    private JRadioButton mAllCasesRadio;
    private JLabel mDatasetLabel;
    private StringTextField mDatasetText;
    private JLabel mRangeLabel;
    private JLabel mSampleLabel;
    private JLabel mLblStatus;
    private JLabel mLblStatus2;
    private JLabel mIfLabel;
    private Vector<Object> mTabOrder;

    public SelectCasesDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SELECT_CASES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = this.mAllCasesRadio.isSelected();
        if (this.mCopyRadio.isEnabled() && this.mCopyRadio.isSelected()) {
            stringBuffer.append(this.generateSyntaxForDataset(true, bl2));
        }
        if ((bl = dialogDataModel.getBoolean(USE_FILTER_RADIO_KEY)) != null && bl.booleanValue()) {
            if (this.mCopyRadio.isSelected() || this.mDeleteRadio.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("ALL"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            if (this.mFilterRadio.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY "));
                stringBuffer.append(this.mTargetVarList.getVariablesStringList());
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommand("SELECT IF "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("(NOT("));
                stringBuffer.append(this.mTargetVarList.getVariablesStringList()).append("=0))");
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        } else {
            bl = dialogDataModel.getBoolean(RANDOM_SAMPLE_RADIO_KEY);
            if (bl != null && bl.booleanValue()) {
                if (this.mFilterRadio.isSelected()) {
                    this.generateSyntaxForFilter(stringBuffer, dialogDataModel);
                } else {
                    this.generateSyntaxForRandom(stringBuffer, dialogDataModel);
                }
            } else {
                bl = dialogDataModel.getBoolean(IF_CONDITION_RADIO_KEY);
                if (bl != null && bl.booleanValue()) {
                    this.generateSyntaxForIf(stringBuffer, dialogDataModel);
                } else {
                    this.generateSyntaxForNonFilter(stringBuffer, dialogDataModel);
                }
            }
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append("EXECUTE.\n");
        }
        if (this.mCopyRadio.isEnabled() && this.mCopyRadio.isSelected()) {
            stringBuffer.append(this.generateSyntaxForDataset(false, bl2));
        }
        return stringBuffer.toString();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableDatasetControls(this.mCopyRadio.isEnabled() && this.mCopyRadio.isSelected());
    }

    @Override
    public String getIActionKey() {
        return "data_select_cases";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.setDefaults();
        this.enableOutputPanel(false);
        this.enableOkPaste(true);
    }

    @Override
    public boolean okPastePressed() {
        if (this.mCopyRadio.isSelected()) {
            int n = DatasetNameValidator.validateDatasetName((String)this.mDatasetText.getText(), (Component)((Object)this));
            if (n == 1) {
                return true;
            }
            this.mDatasetText.requestFocus();
            this.mDatasetText.selectAll();
            return false;
        }
        return true;
    }

    public SrcVariableList getSourceList() {
        return this.mSrcVarList;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sele";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setDefaults();
        this.enableOkPaste(true);
        this.enableOutputPanel(false);
        this.pack();
        this.setTabPolicy();
    }

    @Override
    protected void loadDialogState() {
        Boolean bl;
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getString("SAMPLE_TEXT") != null) {
            this.setSampleLabelText(dialogDataModel.getString("SAMPLE_TEXT"));
        }
        if (dialogDataModel.getString("RANGE_TEXT") != null) {
            this.setRangeLabelText(dialogDataModel.getString("RANGE_TEXT"));
        }
        if (dialogDataModel.getString("IF_CONDITION_TEXT") != null) {
            this.setIfLabelText(dialogDataModel.getString("IF_CONDITION_TEXT"));
        }
        this.mIfLabel.setEnabled((bl = dialogDataModel.getBoolean(IF_CONDITION_RADIO_KEY)) != null && bl != false);
        Boolean bl2 = dialogDataModel.getBoolean(RANDOM_SAMPLE_RADIO_KEY);
        this.mSampleLabel.setEnabled(bl2 != null && bl2 != false);
        Boolean bl3 = dialogDataModel.getBoolean(BASED_RADIO_KEY);
        this.mRangeLabel.setEnabled(bl3 != null && bl3 != false);
        if (this.getFiltervarName() != null) {
            String string = this.getResString("IDS_FILTER_CASES_BY_VALUES_OF_LABEL") + this.getFiltervarName();
            String string2 = "";
            if (string != null) {
                FILTER_NAME = string;
            }
            if (string == null || string.trim().length() == 0) {
                this.mLblStatus.setText(this.getResString("IDS_CUR_STATUS_LABEL") + FILTER_NAME);
                this.mLblStatus2.setText("");
                return;
            }
            this.mLblStatus.setText(this.getResString("IDS_CUR_STATUS_LABEL") + string);
            this.mLblStatus2.setText(string2);
        } else if (this.isUseFilterSet()) {
            String string = "";
            String string3 = "";
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            long l = iSpssDataSrc.getTrendsInfo().getUseHiCase();
            long l2 = iSpssDataSrc.getTrendsInfo().getUseLoCase();
            if (l != 0L || l2 != 0L) {
                String string4 = this.getResString("IDS_SELECT_CASES_RANGE_OBSERVATION").replaceAll(":", " ");
                string = l2 == 0L ? this.getResString("IDS_SELECT_CASES_RANGE_FIRST") : string4 + l2;
                string3 = l == 0L ? "-" + this.getResString("IDS_SELECT_CASES_RANGE_LAST") : "-" + string4 + l;
            }
            this.mLblStatus.setText(this.getResString("IDS_CUR_STATUS_LABEL") + string);
            this.mLblStatus2.setText(string3);
        } else {
            this.mLblStatus.setText(this.getResString("IDS_STATUS_LABEL"));
            this.mLblStatus2.setText("");
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("LABEL_FIRST", this.mLblStatus.getText());
        this.getDialogDataModel().putString("LABEL_SECOND", this.mLblStatus2.getText());
    }

    private void setSampleLabelText(String string) {
        this.mSampleLabel.setText(string);
        this.enableCommandButtons(string);
    }

    private void setRangeLabelText(String string) {
        if (string.length() > 30) {
            string = string.substring(0, 27);
            string = string + "...";
        }
        this.mRangeLabel.setText(string);
        this.enableCommandButtons(string);
    }

    private void setIfLabelText(String string) {
        if (string.length() > 30) {
            string = string.substring(0, 27);
            string = string + "...";
        }
        this.mIfLabel.setText(string);
        this.enableCommandButtons(string);
    }

    private String getFiltervarName() {
        String string = null;
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        if (iSpssDataSrc != null && iSpssDataSrc.getCaseFilter() != null && iSpssDataSrc.getFilterVarIndex() != -1 && iSpssDataSrc.getFilterVarId() != null) {
            string = iSpssDataSrc.getVariable(iSpssDataSrc.getFilterVarIndex()).getName();
            return string;
        }
        return string;
    }

    private boolean isUseFilterSet() {
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (((SpssDataSrc)iSpssDataSrc).getUseCaseFilter() != null && ((SpssDataSrc)iSpssDataSrc).getUseCaseFilter().getUseOn()) {
            bl = true;
            return bl;
        }
        return bl;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mIfButton = new JButton();
        this.mRandomButton = new JButton(this.getResString("IDS_RANDOM_3DOT"));
        this.mRangeButton = new JButton(this.getResString("IDS_RANGE_3DOT"));
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setMinimumSize(this.mArrowButton.getPreferredSize());
        this.mFilterRadio = new JRadioButton(this.createActionForOutputRB(FILTER_OUT_RADIO_KEY, false));
        this.mCopyRadio = new JRadioButton(this.createActionForOutputRB(COPY_RADIO_KEY, true));
        this.mDeleteRadio = new JRadioButton(this.createActionForOutputRB(DELETE_RADIO_KEY, false));
        this.mAllCasesRadio = this.createRButtonWithAction(ALL_RADIO_KEY);
        this.mDatasetLabel = DialogUtil.createLabel(this, "IDS_DATASET_LABEL");
        this.mDatasetText = new StringTextField(16);
        this.mDatasetText.setAction(new TextFieldAction(this, DATASET_TEXT));
        this.mDatasetLabel.setLabelFor((Component)((Object)this.mDatasetText));
        this.mRangeLabel = new JLabel();
        this.mSampleLabel = new JLabel();
        this.mLblStatus = new JLabel();
        this.mLblStatus.setPreferredSize(new Dimension(180, 17));
        this.mLblStatus2 = new JLabel();
        this.mLblStatus2.setPreferredSize(new Dimension(180, 17));
        this.mIfLabel = new JLabel();
        this.mTabOrder = new Vector();
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mTabOrder.add(this.mSrcVarList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SELECT")));
        this.setupSelectPanel(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.setupOutputPanel(jPanel3);
        this.mLblStatus = new JLabel(this.getResString("IDS_STATUS_LABEL"));
        int n = 23;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SELECT_CASES_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel4, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel4, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 0, 1, 2, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLblStatus, gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets.set(0, n2 * 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLblStatus2, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private void setupSelectPanel(JPanel jPanel) {
        int n;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        spssButtonGroup.add(this.mAllCasesRadio);
        this.mAllCasesRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = ((JRadioButton)itemEvent.getSource()).isSelected();
                SelectCasesDlg.this.enableOkPaste(bl);
                SelectCasesDlg.this.enableOutputPanel(!bl);
                SelectCasesDlg.this.mArrowButton.setEnabled(!bl);
            }
        });
        JRadioButton jRadioButton = this.createRButtonWithAction(IF_CONDITION_RADIO_KEY);
        jRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = ((JRadioButton)itemEvent.getSource()).isSelected();
                SelectCasesDlg.this.mIfButton.setEnabled(bl);
                SelectCasesDlg.this.enableCommandButtons(SelectCasesDlg.this.mIfLabel.getText());
                SelectCasesDlg.this.mIfLabel.setEnabled(bl);
                SelectCasesDlg.this.enableOutputPanel(bl);
                SelectCasesDlg.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                SelectCasesDlg.this.mArrowButton.setEnabled(false);
            }
        });
        spssButtonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = this.createRButtonWithAction(RANDOM_SAMPLE_RADIO_KEY);
        spssButtonGroup.add(jRadioButton2);
        jRadioButton2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = ((JRadioButton)itemEvent.getSource()).isSelected();
                SelectCasesDlg.this.mRandomButton.setEnabled(bl);
                SelectCasesDlg.this.enableCommandButtons(SelectCasesDlg.this.mSampleLabel.getText());
                SelectCasesDlg.this.mSampleLabel.setEnabled(bl);
                SelectCasesDlg.this.enableOutputPanel(bl);
                SelectCasesDlg.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                SelectCasesDlg.this.mArrowButton.setEnabled(false);
            }
        });
        JRadioButton jRadioButton3 = this.createRButtonWithAction(BASED_RADIO_KEY);
        spssButtonGroup.add(jRadioButton3);
        jRadioButton3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = ((JRadioButton)itemEvent.getSource()).isSelected();
                SelectCasesDlg.this.mRangeButton.setEnabled(bl);
                SelectCasesDlg.this.enableCommandButtons(SelectCasesDlg.this.mRangeLabel.getText());
                SelectCasesDlg.this.mRangeLabel.setEnabled(bl);
                SelectCasesDlg.this.enableOutputPanel(bl);
                SelectCasesDlg.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                SelectCasesDlg.this.mArrowButton.setEnabled(false);
            }
        });
        JRadioButton jRadioButton4 = this.createRButtonWithAction(USE_FILTER_RADIO_KEY);
        spssButtonGroup.add(jRadioButton4);
        jRadioButton4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = ((JRadioButton)itemEvent.getSource()).isSelected();
                SelectCasesDlg.this.mTargetVarList.setEnabled(bl);
                SelectCasesDlg.this.enableOutputPanel(bl);
                if (SelectCasesDlg.this.mTargetVarList.getModel().getSize() > 0) {
                    SelectCasesDlg.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                    SelectCasesDlg.this.mArrowButton.setEnabled(false);
                    SelectCasesDlg.this.enableOkPaste(true);
                } else {
                    SelectCasesDlg.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                    SelectCasesDlg.this.mArrowButton.setEnabled(true);
                    SelectCasesDlg.this.enableOkPaste(false);
                }
            }
        });
        this.mTabOrder.add(spssButtonGroup);
        AbstractAction abstractAction = new ToggleButtonAction("IDS_COMMON_IF_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectCasesDlg.this.runSubDialog(new SelectCasesIf(SelectCasesDlg.this))) {
                    SelectCasesDlg.this.setIfLabelText(SelectCasesDlg.this.getDialogDataModel().getString("IF_CONDITION_TEXT"));
                }
            }
        };
        this.mIfButton = new JButton(abstractAction);
        this.mTabOrder.add(this.mIfButton);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectCasesDlg.this.runSubDialog(new SelectCasesSample(SelectCasesDlg.this))) {
                    SelectCasesDlg.this.setSampleLabelText(SelectCasesDlg.this.getDialogDataModel().getString("SAMPLE_TEXT"));
                }
            }
        };
        this.addActionWithButton(this.mRandomButton, abstractAction, "IDS_RANDOM_3DOT");
        this.mTabOrder.add(this.mRandomButton);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectCasesDlg.this.runSubDialog(new SelectCasesRange(SelectCasesDlg.this))) {
                    SelectCasesDlg.this.setRangeLabelText(SelectCasesDlg.this.getDialogDataModel().getString("RANGE_TEXT"));
                }
            }
        };
        this.addActionWithButton(this.mRangeButton, abstractAction, "IDS_RANGE_3DOT");
        this.mTabOrder.add(this.mRangeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 1, 3);
        int n3 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllCasesRadio, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        gridBagConstraints.fill = 0;
        insets.left = n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mIfButton, gridBagConstraints, 0, 0, 1, 1, 21, insets);
        insets.left = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mIfLabel, gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, 21, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 3, 1, 1, n3, insets);
        gridBagConstraints.fill = 0;
        insets.left = n;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel3, this.mRandomButton, gridBagConstraints, 0, 0, 1, 1, 21, insets);
        insets.left = n2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mSampleLabel.setPreferredSize(new Dimension(180, 17));
        DialogUtil.addUsingGBL(jPanel3, this.mSampleLabel, gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, 21, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jRadioButton3, gridBagConstraints, 0, 5, 1, 1, n3, insets);
        gridBagConstraints.fill = 0;
        insets.left = n;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel4, this.mRangeButton, gridBagConstraints, 0, 0, 1, 1, 21, insets);
        insets.left = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mRangeLabel, gridBagConstraints, 1, 0, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 6, 1, 1, 21, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jRadioButton4, gridBagConstraints, 0, 7, 1, 1, n3, insets);
        insets.left = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.bottom = n2;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel5, this.mArrowButton, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.left = n2;
        insets.top = n;
        DialogUtil.addUsingGBL(jPanel5, jScrollPane, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        insets.top = 0;
        insets.right = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 8, 1, 1, 23, insets);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mTargetVarList);
        Dimension dimension = this.mRandomButton.getPreferredSize();
        this.mRangeButton.setPreferredSize(dimension);
        this.mIfButton.setPreferredSize(dimension);
        this.pack();
    }

    private void setupOutputPanel(JPanel jPanel) {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mFilterRadio.addItemListener(this);
        this.mCopyRadio.addItemListener(this);
        this.mDeleteRadio.addItemListener(this);
        spssButtonGroup.add(this.mFilterRadio);
        spssButtonGroup.add(this.mCopyRadio);
        spssButtonGroup.add(this.mDeleteRadio);
        this.mTabOrder.add(spssButtonGroup);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OUTPUT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFilterRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCopyRadio, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.left += 25;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.left -= 25;
        insets.right = 3;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetText), gridBagConstraints, 2, 2, 1, 1, n, insets);
        this.mTabOrder.add(this.mDatasetText);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDeleteRadio, gridBagConstraints, 0, 3, 3, 1, n, insets);
    }

    private JRadioButton createRButtonWithAction(String string) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, string);
        return new JRadioButton(toggleButtonAction);
    }

    private void addActionWithButton(JButton jButton, Action action, String string) {
        action.putValue("Name", this.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            string = string.replace("IDS_", "IDK_");
            action.putValue("MnemonicKey", this.getDlgAccessKey(string + "_KEY"));
        }
        jButton.setAction(action);
    }

    private Action createActionForOutputRB(String string, final boolean bl) {
        return new ToggleButtonAction(this, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectCasesDlg.this.enableDatasetControls(bl);
            }
        };
    }

    private void enableOutputPanel(boolean bl) {
        this.mFilterRadio.setEnabled(bl);
        this.mCopyRadio.setEnabled(bl);
        this.mDatasetLabel.setEnabled(bl && this.mCopyRadio.isSelected());
        this.mDatasetText.setEnabled(bl && this.mCopyRadio.isSelected());
        this.mDatasetText.setOpaque(bl);
        this.mDeleteRadio.setEnabled(bl);
        if (CommandLine.isClementineCaller()) {
            this.mFilterRadio.setEnabled(false);
        }
    }

    private void enableDatasetControls(boolean bl) {
        this.mDatasetLabel.setEnabled(bl);
        this.mDatasetText.setEnabled(bl);
        this.mDatasetText.setOpaque(bl);
    }

    private void enableCommandButtons(String string) {
        this.enableOkPaste(string != null && string.trim().length() != 0);
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mAllCasesRadio.setSelected(true);
        if (!CommandLine.isClementineCaller()) {
            this.mFilterRadio.setSelected(true);
        } else {
            this.mDeleteRadio.setSelected(true);
        }
        this.mArrowButton.setEnabled(false);
        this.mIfButton.setEnabled(false);
        this.mRandomButton.setEnabled(false);
        this.mRangeButton.setEnabled(false);
        this.mTargetVarList.setEnabled(false);
        this.setIfLabelText("");
        this.setSampleLabelText("");
        this.setRangeLabelText("");
        this.mDatasetText.setText("");
        this.mDatasetText.setOpaque(false);
        if (CommandLine.isClementineCaller()) {
            this.mCopyRadio.setEnabled(false);
        }
    }

    private void generateSyntaxForNonFilter(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mAllCasesRadio.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("ALL"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            Boolean bl = dialogDataModel.getBoolean(BASED_RADIO_KEY);
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(dialogDataModel.getString("RANGE_TEXT")));
                if (this.mDeleteRadio.isSelected()) {
                    stringBuffer.append(" /permanent");
                }
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        }
    }

    private void generateSyntaxForRandom(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("ALL"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("SAMPLE "));
        if (dialogDataModel.getBoolean("IDS_SELECT_CASES_EXACTLY").booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(dialogDataModel.getString("EXACT_FROM_VALUE")));
            stringBuffer.append(" from ");
            stringBuffer.append(dialogDataModel.getString("EXACT_TO_VALUE"));
        } else {
            String string = dialogDataModel.getString("APPROXIMATE_VALUE");
            double d = Double.parseDouble(string);
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.applyPattern(".00");
            string = decimalFormat.format(d / 100.0);
            string = UIToolResUtil.removeLocale((String)string);
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    private void generateSyntaxForFilter(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(SyntaxUtil.getMainCommand("USE ALL"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (dialogDataModel.getBoolean("IDS_SELECT_CASES_EXACTLY").booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("do if"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("$casenum=1"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("#s_$_1="));
            stringBuffer.append(dialogDataModel.getString("EXACT_FROM_VALUE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("#s_$_2="));
            stringBuffer.append(dialogDataModel.getString("EXACT_TO_VALUE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("end if"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("do if "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("#s_$_2 > 0"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$="));
            stringBuffer.append("uniform(1)* #s_$_2 < #s_$_1");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("#s_$_1="));
            stringBuffer.append("#s_$_1 - filter_$");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("#s_$_2="));
            stringBuffer.append("#s_$_2 - 1");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("else"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("compute"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$="));
            stringBuffer.append("0");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("end if"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            String string = dialogDataModel.getString("APPROXIMATE_VALUE");
            double d = Double.parseDouble(string);
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.applyPattern(".00");
            string = decimalFormat.format(d / 100.0);
            string = UIToolResUtil.removeLocale((String)string);
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$="));
            stringBuffer.append("(uniform(1)<=").append(string).append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$ "));
        stringBuffer.append(CharacterUtil.smartQuote((String)(dialogDataModel.getString("SAMPLE_TEXT") + " (SAMPLE)")));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$ (f1.0)"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("FILTER "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY filter_$"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    private void generateSyntaxForIf(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        String string = dialogDataModel.getString("IF_CONDITION_TEXT").replaceAll("\n", "");
        if (this.mFilterRadio.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("ALL"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$=("));
            stringBuffer.append(string).append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$ "));
            stringBuffer.append(CharacterUtil.smartQuote((String)(this.makeVarLabel(string) + " (FILTER)")));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("VALUE LABELS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$"));
            stringBuffer.append(" 0 'Not Selected' 1 'Selected'");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("filter_$ (f1.0)"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY filter_$"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommand("FILTER"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("USE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("ALL"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("SELECT IF"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("("));
            stringBuffer.append(string).append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    private String makeVarLabel(String string) {
        int n = 241;
        try {
            byte[] byArray = string.getBytes(ComponentState.getCurrentCharsetName());
            if (byArray.length < n) {
                return string;
            }
            string = new String(byArray, 0, n, ComponentState.getCurrentCharsetName()) + "...";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    private String generateSyntaxForDataset(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            String string = this.mDatasetText.getText();
            if (!bl2) {
                stringBuffer.append(SyntaxUtil.getMainCommand("DATASET COPY "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getMainCommand("DATASET ACTIVATE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        } else {
            String string = DatasetNameValidator.getActiveDatasetName();
            if (!bl2) {
                stringBuffer.append(SyntaxUtil.getMainCommand("DATASET ACTIVATE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        }
        return stringBuffer.toString();
    }

    private void setTabPolicy() {
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

