/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class V2CVarGroupsPage
extends AbstractWizardPage
implements DocumentListener,
ItemListener {
    public static final String IDS_ONE_GROUP_RADIO = "IDS_REST_V2C_VARGRP_ONE_RADIO";
    public static final String IDS_MULTIPLE_GROUP_RADIO = "IDS_REST_V2C_VARGRP_MANY_RADIO";
    public static final String IDS_MULTIPLE_GROUP_TEXT = "IDS_REST_V2C_VARGRP_MANY_TEXT";
    JRadioButton mMultipleRadio;
    ContextEnabledTextField mMultipleText;
    JLabel mMultipleLabel;
    private JRadioButton mOneRadio;
    private int mTotalVar;
    private DialogFocusTraversalPolicy mPolicy;

    public V2CVarGroupsPage(BaseWizardDialog baseWizardDialog) {
        super("V2CVariableGroups", baseWizardDialog.getResString("IDS_REST_V2C_VARGRP_TITLE"), baseWizardDialog, false);
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 0;
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel = this.setupPageBody();
        gridBagConstraints.weighty = 1.0;
        insets.top = n2;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jSeparator = new JSeparator();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    public boolean isMultipleRadioSeleted() {
        return this.mMultipleRadio.isSelected();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_v2c_step2";
    }

    public String getMultipleTextValue() {
        return this.mMultipleText.getText();
    }

    public boolean isOneRadioSelected() {
        return this.mOneRadio.isSelected();
    }

    @Override
    public boolean validate() {
        int n;
        if (this.mMultipleRadio.isSelected() && ((n = Integer.parseInt(this.mMultipleText.getText())) < 2 || n > this.mTotalVar)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_REST_MAX_WARNING"), this.mTotalVar), VersionInfo.getAppVersionString());
            this.mMultipleText.requestFocus();
            this.mMultipleText.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public boolean validateOnBack() {
        if (this.mMultipleRadio.isSelected() && this.mMultipleText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_REST_MAX_WARNING"), this.mTotalVar), VersionInfo.getAppVersionString());
            this.mMultipleText.requestFocus();
            return false;
        }
        return this.validate();
    }

    @Override
    public String getNextPage() {
        return "V2CSelectVarPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mMultipleRadio.isSelected()) {
            this.mWizardDialog.enableNext(this.mMultipleText.getText().length() > 0);
        } else {
            this.mWizardDialog.enableNext(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mMultipleRadio.isSelected();
        this.mMultipleLabel.setEnabled(bl);
        this.mMultipleText.setEnabled(bl);
        this.mMultipleText.setOpaque(bl);
        if (this.mMultipleRadio.isSelected()) {
            this.mWizardDialog.enableNext(this.mMultipleText.getText().length() > 0);
        } else {
            this.mWizardDialog.enableNext(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mMultipleRadio.isSelected()) {
            this.mWizardDialog.enableNext(this.mMultipleText.getText().length() > 0);
        } else {
            this.mWizardDialog.enableNext(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mMultipleRadio.isSelected()) {
            this.mWizardDialog.enableNext(this.mMultipleText.getText().length() > 0);
        }
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        if (this.mMultipleRadio.isSelected()) {
            this.mWizardDialog.enableNext(this.mMultipleText.getText().length() > 0);
        }
    }

    private void initVars() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ControlAction controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_ONE_GROUP_RADIO);
        this.mOneRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mOneRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_MULTIPLE_GROUP_RADIO);
        this.mMultipleRadio = new JRadioButton(controlAction);
        this.mOneRadio.addItemListener(this);
        this.mMultipleRadio.addItemListener(this);
        spssButtonGroup.add(this.mMultipleRadio);
        this.mMultipleText = new ContextEnabledTextField();
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_MULTIPLE_GROUP_TEXT);
        this.mMultipleText.setAction((Action)controlAction);
        this.mMultipleText.setDocument((Document)new NumDoc());
        this.mMultipleText.getDocument().addDocumentListener(this);
        this.mMultipleLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_V2C_VARGRP_MANY_LABEL");
        this.mMultipleLabel.setLabelFor((Component)this.mMultipleText);
        this.mTotalVar = this.getTotalSpssVar();
        this.setDefaults();
    }

    private int getTotalSpssVar() {
        LocallyUniqueId locallyUniqueId;
        int n = 10;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame && (locallyUniqueId = ((DataFrame)spssFrame).getDatasetId()) != null) {
            n = DataMgr.getDataMgr().getDataSource(locallyUniqueId).columnCount();
        }
        return n;
    }

    private void setDefaults() {
        this.mOneRadio.setSelected(true);
        this.mMultipleText.setColumns(4);
        this.mMultipleText.setText("2");
        this.mMultipleText.setEnabled(false);
        this.mMultipleText.setOpaque(false);
        this.mMultipleLabel.setEnabled(false);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_HEAD1"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_HEAD2"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        insets.left = 0;
        jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_HEAD3"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_HEAD4"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_HEAD5"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 4, 1, 1, n, insets);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel3 = new JLabel(imageIcon);
        gridBagConstraints.weightx = 0.0;
        insets.left = n2;
        insets.right = DialogUtil.getStandardControlInsets().right;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 3, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2 * 2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_VARGRP_BODY1"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.top = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mOneRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 21;
        insets.top = n2;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = this.setupMultipleVarPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_RESTDATA_V2C_ONETRANS_IMAGE"));
        JLabel jLabel2 = new JLabel(imageIcon);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.left = n2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 2, n, insets);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_RESTDATA_V2C_MULTITRANS_IMAGE"));
        jLabel2 = new JLabel(imageIcon);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 3, n, insets);
        return jPanel;
    }

    private JPanel setupMultipleVarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, DialogUtil.getStandardControlInsets().bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMultipleRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.left = n2 * 3;
        insets.top = 0;
        gridBagConstraints.weightx = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMultipleLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMultipleText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOneRadio);
        spssButtonGroup.add(this.mMultipleRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mMultipleText);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private class NumDoc
    extends PlainDocument {
        private NumDoc() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            if (Character.isDigit(cArray[0])) {
                super.insertString(n, string, attributeSet);
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)V2CVarGroupsPage.this.mWizardDialog), String.format(V2CVarGroupsPage.this.mWizardDialog.getResString("ERR_REST_MAX_WARNING"), V2CVarGroupsPage.this.mTotalVar), VersionInfo.getAppVersionString());
            }
        }
    }
}

