/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2COptionsPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CSelVarSubDlg;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CVarGroupsPage;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class V2CSelectVarPage
extends AbstractWizardPage
implements DocumentListener,
ListSelectionListener,
ActionListener,
ListDataListener,
IVarMoveHandler {
    private static final String REST_VAR2CASE_SELVAR_NAME = "REST_VAR2CASE_SELVAR_NAME";
    private static ArrayList<String> mSrcVariableNames = new ArrayList();
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mFixedVarList;
    private JComboBox mCaseGrpIdCombo;
    private JLabel mCaseGrpIdLabel;
    private JLabel mCaseGrpIdVarLabel;
    private StringTextField mCaseGrpIdEdit;
    private JButton mCaseGrpIdButton;
    private ArrowButton mCaseGrpArrow;
    private TargetVariableList mCaseGrpVarList;
    private JComboBox mTargetVarCombo;
    private Map<Integer, VarListModel> mTargetVarMap;
    private JPanel mCaseGrpPanel;
    private JLabel mCaseGrpBlankLabel;
    private JScrollPane mCaseGrpScrollPane;
    private String mCaseGrpVarLabelValue;
    private ArrowButton mTargetVarArrow;
    private ArrowButton mTargetVarShiftUpArrow;
    private ArrowButton mTargetVarShiftDownArrow;
    private ArrowButton mFixedVarArrow;
    private DialogFocusTraversalPolicy mPolicy;
    private int mLastSelectedIndex;

    public V2CSelectVarPage(BaseWizardDialog baseWizardDialog) {
        super("V2CSelectVarPage", baseWizardDialog.getResString("IDS_REST_V2C_SELVAR_TITLE"), baseWizardDialog, true);
    }

    public SrcVariableList getSrcVarList() {
        return this.mSrcVarList;
    }

    public JComboBox getCaseGrpIdCombo() {
        return this.mCaseGrpIdCombo;
    }

    public TargetVariableList getCaseGrpVarList() {
        return this.mCaseGrpVarList;
    }

    public TargetVariableList getFixedVarList() {
        return this.mFixedVarList;
    }

    public JComboBox getTargetVarCombo() {
        return this.mTargetVarCombo;
    }

    public Map<Integer, VarListModel> getTargetVarMap() {
        return this.mTargetVarMap;
    }

    public String getCaseGrpIdEditValue() {
        return this.mCaseGrpIdEdit.getText();
    }

    public String getCaseGrpVarLabelValue() {
        return this.mCaseGrpVarLabelValue;
    }

    public void setCaseGrpVarLabelValue(String string) {
        this.mCaseGrpVarLabelValue = string;
    }

    public TargetVariableList getTargetVarList() {
        return this.mTargetVarList;
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 0;
        insets.bottom = n2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel = this.setupPageBody();
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
        ((RestructureDataWizDlg)this.mWizardDialog).setVarMoveHandler(this);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_v2c_step3";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mTargetVarCombo)) {
            Object object;
            if (this.mTargetVarCombo.getSelectedIndex() >= 0) {
                this.mLastSelectedIndex = this.mTargetVarCombo.getSelectedIndex();
            }
            if (this.mTargetVarCombo.getSelectedItem() == null) {
                return;
            }
            String string = this.mTargetVarCombo.getSelectedItem().toString();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                string = ComponentState.removeBidiDirectionMarks((String)string);
            }
            if (this.mLastSelectedIndex >= 0 && this.mTargetVarCombo.getModel().getSize() > this.mLastSelectedIndex && !string.equals(object = this.mTargetVarCombo.getModel().getElementAt(this.mLastSelectedIndex).toString())) {
                this.mTargetVarCombo.removeActionListener(this);
                this.mTargetVarCombo.removeItemAt(this.mLastSelectedIndex);
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    this.mTargetVarCombo.insertItemAt(ComponentState.prepareStringForBidiRendering((String)string), this.mLastSelectedIndex);
                } else {
                    this.mTargetVarCombo.insertItemAt(string, this.mLastSelectedIndex);
                }
                this.mTargetVarCombo.setSelectedIndex(this.mLastSelectedIndex);
                this.mTargetVarCombo.addActionListener(this);
            }
            if ((object = this.mTargetVarMap.get(this.mTargetVarCombo.getSelectedIndex())) != null) {
                this.mTargetVarList.setModel(object);
            }
        } else {
            VarListModel varListModel = this.mTargetVarList.getModel();
            int[] nArray = this.mTargetVarList.getSelectedIndices();
            int n = nArray.length;
            if (!this.mCaseGrpIdButton.equals(actionEvent.getSource())) {
                ISpssVariable iSpssVariable;
                int n2;
                if (this.mTargetVarShiftUpArrow.equals(actionEvent.getSource())) {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        iSpssVariable = varListModel.getElementAt(nArray[n2]);
                        varListModel.removeElementAt(nArray[n2]);
                        varListModel.insertElementAt(iSpssVariable, nArray[n2] - 1);
                        nArray[n2] = nArray[n2] - 1;
                    }
                }
                if (this.mTargetVarShiftDownArrow.equals(actionEvent.getSource())) {
                    for (n2 = n - 1; n2 >= 0; --n2) {
                        iSpssVariable = varListModel.getElementAt(nArray[n2]);
                        varListModel.removeElementAt(nArray[n2]);
                        varListModel.insertElementAt(iSpssVariable, nArray[n2] + 1);
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                this.mTargetVarList.setSelectedIndices(nArray);
            } else {
                V2CSelVarSubDlg v2CSelVarSubDlg = new V2CSelVarSubDlg(this.mWizardDialog, this, ((RestructureDataWizDlg)this.mWizardDialog).getResBundleName(), ((RestructureDataWizDlg)this.mWizardDialog).getImageFolderName());
                ((Dialog)((Object)v2CSelVarSubDlg)).setVisible(true);
            }
        }
    }

    @Override
    public boolean validate() {
        int n;
        int n2;
        int n3;
        if (this.mCaseGrpIdCombo.getSelectedIndex() == 0) {
            if (this.mCaseGrpIdEdit.getDocument().getLength() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_EMPTY_VARNAME_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
            String string = this.mCaseGrpIdEdit.getText();
            int n4 = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n4 > 0 && n4 < 8) {
                DialogUtil.showBadSpssVarNameWarning(n4, this.mWizardDialog);
                this.mCaseGrpIdEdit.requestFocus();
                return false;
            }
            ArrayList<String> arrayList = V2CSelectVarPage.getSrcVarNames();
            if (arrayList.contains(string.toLowerCase())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_CANNOT_USE_SRCVAR_WARNING"), VersionInfo.getAppVersionString());
                this.mCaseGrpIdEdit.requestFocus();
                return false;
            }
        }
        if (this.mTargetVarCombo.getSelectedItem().toString().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_TEXTFIELD_EMPTY_WARNING2"), VersionInfo.getAppVersionString());
            this.mTargetVarCombo.requestFocus();
            return false;
        }
        for (n3 = 0; n3 < this.mTargetVarCombo.getModel().getSize(); ++n3) {
            String string = this.mTargetVarCombo.getItemAt(n3).toString();
            int n5 = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n5 <= 0 || n5 >= 8) continue;
            DialogUtil.showBadSpssVarNameWarning(n5, this.mWizardDialog);
            this.mTargetVarCombo.setSelectedIndex(n3);
            this.mTargetVarCombo.requestFocus();
            return false;
        }
        n3 = this.mTargetVarCombo.getModel().getSize();
        for (n2 = 0; n2 < n3; ++n2) {
            VarListModel varListModel = this.mTargetVarMap.get(n2);
            if (varListModel == null) continue;
            n = -1;
            for (int i = 0; i < varListModel.getSize(); ++i) {
                int n6;
                if (i == 0) {
                    n = varListModel.getElementAt(i).getType() == 0 ? 0 : 1;
                    continue;
                }
                int n7 = n6 = varListModel.getElementAt(i).getType() == 0 ? 0 : 1;
                if (n == n6) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_SAMETYPE_VARNAME_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        n2 = 0;
        for (n = 0; n < this.mTargetVarCombo.getModel().getSize(); ++n) {
            if (n == 0) {
                n2 = this.mTargetVarMap.get(n).getSize();
                continue;
            }
            if (this.mTargetVarMap.get(n).getSize() == n2) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_UNEQUAL_VARNAME_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getNextPage() {
        return "V2CIndexVarPage";
    }

    public int getTotalTargetVars() {
        return this.mTargetVarList.getModel().getSize();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mCaseGrpIdButton.setEnabled(this.mCaseGrpIdEdit.getDocument().getLength() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mCaseGrpIdButton.setEnabled(this.mCaseGrpIdEdit.getDocument().getLength() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mCaseGrpIdButton.setEnabled(this.mCaseGrpIdEdit.getDocument().getLength() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mTargetVarList.equals(listSelectionEvent.getSource())) {
            int[] nArray = this.mTargetVarList.getSelectedIndices();
            int n = nArray.length;
            this.mTargetVarShiftUpArrow.setEnabled(true);
            this.mTargetVarShiftDownArrow.setEnabled(true);
            if (n > 0 && n == nArray[n - 1] - nArray[0] + 1) {
                if (nArray[0] == 0) {
                    this.mTargetVarShiftUpArrow.setEnabled(false);
                }
                if (nArray[n - 1] + 1 == this.mTargetVarList.getModel().getSize()) {
                    this.mTargetVarShiftDownArrow.setEnabled(false);
                }
            } else {
                this.mTargetVarShiftUpArrow.setEnabled(false);
                this.mTargetVarShiftDownArrow.setEnabled(false);
            }
        } else if (this.mSrcVarList.equals(listSelectionEvent.getSource())) {
            this.mCaseGrpArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mTargetVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mFixedVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
        this.enableNextButton();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableNextButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableNextButton();
        if (listDataEvent.getSource() == this.mCaseGrpVarList.getModel() && !this.mCaseGrpArrow.isEnabled()) {
            this.mCaseGrpArrow.setEnabled(true);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableNextButton();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        block4: {
            block5: {
                block3: {
                    if (!variableList.equals(this.mTargetVarList)) break block3;
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (!this.isVarPresent(iSpssVariable, false, true)) continue;
                        return false;
                    }
                    break block4;
                }
                if (!variableList.equals(this.mCaseGrpVarList)) break block5;
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (!this.isVarPresent(iSpssVariable, true, false)) continue;
                    return false;
                }
                break block4;
            }
            if (!variableList.equals(this.mFixedVarList)) break block4;
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (!this.isVarPresent(iSpssVariable, false, false)) continue;
                return false;
            }
        }
        return true;
    }

    public static ArrayList<String> getSrcVarNames() {
        return mSrcVariableNames;
    }

    @Override
    protected void aboutToShowPanel() {
        Object object;
        String string;
        int n;
        int n2;
        int n3 = this.mTargetVarCombo.getSelectedIndex();
        int n4 = 1;
        V2CVarGroupsPage v2CVarGroupsPage = (V2CVarGroupsPage)((RestructureDataWizDlg)this.mWizardDialog).getVar2CasesVarGrpPage();
        if (v2CVarGroupsPage.isMultipleRadioSeleted()) {
            n4 = Integer.parseInt(v2CVarGroupsPage.getMultipleTextValue());
        }
        if (this.mTargetVarMap == null) {
            this.mTargetVarMap = new HashMap<Integer, VarListModel>();
        }
        if (n4 > (n2 = this.mTargetVarMap.size())) {
            this.mTargetVarCombo.removeActionListener(this);
            for (n = n2; n < n4; ++n) {
                string = this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_TARGETVARCB") + (n + 1);
                this.mTargetVarCombo.addItem(string);
                TargetVariableList targetVariableList = new TargetVariableList();
                this.mTargetVarMap.put(n, targetVariableList.getModel());
            }
            this.mTargetVarCombo.addActionListener(this);
        } else {
            for (n = n2 - 1; n >= n4; --n) {
                this.mTargetVarMap.remove(n);
                this.mTargetVarCombo.removeItemAt(n);
            }
            if (n3 >= n4) {
                n3 = 0;
            }
        }
        this.mTargetVarCombo.setSelectedIndex(n3);
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        this.enableNextButton();
        if (this.mLastSelectedIndex >= this.mTargetVarCombo.getModel().getSize()) {
            this.mTargetVarCombo.setSelectedIndex(0);
        } else {
            this.mTargetVarCombo.setSelectedIndex(this.mLastSelectedIndex);
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        string = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n5 = string.getNSplitVars();
        if (n5 != 0) {
            int n6;
            object = new int[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                object[n6] = string.getSplitVarIndex(n6);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                this.mFixedVarList.getModel().addElement(string.getVariable(object[n6]));
            }
        }
        if (this.mWizardDialog.getGlassPane() instanceof DragPane) {
            object = this.mWizardDialog.getGlassPane();
            DragPane dragPane = (DragPane)object;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mCaseGrpVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mFixedVarList));
        }
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
        V2COptionsPage v2COptionsPage = (V2COptionsPage)((RestructureDataWizDlg)this.mWizardDialog).getVar2CasesOptionPage();
        v2COptionsPage.setKeepUnselectedVariables(this.mFixedVarList.getModel().getSize() == 0);
    }

    boolean isVarPresent(ISpssVariable iSpssVariable, boolean bl, boolean bl2) {
        int n;
        VarListModel varListModel;
        boolean bl3 = false;
        if (!bl) {
            varListModel = this.mCaseGrpVarList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                if (iSpssVariable.getId().asInt() != varListModel.getElementAt(n).getId().asInt()) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_VAR_EXIST_WARNING"), VersionInfo.getAppVersionString());
                bl3 = true;
                break;
            }
        }
        varListModel = this.mFixedVarList.getModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            if (iSpssVariable.getId().asInt() != varListModel.getElementAt(n).getId().asInt()) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_VAR_EXIST_WARNING"), VersionInfo.getAppVersionString());
            bl3 = true;
            break;
        }
        if (!bl3) {
            n = this.mTargetVarCombo.getSelectedIndex();
            int n2 = this.mTargetVarCombo.getModel().getSize();
            block2: for (int i = 0; !bl3 && i < n2; ++i) {
                if (i == n && bl2 || (varListModel = this.mTargetVarMap.get(i)) == null) continue;
                for (int j = 0; j < varListModel.getSize(); ++j) {
                    if (iSpssVariable.getId().asInt() != varListModel.getElementAt(j).getId().asInt()) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_VAR_EXIST_WARNING"), VersionInfo.getAppVersionString());
                    bl3 = true;
                    continue block2;
                }
            }
        }
        return bl3;
    }

    void enableNextButton() {
        int n;
        if (this.mCaseGrpIdCombo.getSelectedIndex() == 1 && this.mCaseGrpVarList.getModel().getSize() == 0) {
            this.mWizardDialog.enableNext(false);
            return;
        }
        int n2 = this.mTargetVarCombo.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            VarListModel varListModel = this.mTargetVarMap.get(n);
            if (varListModel == null || this.mTargetVarMap.get(n).getSize() >= 2) continue;
            this.mWizardDialog.enableNext(false);
            return;
        }
        if (n == n2 && n > 0) {
            this.mWizardDialog.enableNext(true);
        } else {
            this.mWizardDialog.enableNext(false);
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addListSelectionListener(this);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setAllowDuplicates(true);
        this.mFixedVarList = new TargetVariableList();
        this.mFixedVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mFixedVarList.setAllowDuplicates(true);
        this.mCaseGrpVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseGrpVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mCaseGrpVarList.getModel().addListDataListener(this);
        this.mTargetVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarArrow.setVarMoveHandler(this);
        this.mFixedVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFixedVarArrow.setVarMoveHandler(this);
        this.mCaseGrpArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseGrpArrow.setVarMoveHandler(this);
        this.mTargetVarShiftUpArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mTargetVarShiftUpArrow.addActionListener(this);
        this.mTargetVarShiftDownArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mTargetVarShiftDownArrow.addActionListener(this);
        this.mCaseGrpIdCombo = new JComboBox();
        this.mCaseGrpIdCombo.setAction(new CaseGrpIdComboAction());
        this.mCaseGrpIdEdit = new StringTextField();
        ControlAction controlAction = new TextFieldAction(this.mWizardDialog, REST_VAR2CASE_SELVAR_NAME);
        this.mCaseGrpIdEdit.setAction(controlAction);
        this.mCaseGrpIdEdit.getDocument().addDocumentListener(this);
        this.mCaseGrpPanel = new JPanel();
        this.mCaseGrpIdLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_NAME_LABEL");
        this.mCaseGrpIdLabel.setLabelFor((Component)((Object)this.mCaseGrpIdEdit));
        this.mCaseGrpBlankLabel = new JLabel();
        this.mCaseGrpIdVarLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_V2C_SELVAR_VARCOLON");
        this.mCaseGrpIdVarLabel.setLabelFor(this.mCaseGrpVarList);
        this.mCaseGrpScrollPane = new JScrollPane(this.mCaseGrpVarList);
        controlAction = new ToggleButtonAction(this.mWizardDialog, "IDS_REST_V2C_SELVAR_LABEL3DOT");
        this.mCaseGrpIdButton = new JButton(controlAction);
        this.mCaseGrpIdButton.addActionListener(this);
        this.mCaseGrpVarLabelValue = "";
        this.mTargetVarCombo = new JComboBox();
        if (ComponentState.isBtdRtlOrLtr() && this.mTargetVarCombo.getEditor() != null && this.mTargetVarCombo.getEditor().getEditorComponent() != null && this.mTargetVarCombo.getEditor().getEditorComponent() instanceof JTextField && ((JTextField)this.mTargetVarCombo.getEditor().getEditorComponent()).getDocument() != null) {
            if (ComponentState.getBTD() == 1) {
                ((JTextField)this.mTargetVarCombo.getEditor().getEditorComponent()).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                ((JTextField)this.mTargetVarCombo.getEditor().getEditorComponent()).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mTargetVarCombo.setEditable(true);
        this.mTargetVarCombo.setPreferredSize(new Dimension(100, 20));
        this.mTargetVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarArrow.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFixedVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFixedVarArrow.registerVariableList(this.mFixedVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseGrpArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseGrpArrow.registerVariableList(this.mCaseGrpVarList, SpssArrowButton.ButtonOrientation.left);
        this.setDefaults();
    }

    private void setDefaults() {
        int n;
        this.mCaseGrpIdCombo.addItem(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_CASEGRPCB1"));
        this.mCaseGrpIdCombo.addItem(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_CASEGRPCB2"));
        this.mCaseGrpIdCombo.addItem(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_CASEGRPCB3"));
        this.mCaseGrpIdCombo.setSelectedIndex(0);
        this.mSrcVarList.setSelectedIndex(0);
        String string = this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_ID");
        mSrcVariableNames = new ArrayList();
        VarListModel varListModel = this.mSrcVarList.getModel();
        int n2 = varListModel.getSize();
        for (n = 0; n < n2; ++n) {
            mSrcVariableNames.add(varListModel.getElementAt(n).getName());
        }
        if (mSrcVariableNames.contains(string)) {
            String string2;
            n = 1;
            do {
                string2 = string + n;
                ++n;
            } while (mSrcVariableNames.contains(string2));
            string = string2;
        }
        this.mCaseGrpIdEdit.setText(string);
        this.mCaseGrpIdEdit.setColumns(15);
        this.mTargetVarShiftDownArrow.setEnabled(false);
        this.mTargetVarShiftUpArrow.setEnabled(false);
        this.mWizardDialog.enableNext(false);
        this.mLastSelectedIndex = 0;
    }

    private JPanel setupPageHeader() {
        int n = DialogUtil.getComponentGroupGap();
        JPanel jPanel = new JPanel(new GridLayout(4, 1, n, 0));
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_HEAD1"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_HEAD2"));
        jPanel.add(jLabel2);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_HEAD3"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jPanel.add(jTextArea);
        jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_SELVAR_HEAD4"));
        jPanel.add(jLabel2);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, n, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_VAR_CURR_FILE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        insets2.top = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 3, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.top = n;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n2, insets2);
        this.mCaseGrpPanel = this.setupCaseGrpIDPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpPanel, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        JPanel jPanel2 = this.setupVarTransPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.top = n;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n2, insets2);
        jPanel2 = this.setupFixedVarPanel();
        insets2.left = n * 2;
        insets2.right = n + insets.right;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupCaseGrpIDPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, 0, n, insets.right);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpIdCombo, gridBagConstraints, 1, 0, 3, 1, n2, insets2);
        insets2.left = insets.left;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets4 = new Insets(n, 0, n, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpIdLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets4);
        n2 = 21;
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpIdVarLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 23;
        insets4.left = insets.left;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCaseGrpIdEdit), gridBagConstraints, 2, 1, 1, 1, n2, insets4);
        gridBagConstraints.fill = 0;
        n2 = 24;
        insets4.top = insets.bottom * 2;
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpIdButton, gridBagConstraints, 3, 1, 1, 1, n2, insets4);
        gridBagConstraints.fill = 2;
        n2 = 21;
        this.mCaseGrpScrollPane.setVerticalScrollBarPolicy(21);
        this.mCaseGrpScrollPane.setPreferredSize(this.mCaseGrpVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpScrollPane, gridBagConstraints, 2, 1, 2, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.left = insets3.left;
        insets2.right = insets3.right;
        insets2.bottom = insets.bottom;
        gridBagConstraints.fill = 0;
        this.mCaseGrpArrow.setMinimumSize(this.mCaseGrpArrow.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpArrow, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        this.mCaseGrpBlankLabel.setPreferredSize(this.mCaseGrpArrow.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, this.mCaseGrpBlankLabel, gridBagConstraints, 0, 0, 1, 2, n2, insets2);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_CASE_GRP_ID_TITLE");
        jLabel.setLabelFor(this.mCaseGrpIdCombo);
        return PanelFactory.setupMnemonickey(jPanel, jLabel);
    }

    private JPanel setupVarTransPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_VAR_TO_TRASPOSE_TITLE")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, n, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_TARGET_VAR_LABEL");
        jLabel.setLabelFor(this.mTargetVarCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarCombo, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.right = 0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarShiftUpArrow, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2.left = 0;
        insets2.right = insets.right;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarShiftDownArrow, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.left = insets.left;
        insets2.right = insets.right;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 2, 3, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets2.left = n;
        insets2.top = insets3.top;
        insets2.bottom = insets3.bottom;
        n2 = 10;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarArrow, gridBagConstraints, 0, 2, 2, 2, n2, insets2);
        return jPanel;
    }

    private JPanel setupFixedVarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, insets.left, insets.bottom, n);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_FIXED_VAR_LABEL");
        jLabel.setLabelFor(this.mFixedVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        JScrollPane jScrollPane = new JScrollPane(this.mFixedVarList);
        Dimension dimension = this.mFixedVarList.getMinimumSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width - 10, dimension.height));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n2 = 10;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets2.left = insets3.left + insets.left;
        insets2.right = insets3.right;
        insets2.top = insets3.top;
        insets2.bottom = insets3.bottom;
        DialogUtil.addUsingGBL(jPanel, this.mFixedVarArrow, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTargetVarArrow);
        vector.add(this.mFixedVarArrow);
        vector.add(this.mTargetVarList);
        vector.add(this.mTargetVarShiftUpArrow);
        vector.add(this.mTargetVarShiftDownArrow);
        vector.add(this.mTargetVarCombo);
        vector.add(this.mFixedVarList);
        vector.add(this.mCaseGrpIdCombo);
        vector.add(this.mCaseGrpArrow);
        vector.add(this.mCaseGrpIdEdit);
        vector.add(this.mCaseGrpIdButton);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    class CaseGrpIdComboAction
    extends AbstractAction {
        CaseGrpIdComboAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dimension dimension = V2CSelectVarPage.this.mCaseGrpPanel.getPreferredSize();
            V2CSelectVarPage.this.mCaseGrpIdLabel.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpIdEdit.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpIdButton.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpVarList.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpArrow.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpIdVarLabel.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpScrollPane.setVisible(false);
            V2CSelectVarPage.this.mCaseGrpBlankLabel.setVisible(true);
            int n = V2CSelectVarPage.this.mCaseGrpIdCombo.getSelectedIndex();
            if (n == 0) {
                V2CSelectVarPage.this.mCaseGrpIdLabel.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpIdEdit.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpIdButton.setVisible(true);
            } else if (n == 1) {
                V2CSelectVarPage.this.mCaseGrpIdVarLabel.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpVarList.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpArrow.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpScrollPane.setVisible(true);
                V2CSelectVarPage.this.mCaseGrpBlankLabel.setVisible(false);
            }
            V2CSelectVarPage.this.mCaseGrpPanel.setPreferredSize(dimension);
            V2CSelectVarPage.this.enableNextButton();
        }
    }
}

