/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CSelectVarPage;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class V2COptionsPage
extends AbstractWizardPage
implements FocusListener {
    private static final String IDS_REST_V2C_OPT_DROPVAR_RADIO = "IDS_REST_V2C_OPT_DROPVAR_RADIO";
    private static final String IDS_REST_V2C_OPT_KEEPVAR_RADIO = "IDS_REST_V2C_OPT_KEEPVAR_RADIO";
    private static final String IDS_REST_V2C_OPT_CREATECASE_RADIO = "IDS_REST_V2C_OPT_CREATECASE_RADIO";
    private static final String IDS_REST_V2C_OPT_DISCARD_RADIO = "IDS_REST_V2C_OPT_DISCARD_RADIO";
    private static final String IDS_REST_V2C_COUNT_CASE_CHECK = "IDS_REST_COUNT_CASE_CHECK";
    private static final String IDS_REST_V2C_NAME_TEXT = "IDS_REST_V2C_NAME_TEXT";
    private static final String IDS_REST_V2C_LABEL_TEXT = "IDS_REST_V2C_LABEL_TEXT";
    JCheckBox mCountCheck;
    StringTextField mNameEdit;
    StringTextField mLabelEdit;
    JLabel mNameLabel;
    JLabel mLblLabel;
    private JRadioButton mDropVarRadio;
    private JRadioButton mKeepVarRadio;
    private JRadioButton mCreateCaseRadio;
    private JRadioButton mDiscardDataRadio;
    private DialogFocusTraversalPolicy mPolicy;

    public V2COptionsPage(BaseWizardDialog baseWizardDialog) {
        super("V2COptionsPage", baseWizardDialog.getResString("IDS_REST_V2C_OPTIONS_TITLE"), baseWizardDialog, true);
    }

    public boolean isCountCheckSelected() {
        return this.mCountCheck.isSelected();
    }

    public boolean isCreateCaseRadioSeleted() {
        return this.mCreateCaseRadio.isSelected();
    }

    public boolean isDiscardDataRadioSelected() {
        return this.mDiscardDataRadio.isSelected();
    }

    public boolean isDropVarRadioSelected() {
        return this.mDropVarRadio.isSelected();
    }

    public boolean isKeepVarRadioSelected() {
        return this.mKeepVarRadio.isSelected();
    }

    public String getLabelEditValue() {
        return this.mLabelEdit.getText();
    }

    public String getNameEditValue() {
        return this.mNameEdit.getText();
    }

    public void setKeepUnselectedVariables(boolean bl) {
        if (bl) {
            this.mKeepVarRadio.setSelected(true);
        } else {
            this.mDropVarRadio.setSelected(true);
        }
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = n2 * 6;
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel = this.setupPageBody();
        gridBagConstraints.weighty = 1.0;
        insets.top = n2;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jSeparator = new JSeparator();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_v2c_step6";
    }

    @Override
    public boolean validate() {
        boolean bl = true;
        if (this.mCountCheck.isSelected()) {
            String string = this.mNameEdit.getText();
            if (string.length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_V2C_MULTIVAR_EMPTYVAR_WARNING"), VersionInfo.getAppVersionString());
                bl = false;
            } else {
                ArrayList<String> arrayList;
                int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
                if (n > 0 && n < 8) {
                    DialogUtil.showBadSpssVarNameWarning(n, this.mWizardDialog);
                    this.mNameEdit.requestFocus();
                    bl = false;
                }
                if ((arrayList = V2CSelectVarPage.getSrcVarNames()).contains(string.toLowerCase())) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_CANNOT_USE_SRCVAR_WARNING"), VersionInfo.getAppVersionString());
                    this.mNameEdit.requestFocus();
                    bl = false;
                }
            }
        }
        return bl && super.validate();
    }

    @Override
    public String getNextPage() {
        return "FinishPage";
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNameEdit)) {
            this.mNameEdit.selectAll();
        } else if (focusEvent.getSource().equals(this.mLabelEdit)) {
            this.mLabelEdit.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private void initVars() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ControlAction controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_V2C_OPT_DROPVAR_RADIO);
        this.mDropVarRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mDropVarRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_V2C_OPT_KEEPVAR_RADIO);
        this.mKeepVarRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mKeepVarRadio);
        spssButtonGroup = new SpssButtonGroup();
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_V2C_OPT_CREATECASE_RADIO);
        this.mCreateCaseRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mCreateCaseRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_V2C_OPT_DISCARD_RADIO);
        this.mDiscardDataRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mDiscardDataRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_V2C_COUNT_CASE_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = V2COptionsPage.this.mCountCheck.isSelected();
                V2COptionsPage.this.mNameLabel.setEnabled(bl);
                V2COptionsPage.this.mNameEdit.setEnabled(bl);
                V2COptionsPage.this.mNameEdit.setOpaque(bl);
                V2COptionsPage.this.mLblLabel.setEnabled(bl);
                V2COptionsPage.this.mLabelEdit.setEnabled(bl);
                V2COptionsPage.this.mLabelEdit.setOpaque(bl);
            }
        };
        this.mCountCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_REST_V2C_NAME_TEXT);
        this.mNameEdit = new StringTextField();
        this.mNameEdit.setAction(controlAction);
        this.mNameEdit.addFocusListener(this);
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_REST_V2C_LABEL_TEXT);
        this.mLabelEdit = new StringTextField();
        this.mLabelEdit.setAction(controlAction);
        this.mLabelEdit.addFocusListener(this);
        this.mLblLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_LABEL");
        this.mLblLabel.setLabelFor((Component)((Object)this.mLabelEdit));
        this.mNameLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_NAME_LABEL");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameEdit));
        this.setDefaults();
    }

    private void setDefaults() {
        this.mDropVarRadio.setSelected(true);
        this.mCreateCaseRadio.setSelected(true);
        this.mCountCheck.setSelected(false);
        this.mNameEdit.setEnabled(false);
        this.mNameEdit.setOpaque(false);
        this.mNameLabel.setEnabled(false);
        this.mLabelEdit.setEnabled(false);
        this.mLabelEdit.setOpaque(false);
        this.mLblLabel.setEnabled(false);
        this.mNameEdit.setColumns(15);
        this.mLabelEdit.setColumns(30);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDropVarRadio);
        spssButtonGroup.add(this.mKeepVarRadio);
        vector.add(spssButtonGroup);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCreateCaseRadio);
        spssButtonGroup.add(this.mDiscardDataRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mCountCheck);
        vector.add(this.mNameEdit);
        vector.add(this.mLabelEdit);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_OPTIONS_HEAD1"));
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_OPTIONS_HEAD2"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, n * 3, n, n * 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        JPanel jPanel2 = this.setupHandleVarGrpPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        jPanel2 = this.setupMissingValPanel();
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        jPanel2 = this.setupCaseCountPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupHandleVarGrpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_REST_V2C_OPT_HANDLEVAR_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, 0, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDropVarRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.top = 0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mKeepVarRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupMissingValPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_REST_V2C_OPT_MISSINGVAR_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, 0, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCreateCaseRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.top = 0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mDiscardDataRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupCaseCountPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_REST_CASE_COUNT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, n, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCountCheck, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.left = n2 * 4;
        insets2.right = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, gridBagConstraints, 0, 1, 1, 1, n3, insets2);
        insets2.left = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameEdit), gridBagConstraints, 1, 1, 1, 1, n3, insets2);
        insets2.left = n2 * 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mLblLabel, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        insets2.left = n2;
        insets2.right = n;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelEdit), gridBagConstraints, 1, 2, 1, 1, n3, insets2);
        return jPanel;
    }
}

