/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.data.restructure.IndexVarCellRenderer;
import com.spss.java_client.ui.dialogs.base.data.restructure.IntVarCellEditor;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.base.data.restructure.SpssVarCellEditor;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CIndexVarPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CSelectVarPage;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class V2CMultipleIdxVarPage
extends AbstractWizardPage
implements ItemListener {
    static final String SEQNUM_RADIO_KEY = "IDS_REST_V2C_MULTIVAR_SEQNUM_RADIO";
    static final String VARNAME_RADIO_KEY = "IDS_REST_V2C_MULTIVAR_VARNAME_RADIO";
    static final int IND_VAR_TBL_NAME_COL = 1;
    static final int IND_VAR_TBL_LABEL_COL = 2;
    JTable mIndexVarTable;
    JRadioButton mSeqRadio;
    JRadioButton mVarNamesRadio;
    JComboBox mVarNamesCombo;
    JLabel mSeqVarIdxValueLabel;
    JLabel mVarNameIdxValueLabel;
    JLabel mSeqValSeriesLabel;
    int mVarGroupsCount;
    private JLabel mHeadLabel1;
    private JTextArea mHeadLabel2;
    private JTextArea mHeadLabel3;
    private JLabel mBodyLabel1;
    private JLabel mBodyLabel2;
    private JTextArea mBodyLabel3;
    private IdxVarTableModel mTableModel;
    private IdxVarTableModel mMultiTableModel;
    private JPanel mIdxValuePanel;
    private JPanel mTablePanel;
    private JPanel mFooterPanel;
    private int mTotalVars;
    private JScrollPane mScrollPane;
    private DialogFocusTraversalPolicy mPolicy;
    private String mHelpIDString;

    public V2CMultipleIdxVarPage(BaseWizardDialog baseWizardDialog) {
        super("V2CMultipleIdxVar", baseWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_TITLE"), baseWizardDialog, true);
        this.mWizardDialog.pack();
    }

    public TableModel getIndexVarTableModel() {
        return this.mIndexVarTable.getModel();
    }

    public boolean isSeqRadioSelected() {
        return this.mSeqRadio.isSelected();
    }

    public JComboBox getVarNamesCombo() {
        return this.mVarNamesCombo;
    }

    public boolean isVarNamesRadioSelected() {
        return this.mVarNamesRadio.isSelected();
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 0;
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        insets.top = n2;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel = this.setupPageBody();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jSeparator = new JSeparator();
        n = 25;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setupTable();
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return this.mHelpIDString;
    }

    @Override
    public boolean validate() {
        int n = 1;
        int n2 = this.mIndexVarTable.getEditingColumn();
        if (!(n2 != 1 && n2 != 2 && n2 != 3 || this.mIndexVarTable.getCellEditor(this.mIndexVarTable.getEditingRow(), n2).stopCellEditing())) {
            final int n3 = n2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    V2CMultipleIdxVarPage.this.mIndexVarTable.changeSelection(V2CMultipleIdxVarPage.this.mIndexVarTable.getEditingRow(), n3, false, false);
                }
            });
            return false;
        }
        TableModel tableModel = this.mIndexVarTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (tableModel.getValueAt(i, 1).toString().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_V2C_MULTIVAR_EMPTYVAR_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
            int n4 = VarNameValidator.validateSPSSName((String)tableModel.getValueAt(i, 1).toString(), (boolean)true).asInt();
            if (n4 > 0 && n4 < 8) {
                DialogUtil.showBadSpssVarNameWarning(n4, this.mWizardDialog);
                this.mIndexVarTable.setRowSelectionInterval(i, i);
                this.mIndexVarTable.setColumnSelectionInterval(1, 1);
                return false;
            }
            String string = tableModel.getValueAt(i, 3).toString();
            if (string.length() <= 0) continue;
            n *= Integer.parseInt(string);
        }
        if (this.mTotalVars != n) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_REST_V2C_MULTIVAR_INVALIDLEVEL_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getNextPage() {
        return "V2COptionsPage";
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mSeqRadio.isSelected();
        this.mSeqVarIdxValueLabel.setEnabled(bl);
        this.mSeqValSeriesLabel.setEnabled(bl);
        this.mVarNamesCombo.setEnabled(!bl);
        this.mVarNameIdxValueLabel.setEnabled(!bl);
        if (bl) {
            V2CIndexVarPage v2CIndexVarPage = (V2CIndexVarPage)((RestructureDataWizDlg)this.mWizardDialog).getVar2CasesIndexVarPage();
            int n = v2CIndexVarPage.getTotalTargetListVar();
            String string = this.generateSequence(n);
            if (this.mIndexVarTable.getRowCount() > 0 && this.mIndexVarTable.getColumnCount() >= 5) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0 && !Character.isDigit(string.charAt(0))) {
                    this.mIndexVarTable.setValueAt(ComponentState.prepareStringForBidiRendering((String)string), 0, 4);
                } else {
                    this.mIndexVarTable.setValueAt(string, 0, 4);
                }
            }
        } else {
            String string = this.mVarNamesCombo.getSelectedItem().toString();
            if (this.mIndexVarTable.getRowCount() > 0 && this.mIndexVarTable.getColumnCount() >= 5) {
                this.mIndexVarTable.setValueAt(string, 0, 4);
            }
        }
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validateOnBack() {
        if (this.mIndexVarTable.isEditing()) {
            this.mIndexVarTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        IndexVariable indexVariable;
        V2CIndexVarPage v2CIndexVarPage = (V2CIndexVarPage)((RestructureDataWizDlg)this.mWizardDialog).getVar2CasesIndexVarPage();
        if (v2CIndexVarPage.isMultipleRadioSelected()) {
            int n;
            if (this.mMultiTableModel == null) {
                this.mMultiTableModel = new IdxVarTableModel();
            }
            this.mIndexVarTable.setModel(this.mMultiTableModel);
            int n2 = this.mMultiTableModel.getRowCount();
            this.mVarGroupsCount = Integer.parseInt(v2CIndexVarPage.getMultipleTextValue());
            if (this.mVarGroupsCount > n2) {
                for (n = n2; n < this.mVarGroupsCount; ++n) {
                    indexVariable = new IndexVariable();
                    indexVariable.setValues(n + 1, this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_INDEX") + (n + 1), "", "", "");
                    this.mMultiTableModel.addElement(indexVariable);
                }
            } else {
                for (n = n2 - 1; n >= this.mVarGroupsCount; --n) {
                    this.mTableModel.removeElement(n);
                }
            }
        } else {
            if (this.mTableModel == null) {
                this.mTableModel = new IdxVarTableModel();
                indexVariable = new IndexVariable();
                indexVariable.setValues(1, this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_INDEX") + 1, "", "", "");
                this.mTableModel.addElement(indexVariable);
            }
            this.mIndexVarTable.setModel(this.mTableModel);
            this.mVarGroupsCount = 1;
        }
        this.mTotalVars = v2CIndexVarPage.getTotalTargetListVar();
        if (this.mVarGroupsCount == 1) {
            String string;
            int n;
            this.mSeqRadio.setEnabled(true);
            this.mVarNamesRadio.setEnabled(true);
            this.mIndexVarTable.setPreferredScrollableViewportSize(new Dimension(400, 50));
            this.mIdxValuePanel.setVisible(true);
            this.mFooterPanel.setVisible(false);
            this.mBodyLabel1.setText(this.mWizardDialog.getResString("IDS_REST_V2C_SINGLEVAR_HEADER"));
            this.mBodyLabel2.setVisible(false);
            this.mSeqValSeriesLabel.setText(this.generateSequence(this.mTotalVars));
            this.mSeqValSeriesLabel.setPreferredSize(new Dimension(100, 15));
            this.mTableModel.setValueAt(this.mTotalVars, 0, 3);
            this.mTableModel.setValueAt(this.generateSequence(this.mTotalVars), 0, 4);
            this.mVarNamesCombo.setPreferredSize(new Dimension(100, 20));
            V2CSelectVarPage v2CSelectVarPage = (V2CSelectVarPage)((RestructureDataWizDlg)this.mWizardDialog).getVar2CasesSelVarPage();
            ComboBoxModel comboBoxModel = v2CSelectVarPage.getTargetVarCombo().getModel();
            Map<Integer, VarListModel> map = v2CSelectVarPage.getTargetVarMap();
            this.mVarNamesCombo.removeAllItems();
            for (n = 0; n < comboBoxModel.getSize(); ++n) {
                VarListModel varListModel = map.get(n);
                string = "";
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    string = string + varListModel.getElementAt(i).getName() + " ";
                }
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    this.mVarNamesCombo.addItem(ComponentState.prepareStringForBidiRendering((String)string.trim().replace(" ", ", ")));
                    continue;
                }
                this.mVarNamesCombo.addItem(string.trim().replace(" ", ", "));
            }
            this.mHeadLabel1.setText(this.mWizardDialog.getResString("IDS_REST_V2C_ONEVAR_HEAD1"));
            this.mHeadLabel2.setText(this.mWizardDialog.getResString("IDS_REST_V2C_ONEVAR_HEAD2"));
            this.mHeadLabel3.setText(this.mWizardDialog.getResString("IDS_REST_V2C_ONEVAR_HEAD3"));
            this.mHelpIDString = "idh_rdwiz_v2c_step5_one";
            if (this.mSeqRadio.isSelected()) {
                n = v2CIndexVarPage.getTotalTargetListVar();
                string = this.generateSequence(n);
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0 && !Character.isDigit(string.charAt(0))) {
                    this.mIndexVarTable.setValueAt(ComponentState.prepareStringForBidiRendering((String)string), 0, 4);
                } else {
                    this.mIndexVarTable.setValueAt(string, 0, 4);
                }
            } else {
                String string2 = this.mVarNamesCombo.getSelectedItem().toString();
                this.mIndexVarTable.setValueAt(string2, 0, 4);
            }
        } else {
            this.mVarNamesCombo.setEnabled(false);
            this.mSeqRadio.setEnabled(false);
            this.mVarNamesRadio.setEnabled(false);
            this.mIdxValuePanel.setVisible(false);
            this.mFooterPanel.setVisible(true);
            this.mIndexVarTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.mBodyLabel1.setText(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEADER"));
            this.mBodyLabel2.setVisible(true);
            this.mBodyLabel2.setText(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_BODY2") + "  " + this.mTotalVars);
            this.mHeadLabel1.setText(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEAD1"));
            this.mHeadLabel2.setText(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEAD2"));
            this.mHeadLabel3.setText(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEAD3"));
            this.mHelpIDString = "idh_rdwiz_v2c_step5_mult";
        }
        this.mWizardDialog.pack();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        if (this.mVarGroupsCount > 1) {
            this.mIndexVarTable.changeSelection(0, 1, false, false);
            this.mIndexVarTable.editCellAt(0, 1);
        } else if (this.mSeqRadio.isSelected()) {
            this.mSeqRadio.requestFocus();
        } else {
            this.mVarNamesRadio.setSelected(true);
            this.mVarNamesCombo.setEnabled(true);
            this.mVarNamesRadio.requestFocus();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel tableColumnModel = V2CMultipleIdxVarPage.this.mIndexVarTable.getColumnModel();
                for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    if (i == 0) {
                        tableColumn.setPreferredWidth(20);
                        continue;
                    }
                    tableColumn.setPreferredWidth(125);
                }
                V2CMultipleIdxVarPage.this.mIndexVarTable.revalidate();
            }
        });
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, n2);
        this.mHeadLabel1.setFont(this.mHeadLabel1.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel1, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mHeadLabel2.setLineWrap(true);
        this.mHeadLabel2.setWrapStyleWord(true);
        this.mHeadLabel2.setBorder(null);
        this.mHeadLabel2.setOpaque(false);
        this.mHeadLabel2.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.bottom = DialogUtil.getStandardControlInsets().bottom;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mHeadLabel3.setLineWrap(true);
        this.mHeadLabel3.setWrapStyleWord(true);
        this.mHeadLabel3.setBorder(null);
        this.mHeadLabel3.setOpaque(false);
        this.mHeadLabel3.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2 * 2, n2, n2 * 2);
        this.mIdxValuePanel = this.setupIdxValuePanel();
        DialogUtil.addUsingGBL(jPanel, this.mIdxValuePanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTablePanel = this.setupTablePanel();
        DialogUtil.addUsingGBL(jPanel, this.mTablePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mFooterPanel = this.setupFooterPanel();
        gridBagConstraints.weighty = 0.0;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFooterPanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mBodyLabel1, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        this.mScrollPane.setHorizontalScrollBarPolicy(32);
        this.mScrollPane.setVerticalScrollBarPolicy(20);
        this.mScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mBodyLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupIdxValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_IDXVAL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n3, n3, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSeqRadio, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        insets2.left += n2 * 2;
        insets2.top = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSeqVarIdxValueLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSeqValSeriesLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.left = n3;
        insets2.top = n2;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarNamesRadio, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        insets2.left += n2 * 2;
        insets2.top = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mVarNameIdxValueLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.bottom = n2;
        insets2.right = n3;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarNamesCombo, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupFooterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, 0, insets.right);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mBodyLabel3.setLineWrap(true);
        this.mBodyLabel3.setWrapStyleWord(true);
        this.mBodyLabel3.setBorder(null);
        this.mBodyLabel3.setOpaque(false);
        this.mBodyLabel3.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, this.mBodyLabel3, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private void initVars() {
        this.mHeadLabel1 = new JLabel();
        this.mHeadLabel2 = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEAD2"));
        this.mHeadLabel3 = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_HEAD3"));
        this.mBodyLabel1 = new JLabel();
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mBodyLabel1.setDisplayedMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_REST_V2C_TABLEHEADER_KEY"));
        }
        this.mBodyLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_BODY2"));
        this.mBodyLabel3 = new JTextArea(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_BODY3"));
        this.mIndexVarTable = new JTable(new IdxVarTableModel()){

            @Override
            public boolean editCellAt(int n, int n2) {
                boolean bl = super.editCellAt(n, n2);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                if (component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && (n2 == 1 || n2 == 2) && component instanceof JTextField && ((JTextField)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextField)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextField)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    ((JTextField)component).selectAll();
                }
                return component;
            }
        };
        this.mBodyLabel1.setLabelFor(this.mIndexVarTable);
        this.mIndexVarTable.getTableHeader().setReorderingAllowed(false);
        this.mIndexVarTable.setAutoResizeMode(0);
        IntTextField intTextField = new IntTextField();
        CellEditor cellEditor = new CellEditor(intTextField);
        this.mIndexVarTable.setDefaultEditor(Integer.class, cellEditor);
        this.mIdxValuePanel = new JPanel();
        this.mTablePanel = new JPanel();
        this.mFooterPanel = new JPanel();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SEQNUM_RADIO_KEY);
        this.mSeqRadio = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(this.mSeqRadio);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, VARNAME_RADIO_KEY);
        this.mVarNamesRadio = new JRadioButton(toggleButtonAction);
        this.mVarNamesRadio.addItemListener(this);
        this.mSeqRadio.addItemListener(this);
        spssButtonGroup.add(this.mVarNamesRadio);
        this.mVarNamesCombo = new JComboBox();
        if (ComponentState.isBtdRtlOrLtr() && this.mVarNamesCombo.getEditor() != null && this.mVarNamesCombo.getEditor().getEditorComponent() != null && this.mVarNamesCombo.getEditor().getEditorComponent() instanceof JTextField && ((JTextField)this.mVarNamesCombo.getEditor().getEditorComponent()).getDocument() != null) {
            if (ComponentState.getBTD() == 1) {
                ((JTextField)this.mVarNamesCombo.getEditor().getEditorComponent()).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                ((JTextField)this.mVarNamesCombo.getEditor().getEditorComponent()).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mSeqValSeriesLabel = new JLabel();
        this.mSeqVarIdxValueLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_IDXVALUES"));
        this.mVarNameIdxValueLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_IDXVALUES"));
        this.mVarNameIdxValueLabel.setDisplayedMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_REST_V2C_MULTIVAR_IDXVALUES_KEY"));
        this.mVarNameIdxValueLabel.setLabelFor(this.mVarNamesCombo);
        this.mScrollPane = new JScrollPane(this.mIndexVarTable);
        TableColumn tableColumn = this.mIndexVarTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(20);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mIndexVarTable.setCellSelectionEnabled(true);
        this.mSeqRadio.setSelected(true);
        this.mSeqVarIdxValueLabel.setEnabled(this.mSeqRadio.isSelected());
        this.mSeqValSeriesLabel.setEnabled(this.mSeqRadio.isSelected());
        this.mVarNamesCombo.setEnabled(this.mVarNamesRadio.isSelected());
        this.mVarNameIdxValueLabel.setEnabled(this.mVarNamesRadio.isSelected());
        this.mFooterPanel.setVisible(false);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSeqRadio);
        spssButtonGroup.add(this.mVarNamesRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mVarNamesCombo);
        vector.add(this.mIndexVarTable);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private String generateSequence(int n) {
        String string = "";
        for (int i = 1; i <= n; ++i) {
            string = string + i;
            if (i == n) continue;
            string = string + ", ";
        }
        return string;
    }

    private void setupTable() {
        TableColumn tableColumn = this.mIndexVarTable.getColumnModel().getColumn(3);
        JTextField jTextField = new JTextField();
        tableColumn.setCellEditor(new IntVarCellEditor(jTextField, this.mIndexVarTable, this.mWizardDialog.getResString("IDS_REST_V2C_TOO_MANY_LEVELS")));
        tableColumn = this.mIndexVarTable.getColumnModel().getColumn(1);
        StringTextField stringTextField = new StringTextField();
        tableColumn.setCellEditor(new SpssVarCellEditor((JTextField)((Object)stringTextField), this.mWizardDialog));
        this.mIndexVarTable.setDefaultRenderer(Object.class, new IndexVarCellRenderer());
        TableCellRenderer tableCellRenderer = this.mIndexVarTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
            defaultTableCellRenderer.setHorizontalAlignment(0);
            defaultTableCellRenderer.setFont(defaultTableCellRenderer.getFont().deriveFont(1));
            defaultTableCellRenderer.invalidate();
        }
    }

    public class CellEditor
    extends DefaultCellEditor {
        IntTextField mIntTextField;

        public CellEditor(IntTextField intTextField) {
            super((JTextField)intTextField);
            this.mIntTextField = new IntTextField();
            this.mIntTextField = intTextField;
            this.mIntTextField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (V2CMultipleIdxVarPage.this.mIndexVarTable.getEditingColumn() == 3 && V2CMultipleIdxVarPage.this.mIndexVarTable.getEditingRow() != -1) {
                        IdxVarTableModel idxVarTableModel = (IdxVarTableModel)V2CMultipleIdxVarPage.this.mIndexVarTable.getModel();
                        idxVarTableModel.setLevels(CellEditor.this.mIntTextField.getText(), V2CMultipleIdxVarPage.this.mIndexVarTable.getEditingRow());
                    }
                }
            });
        }
    }

    class IndexVariable {
        private int mSerialNumber;
        private String mVarName = "";
        private String mVarLabel = "";
        private String mLevels = "";
        private String mIndexValues = "";

        IndexVariable() {
        }

        public void setValues(int n, String string, String string2, String string3, String string4) {
            this.mSerialNumber = n;
            this.mVarName = string;
            this.mVarLabel = string2;
            this.mLevels = string3;
            this.mIndexValues = string4;
        }

        public String getIndexValues() {
            return this.mIndexValues;
        }

        public void setIndexValues(String string) {
            this.mIndexValues = string;
        }

        public String getLevels() {
            return this.mLevels;
        }

        public void setLevels(String string) {
            this.mLevels = string;
        }

        public int getSerialNumber() {
            return this.mSerialNumber;
        }

        public void setSerialNumber(int n) {
            this.mSerialNumber = n;
        }

        public String getVarName() {
            return this.mVarName;
        }

        public void setVarName(String string) {
            this.mVarName = string;
        }

        public String getVarLabel() {
            return this.mVarLabel;
        }

        public void setVarLabel(String string) {
            this.mVarLabel = string;
        }
    }

    class IdxVarTableModel
    extends AbstractTableModel {
        private String[] mColumnNames;
        ArrayList<Object> mArrList;

        IdxVarTableModel() {
            this.mColumnNames = new String[]{V2CMultipleIdxVarPage.this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_COLUMN1"), V2CMultipleIdxVarPage.this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_COLUMN2"), V2CMultipleIdxVarPage.this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_COLUMN3"), V2CMultipleIdxVarPage.this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_COLUMN4"), V2CMultipleIdxVarPage.this.mWizardDialog.getResString("IDS_REST_V2C_MULTIVAR_COLUMN5")};
            this.mArrList = new ArrayList();
        }

        public void addElement(Object object) {
            this.mArrList.add(object);
            int n = this.mArrList.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void removeElement(int n) {
            if (n < this.mArrList.size()) {
                this.mArrList.remove(n);
            }
            this.fireTableRowsDeleted(n, n);
        }

        public void removeAll() {
            int n = this.mArrList.size();
            this.mArrList.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }

        @Override
        public int getColumnCount() {
            return this.mColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mArrList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IndexVariable indexVariable = (IndexVariable)this.mArrList.get(n);
            switch (n2) {
                case 0: {
                    return indexVariable.getSerialNumber();
                }
                case 1: {
                    if (ComponentState.isBtdRtlOrLtr() && indexVariable != null && indexVariable.getVarName() != null && indexVariable.getVarName().length() > 0) {
                        return ComponentState.removeBidiDirectionMarks((String)indexVariable.getVarName());
                    }
                    return indexVariable.getVarName();
                }
                case 2: {
                    if (ComponentState.isBtdRtlOrLtr() && indexVariable != null && indexVariable.getVarLabel() != null && indexVariable.getVarLabel().length() > 0) {
                        return ComponentState.removeBidiDirectionMarks((String)indexVariable.getVarLabel());
                    }
                    return indexVariable.getVarLabel();
                }
                case 3: {
                    return indexVariable.getLevels();
                }
            }
            return indexVariable.getIndexValues();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Integer.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && n2 != 4 && (n2 != 3 || V2CMultipleIdxVarPage.this.mVarGroupsCount != 1);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n > this.mArrList.size()) {
                return;
            }
            IndexVariable indexVariable = (IndexVariable)this.mArrList.get(n);
            switch (n2) {
                case 0: {
                    indexVariable.setSerialNumber(Integer.parseInt(object.toString()));
                    break;
                }
                case 1: {
                    if (ComponentState.isBtdRtlOrLtr() && object != null && object.toString().length() > 0) {
                        indexVariable.setVarName(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                        break;
                    }
                    indexVariable.setVarName(object.toString());
                    break;
                }
                case 2: {
                    if (object != null && object.toString().length() > 0) {
                        indexVariable.setVarLabel(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                        break;
                    }
                    indexVariable.setVarLabel(object.toString());
                    break;
                }
                case 3: {
                    indexVariable.setLevels(object.toString());
                    this.setLevels(object, n);
                    break;
                }
                default: {
                    indexVariable.setIndexValues(object.toString());
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void setLevels(Object object, int n) {
            if (object.equals("")) {
                this.setValueAt("", n, 4);
            } else {
                this.setValueAt(V2CMultipleIdxVarPage.this.generateSequence(Integer.parseInt(object.toString())), n, 4);
            }
        }
    }
}

