/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CSelectVarPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

class SpssVarCellEditor
extends DefaultCellEditor {
    private RestructureDataWizDlg mWizardDlg;

    public SpssVarCellEditor(JTextField jTextField, BaseWizardDialog baseWizardDialog) {
        super(jTextField);
        this.mWizardDlg = (RestructureDataWizDlg)baseWizardDialog;
    }

    @Override
    public boolean stopCellEditing() {
        String string = this.getCellEditorValue().toString();
        if (string.length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDlg), this.mWizardDlg.getResString("ERR_REST_V2C_MULTIVAR_EMPTYVAR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n < 8) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mWizardDlg);
            return false;
        }
        ArrayList<String> arrayList = V2CSelectVarPage.getSrcVarNames();
        if (arrayList.contains(string.toLowerCase())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDlg), this.mWizardDlg.getResString("ERR_CANNOT_USE_SRCVAR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return super.stopCellEditing();
    }
}

