/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.base.data.restructure.C2VOptionsPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.C2VSelectVarPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.C2VSortingDataPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.FinishPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CIndexVarPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CMultipleIdxVarPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2COptionsPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CSelectVarPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.V2CVarGroupsPage;
import com.spss.java_client.ui.dialogs.base.data.restructure.WelcomePage;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JFrame;
import javax.swing.table.TableModel;

public class RestructureDataWizDlg
extends BaseWizardDialog {
    public static final int HEADER_LABEL_SIZE = 18;
    private AbstractWizardPage mWelcomePage;
    private AbstractWizardPage mCases2VarSelVar;
    private AbstractWizardPage mCases2VarSortData;
    private AbstractWizardPage mCases2VarOptions;
    private AbstractWizardPage mFinishPage;
    private AbstractWizardPage mVar2CasesVarGrp;
    private AbstractWizardPage mVar2CasesIndexVar;
    private AbstractWizardPage mVar2CasesOption;
    private AbstractWizardPage mVar2CasesSelVar;
    private AbstractWizardPage mVar2CasesMultiIdxVar;
    private JFrame mParent;

    public RestructureDataWizDlg(JFrame jFrame) {
        super(jFrame, true, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.mParent = jFrame;
        this.setLocationRelativeTo(jFrame);
    }

    public String getResBundleName() {
        return DataResBundle.getDefaultResourceBundleName();
    }

    public String getImageFolderName() {
        return DataResBundle.getImageFolder();
    }

    void setVarMoveHandler(IVarMoveHandler iVarMoveHandler) {
        this.mVarMoveHandler = iVarMoveHandler;
    }

    @Override
    public void init() {
        super.init();
        this.mWelcomePage = new WelcomePage(this);
        this.mCases2VarSelVar = new C2VSelectVarPage(this);
        this.mCases2VarSortData = new C2VSortingDataPage(this);
        this.mCases2VarOptions = new C2VOptionsPage(this);
        this.mFinishPage = new FinishPage(this);
        this.mVar2CasesVarGrp = new V2CVarGroupsPage(this);
        this.mVar2CasesIndexVar = new V2CIndexVarPage(this);
        this.mVar2CasesOption = new V2COptionsPage(this);
        this.mVar2CasesSelVar = new V2CSelectVarPage(this);
        this.mVar2CasesMultiIdxVar = new V2CMultipleIdxVarPage(this);
        try {
            this.registerPage(this.mWelcomePage);
            this.registerPage(this.mCases2VarSelVar);
            this.registerPage(this.mCases2VarSortData);
            this.registerPage(this.mCases2VarOptions);
            this.registerPage(this.mFinishPage);
            this.registerPage(this.mVar2CasesVarGrp);
            this.registerPage(this.mVar2CasesIndexVar);
            this.registerPage(this.mVar2CasesOption);
            this.registerPage(this.mVar2CasesSelVar);
            this.registerPage(this.mVar2CasesMultiIdxVar);
        }
        catch (BaseWizardDialog.PageAlreadyRegistered pageAlreadyRegistered) {
            pageAlreadyRegistered.printStackTrace();
        }
        this.mVarMoveHandler = (IVarMoveHandler)((Object)this.mVar2CasesSelVar);
        this.pack();
    }

    public AbstractWizardPage getWelcomePage() {
        return this.mWelcomePage;
    }

    public AbstractWizardPage getCases2VarSelVarPage() {
        return this.mCases2VarSelVar;
    }

    public AbstractWizardPage getCases2VarSortDataPage() {
        return this.mCases2VarSortData;
    }

    public AbstractWizardPage getCases2VarOptionsPage() {
        return this.mCases2VarOptions;
    }

    public AbstractWizardPage getFinishPage() {
        return this.mFinishPage;
    }

    public AbstractWizardPage getVar2CasesVarGrpPage() {
        return this.mVar2CasesVarGrp;
    }

    public AbstractWizardPage getVar2CasesIndexVarPage() {
        return this.mVar2CasesIndexVar;
    }

    public AbstractWizardPage getVar2CasesOptionPage() {
        return this.mVar2CasesOption;
    }

    public AbstractWizardPage getVar2CasesSelVarPage() {
        return this.mVar2CasesSelVar;
    }

    public String getDialogHelpID() {
        return "idh_freq";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (((WelcomePage)this.mWelcomePage).isRestSelC2VRadioSeleted()) {
            C2VOptionsPage c2VOptionsPage;
            String string = ((C2VSelectVarPage)this.mCases2VarSelVar).getIdentifierVarListValues();
            String string2 = ((C2VSelectVarPage)this.mCases2VarSelVar).getIndexVarListValues();
            if (((C2VSortingDataPage)this.mCases2VarSortData).isSortDataYesSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY "));
                stringBuffer.append(string).append(" ");
                stringBuffer.append(string2);
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            stringBuffer.append(SyntaxUtil.getMainCommand("CASESTOVARS")).append("\n");
            if (string.length() > 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/ID=")).append(string).append("\n");
            }
            if (string2.length() > 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/INDEX=")).append(string2).append("\n");
            }
            if ((c2VOptionsPage = (C2VOptionsPage)this.mCases2VarOptions).isOriginalVarRadioSelected()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/GROUPBY=VARIABLE"));
            } else {
                stringBuffer.append(SyntaxUtil.getSubCommand("/GROUPBY=INDEX"));
            }
            if (c2VOptionsPage.isCountCheckSelected()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COUNT=")).append(c2VOptionsPage.getNameEditValue()).append(" \"").append(c2VOptionsPage.getLabelEditValue()).append("\"");
            }
            if (c2VOptionsPage.isCreateIndicatorCheckSelected()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VIND ROOT=")).append(c2VOptionsPage.getRootNameEditValue());
            }
        } else if (((WelcomePage)this.mWelcomePage).isRestSelV2CRadioSelected()) {
            int n;
            stringBuffer.append(SyntaxUtil.getMainCommand("VARSTOCASES")).append("\n");
            V2CSelectVarPage v2CSelectVarPage = (V2CSelectVarPage)this.mVar2CasesSelVar;
            if (v2CSelectVarPage.getCaseGrpIdCombo().getSelectedIndex() == 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/ID=")).append(v2CSelectVarPage.getCaseGrpIdEditValue());
                if (v2CSelectVarPage.getCaseGrpVarLabelValue().length() > 0) {
                    stringBuffer.append(" \"").append(v2CSelectVarPage.getCaseGrpVarLabelValue()).append("\"");
                }
                stringBuffer.append("\n");
            }
            ComboBoxModel comboBoxModel = v2CSelectVarPage.getTargetVarCombo().getModel();
            Map<Integer, VarListModel> map = v2CSelectVarPage.getTargetVarMap();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                VarListModel varListModel = map.get(i);
                stringBuffer.append(SyntaxUtil.getSubCommand("/MAKE ").toString()).append(comboBoxModel.getElementAt(i)).append(" FROM");
                for (int j = 0; j < varListModel.getSize(); ++j) {
                    stringBuffer.append(" ").append(varListModel.getElementAt(j).getName());
                }
                stringBuffer.append("\n");
            }
            V2CIndexVarPage v2CIndexVarPage = (V2CIndexVarPage)this.mVar2CasesIndexVar;
            V2CMultipleIdxVarPage v2CMultipleIdxVarPage = (V2CMultipleIdxVarPage)this.mVar2CasesMultiIdxVar;
            V2COptionsPage v2COptionsPage = (V2COptionsPage)this.mVar2CasesOption;
            TableModel tableModel = v2CMultipleIdxVarPage.getIndexVarTableModel();
            if (v2CIndexVarPage.isMultipleRadioSelected()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/INDEX="));
                for (n = 0; n < tableModel.getRowCount(); ++n) {
                    stringBuffer.append(tableModel.getValueAt(n, 1).toString());
                    if (tableModel.getValueAt(n, 2).toString().length() > 0) {
                        stringBuffer.append(" \"").append(tableModel.getValueAt(n, 2).toString()).append("\"");
                    }
                    stringBuffer.append("(").append(tableModel.getValueAt(n, 3).toString()).append(") ");
                }
                stringBuffer.append("\n");
            } else if (v2CIndexVarPage.isOneRadioSelected()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/INDEX="));
                stringBuffer.append(tableModel.getValueAt(0, 1).toString());
                if (tableModel.getValueAt(0, 2).toString().length() > 0) {
                    stringBuffer.append(" \"").append(tableModel.getValueAt(0, 2).toString()).append("\"");
                }
                if (v2CMultipleIdxVarPage.isSeqRadioSelected()) {
                    stringBuffer.append("(").append(tableModel.getValueAt(0, 3).toString()).append(") ");
                } else {
                    n = v2CMultipleIdxVarPage.getVarNamesCombo().getSelectedIndex();
                    stringBuffer.append("(").append(comboBoxModel.getElementAt(n).toString()).append(") ");
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.getSubCommand("/KEEP="));
            if (v2COptionsPage.isKeepVarRadioSelected()) {
                ArrayList<String> arrayList = this.getTargetVarList(v2CSelectVarPage);
                VarListModel varListModel = v2CSelectVarPage.getSrcVarList().getModel();
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    String string = varListModel.getElementAt(i).getName();
                    if (arrayList.contains(string)) continue;
                    stringBuffer.append(string).append(" ");
                }
            } else {
                if (v2CSelectVarPage.getCaseGrpIdCombo().getSelectedIndex() == 1) {
                    stringBuffer.append(v2CSelectVarPage.getCaseGrpVarList().getVariablesStringList()).append(" ");
                }
                String string = v2CSelectVarPage.getFixedVarList().getVariablesStringList();
                if (v2CSelectVarPage.getFixedVarList().getModel().getSize() > 0) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append("\n");
            if (v2COptionsPage.isCreateCaseRadioSeleted()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/NULL=KEEP"));
            } else {
                stringBuffer.append(SyntaxUtil.getSubCommand("/NULL=DROP"));
            }
            if (v2COptionsPage.isCountCheckSelected()) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COUNT=")).append(v2COptionsPage.getNameEditValue());
                if (v2COptionsPage.getLabelEditValue().length() > 0) {
                    stringBuffer.append(" \"").append(v2COptionsPage.getLabelEditValue()).append("\"");
                }
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private ArrayList<String> getTargetVarList(V2CSelectVarPage v2CSelectVarPage) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<Integer, VarListModel> map = v2CSelectVarPage.getTargetVarMap();
        for (Integer n : map.keySet()) {
            VarListModel varListModel = map.get(n);
            int n2 = varListModel.getSize();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(varListModel.getElementAt(i).getName());
            }
        }
        return arrayList;
    }

    @Override
    protected BaseWizardDialog.DoFinishAction doFinish() {
        if (((WelcomePage)this.mWelcomePage).isTransDataRadioSelected()) {
            ProcedureAction procedureAction = (ProcedureAction)ActionCatalog.getActionCatalog().getSpssAction("data_transpose");
            ProcedureDialogLoader.showDialog(procedureAction, (SpssFrame)this.getParent());
        } else if (((FinishPage)this.mFinishPage).isPasteRadioSelected()) {
            return BaseWizardDialog.DoFinishAction.ePaste;
        }
        return BaseWizardDialog.DoFinishAction.eOK;
    }

    @Override
    protected boolean validateOnFinish() {
        if (((WelcomePage)this.mWelcomePage).isTransDataRadioSelected()) {
            return true;
        }
        if (super.validateOnFinish()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REST_FINISH_WARNING"), VersionInfo.getAppVersionString());
            return true;
        }
        return false;
    }

    public Vector<Object> getTabTraversal(Vector<Object> vector) {
        int n;
        Vector<Object> vector2 = new Vector<Object>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(vector.elementAt(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector2.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector2;
    }

    @Override
    public String getIActionKey() {
        return "data_restructure";
    }

    public String getTitle() {
        return this.getResString("IDS_REST_WEL_TITLE");
    }

    public AbstractWizardPage getMVar2CasesMultiIdxVar() {
        return this.mVar2CasesMultiIdxVar;
    }

    public JFrame getParentFrame() {
        return this.mParent;
    }
}

