/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class IntVarCellEditor
extends DefaultCellEditor
implements DocumentListener {
    private JTextField mIntegerField;
    private JTable mTable;
    private String mMessage;

    public IntVarCellEditor(JTextField jTextField, JTable jTable, String string) {
        super(jTextField);
        this.mIntegerField = jTextField;
        this.mTable = jTable;
        this.mIntegerField.setDocument(new NumDoc());
        this.mIntegerField.getDocument().addDocumentListener(this);
        this.mMessage = string;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n = Integer.parseInt(this.mIntegerField.getText());
        this.generateSequence(n);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        String string = this.mIntegerField.getText();
        if (string.length() > 0) {
            int n = Integer.parseInt(string);
            this.generateSequence(n);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        int n = Integer.parseInt(this.mIntegerField.getText());
        this.generateSequence(n);
    }

    private void generateSequence(int n) {
        String string = new String();
        if (n > 999) {
            string = this.mMessage;
        } else {
            for (int i = 1; i <= n; ++i) {
                string = string + i;
                if (i == n) continue;
                string = string + ", ";
            }
        }
        this.mTable.getModel().setValueAt(string, this.mTable.getSelectedRow(), 4);
    }

    private class NumDoc
    extends PlainDocument {
        private NumDoc() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            boolean bl = true;
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) continue;
                bl = false;
                break;
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

