/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class FinishPage
extends AbstractWizardPage {
    private static final String IDS_RESTRUCTURE_RADIO = "IDS_REST_FINISH_RESTDATA_RADIO";
    private static final String IDS_PASTE_RADIO = "IDS_REST_FINISH_PASTE_RADIO";
    private JRadioButton mRestructureRadio;
    private JRadioButton mPasteRadio;
    private DialogFocusTraversalPolicy mPolicy;

    public FinishPage(BaseWizardDialog baseWizardDialog) {
        super("FinishPage", baseWizardDialog.getResString("IDS_REST_FINISH_TITLE"), baseWizardDialog, true);
    }

    public boolean isPasteRadioSelected() {
        return this.mPasteRadio.isSelected();
    }

    public boolean isRestructureRadioSelected() {
        return this.mRestructureRadio.isSelected();
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = n2 * 7;
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.top = n2;
        jPanel = this.setupPageBody();
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jSeparator = new JSeparator();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_results";
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mWizardDialog.setTitle(this.mWizardDialog.getResString("IDS_REST_FINISH_TITLE_MAC"));
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mRestructureRadio);
        spssButtonGroup.add(this.mPasteRadio);
        vector.add(spssButtonGroup);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupRestRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, DialogUtil.getStandardControlInsets().bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mRestructureRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.left = n2 * 2;
        n = 23;
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_FINISH_RESTDATA_TEXT"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSyntaxRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, DialogUtil.getStandardControlInsets().bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPasteRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 0;
        insets.left = n2 * 2;
        n = 23;
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_FINISH_PASTE_TEXT"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, IDS_RESTRUCTURE_RADIO);
        this.mRestructureRadio = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(this.mRestructureRadio);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, IDS_PASTE_RADIO);
        this.mPasteRadio = new JRadioButton(toggleButtonAction);
        if (CommandLine.isClementineCaller()) {
            this.mPasteRadio.setEnabled(false);
        }
        spssButtonGroup.add(this.mPasteRadio);
        this.mRestructureRadio.setSelected(true);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, n2);
        String string = "IDS_REST_FINISH_HEAD1";
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = "IDS_REST_FINISH_HEAD1_MAC";
        }
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString(string));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2 * 2, DialogUtil.getStandardControlInsets().bottom, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_WEL_BODY1"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.setupRestRadioPanel();
        n = 21;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jPanel2 = this.setupSyntaxRadioPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_RESTDATA_FIN_REST_IMAGE"));
        JLabel jLabel2 = new JLabel(imageIcon);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.left = n2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 2, n, insets);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_RESTDATA_FIN_SYNTAX_IMAGE"));
        jLabel2 = new JLabel(imageIcon);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }
}

