/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class C2VSelectVarPage
extends AbstractWizardPage
implements ListDataListener {
    private SrcVariableList mCurrFileSrcVarList;
    private TargetVariableList mIdentifierVarList;
    private TargetVariableList mIndexVarList;
    private ArrowButton mIdentifierArrow;
    private ArrowButton mIndexArrow;
    private JLabel mVarCurrFileLabel;
    private JLabel mIdentifierVarLabel;
    private JLabel mIndexVarLabel;
    private DialogFocusTraversalPolicy mPolicy;

    public C2VSelectVarPage(BaseWizardDialog baseWizardDialog) {
        super("C2VSelectVarPage", baseWizardDialog.getResString("IDS_REST_C2V_SELVAR_TITLE"), baseWizardDialog, true);
    }

    public String getIdentifierVarListValues() {
        return this.mIdentifierVarList.getVariablesStringList();
    }

    public String getIndexVarListValues() {
        return this.mIndexVarList.getVariablesStringList();
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 0;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        jPanel = this.setupPageBody();
        insets.left = n2 * 4;
        insets.right = n2 * 4;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jSeparator = new JSeparator();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mWizardDialog.enableNext(this.mIdentifierVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mWizardDialog.enableNext(this.mIdentifierVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mWizardDialog.enableNext(this.mIdentifierVarList.getModel().getSize() > 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_c2v_step2";
    }

    @Override
    public String getNextPage() {
        return "C2VSortingDataPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return this.mIdentifierVarList.getModel().getSize() > 0;
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        if (n != 0) {
            int n2;
            int[] nArray = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = iSpssDataSrc.getSplitVarIndex(n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.mIdentifierVarList.getModel().addElement(iSpssDataSrc.getVariable(nArray[n2]));
                this.mCurrFileSrcVarList.getModel().removeElement(iSpssDataSrc.getVariable(nArray[n2]));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                C2VSelectVarPage.this.mPolicy.getDefaultComponent((Container)((Object)C2VSelectVarPage.this.mWizardDialog)).requestFocus();
            }
        });
    }

    private void initVars() {
        this.mCurrFileSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mCurrFileSrcVarList.loadFromActiveDataset();
        this.mIdentifierVarList = new TargetVariableList();
        this.mIdentifierVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIdentifierVarList.getModel().addListDataListener(this);
        this.mIndexVarList = new TargetVariableList();
        this.mIndexVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIdentifierArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIndexArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifierArrow.registerVariableList(this.mCurrFileSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifierArrow.registerVariableList(this.mIdentifierVarList, SpssArrowButton.ButtonOrientation.left);
        this.mIndexArrow.registerVariableList(this.mCurrFileSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIndexArrow.registerVariableList(this.mIndexVarList, SpssArrowButton.ButtonOrientation.left);
        this.mVarCurrFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_VAR_CURR_FILE_LABEL");
        this.mIdentifierVarLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_IDENTIFIER_VAR_LABEL");
        this.mIndexVarLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_INDEX_VAR_LABEL");
        this.mVarCurrFileLabel.setLabelFor(this.mCurrFileSrcVarList);
        this.mIdentifierVarLabel.setLabelFor(this.mIdentifierVarList);
        this.mIndexVarLabel.setLabelFor(this.mIndexVarList);
        this.setDefaults();
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, 0);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_C2V_SELVAR_HEAD1"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_REST_C2V_SELVAR_HEAD2"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_C2V_SELVAR_HEAD3"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 2, 1, n, insets);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel3 = new JLabel(imageIcon);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 3, 1, 2, n, insets);
        jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_C2V_SELVAR_HEAD4"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.top = DialogUtil.getStandardControlInsets().bottom * 2;
        jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_REST_C2V_SELVAR_HEAD5"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 5, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mVarCurrFileLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JScrollPane jScrollPane = new JScrollPane(this.mCurrFileSrcVarList);
        jScrollPane.setPreferredSize(this.mCurrFileSrcVarList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n2, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIdentifierVarLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        jScrollPane = new JScrollPane(this.mIdentifierVarList);
        jScrollPane.setPreferredSize(this.mCurrFileSrcVarList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.top = n;
        DialogUtil.addUsingGBL(jPanel, this.mIndexVarLabel, gridBagConstraints, 2, 2, 1, 1, n2, insets2);
        insets2.top = 0;
        jScrollPane = new JScrollPane(this.mIndexVarList);
        jScrollPane.setPreferredSize(this.mIndexVarList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 10;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIdentifierArrow, gridBagConstraints, 1, 1, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIndexArrow, gridBagConstraints, 1, 3, 1, 1, n2, insets3);
        return jPanel;
    }

    private void setDefaults() {
        this.mCurrFileSrcVarList.setSelectedIndex(0);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCurrFileSrcVarList);
        vector.add(this.mIdentifierArrow);
        vector.add(this.mIdentifierVarList);
        vector.add(this.mIndexArrow);
        vector.add(this.mIndexVarList);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }
}

