/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.restructure;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.restructure.RestructureDataWizDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class C2VOptionsPage
extends AbstractWizardPage {
    private static final String IDS_GRP_ORIGINAL_VAR_RADIO = "IDS_GRP_ORIGINAL_VAR_RADIO";
    private static final String IDS_GRP_INDEX_RADIO = "IDS_GRP_INDEX_RADIO";
    private static final String IDS_REST_COUNT_CASE_CHECK = "IDS_REST_C2V_COUNT_CASE_CHECK";
    private static final String IDS_CREATE_INDICATOR_VAR_RADIO = "IDS_CREATE_INDICATOR_VAR_RADIO";
    private static final String IDS_NAME_TEXT = "IDS_NAME_TEXT";
    private static final String IDS_LABEL_NAME_TEXT = "IDS_LABEL_NAME_TEXT";
    private static final String IDS_ROOT_NAME_TEXT = "IDS_ROOT_NAME_TEXT";
    JCheckBox mCountCheck;
    StringTextField mNameEdit;
    JLabel mNameLabel;
    JLabel mLblLabel;
    StringTextField mLabelEdit;
    StringTextField mRootNameEdit;
    JLabel mRootNameLabel;
    private JRadioButton mGrpOriginalVarRadio;
    private JRadioButton mGrpIndexRadio;
    private JCheckBox mCreateIndicatorCheck;
    private DialogFocusTraversalPolicy mPolicy;

    public C2VOptionsPage(BaseWizardDialog baseWizardDialog) {
        super("C2VOptionsPage", baseWizardDialog.getResString("IDS_REST_C2V_OPTIONS_TITLE"), baseWizardDialog, true);
    }

    public boolean isCountCheckSelected() {
        return this.mCountCheck.isSelected();
    }

    public boolean isCreateIndicatorCheckSelected() {
        return this.mCreateIndicatorCheck.isSelected();
    }

    public boolean isGrpIndexRadioSelected() {
        return this.mGrpIndexRadio.isSelected();
    }

    public boolean isOriginalVarRadioSelected() {
        return this.mGrpOriginalVarRadio.isSelected();
    }

    public String getNameEditValue() {
        return this.mNameEdit.getText();
    }

    public String getLabelEditValue() {
        return this.mLabelEdit.getText();
    }

    public String getRootNameEditValue() {
        return this.mRootNameEdit.getText();
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
    }

    @Override
    public void init() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = n2 * 6;
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.top = n2;
        insets.left = n2 * 4;
        insets.right = n2 * 4;
        gridBagConstraints.weighty = 1.0;
        jPanel = this.setupPageBody();
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.left = n2;
        insets.right = n2;
        jSeparator = new JSeparator();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    @Override
    public boolean validate() {
        int n;
        boolean bl = true;
        if (this.mCountCheck.isSelected()) {
            if (this.mNameEdit.getDocument().getLength() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_TEXTFIELD_EMPTY_WARNING"), VersionInfo.getAppVersionString());
                this.mNameEdit.requestFocus();
                bl = false;
            } else {
                n = VarNameValidator.validateSPSSName((String)this.mNameEdit.getText(), (boolean)true).asInt();
                if (n > 0 && n < 8) {
                    DialogUtil.showBadSpssVarNameWarning(n, this.mWizardDialog);
                    this.mNameEdit.requestFocus();
                    bl = false;
                }
            }
        }
        if (this.mCreateIndicatorCheck.isSelected() && this.mRootNameEdit.getText().length() > 0 && (n = VarNameValidator.validateSPSSName((String)this.mRootNameEdit.getText(), (boolean)true).asInt()) > 0 && n < 8) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mWizardDialog);
            this.mRootNameEdit.requestFocus();
            this.mRootNameEdit.select(0, this.mRootNameEdit.getText().length() - 1);
            bl = false;
        }
        return bl && super.validate();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rdwiz_c2v_step4";
    }

    @Override
    public String getNextPage() {
        return "FinishPage";
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    private void initVars() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ControlAction controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_GRP_ORIGINAL_VAR_RADIO);
        this.mGrpOriginalVarRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mGrpOriginalVarRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_GRP_INDEX_RADIO);
        this.mGrpIndexRadio = new JRadioButton(controlAction);
        spssButtonGroup.add(this.mGrpIndexRadio);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_REST_COUNT_CASE_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = C2VOptionsPage.this.mCountCheck.isSelected();
                C2VOptionsPage.this.mNameLabel.setEnabled(bl);
                C2VOptionsPage.this.mNameEdit.setEnabled(bl);
                C2VOptionsPage.this.mNameEdit.setOpaque(bl);
                C2VOptionsPage.this.mLblLabel.setEnabled(bl);
                C2VOptionsPage.this.mLabelEdit.setEnabled(bl);
                C2VOptionsPage.this.mLabelEdit.setOpaque(bl);
            }
        };
        this.mCountCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_NAME_TEXT);
        this.mNameEdit = new StringTextField();
        this.mNameEdit.setAction(controlAction);
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_LABEL_NAME_TEXT);
        this.mLabelEdit = new StringTextField();
        this.mLabelEdit.setAction(controlAction);
        controlAction = new ToggleButtonAction(this.mWizardDialog, IDS_CREATE_INDICATOR_VAR_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = C2VOptionsPage.this.mCreateIndicatorCheck.isSelected();
                C2VOptionsPage.this.mRootNameLabel.setEnabled(bl);
                C2VOptionsPage.this.mRootNameEdit.setEnabled(bl);
                C2VOptionsPage.this.mRootNameEdit.setOpaque(bl);
            }
        };
        this.mCreateIndicatorCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mWizardDialog, IDS_ROOT_NAME_TEXT);
        this.mRootNameEdit = new StringTextField();
        this.mRootNameEdit.setAction(controlAction);
        this.mLblLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_LABEL");
        this.mLblLabel.setLabelFor((Component)((Object)this.mLabelEdit));
        this.mNameLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_REST_NAME_LABEL");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameEdit));
        this.mRootNameLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_ROOT_NAME_VAR_LABEL");
        this.mRootNameLabel.setLabelFor((Component)((Object)this.mRootNameEdit));
        this.setLabelWidth();
        this.setDefaults();
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_C2V_OPTIONS_HEAD1"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_REST_C2V_OPTIONS_HEAD2"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        JPanel jPanel2 = this.setupOrderVarGrpPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        jPanel2 = this.setupCaseCountPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        jPanel2 = this.setupIndicatorVarPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mGrpOriginalVarRadio);
        spssButtonGroup.add(this.mGrpIndexRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mCountCheck);
        vector.add(this.mNameEdit);
        vector.add(this.mLabelEdit);
        vector.add(this.mCreateIndicatorCheck);
        vector.add(this.mRootNameEdit);
        Vector<Object> vector2 = ((RestructureDataWizDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setDefaults() {
        this.mGrpOriginalVarRadio.setSelected(true);
        this.mNameEdit.setEnabled(false);
        this.mNameEdit.setOpaque(false);
        this.mNameLabel.setEnabled(false);
        this.mLabelEdit.setEnabled(false);
        this.mLabelEdit.setOpaque(false);
        this.mLblLabel.setEnabled(false);
        this.mRootNameLabel.setEnabled(false);
        this.mRootNameEdit.setEnabled(false);
        this.mRootNameEdit.setOpaque(false);
        this.mRootNameEdit.setText(this.mWizardDialog.getResString("IDS_ROOT_NAME_VAR_TEXT"));
        this.mNameEdit.setColumns(15);
        this.mLabelEdit.setColumns(30);
        this.mRootNameEdit.setColumns(15);
    }

    private JPanel setupOrderVarGrpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_ORDER_VAR_GROUP_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(n, 0, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mGrpOriginalVarRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mGrpIndexRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupIndicatorVarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_INDICATOR_VAR_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, n, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCreateIndicatorCheck, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.top = 0;
        insets2.left = n2 * 4;
        insets2.right = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRootNameLabel, gridBagConstraints, 0, 1, 1, 1, n3, insets2);
        insets2.left = n2;
        gridBagConstraints.weightx = 1.0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mRootNameEdit), gridBagConstraints, 1, 1, 1, 1, n3, insets2);
        return jPanel;
    }

    private JPanel setupCaseCountPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_REST_CASE_COUNT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, n, insets.bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCountCheck, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.left = n2 * 4;
        insets2.right = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, gridBagConstraints, 0, 1, 1, 1, n3, insets2);
        insets2.left = n2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameEdit), gridBagConstraints, 1, 1, 1, 1, n3, insets2);
        insets2.left = n2 * 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.top = n;
        DialogUtil.addUsingGBL(jPanel, this.mLblLabel, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        insets2.left = n2;
        insets2.right = n;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelEdit), gridBagConstraints, 1, 2, 1, 1, n3, insets2);
        return jPanel;
    }

    private void setLabelWidth() {
        FontMetrics fontMetrics = this.mRootNameLabel.getFontMetrics(this.mRootNameLabel.getFont());
        int n = fontMetrics.stringWidth(this.mRootNameLabel.getText());
        fontMetrics = this.mNameLabel.getFontMetrics(this.mNameLabel.getFont());
        int n2 = fontMetrics.stringWidth(this.mNameLabel.getText());
        int n3 = n2 > n ? n2 : n;
        Dimension dimension = this.mRootNameLabel.getPreferredSize();
        dimension.width = n3 + this.mRootNameLabel.getInsets().left + this.mRootNameLabel.getInsets().right;
        this.mRootNameLabel.setPreferredSize(dimension);
        this.mRootNameLabel.setMaximumSize(dimension);
        this.mRootNameLabel.setMinimumSize(dimension);
        dimension = this.mNameLabel.getPreferredSize();
        dimension.width = n3 + this.mNameLabel.getInsets().left + this.mNameLabel.getInsets().right;
        this.mNameLabel.setPreferredSize(dimension);
        this.mNameLabel.setMaximumSize(dimension);
        this.mNameLabel.setMinimumSize(dimension);
    }
}

