/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarDropCallback;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesDlg;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesRename;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesVarFormatter;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.MergeFilesListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VariablesTab
extends BaseProcedureTab
implements ListSelectionListener,
ListDataListener,
VarDropCallback {
    private AddVariablesDlg mDataView;
    TargetVariableList mKeyVarList;
    TargetVariableList mIncludeVarList;
    TargetVariableList mExcludedVarList;
    private ArrowButton mExcludeToActiveArrowButton;
    private ArrowButton mKeyArrowButton;
    private JButton mRenameButton;
    private ListTravArrowButtonFactory mArrowButtonKeyVars;
    static int mCnt = 0;
    private int mCrtMethod;
    static String sRENAME_DIALOG_TITLE_KEY;
    static final String GROUP_VARIABLE_LIST = "GROUP_VARIABLE_LIST";
    static final String EXCLUDED_LIST = "EXCLUDED_LIST";
    HashMap<ISpssVariable, KeyListInfo> mKeyListMap;

    VariablesTab(AddVariablesDlg addVariablesDlg) {
        super(addVariablesDlg, true);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.mCrtMethod = -1;
        this.setFocusTraversalPolicy();
    }

    @Override
    public void reset() {
        super.reset();
        this.mIncludeVarList.getModel().removeAll();
        this.mKeyVarList.getModel().removeAll();
        this.mExcludedVarList.getModel().removeAll();
        this.mCrtMethod = -1;
        this.mExcludedVarList.requestFocus();
        this.mIncludeVarList.ensureIndexIsVisible(0);
        this.mExcludedVarList.ensureIndexIsVisible(0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_addv_main";
    }

    private void setupPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_ADD_EXCLUDE_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mExcludedVarList);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this.mParent, "IDS_ADD_VARIABLES_INCLUDE_VARS_LABEL");
        jLabel.setLabelFor(this.mIncludeVarList);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mExcludedVarList);
        jScrollPane.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mExcludedVarList.getFixedCellHeight() * 10 + 2));
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mExcludedVarList.getFixedCellHeight() * 10 + 2));
        jScrollPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(this, this.mExcludeToActiveArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jScrollPane = new JScrollPane(this.mIncludeVarList);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), this.mIncludeVarList.getFixedCellHeight() * 7 + 2);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(this, this.mKeyArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        JPanel jPanel = this.setupKeyVarSetPanel();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 2, 2, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.mRenameButton, gridBagConstraints, 0, 3, 1, 1, 10, insets);
        jPanel = this.setupLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 4, 3, 1, n, insets);
        this.mExcludeToActiveArrowButton.registerVariableList(this.mIncludeVarList, SpssArrowButton.ButtonOrientation.left);
        this.mExcludeToActiveArrowButton.registerVariableList(this.mExcludedVarList, SpssArrowButton.ButtonOrientation.right);
        this.mKeyArrowButton.registerVariableList(this.mKeyVarList, SpssArrowButton.ButtonOrientation.left);
        this.mKeyArrowButton.registerVariableList(this.mExcludedVarList, SpssArrowButton.ButtonOrientation.right);
    }

    private JPanel setupKeyVarSetPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_ADD_VARIABLES_KEY_VAR_LABEL");
        jLabel.setLabelFor(this.mKeyVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mKeyVarList);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), this.mKeyVarList.getFixedCellHeight() * 3 + 2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = this.mArrowButtonKeyVars.getArrowButtonPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_ADD_VARIABLES_VAR_TYPE_INFO"), 2, 0);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JLabel jLabel2 = new JLabel(this.getResString("IDS_ADD_VARIABLES_VARIABLES_TAB_ACTIVE_DATASET_LABEL") + ((AddVariablesDlg)this.mParent).mActiveDsName);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JLabel jLabel3 = new JLabel(this.getResString("IDS_ADD_VARIABLES_SOURCE_FILE_DATASET_LABEL") + ((AddVariablesDlg)this.mParent).mSecendDsName);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mDataView = (AddVariablesDlg)this.mParent;
        this.mExcludedVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mExcludedVarList.setLoadFromPersistent(false);
        AddVariablesVarFormatter addVariablesVarFormatter = new AddVariablesVarFormatter(this.mExcludedVarList, this.mDataView);
        this.mExcludedVarList.setModel(new MergeFilesListModel(1, addVariablesVarFormatter));
        this.mExcludedVarList.getModel().addListDataListener(this);
        this.mExcludedVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mExcludedVarList.addListSelectionListener(this);
        this.mExcludedVarList.setSortType(SpssVariableSortType.alpha);
        this.mExcludedVarList.setCellRenderer(new CustomVarListCellRenderer(addVariablesVarFormatter));
        this.mExcludedVarList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VariablesTab.this.processEnableRename(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() == VariablesTab.this.mKeyVarList || focusEvent.getOppositeComponent() == VariablesTab.this.mIncludeVarList) {
                    VariablesTab.this.processEnableRename(false);
                }
            }
        });
        this.mIncludeVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mIncludeVarList.setLoadFromPersistent(false);
        AddVariablesVarFormatter addVariablesVarFormatter2 = new AddVariablesVarFormatter(this.mIncludeVarList, this.mDataView);
        this.mIncludeVarList.setModel(new MergeFilesListModel(0, addVariablesVarFormatter2));
        this.mIncludeVarList.getModel().addListDataListener(this);
        this.mIncludeVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIncludeVarList.addListSelectionListener(this);
        this.mIncludeVarList.setCellRenderer(new CustomVarListCellRenderer(addVariablesVarFormatter2));
        this.mKeyVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mKeyVarList.setLoadFromPersistent(false);
        AddVariablesVarFormatter addVariablesVarFormatter3 = new AddVariablesVarFormatter(this.mKeyVarList, this.mDataView);
        this.mKeyVarList.setModel(new MergeFilesListModel(2, addVariablesVarFormatter3));
        this.mKeyVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mKeyVarList.getModel().addListDataListener(this);
        this.mKeyVarList.setCellRenderer(new CustomVarListCellRenderer(addVariablesVarFormatter3));
        this.mArrowButtonKeyVars = new ListTravArrowButtonFactory(this.mKeyVarList, false);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mExcludeToActiveArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariablesTab.this.excludeActiveArrowAction();
            }
        };
        this.mKeyListMap = new HashMap();
        this.mKeyArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariablesTab.this.keyArrowButton();
            }
        };
        this.mIncludeVarList.setIdentifier(GROUP_VARIABLE_LIST);
        this.mExcludedVarList.setIdentifier(EXCLUDED_LIST);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_RENAME"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariablesTab.this.runRenameDialog();
            }
        };
        this.mRenameButton = new JButton(toggleButtonAction);
    }

    private void setDefaults() {
        mCnt = 0;
        this.loadExcludeAndActiveVarList();
        this.mKeyVarList.setShowIcon(false);
        this.mKeyVarList.setShowVarLabels(false, false);
        this.mKeyVarList.clearSelection();
        this.mRenameButton.setEnabled(false);
        this.mExcludedVarList.requestFocus();
        this.mIncludeVarList.ensureIndexIsVisible(0);
        this.mExcludedVarList.ensureIndexIsVisible(0);
        this.mKeyArrowButton.setEnabled(this.mCrtMethod != 0 && !this.mExcludedVarList.isSelectionEmpty());
        this.mExcludeToActiveArrowButton.setEnabled(false);
    }

    public void changeStates(int n) {
        if (n != this.mCrtMethod) {
            this.mCrtMethod = n;
            this.setDefaults();
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExcludedVarList);
        vector.add(this.mExcludeToActiveArrowButton);
        vector.add(this.mIncludeVarList);
        vector.add(this.mKeyArrowButton);
        vector.add(this.mKeyVarList);
        vector.add(this.mArrowButtonKeyVars.getUpArrowButton());
        vector.add(this.mArrowButtonKeyVars.getDownArrowButton());
        vector.add(this.mRenameButton);
        this.setComponentOrder(vector);
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mExcludedVarList;
    }

    private void keyArrowButton() {
        if (this.mKeyArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right)) {
            if (this.mDataView.isInBothDatasets(this.mExcludedVarList.getSelectedValues(), true)) {
                ArrayList<ISpssVariable> arrayList = VariablesTab.convertToArrayList(this.mExcludedVarList.getSelectedValues());
                this.moveVariablesToKeyList(arrayList);
            }
        } else if (this.mKeyArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.left)) {
            ISpssVariable[] iSpssVariableArray = this.mKeyVarList.getSelectedValues();
            this.moveKeyListVarsBack(iSpssVariableArray);
        }
    }

    private void loadExcludeAndActiveVarList() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>();
        ArrayList<ISpssVariable> arrayList3 = new ArrayList<ISpssVariable>();
        if (this.mDataView.mActiveList != null && this.mDataView.mSecondList != null) {
            for (ISpssVariable iSpssVariable : this.mDataView.mSecondList) {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < this.mDataView.mActiveList.size(); ++i) {
                    ISpssVariable iSpssVariable2 = this.mDataView.mActiveList.get(i);
                    if (!iSpssVariable.getName().equalsIgnoreCase(iSpssVariable2.getName())) continue;
                    bl = true;
                    if ((iSpssVariable.getType() != 0 || iSpssVariable2.getType() != 0) && (iSpssVariable.getType() <= 0 || iSpssVariable2.getType() <= 0)) break;
                    bl2 = true;
                    break;
                }
                if (bl) {
                    if (bl2) {
                        arrayList2.add(iSpssVariable);
                        continue;
                    }
                    arrayList.add(iSpssVariable);
                    continue;
                }
                arrayList3.add(iSpssVariable);
            }
        }
        this.mIncludeVarList.getModel().removeAll();
        for (ISpssVariable iSpssVariable : this.mDataView.mActiveList) {
            this.mIncludeVarList.getModel().addElement(iSpssVariable);
        }
        for (ISpssVariable iSpssVariable : arrayList3) {
            this.mIncludeVarList.getModel().addElement(iSpssVariable);
        }
        this.mExcludedVarList.getModel().removeAll();
        for (ISpssVariable iSpssVariable : arrayList2) {
            this.mExcludedVarList.getModel().addElement(iSpssVariable);
            String string = iSpssVariable.getName() + iSpssVariable.getId().toString();
            this.mDataView.mRenameMap.remove(string);
        }
        for (ISpssVariable iSpssVariable : arrayList) {
            this.mExcludedVarList.getModel().addElement(iSpssVariable);
            String string = iSpssVariable.getName() + iSpssVariable.getId().toString();
            this.mDataView.mRenameMap.remove(string);
        }
        this.mExcludedVarList.setSortType(SpssVariableSortType.alpha);
        this.mExcludedVarList.getModel().sort();
        this.mKeyVarList.getModel().removeAll();
        if (this.mCrtMethod != 0) {
            this.moveVariablesToKeyList(arrayList2);
        }
    }

    private void excludeActiveArrowAction() {
        ISpssVariable[] iSpssVariableArray = this.mExcludedVarList.getSelectedValues();
        boolean bl = this.mExcludeToActiveArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right);
        if (bl && this.checkForExistInActiveVarList(iSpssVariableArray)) {
            return;
        }
        if (this.mExcludeToActiveArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right)) {
            this.moveVarsFromExcludeToActive(iSpssVariableArray);
        } else {
            ISpssVariable[] iSpssVariableArray2 = this.mIncludeVarList.getSelectedValues();
            this.moveVarsFromActiveToExclude(iSpssVariableArray2);
        }
    }

    public static ArrayList<ISpssVariable> convertToArrayList(ISpssVariable[] iSpssVariableArray) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        arrayList.addAll(Arrays.asList(iSpssVariableArray));
        return arrayList;
    }

    public void moveKeyListVarsBack(ISpssVariable iSpssVariable) {
        this.moveKeyListVarsBack(new ISpssVariable[]{iSpssVariable});
    }

    public void moveKeyListVarsBack(ISpssVariable[] iSpssVariableArray) {
        this.removeFromListByName(this.mIncludeVarList, iSpssVariableArray);
        this.removeFromListByName(this.mExcludedVarList, iSpssVariableArray);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (this.mKeyListMap.containsKey(iSpssVariable)) {
                this.mKeyVarList.getModel().removeElement(iSpssVariable);
                KeyListInfo keyListInfo = this.mKeyListMap.get(iSpssVariable);
                this.mKeyListMap.remove(iSpssVariable);
                ArrayList<ISpssVariable> arrayList2 = keyListInfo.getExcludeList();
                arrayList.addAll(arrayList2);
                for (ISpssVariable iSpssVariable2 : arrayList2) {
                    this.mExcludedVarList.getModel().addElement(iSpssVariable2);
                }
                ArrayList<ISpssVariable> arrayList3 = keyListInfo.getActiveList();
                Iterator object2 = arrayList3.iterator();
                while (object2.hasNext()) {
                    ISpssVariable iSpssVariable3 = (ISpssVariable)object2.next();
                    this.mIncludeVarList.getModel().addElement(iSpssVariable3);
                }
            }
            this.mExcludedVarList.getModel().sort();
            this.selectVariables(this.mExcludedVarList, arrayList);
            this.mExcludedVarList.requestFocus();
        }
    }

    private void removeFromListByName(TargetVariableList targetVariableList, ISpssVariable[] iSpssVariableArray) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            String string = this.mDataView.getCurrentVarName(iSpssVariable);
            for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable2 = targetVariableList.getModel().getElementAt(i);
                String string2 = this.mDataView.getCurrentVarName(iSpssVariable2);
                if (!string.equals(string2)) continue;
                arrayList.add(iSpssVariable2);
            }
        }
        for (ISpssVariable iSpssVariable : arrayList) {
            targetVariableList.getModel().removeElement(iSpssVariable);
        }
    }

    public void moveVariablesToKeyList(ISpssVariable iSpssVariable) {
        this.moveVariablesToKeyList(VariablesTab.convertToArrayList(new ISpssVariable[]{iSpssVariable}));
    }

    public void moveVariablesToKeyList(ArrayList<ISpssVariable> arrayList) {
        if (mCnt == 0) {
            this.mKeyListMap.clear();
            ++mCnt;
        }
        ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>();
        ArrayList<ISpssVariable> arrayList3 = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : arrayList) {
            ArrayList<ISpssVariable> arrayList4 = this.findMatchingVariables(this.mExcludedVarList, iSpssVariable);
            for (ISpssVariable iSpssVariable2 : arrayList4) {
                arrayList2.add(iSpssVariable2);
            }
            ArrayList<ISpssVariable> arrayList5 = this.findMatchingVariables(this.mIncludeVarList, iSpssVariable);
            Iterator object2 = arrayList5.iterator();
            while (object2.hasNext()) {
                ISpssVariable iSpssVariable3 = (ISpssVariable)object2.next();
                arrayList3.add(iSpssVariable3);
            }
            this.addVariableToKeyList(iSpssVariable, arrayList4, arrayList5);
        }
        this.selectVariables(this.mKeyVarList, arrayList);
        for (ISpssVariable iSpssVariable : arrayList2) {
            this.mExcludedVarList.getModel().removeElement(iSpssVariable);
        }
        for (ISpssVariable iSpssVariable : arrayList3) {
            this.mIncludeVarList.getModel().removeElement(iSpssVariable);
        }
        this.mKeyVarList.requestFocus();
    }

    private ArrayList<ISpssVariable> findMatchingVariables(TargetVariableList targetVariableList, ISpssVariable iSpssVariable) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        arrayList.add(iSpssVariable);
        return this.findMatchingVariables(targetVariableList, arrayList);
    }

    private ArrayList<ISpssVariable> findMatchingVariables(TargetVariableList targetVariableList, ArrayList<ISpssVariable> arrayList) {
        ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            String string = this.mDataView.getCurrentVarName(iSpssVariable);
            for (ISpssVariable iSpssVariable2 : arrayList) {
                String string2 = this.mDataView.getCurrentVarName(iSpssVariable2);
                if (!string.equalsIgnoreCase(string2)) continue;
                arrayList2.add(iSpssVariable);
            }
        }
        return arrayList2;
    }

    private void addVariableToKeyList(ISpssVariable iSpssVariable, ArrayList<ISpssVariable> arrayList, ArrayList<ISpssVariable> arrayList2) {
        KeyListInfo keyListInfo = this.findKeyListInfoByVarName(this.mDataView.getCurrentVarName(iSpssVariable));
        if (keyListInfo == null) {
            this.mKeyListMap.put(iSpssVariable, new KeyListInfo(arrayList, arrayList2));
            this.mKeyVarList.getModel().addElement(iSpssVariable);
        }
    }

    private KeyListInfo findKeyListInfoByVarName(String string) {
        KeyListInfo keyListInfo = null;
        Set<ISpssVariable> set = this.mKeyListMap.keySet();
        for (ISpssVariable iSpssVariable : set) {
            String string2 = this.mDataView.getCurrentVarName(iSpssVariable);
            if (!string.equalsIgnoreCase(string2)) continue;
            keyListInfo = this.mKeyListMap.get(iSpssVariable);
            break;
        }
        return keyListInfo;
    }

    private void moveVarsFromActiveToExclude(ISpssVariable[] iSpssVariableArray) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (this.mDataView.isVarFromActiveDataSet(iSpssVariable)) {
                this.mExcludedVarList.getModel().addElement(iSpssVariable);
            } else if (!this.mDataView.isVarFromActiveDataSet(iSpssVariable)) {
                this.mExcludedVarList.getModel().addElement(iSpssVariable);
            }
            arrayList.add(iSpssVariable);
            this.mIncludeVarList.getModel().removeElement(iSpssVariable);
        }
        this.selectVariables(this.mExcludedVarList, arrayList);
        this.mExcludedVarList.requestFocus();
    }

    private void moveVarsFromExcludeToActive(ISpssVariable[] iSpssVariableArray) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (!this.mDataView.isVarFromActiveDataSet(iSpssVariable)) {
                this.mIncludeVarList.getModel().addElement(iSpssVariable);
            } else if (this.mDataView.isVarFromActiveDataSet(iSpssVariable)) {
                this.mIncludeVarList.getModel().addElement(iSpssVariable);
            }
            arrayList.add(iSpssVariable);
            this.mExcludedVarList.getModel().removeElement(iSpssVariable);
        }
        this.selectVariables(this.mIncludeVarList, arrayList);
        this.mIncludeVarList.requestFocus();
    }

    boolean checkForExistInActiveVarList(ISpssVariable[] iSpssVariableArray) {
        String[] stringArray = new String[iSpssVariableArray.length];
        String[] stringArray2 = new String[this.mIncludeVarList.getModel().getSize()];
        int n = 0;
        for (ISpssVariable object : iSpssVariableArray) {
            stringArray[n++] = this.mDataView.getCurrentVarName(object);
        }
        for (int i = 0; i < this.mIncludeVarList.getModel().getSize(); ++i) {
            stringArray2[i] = this.mDataView.getCurrentVarName(this.mIncludeVarList.getModel().getElementAt(i));
        }
        for (String string : stringArray2) {
            for (String string2 : stringArray) {
                if (!string.equalsIgnoreCase(string2)) continue;
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_ADD_VARIABLES_NAME_EXIST_WORKING_DATA_FILE"), VersionInfo.getAppVersionString());
                return true;
            }
        }
        return false;
    }

    private void selectVariables(TargetVariableList targetVariableList, ArrayList<ISpssVariable> arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (ISpssVariable iSpssVariable : arrayList) {
            int n = targetVariableList.getModel().findElementIndex(iSpssVariable);
            if (n == -1) continue;
            arrayList2.add(n);
        }
        Object object = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList2.get(i);
        }
        targetVariableList.setSelectedIndices((int[])object);
    }

    public boolean isExludeVarList(TargetVariableList targetVariableList) {
        return targetVariableList == this.mExcludedVarList;
    }

    public boolean isKeyVarList(TargetVariableList targetVariableList) {
        return targetVariableList == this.mKeyVarList;
    }

    void runRenameDialog() {
        ISpssVariable iSpssVariable = (ISpssVariable)this.mExcludedVarList.getSelectedValue();
        int[] nArray = this.mExcludedVarList.getSelectedIndices();
        String string = iSpssVariable.getName();
        String string2 = string + iSpssVariable.getId().toString();
        sRENAME_DIALOG_TITLE_KEY = string;
        String string3 = this.mDataView.getRename(iSpssVariable);
        if (string3 != null) {
            this.mDataView.getDialogDataModel().putString("IDS_ADD_VARIABLES_RENAME_KEY", string3);
        } else {
            this.mDataView.getDialogDataModel().putString("IDS_ADD_VARIABLES_RENAME_KEY", string);
        }
        this.mDataView.runSubDialog(new AddVariablesRename(this.mDataView, iSpssVariable));
        String string4 = this.mDataView.getDialogDataModel().getString("IDS_ADD_VARIABLES_RENAME_KEY");
        if (string4 == null || string4.equals(string)) {
            this.mDataView.mRenameMap.remove(string2);
            this.mDataView.mRenameList.remove(iSpssVariable);
        } else {
            this.mDataView.mRenameMap.put(string2, string4);
            this.mDataView.mRenameList.add(iSpssVariable);
        }
        this.mExcludedVarList.setModel(this.mExcludedVarList.getModel());
        this.mExcludedVarList.setSelectedIndices(nArray);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mExcludedVarList)) {
            this.processEnableRename(true);
        }
        if (this.mCrtMethod == 1 || this.mCrtMethod == 2) {
            this.mKeyArrowButton.setEnabled(true);
        } else {
            this.mKeyArrowButton.setEnabled(false);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mCrtMethod != 0) {
            this.mDataView.enableOkPaste(this.mKeyVarList.getModel().getSize() > 0);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mCrtMethod != 0) {
            this.mDataView.enableOkPaste(this.mKeyVarList.getModel().getSize() > 0);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (this.mCrtMethod != 0) {
            this.mDataView.enableOkPaste(this.mKeyVarList.getModel().getSize() > 0);
        }
    }

    @Override
    public boolean canDrop(VariableList variableList, VariableList variableList2, ISpssVariable[] iSpssVariableArray) {
        if (variableList2.containsAll(VariablesTab.convertToArrayList(iSpssVariableArray))) {
            return false;
        }
        if (variableList2.equals(this.mIncludeVarList)) {
            return !this.checkForExistInActiveVarList(iSpssVariableArray);
        }
        if (variableList2.equals(this.mKeyVarList)) {
            return (this.mCrtMethod == 1 || this.mCrtMethod == 2) && this.mDataView.isInBothDatasets(iSpssVariableArray, true);
        }
        return variableList2.equals(this.mExcludedVarList);
    }

    @Override
    public void processDrop(VariableList variableList, VariableList variableList2, ISpssVariable[] iSpssVariableArray) {
        if (((MergeFilesListModel)variableList2.getModel()).isKeyModelType()) {
            this.moveVariablesToKeyList(VariablesTab.convertToArrayList(iSpssVariableArray));
        }
        if (((MergeFilesListModel)variableList.getModel()).isKeyModelType()) {
            this.moveKeyListVarsBack(iSpssVariableArray);
        } else if (((MergeFilesListModel)variableList2.getModel()).isActiveModelType()) {
            this.moveVarsFromExcludeToActive(iSpssVariableArray);
        } else if (((MergeFilesListModel)variableList2.getModel()).isExcludeModelType()) {
            this.moveVarsFromActiveToExclude(iSpssVariableArray);
        }
    }

    private void processEnableRename(boolean bl) {
        if (bl && this.mExcludedVarList.getSelectedValues().length == 1) {
            this.mRenameButton.setEnabled(true);
        } else {
            this.mRenameButton.setEnabled(false);
        }
    }

    public int getCurrentMethodType() {
        return this.mCrtMethod;
    }

    public void setCurrentNoMethodType() {
        this.mCrtMethod = -1;
    }

    class KeyListInfo {
        ArrayList<ISpssVariable> mExcludeList;
        ArrayList<ISpssVariable> mActiveList;

        KeyListInfo(ArrayList<ISpssVariable> arrayList, ArrayList<ISpssVariable> arrayList2) {
            this.mExcludeList = arrayList;
            this.mActiveList = arrayList2;
        }

        public ArrayList<ISpssVariable> getExcludeList() {
            return this.mExcludeList;
        }

        public ArrayList<ISpssVariable> getActiveList() {
            return this.mActiveList;
        }
    }
}

