/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesDlg;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesVarFormatter;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.MergeFilesListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MergeMethodTab
extends BaseProcedureTab
implements ItemListener {
    public static final int OneToOneByFileOrder = 0;
    public static final int OneToOneByKeyValue = 1;
    public static final int OneToManyByKeyValue = 2;
    private AddVariablesDlg mDataView;
    private int mMethod;
    ArrayList<ISpssVariable> mCanKeyVars;
    private JRadioButton mOOFileOrderRadioButton;
    private JRadioButton mOOKeyValuesRadioButton;
    private JRadioButton mOMKeyValuesRadioButton;
    private JRadioButton mActiveRadioButton;
    private JRadioButton mSecondRadioButton;
    private JCheckBox mSortFilesCheck;
    private TargetVariableList mKeyVarList;

    MergeMethodTab(AddVariablesDlg addVariablesDlg) {
        super(addVariablesDlg, true);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_addv_main";
    }

    private void setupPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(5, 5, 5, 5);
        DialogUtil.addUsingGBL(this, this.getMethodPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.getLookupPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.getSortPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.getKeyVarsPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    private JPanel getMethodPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 17;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mOOFileOrderRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOOKeyValuesRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOMKeyValuesRadioButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getLookupPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_ADD_VARIABLES_LOOKUP_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 17;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mActiveRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSecondRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_ADD_VARIABLES_LOOKUP_ACTIVE_DATASET_LABEL");
        Insets insets2 = new Insets(15, 15, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel getSortPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_ADD_VARIABLES_SORT_INFO"), 2, 0);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSortFilesCheck, gridBagConstraints, 1, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel getKeyVarsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_ADD_VARIABLES_KEY_VAR_LABEL");
        jLabel.setLabelFor(this.mKeyVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mKeyVarList);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), this.mKeyVarList.getFixedCellHeight() * 3 + 2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(new ImageIcon(uRL));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_ADD_VARIABLES_VARIABLE_INFO"), 1, 0);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 2, 1, 1, n, null);
        return jPanel;
    }

    private void initVars() {
        this.mDataView = (AddVariablesDlg)this.mParent;
        this.mOOFileOrderRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_ADD_VARIABLES_ONE_TO_ONE_FILE_ORDER_RADIO", null);
        this.mOOKeyValuesRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_ADD_VARIABLES_ONE_TO_ONE_KEY_VALUE_RADIO", null);
        this.mOMKeyValuesRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_ADD_VARIABLES_ONE_TO_MANY_KEY_VALUE_RADIO", null);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOOFileOrderRadioButton);
        spssButtonGroup.add(this.mOOKeyValuesRadioButton);
        spssButtonGroup.add(this.mOMKeyValuesRadioButton);
        this.mOOFileOrderRadioButton.addItemListener(this);
        this.mOOKeyValuesRadioButton.addItemListener(this);
        this.mOMKeyValuesRadioButton.addItemListener(this);
        this.mActiveRadioButton = new JRadioButton(this.mDataView.mActiveDsName + "*");
        this.mSecondRadioButton = new JRadioButton(this.mDataView.mSecendDsName);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mActiveRadioButton);
        spssButtonGroup2.add(this.mSecondRadioButton);
        this.mSortFilesCheck = DialogUtil.createCheckBox(this.mParent, "IDS_ADD_VARIABLES_SORT_CHECK", null);
        this.mKeyVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mKeyVarList.setLoadFromPersistent(false);
        this.mKeyVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        AddVariablesVarFormatter addVariablesVarFormatter = new AddVariablesVarFormatter(this.mKeyVarList, this.mDataView);
        this.mKeyVarList.setModel(new MergeFilesListModel(2, addVariablesVarFormatter));
        this.mKeyVarList.setCellRenderer(new CustomVarListCellRenderer(addVariablesVarFormatter));
    }

    private void setDefaults() {
        this.mMethod = -1;
        this.mCanKeyVars = this.findCanExistKeyVars();
        boolean bl = this.mCanKeyVars.size() > 0;
        this.mMethod = bl ? 1 : 0;
        this.setEnableState(bl, false);
        this.mOOFileOrderRadioButton.setSelected(!bl);
        this.mOOKeyValuesRadioButton.setSelected(bl);
        this.mOMKeyValuesRadioButton.setSelected(false);
        this.mSortFilesCheck.setSelected(bl);
        this.loadDefaultKeyList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MergeMethodTab.this.mOOFileOrderRadioButton.requestFocusInWindow();
            }
        });
        this.mOOFileOrderRadioButton.setFocusable(true);
        this.mDataView.enableOkPaste(true);
    }

    private ArrayList<ISpssVariable> findCanExistKeyVars() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (this.mDataView.mActiveList != null && this.mDataView.mSecondList != null) {
            block0: for (int i = 0; i < this.mDataView.mActiveList.size(); ++i) {
                ISpssVariable iSpssVariable = this.mDataView.mActiveList.get(i);
                for (int j = 0; j < this.mDataView.mSecondList.size(); ++j) {
                    ISpssVariable iSpssVariable2 = this.mDataView.mSecondList.get(j);
                    if (!iSpssVariable.getName().equalsIgnoreCase(iSpssVariable2.getName()) || (iSpssVariable.getType() != 0 || iSpssVariable2.getType() != 0) && (iSpssVariable.getType() <= 0 || iSpssVariable2.getType() <= 0)) continue;
                    arrayList.add(iSpssVariable2);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mOOFileOrderRadioButton);
        vector.add(this.mOOKeyValuesRadioButton);
        vector.add(this.mOMKeyValuesRadioButton);
        vector.add(this.mActiveRadioButton);
        vector.add(this.mSecondRadioButton);
        vector.add(this.mSortFilesCheck);
        vector.add(this.mKeyVarList);
        this.setComponentOrder(vector);
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mOOFileOrderRadioButton;
    }

    private void setEnableState(boolean bl, boolean bl2) {
        this.mOOFileOrderRadioButton.setEnabled(true);
        this.mOOKeyValuesRadioButton.setEnabled(true);
        this.mOMKeyValuesRadioButton.setEnabled(true);
        this.mActiveRadioButton.setEnabled(bl && bl2);
        this.mSecondRadioButton.setEnabled(bl && bl2);
        this.mSortFilesCheck.setEnabled(bl);
    }

    public void updateKeyList(TargetVariableList targetVariableList) {
        if (targetVariableList == null) {
            return;
        }
        this.mKeyVarList.getModel().removeAll();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            this.mKeyVarList.getModel().addElement(targetVariableList.getModel().getElementAt(i));
        }
    }

    public int getMethodType() {
        return this.mMethod;
    }

    public boolean isKeyVarList(TargetVariableList targetVariableList) {
        return targetVariableList == this.mKeyVarList;
    }

    public boolean isSortFilesChecked() {
        return this.mSortFilesCheck.isEnabled() && this.mSortFilesCheck.isSelected();
    }

    public boolean isActiveDatasetAreLookupTable() {
        return this.mActiveRadioButton.isEnabled() && this.mActiveRadioButton.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = -1;
        if (this.mOOFileOrderRadioButton.isSelected()) {
            n = 0;
        } else if (this.mOOKeyValuesRadioButton.isSelected()) {
            n = 1;
        } else if (this.mOMKeyValuesRadioButton.isSelected()) {
            n = 2;
        }
        if (n == -1 || this.mMethod == n) {
            return;
        }
        boolean bl = true;
        if (this.mMethod != -1 && this.mDataView.getVariablesTab() != null && this.mDataView.getVariablesTab().getCurrentMethodType() != -1 && this.mDataView.getVariablesTab().getCurrentMethodType() != n) {
            if (SpssAlertOptionPane.showConfirmDialog(this, this.getResString("ERR_ADD_VARIABLES_CHANGE_OPTION_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) > 0) {
                bl = false;
            } else {
                this.mDataView.getVariablesTab().changeStates(n);
            }
        }
        if (bl) {
            switch (n) {
                case 0: {
                    this.setEnableState(false, false);
                    this.mKeyVarList.getModel().removeAll();
                    this.mDataView.enableOkPaste(true);
                    break;
                }
                case 1: {
                    this.setEnableState(true, false);
                    this.loadDefaultKeyList();
                    this.mDataView.enableOkPaste(this.mKeyVarList.getModel().getSize() > 0);
                    break;
                }
                case 2: {
                    this.setEnableState(true, true);
                    if (!this.mActiveRadioButton.isSelected() && !this.mSecondRadioButton.isSelected()) {
                        this.mSecondRadioButton.setSelected(true);
                    }
                    this.loadDefaultKeyList();
                    this.mDataView.enableOkPaste(this.mKeyVarList.getModel().getSize() > 0);
                    break;
                }
            }
            this.mMethod = n;
        } else {
            this.mOOFileOrderRadioButton.setSelected(false);
            this.mOOKeyValuesRadioButton.setSelected(false);
            this.mOMKeyValuesRadioButton.setSelected(false);
            switch (this.mMethod) {
                case 0: {
                    this.mOOFileOrderRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.mOOKeyValuesRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.mOMKeyValuesRadioButton.setSelected(true);
                    break;
                }
            }
        }
    }

    private void loadDefaultKeyList() {
        this.mKeyVarList.getModel().removeAll();
        if (this.mCanKeyVars == null) {
            this.mCanKeyVars = this.findCanExistKeyVars();
        }
        for (ISpssVariable iSpssVariable : this.mCanKeyVars) {
            this.mKeyVarList.getModel().addElement(iSpssVariable);
        }
    }
}

