/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class AddVariablesGating
extends BaseGatingDialog
implements ItemListener,
DocumentListener,
ListSelectionListener {
    static String sFILE_NAME_KEY;
    static LocallyUniqueId sLOCALLY_UNIQUE_DATASETID_KEY;
    static String sMANGLED_PASSWORD;
    static Vector<VariableBlock> sVARBLOCKS_FROM_ENCRYPTEDFILE;
    Vector<LocallyUniqueId> mLocallyUniqueIDs;
    private static final String SAVE_BROWSE_KEY = "IDS_ADD_VARIABLES_BROWSE";
    private static final String ADD_VARIABLES_EXTERNAL_RADIO_KEY = "IDS_ADD_VARIABLES_EXTERNAL_RADIO";
    private static final String ADD_VARIABLES_OPEN_DATASET_RADIO_KEY = "IDS_ADD_VARIABLES_OPEN_DATASET_RADIO";
    private FileTextField mFileNameText;
    private JRadioButton mOpenDataSetRadioButton;
    private JRadioButton mExternalSorceRadioButton;
    private PlainList mList;
    private JButton mBrowseButton;
    private SpssButtonGroup mButtonGroup;
    private Hashtable<String, String> mFileDatasetNames;

    public AddVariablesGating(JFrame jFrame) throws HeadlessException {
        super(jFrame, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        IDataDocument iDataDocument = dataMgr.findDataDocument(locallyUniqueId);
        this.setTitle(this.getResString("IDS_ADD_VARIABLES_BASE_TITLE") + " " + iDataDocument.getDocName() + "[" + iDataDocument.getDatasetName() + "]");
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    @Override
    public String getNextProcDlgActionKey() {
        return "data_merge_files_continue_add_vars";
    }

    @Override
    public String getIActionKey() {
        return "data_merge_files_add_vars";
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_ADD_GATING";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mOpenDataSetRadioButton.isSelected()) {
            this.mFileNameText.setEnabled(false);
            this.mFileNameText.setOpaque(false);
            this.mBrowseButton.setEnabled(false);
            this.mList.setEnabled(true);
            this.mList.setOpaque(true);
            if (this.mList.getModel().getSize() > 0 && !this.mList.isSelectionEmpty()) {
                this.mDefineButton.setEnabled(true);
            } else {
                this.mDefineButton.setEnabled(false);
            }
        }
        if (this.mExternalSorceRadioButton.isSelected()) {
            this.mFileNameText.setEnabled(true);
            this.mFileNameText.setOpaque(true);
            this.mBrowseButton.setEnabled(true);
            this.mList.setEnabled(false);
            this.mList.setOpaque(false);
            if (this.mFileNameText.getText().length() > 0) {
                this.mDefineButton.setEnabled(true);
            } else {
                this.mDefineButton.setEnabled(false);
            }
        }
    }

    @Override
    protected void loadDialogState() {
        this.setVisible(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.mList.isSelectionEmpty() && this.mOpenDataSetRadioButton.isSelected()) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mOpenDataSetRadioButton.isSelected()) {
            sLOCALLY_UNIQUE_DATASETID_KEY = this.mLocallyUniqueIDs.get(this.mList.getSelectedIndex());
            sFILE_NAME_KEY = this.mFileDatasetNames.get(this.mList.getSelectedValue().toString());
        }
        if (this.mExternalSorceRadioButton.isSelected()) {
            DocUtil.DataEncryptionTestResults dataEncryptionTestResults = DocUtil.testOpenEncryptedData(this.getParentFrame(), this.mFileNameText.getText());
            bl = dataEncryptionTestResults.isCanContinue();
            if (bl) {
                sMANGLED_PASSWORD = dataEncryptionTestResults.getMangledPassword();
                sVARBLOCKS_FROM_ENCRYPTEDFILE = dataEncryptionTestResults.getVarBlocks();
                sFILE_NAME_KEY = this.mFileNameText.getText();
                sLOCALLY_UNIQUE_DATASETID_KEY = null;
            } else if (dataEncryptionTestResults.isPasswordDlgOKPressed()) {
                String string = dataEncryptionTestResults.getErrorMsg() != null ? dataEncryptionTestResults.getErrorMsg() : this.getResString("ERR_ADD_CASES_RENAME_INVALID_FILENAME_ERROR");
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                this.mFileNameText.requestFocus();
                this.mFileNameText.selectAll();
                return false;
            }
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.mFileDatasetNames = new Hashtable();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        int n2 = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupExportPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void doLoadRemote() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_ADD_VARIABLES_BASE_FILE_DESC"), this.getResString("IDS_ADD_VARIABLES_BASE_FILE_EXT"));
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_ADD_VARIABLES_OPEN_FILE_TITLE"));
        int n = remoteFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            this.mFileNameText.setText(remoteFileChooser.getSelectedFilePath());
        }
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_ADD_VARIABLES_BASE_TOP_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOpenDataSetRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        int n2 = DialogUtil.getComponentGroupGap();
        jScrollPane.setPreferredSize(new Dimension(30 * n2, 10 * n2));
        Insets insets2 = new Insets(0, 3 * n2, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mExternalSorceRadioButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameText), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        insets2 = new Insets(-3, 6, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        this.mBrowseButton.addItemListener(this);
        JLabel jLabel = new JLabel(this.getResString("IDS_ADD_VARIABLES_BASE_BOTTOM_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 6, 2, 1, n, null);
        gridBagConstraints.gridy = 1;
        return jPanel;
    }

    private void initVars() {
        this.mFileNameText = new FileTextField();
        this.mFileNameText.setColumns(30);
        this.mFileNameText.setFocusable(true);
        this.mFileNameText.getDocument().addDocumentListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ADD_VARIABLES_EXTERNAL_RADIO_KEY);
        this.mExternalSorceRadioButton = new JRadioButton(toggleButtonAction);
        this.mExternalSorceRadioButton.addItemListener(this);
        this.mButtonGroup.add(this.mExternalSorceRadioButton);
        toggleButtonAction = new ToggleButtonAction(this, ADD_VARIABLES_OPEN_DATASET_RADIO_KEY);
        this.mOpenDataSetRadioButton = new JRadioButton(toggleButtonAction);
        this.mOpenDataSetRadioButton.addItemListener(this);
        this.mButtonGroup.add(this.mOpenDataSetRadioButton);
        toggleButtonAction = new ToggleButtonAction(this, SAVE_BROWSE_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddVariablesGating.this.doLoadRemote();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        DataMgr dataMgr = DataMgr.getDataMgr();
        this.mLocallyUniqueIDs = new Vector();
        if (spssFrameArray != null) {
            for (SpssFrame spssFrame : spssFrameArray) {
                DataFrame dataFrame;
                IDataDocument iDataDocument;
                if (spssFrame.docType() != DocType.DE_DOC || spssFrame == SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC) || (iDataDocument = dataMgr.findDataDocument((dataFrame = (DataFrame)spssFrame).getDatasetId())).getDatasetName().length() == 0) continue;
                String string = iDataDocument.getDocName() + "[" + iDataDocument.getDatasetName() + "]";
                defaultListModel.addElement(string);
                this.mFileDatasetNames.put(string, iDataDocument.getDatasetName());
                this.mLocallyUniqueIDs.add(((DataFrame)spssFrame).getDatasetId());
            }
        }
        this.mList = new PlainList(defaultListModel, "", PlainList.DragType.eNoAutoDrag);
        this.mList.setSelectionMode(0);
        this.mList.addListSelectionListener(this);
        this.setDefault();
    }

    private void setDefault() {
        if (this.mList.getModel().getSize() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddVariablesGating.this.mOpenDataSetRadioButton.requestFocus();
                    AddVariablesGating.this.mOpenDataSetRadioButton.setSelected(true);
                    AddVariablesGating.this.mOpenDataSetRadioButton.setEnabled(true);
                }
            });
            this.mList.setEnabled(true);
            this.mFileNameText.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddVariablesGating.this.mExternalSorceRadioButton.requestFocus();
                    AddVariablesGating.this.mExternalSorceRadioButton.setSelected(true);
                    AddVariablesGating.this.mOpenDataSetRadioButton.setEnabled(false);
                }
            });
            this.mList.setEnabled(false);
            this.mOpenDataSetRadioButton.setEnabled(false);
            this.mFileNameText.setEnabled(true);
            this.mBrowseButton.setEnabled(true);
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mList);
        vector.add(this.mFileNameText);
        vector.add(this.mBrowseButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    static {
        sLOCALLY_UNIQUE_DATASETID_KEY = null;
    }
}

