/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.AddCasesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddCasesRename
extends BaseSubDialog {
    public static final String RENAME_KEY = "IDS_ADD_VARIABLES_RENAME_KEY";
    StringTextField mRenameText;
    String mIspssVarName = null;
    String mIspssInitStr = null;
    BaseProcedureDialog mDialog;
    ISpssVariable mRenameVar;

    public AddCasesRename(BaseProcedureDialog baseProcedureDialog, ISpssVariable iSpssVariable, String string) {
        super(baseProcedureDialog, string, true);
        this.mDialog = baseProcedureDialog;
        this.mRenameVar = iSpssVariable;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = false;
        boolean bl2 = false;
        this.mIspssInitStr = this.mRenameText.getText();
        if (this.mRenameText.getText().length() == 0) {
            bl = true;
        } else if (this.validateSPSSVarName()) {
            bl = this.mIspssInitStr.equalsIgnoreCase(this.mRenameVar.getName()) || !((AddCasesDlg)this.mDialog).checkRename(this.mIspssInitStr, this.mRenameVar);
        } else {
            bl2 = true;
        }
        if (!bl) {
            if (!bl2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_VARIABLES_RENAME_NAME_EXIST_WARNING"), VersionInfo.getAppVersionString());
            }
            this.mRenameText.requestFocus();
            this.mRenameText.selectAll();
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_ADDM_RENAME";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_ADD_VARIABLES_SOURCE_RENAME_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mRenameText), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (this.mRenameText.getText().length() > 0) {
            if (!this.mIspssVarName.equals(this.mIspssInitStr)) {
                this.mIspssVarName = this.mRenameText.getText();
            }
            dialogDataModel.putString(RENAME_KEY, this.mIspssVarName);
        } else {
            dialogDataModel.putString(RENAME_KEY, null);
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString(RENAME_KEY) != null) {
            this.mIspssInitStr = this.mIspssVarName = dialogDataModel.getString(RENAME_KEY);
            this.mRenameText.setText(dialogDataModel.getString(RENAME_KEY));
            this.mRenameText.requestFocus();
            this.mRenameText.selectAll();
        }
    }

    private boolean validateSPSSVarName() {
        boolean bl;
        String string = this.mRenameText.getText();
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl2 = bl = n <= 0 || n == 3 || n == 100 || DialogUtil.showBadSpssVarNameWarning(n, this);
        if (!bl) {
            this.mRenameText.requestFocus();
            this.mRenameText.selectAll();
        }
        return bl;
    }

    private void initVars() {
        FixedLengthDocument fixedLengthDocument = new FixedLengthDocument(64);
        this.mRenameText = new StringTextField(10);
        this.mRenameText.setDocument(fixedLengthDocument);
        this.setDefaults();
    }

    private void setDefaults() {
        this.enableContinue(true);
    }
}

