/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.CallbackVarDropListener;
import com.spss.java_client.ui.controls.drag_drop.VarDropCallback;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.AddCasesGating;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.AddCasesRename;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.AddCasesVarFormatter;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.MergeFilesListModel;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ListSelectionListener,
VarDropCallback {
    final String RENAMED_VARIABLE_EXIST_KEY = "RENAMED_VARIABLE_EXIST_KEY";
    private ArrowButton mArrowButton;
    static String RENAME_DIALOG_TITLE_KEY;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mSrcVarList;
    private JButton mPairButton;
    private StringTextField mIndicateSourceText;
    private HashMap<String, String> mRenameMap;
    private HashMap<String, Boolean> mHashMap;
    private String mDataSource;
    private JCheckBox mIndicateCheck;
    private JButton mRenameButton;
    private boolean mIsVarHandler;
    private Vector<Object> mTabOrder;
    AddCasesVarFormatter mSrcFormatter;
    AddCasesVarFormatter mTargetFormatter;
    ArrayList<ISpssVariable> mActiveList;
    private HashMap<String, Boolean> mActiveVarsMap;
    ArrayList<ISpssVariable> mNewList;
    Vector<ISpssVariable> mRenameList;

    public AddCasesDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ADD_CASES_DLG_TITLE") + " " + AddCasesGating.sFILE_NAME_KEY);
        this.setLocationRelativeTo(this.getParent());
    }

    private boolean isVarPresentInTargetList(String string) {
        boolean bl = false;
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            String string2;
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            String string3 = iSpssVariable.getName() + iSpssVariable.getId().toString();
            String string4 = string2 = this.mRenameMap.containsKey(string3) ? this.mRenameMap.get(string3) : iSpssVariable.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean canDrop(VariableList variableList, VariableList variableList2, ISpssVariable[] iSpssVariableArray) {
        return variableList != variableList2;
    }

    @Override
    public void processDrop(VariableList variableList, VariableList variableList2, ISpssVariable[] iSpssVariableArray) {
        if (((MergeFilesListModel)variableList2.getModel()).isActiveModelType()) {
            this.moveVarsFromUnpairedToActive(iSpssVariableArray);
        } else if (((MergeFilesListModel)variableList2.getModel()).isUnpairedModelType()) {
            this.moveVarsFromActiveToUnpaired(iSpssVariableArray);
        }
    }

    private boolean canMoveToTarget(ISpssVariable[] iSpssVariableArray, String string, int n) {
        for (int i = n; i < iSpssVariableArray.length; ++i) {
            ISpssVariable iSpssVariable = iSpssVariableArray[i];
            if (!iSpssVariable.getName().equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_ADDC_MAIN";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mIndicateSourceText.setEnabled(this.mIndicateCheck.isSelected());
        this.mIndicateSourceText.setOpaque(this.mIndicateCheck.isSelected());
        if (this.mIndicateSourceText.isEnabled()) {
            this.mIndicateSourceText.selectAll();
            this.mIndicateSourceText.requestFocus();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mSrcVarList)) {
            this.mPairButton.setEnabled(this.mSrcVarList.getSelectedValues().length == 2);
            this.mRenameButton.setEnabled(this.mSrcVarList.getSelectedValues().length == 1);
        }
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mIndicateCheck.isSelected()) {
            if (this.mIndicateSourceText.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_CASES_INDICATE_SOURCE_TEXT_EMPTY"), VersionInfo.getAppVersionString());
                return false;
            }
            String string = this.mIndicateSourceText.getText();
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            boolean bl2 = bl = n <= 0 || n == 3 || n == 100 || DialogUtil.showBadSpssVarNameWarning(n, this);
            if (bl && this.isVarPresentInTargetList(string)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INDICATE_NAME_IN_USE"), VersionInfo.getAppVersionString());
                bl = false;
            }
        }
        if (!bl) {
            this.mIndicateSourceText.requestFocus();
            this.mIndicateSourceText.selectAll();
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        String string;
        int n;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("ADD FILES"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("/FILE=*")).append("\n");
        String string2 = "(";
        String string3 = "(";
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            object = this.mSrcVarList.getModel().getElementAt(i);
            if (this.mActiveList.contains(object)) {
                string2 = string2 + object.getName() + " ";
                ++n2;
                continue;
            }
            if (!this.mNewList.contains(object)) continue;
            string3 = string3 + object.getName() + " ";
            ++n3;
        }
        string2 = n2 > 0 ? string2.trim() + "=" : " ";
        string3 = n3 > 0 ? string3.trim() + "=" : " ";
        object = "";
        FindOpenId findOpenId = new FindOpenId(0);
        for (n = 0; n < n2; ++n) {
            String string4 = findOpenId.getNextOpenVarId();
            string2 = string2 + string4;
            object = (String)object + string4;
        }
        for (n = n2; n < n2 + n3; ++n) {
            String string5 = findOpenId.getNextOpenVarId();
            string3 = string3 + string5;
            object = (String)object + string5;
        }
        if (n2 > 0) {
            string2 = string2.trim() + ") ";
        }
        if (n3 > 0) {
            string3 = string3.trim() + ") ";
        }
        for (n = 0; n < this.mTargetVarList.getModel().getSize(); ++n) {
            String[] stringArray;
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(n);
            String string6 = iSpssVariable.getName() + iSpssVariable.getId().toString();
            if (this.mTargetFormatter.getMap().get(string6).toString().contains("*")) {
                if (!this.mRenameMap.containsKey(string6)) continue;
                string2 = string2 + iSpssVariable.getName() + "=" + this.mRenameMap.get(string6) + " ";
                continue;
            }
            if (this.mTargetFormatter.getMap().get(string6).toString().contains("+")) {
                if (!this.mRenameMap.containsKey(string6)) continue;
                string3 = string3 + iSpssVariable.getName() + "=" + this.mRenameMap.get(string6) + " ";
                continue;
            }
            if (this.mTargetFormatter.getMap().get(string6).toString().contains("&")) {
                stringArray = this.mTargetFormatter.getMap().get(string6).toString().split("&");
                String string7 = stringArray[0].trim();
                Object object2 = stringArray[1].trim();
                object2 = this.removeInvalidMarkerCharacters((String)object2);
                boolean bl = false;
                for (ISpssVariable iSpssVariable2 : this.mRenameList) {
                    String string8 = iSpssVariable2.getName() + iSpssVariable2.getId().toString();
                    String string9 = this.mRenameMap.get(string8);
                    if (string9.equalsIgnoreCase(string7)) {
                        string2 = string2 + iSpssVariable2.getName() + "=" + (String)string7 + " ";
                        bl = true;
                    }
                    if (!string9.equalsIgnoreCase((String)object2)) continue;
                    string3 = string3 + iSpssVariable2.getName() + "=" + (String)string7 + " ";
                    bl = true;
                }
                if (bl) continue;
                string3 = string3 + (String)object2 + "=" + (String)string7 + " ";
                continue;
            }
            stringArray = this.mTargetFormatter.getDisplayText(iSpssVariable);
            for (Object object2 : this.mRenameList) {
                String string10 = object2.getName() + object2.getId().toString();
                String string11 = this.mRenameMap.get(string10);
                if (!string11.equalsIgnoreCase((String)stringArray)) continue;
                if (this.mActiveList.contains(object2)) {
                    string2 = string2 + object2.getName() + "=" + (String)stringArray + " ";
                    continue;
                }
                string3 = string3 + object2.getName() + "=" + (String)stringArray + " ";
            }
        }
        if (string2.length() > 1) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RENAME ")).append(string2.trim());
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/FILE=")).append(CharacterUtil.smartQuote((String)this.mDataSource));
        if (AddCasesGating.sMANGLED_PASSWORD != null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("PASSWORD=")).append(CharacterUtil.smartQuote((String)AddCasesGating.sMANGLED_PASSWORD));
        }
        if (string3.length() > 1) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/RENAME ")).append(string3.trim());
        }
        if (this.mIndicateCheck.isSelected() && this.mIndicateSourceText.getText().length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/IN=")).append(this.mIndicateSourceText.getText());
        }
        if (!(string = SyntaxUtil.getSubCommand("/DROP=").toString() + ((String)object).trim()).equals(SyntaxUtil.getSubCommand("/DROP=").toString())) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIndicateCheck.isSelected() && this.mIndicateSourceText.getText().length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mIndicateSourceText.getText()));
            stringBuffer.append("\n");
            stringBuffer.append(" 'Case source is ").append(this.mDataSource).append("'");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    private String removeInvalidMarkerCharacters(String string) {
        if (string != null) {
            int n = string.lastIndexOf(">");
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((n = string.lastIndexOf("<")) != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public final String getIActionKey() {
        return "data_merge_files_continue_add_cases";
    }

    public final String getIActionGatingKey() {
        return "data_merge_files_add_cases";
    }

    public final String getRecallListText() {
        return this.getResString("IDS_ADD_CASES_TITLE");
    }

    @Override
    public void reset() {
        this.mSrcVarList.removeAll();
        this.mTargetVarList.removeAll();
        this.mHashMap.clear();
        this.mActiveVarsMap.clear();
        this.mActiveList.clear();
        this.mRenameList.removeAllElements();
        this.mRenameMap.clear();
        this.mIndicateCheck.setSelected(false);
        this.mIndicateSourceText.setText(this.getResString("IDS_ADD_CASES_INITIAL_INDICATE_TEXT"));
        super.reset();
        this.fillSourceAndTargetList();
        this.mSrcVarList.ensureIndexIsVisible(0);
        this.mTargetVarList.ensureIndexIsVisible(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mIsVarHandler) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddCasesDlg.this.afterArrowButtonAction();
                }
            });
            this.mIsVarHandler = false;
        }
        if (this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
        if (listDataEvent.getSource() == this.mSrcVarList.getModel()) {
            this.mSrcVarList.getModel().sort();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public boolean checkRename(String string, ISpssVariable iSpssVariable) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        boolean bl = iSpssDataSrc.findVarIndex(iSpssVariable.getId()) != -1;
        Set<String> set = this.mRenameMap.keySet();
        for (String string2 : set) {
            if (bl && this.mActiveVarsMap.containsKey(string2) && this.mRenameMap.get(string2).equalsIgnoreCase(string)) {
                return true;
            }
            if (bl || this.mActiveVarsMap.containsKey(string2) || !this.mRenameMap.get(string2).equalsIgnoreCase(string)) continue;
            return true;
        }
        if (bl) {
            return iSpssDataSrc.findVarIndex(string) != -1;
        }
        for (ISpssVariable iSpssVariable2 : this.mNewList) {
            if (!iSpssVariable2.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canBeRecalled() {
        return true;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    protected void loadDialogState() {
        this.mSrcVarList.removeAll();
        this.mTargetVarList.removeAll();
        this.mRenameList.removeAllElements();
        this.mHashMap.clear();
        this.fillSourceAndTargetList();
        this.mIndicateCheck.setSelected(false);
        this.mIndicateSourceText.setText(this.getResString("IDS_ADD_CASES_INITIAL_INDICATE_TEXT"));
        this.setVisible(true);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        JPanel jPanel2 = this.setupSourceListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jPanel2 = this.setupTargetListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jPanel2 = this.setupLabelPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.pack();
        this.setTabPolicy();
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            CallbackVarDropListener.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this);
        }
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mRenameButton);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mPairButton);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTabOrder.add(this.mIndicateCheck);
        this.mTabOrder.add(this.mIndicateSourceText);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    void runRenameDialog() {
        Object object;
        String string;
        ISpssVariable iSpssVariable = (ISpssVariable)this.mSrcVarList.getSelectedValue();
        int[] nArray = this.mSrcVarList.getSelectedIndices();
        String string2 = iSpssVariable.getName();
        String string3 = this.mSrcFormatter.getDisplayText(iSpssVariable);
        String string4 = string2 + iSpssVariable.getId().toString();
        RENAME_DIALOG_TITLE_KEY = string2;
        if (this.mHashMap.get(string4).booleanValue()) {
            string = string3.substring(0, string3.length() - 3);
            object = string.split("->");
            this.getDialogDataModel().putString("IDS_ADD_VARIABLES_RENAME_KEY", object[1]);
        } else {
            this.getDialogDataModel().putString("IDS_ADD_VARIABLES_RENAME_KEY", string2);
        }
        this.runSubDialog(new AddCasesRename((BaseProcedureDialog)this, iSpssVariable, String.format(this.getResString("IDS_ADD_RENAME_TITLE"), RENAME_DIALOG_TITLE_KEY)));
        string = this.getDialogDataModel().getString("IDS_ADD_VARIABLES_RENAME_KEY");
        if (string == null || string.equals(string2)) {
            this.mHashMap.put(string4, false);
            this.mRenameMap.remove(string4);
            this.mRenameList.remove(iSpssVariable);
            object = iSpssVariable.getName();
            if (iSpssVariable.getType() != 0) {
                object = iSpssVariable.getType() <= 8 ? (String)object + "<" : (String)object + ">";
            }
            if (string3.contains("(+)")) {
                this.mSrcFormatter.getMap().put(string4, (String)object + "(+)");
            } else {
                this.mSrcFormatter.getMap().put(string4, (String)object + "(*)");
            }
        } else {
            this.mHashMap.put(string4, true);
            this.mRenameMap.put(string4, string);
            this.mRenameList.add(iSpssVariable);
            string = string3.contains("(+)") ? iSpssVariable.getName() + "->" + string + "(+)" : iSpssVariable.getName() + "->" + string + "(*)";
            this.mSrcFormatter.getMap().put(string4, string);
        }
        this.mSrcVarList.setModel(this.mSrcVarList.getModel());
        this.mSrcVarList.setSelectedIndices(nArray);
    }

    private void setDefaults() {
        this.mPairButton.setEnabled(false);
        this.mIndicateCheck.setEnabled(true);
        this.mIndicateCheck.setSelected(false);
        this.mIndicateSourceText.setEnabled(false);
        this.mIndicateSourceText.setOpaque(false);
        this.mRenameButton.setEnabled(false);
        this.mArrowButton.setEnabled(false);
        if (this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    private void initVars() {
        this.mSrcVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcFormatter = new AddCasesVarFormatter(this.mSrcVarList, this);
        this.mSrcVarList.setModel(new MergeFilesListModel(1, this.mSrcFormatter));
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTargetVarList.setLoadFromPersistent(false);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetFormatter = new AddCasesVarFormatter(this.mTargetVarList, this);
        this.mTargetVarList.setModel(new MergeFilesListModel(0, this.mTargetFormatter));
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcVarList.addListSelectionListener(this);
        int n = DialogUtil.getComponentGroupGap();
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcVarList.getFixedCellHeight() * 10));
        this.mTargetVarList.setMinimumSize(new Dimension(n * 14, n * 13));
        this.mSrcVarList.setCellRenderer(new CustomVarListCellRenderer(this.mSrcFormatter));
        this.mSrcVarList.setSortType(SpssVariableSortType.alpha);
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mTargetFormatter));
        this.mTargetVarList.getModel().addListDataListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_ADD_CASES_SOURCE_CHECK");
        this.mIndicateCheck = new JCheckBox(toggleButtonAction);
        this.mIndicateCheck.addItemListener(this);
        FixedLengthDocument fixedLengthDocument = new FixedLengthDocument(64);
        this.mIndicateSourceText = new StringTextField(10);
        this.mIndicateSourceText.setDocument(fixedLengthDocument);
        this.mIndicateSourceText.setText(this.getResString("IDS_ADD_CASES_INITIAL_INDICATE_TEXT"));
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AddCasesDlg.this.mArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.left)) {
                    ISpssVariable[] iSpssVariableArray = AddCasesDlg.this.mTargetVarList.getSelectedValues();
                    AddCasesDlg.this.moveVarsFromActiveToUnpaired(iSpssVariableArray);
                } else if (AddCasesDlg.this.mArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right)) {
                    ISpssVariable[] iSpssVariableArray = AddCasesDlg.this.mSrcVarList.getSelectedValues();
                    AddCasesDlg.this.moveVarsFromUnpairedToActive(iSpssVariableArray);
                }
            }
        };
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ADD_CASES_PAIR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddCasesDlg.this.doPairButtonClick();
            }
        };
        this.mPairButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ADD_CASES_RENAME"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddCasesDlg.this.runRenameDialog();
            }
        };
        this.mRenameButton = new JButton(toggleButtonAction);
        this.mHashMap = new HashMap();
        this.mActiveVarsMap = new HashMap();
        this.mRenameMap = new HashMap();
        if (AddCasesGating.sFILE_NAME_KEY != null) {
            this.mDataSource = AddCasesGating.sFILE_NAME_KEY;
        }
        this.mTabOrder = new Vector();
        this.mActiveList = new ArrayList();
        this.mNewList = new ArrayList();
        this.mRenameList = new Vector();
        ((MergeFilesListModel)this.mSrcVarList.getModel()).getVarFormatter().setUpdateNameMap(false);
        this.fillSourceAndTargetList();
        this.setDefaults();
        ((MergeFilesListModel)this.mSrcVarList.getModel()).getVarFormatter().setUpdateNameMap(true);
    }

    private void moveVarsFromActiveToUnpaired(ISpssVariable[] iSpssVariableArray) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            Object object;
            Object object2;
            boolean bl = false;
            String string = iSpssVariable.getName() + iSpssVariable.getId().toString();
            if (this.mTargetFormatter.getMap().get(string).toString().contains("*")) {
                ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable, locallyUniqueId.asInt());
                if (this.mRenameMap.containsKey(string)) {
                    object2 = iSpssVariable.getName() + "->" + this.mRenameMap.get(string) + "(*)";
                    this.mSrcFormatter.getMap().put(string, object2);
                    bl = true;
                }
                this.mHashMap.put(string, bl);
            } else if (this.mTargetFormatter.getMap().get(string).toString().contains("+")) {
                ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable, -1);
                if (this.mRenameMap.containsKey(string)) {
                    object2 = iSpssVariable.getName() + "->" + this.mRenameMap.get(string) + "(+)";
                    this.mSrcFormatter.getMap().put(string, object2);
                    bl = true;
                }
                this.mHashMap.put(string, bl);
            } else if (this.mTargetFormatter.getMap().get(string).toString().contains("&")) {
                object2 = this.mTargetFormatter.getMap().get(string).toString().split("&");
                Iterator<ISpssVariable> iterator = object2[0].trim();
                String string2 = object2[1].trim();
                boolean bl2 = false;
                boolean bl3 = false;
                object = this.mRenameList.iterator();
                while (object.hasNext()) {
                    String string3;
                    ISpssVariable iSpssVariable2 = object.next();
                    String string4 = iSpssVariable2.getName() + iSpssVariable2.getId().toString();
                    String string5 = this.mRenameMap.get(string4);
                    if (string5.equalsIgnoreCase((String)((Object)iterator))) {
                        if (this.mActiveList.contains(iSpssVariable2)) {
                            ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable2, locallyUniqueId.asInt());
                            string3 = iSpssVariable2.getName() + " -> " + string5 + "(*)";
                        } else {
                            ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable2, -1);
                            string3 = iSpssVariable2.getName() + " -> " + string5 + "(+)";
                        }
                        this.mSrcFormatter.getMap().put(string4, string3);
                        bl2 = true;
                        continue;
                    }
                    if (!string5.equalsIgnoreCase(string2)) continue;
                    if (this.mActiveList.contains(iSpssVariable2)) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable2, locallyUniqueId.asInt());
                        string3 = iSpssVariable2.getName() + " -> " + string5 + "(*)";
                    } else {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable2, -1);
                        string3 = iSpssVariable2.getName() + " -> " + string5 + "(+)";
                    }
                    this.mSrcFormatter.getMap().put(string4, string3);
                    bl3 = true;
                }
                if (!bl2 || !bl3) {
                    if (!bl2 && (object = this.findVarList(this.mActiveList, (String)((Object)iterator))) != null) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement((ISpssVariable)object, locallyUniqueId.asInt());
                        string = object.getName() + object.getId().toString();
                        this.mHashMap.put(string, false);
                    }
                    if (!bl3 && (object = this.findVarList(this.mNewList, string2)) != null) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement((ISpssVariable)object, -1);
                        string = object.getName() + object.getId().toString();
                        this.mHashMap.put(string, false);
                    }
                }
            } else if (this.mHashMap.get(string).booleanValue()) {
                object2 = this.mRenameMap.get(string);
                for (ISpssVariable iSpssVariable3 : this.mRenameList) {
                    String string6 = iSpssVariable3.getName() + iSpssVariable3.getId().toString();
                    String string7 = this.mRenameMap.get(string6);
                    if (!string7.equalsIgnoreCase((String)object2)) continue;
                    if (this.mActiveList.contains(iSpssVariable3)) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable3, locallyUniqueId.asInt());
                        object = iSpssVariable3.getName() + " -> " + string7 + "(*)";
                    } else {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable3, -1);
                        object = iSpssVariable3.getName() + " -> " + string7 + "(+)";
                    }
                    this.mSrcFormatter.getMap().put(string6, object);
                }
            } else {
                object2 = iSpssVariable.getName();
                for (ISpssVariable iSpssVariable4 : this.mRenameList) {
                    String string8 = iSpssVariable4.getName() + iSpssVariable4.getId().toString();
                    String string9 = this.mRenameMap.get(string8);
                    if (!string9.equalsIgnoreCase((String)object2)) continue;
                    if (this.mActiveList.contains(iSpssVariable4)) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable4, locallyUniqueId.asInt());
                        object = iSpssVariable4.getName() + " -> " + string9 + "(*)";
                    } else {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable4, -1);
                        object = iSpssVariable4.getName() + " -> " + string9 + "(+)";
                    }
                    this.mSrcFormatter.getMap().put(string8, object);
                }
                for (ISpssVariable iSpssVariable5 : this.mActiveList) {
                    if (!iSpssVariable5.getName().equalsIgnoreCase((String)object2)) continue;
                    ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable5, locallyUniqueId.asInt());
                    string = iSpssVariable5.getName() + iSpssVariable5.getId().toString();
                    this.mHashMap.put(string, false);
                    break;
                }
                for (ISpssVariable iSpssVariable6 : this.mNewList) {
                    if (!iSpssVariable6.getName().equalsIgnoreCase((String)object2)) continue;
                    ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable6, -1);
                    string = iSpssVariable6.getName() + iSpssVariable6.getId().toString();
                    this.mHashMap.put(string, false);
                    break;
                }
            }
            this.mTargetVarList.getModel().removeElement(iSpssVariable);
        }
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSrcVarList.setSelection(iSpssVariableArray, true);
        final TargetVariableList targetVariableList = this.mSrcVarList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                targetVariableList.requestFocus();
            }
        });
    }

    private void moveVarsFromUnpairedToActive(ISpssVariable[] iSpssVariableArray) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        int n = this.mTargetVarList.getModel().getSize();
        for (int i = 0; i < iSpssVariableArray.length; ++i) {
            ISpssVariable iSpssVariable = iSpssVariableArray[i];
            String string = iSpssVariableArray[i].getName() + iSpssVariableArray[i].getId().toString();
            String string2 = iSpssVariable.getName();
            if (this.mHashMap.containsKey(string) && this.mHashMap.get(string).booleanValue()) {
                string2 = this.mRenameMap.get(string);
            }
            if (!this.canMoveToTarget(iSpssVariableArray, string2, i + 1)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_CASES_NAME_USE_PAIR_BUTTON"), VersionInfo.getAppVersionString());
                return;
            }
            if (this.isVarPresentInTargetList(string2)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_CASES_NAME_EXIST_WORKING_DATA_FILE"), VersionInfo.getAppVersionString());
                return;
            }
            string = iSpssVariable.getName() + iSpssVariable.getId().toString();
            if (this.mSrcFormatter.getMap().get(string) != null) {
                String string3;
                if (this.mSrcFormatter.getMap().get(string).toString().contains("*")) {
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, locallyUniqueId.asInt());
                    if (this.mRenameMap.containsKey(string)) {
                        string3 = this.mRenameMap.get(string) + "(*)";
                        this.mTargetFormatter.getMap().put(string, string3);
                    }
                } else if (this.mSrcFormatter.getMap().get(string).toString().contains("+")) {
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, -1);
                    if (this.mRenameMap.containsKey(string)) {
                        string3 = this.mRenameMap.get(string) + "(+)";
                        this.mTargetFormatter.getMap().put(string, string3);
                    }
                }
            }
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
            this.mHashMap.remove(string);
        }
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        int[] nArray = new int[iSpssVariableArray.length];
        int n2 = 0;
        int n3 = n;
        while (n3 < n + iSpssVariableArray.length) {
            nArray[n2++] = n3++;
        }
        this.mTargetVarList.setSelectedIndices(nArray);
        final TargetVariableList targetVariableList = this.mTargetVarList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                targetVariableList.requestFocus();
            }
        });
    }

    private ISpssVariable findVarList(ArrayList<ISpssVariable> arrayList, String string) {
        ISpssVariable iSpssVariable = null;
        for (ISpssVariable iSpssVariable2 : arrayList) {
            if (!iSpssVariable2.getName().equals(string)) continue;
            iSpssVariable = iSpssVariable2;
            break;
        }
        return iSpssVariable;
    }

    private void doPairButtonClick() {
        Object object;
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        ISpssVariable iSpssVariable = iSpssVariableArray[0];
        String string = iSpssVariable.getName() + iSpssVariable.getId().toString();
        String string2 = this.mSrcFormatter.getMap().get(string).toString();
        ISpssVariable iSpssVariable2 = iSpssVariableArray[1];
        String string3 = iSpssVariable2.getName() + iSpssVariable2.getId().toString();
        String string4 = this.mSrcFormatter.getMap().get(string3).toString();
        if (string2.contains("+")) {
            object = iSpssVariable;
            iSpssVariable = iSpssVariable2;
            iSpssVariable2 = object;
            string = iSpssVariable.getName() + iSpssVariable.getId().toString();
            string3 = iSpssVariable2.getName() + iSpssVariable2.getId().toString();
            string2 = this.mSrcFormatter.getMap().get(string).toString();
            string4 = this.mSrcFormatter.getMap().get(string3).toString();
        }
        if (string2.contains("+") && string4.contains("+") || string2.contains("*") && string4.contains("*")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_CASES_SAME_FILE_VARIABLE"), VersionInfo.getAppVersionString());
            this.mSrcVarList.clearSelection();
        } else if (iSpssVariable.getType() == iSpssVariable2.getType()) {
            if (this.mHashMap.get(string).booleanValue()) {
                if (this.mHashMap.get(string3).booleanValue()) {
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, iSpssVariable2, this.mRenameMap.get(string), this.mRenameMap.get(string3));
                    this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
                } else {
                    object = this.mRenameMap.get(string);
                    if (((String)object).equalsIgnoreCase(iSpssVariable2.getName())) {
                        ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable2, 0);
                        this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
                    } else {
                        ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, iSpssVariable2, (String)object, iSpssVariable2.getName());
                        this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
                    }
                }
            } else if (this.mHashMap.get(string3).booleanValue()) {
                object = this.mRenameMap.get(string3);
                if (((String)object).equalsIgnoreCase(iSpssVariable.getName())) {
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, 0);
                    this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
                } else {
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, iSpssVariable2, iSpssVariable.getName(), (String)object);
                    this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
                }
            } else if (iSpssVariable.getName().equalsIgnoreCase(iSpssVariable2.getName())) {
                ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, 0);
                this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
            } else {
                ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement(iSpssVariable, iSpssVariable2, iSpssVariable.getName(), iSpssVariable2.getName());
                this.mTargetVarList.setSelectedIndex(this.mTargetVarList.getModel().getSize() - 1);
            }
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
            this.mSrcVarList.getModel().removeElement(iSpssVariable2);
        } else {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ADD_CASES_NAME_VAR_PAIR_LENGTH_TYPE"), VersionInfo.getAppVersionString());
            this.mSrcVarList.clearSelection();
        }
    }

    private int indexOfVariableExist(VariableList variableList, String string) {
        for (int i = 0; i < variableList.getModel().getSize(); ++i) {
            String string2 = variableList.getModel().getElementAt(i).getName();
            if (string2.contains("->")) {
                String[] stringArray = string2.split("->");
                if (string.equalsIgnoreCase(stringArray[0])) {
                    return i;
                }
                if (stringArray[1].endsWith("<")) {
                    stringArray[1] = this.removeLastCharacter(stringArray[1]);
                }
                if (string.equalsIgnoreCase(stringArray[1])) {
                    return i;
                }
            }
            if (string2.endsWith("<")) {
                string2 = this.removeLastCharacter(string2);
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    private String removeLastCharacter(String string) {
        return string.substring(0, string.length() - 1);
    }

    private void afterArrowButtonAction() {
        String[] stringArray;
        ISpssVariable[] iSpssVariableArray;
        for (ISpssVariable iSpssVariable : iSpssVariableArray = this.mSrcVarList.getSelectedValues()) {
            int[] nArray;
            int[] nArray2;
            Object exception;
            String string = iSpssVariable.getName();
            if (iSpssVariable.getName().contains(" & ")) {
                if (string.contains("<")) {
                    iSpssVariable.setName(string.substring(0, string.length() - 1));
                }
                try {
                    exception = iSpssVariable.clone();
                    stringArray = iSpssVariable.getName().split(" & ");
                    if (this.mHashMap.get(stringArray[0].trim() + "(*)") != null) {
                        iSpssVariable.setName(this.mHashMap.get(stringArray[0].trim() + "(*)") + "->" + stringArray[0].trim() + "(*)");
                    } else if (iSpssVariable.getType() > 0 && !iSpssVariable.getName().contains("<")) {
                        iSpssVariable.setName(stringArray[0].trim() + "<(*)");
                    } else {
                        iSpssVariable.setName(stringArray[0].trim() + "(*)");
                    }
                    if (this.mHashMap.get(stringArray[1].trim() + "(+)") != null) {
                        exception.setName(this.mHashMap.get(stringArray[1].trim() + "(+)") + "->" + stringArray[1].trim() + "(+)");
                    } else if (exception.getType() > 0 && !exception.getName().contains("<")) {
                        exception.setName(stringArray[1].trim() + "<(+)");
                    } else {
                        exception.setName(stringArray[1].trim() + "(+)");
                    }
                    this.mSrcVarList.getModel().addElement((ISpssVariable)exception);
                    nArray2 = this.mSrcVarList.getSelectedIndices();
                    nArray = new int[nArray2.length + 1];
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                    nArray[nArray2.length] = this.indexOfVariableExist(this.mSrcVarList, exception.getName());
                    this.mSrcVarList.setModel(this.mSrcVarList.getModel());
                    this.mSrcVarList.setSelectedIndices(nArray);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
            if (!(string.contains("&") || string.contains("(+)") || string.contains("(*)"))) {
                try {
                    exception = iSpssVariable.clone();
                    if (this.mHashMap.get(string + "(*)") != null) {
                        iSpssVariable.setName(this.mHashMap.get(string + "(*)") + "->" + string + "(*)");
                    } else if (iSpssVariable.getType() > 0 && !string.contains("<")) {
                        iSpssVariable.setName(string + "<(*)");
                    } else {
                        iSpssVariable.setName(iSpssVariable.getName() + "(*)");
                    }
                    if (this.mHashMap.get(exception.getName() + "(+)") != null) {
                        exception.setName(this.mHashMap.get(exception.getName() + "(+)") + "->" + exception.getName() + "(+)");
                    } else if (exception.getType() > 0 && !exception.getName().contains("<")) {
                        exception.setName(string.substring(0, exception.getName().length()) + "<(+)");
                    } else {
                        exception.setName(iSpssVariable.getName().substring(0, exception.getName().length()) + "(+)");
                    }
                    this.mSrcVarList.getModel().addElement((ISpssVariable)exception);
                    nArray2 = this.mSrcVarList.getSelectedIndices();
                    nArray = new int[nArray2.length + 1];
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                    nArray[nArray2.length] = this.indexOfVariableExist(this.mSrcVarList, exception.getName());
                    this.mSrcVarList.setModel(this.mSrcVarList.getModel());
                    this.mSrcVarList.setSelectedIndices(nArray);
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
            }
            if (string.contains("(*)")) {
                if (this.mHashMap.get(string) != null) {
                    iSpssVariable.setName(this.mHashMap.get(string) + "->" + string);
                } else {
                    iSpssVariable.setName(string);
                }
                exception = this.mSrcVarList.getSelectedIndices();
                this.mSrcVarList.setModel(this.mSrcVarList.getModel());
                this.mSrcVarList.setSelectedIndices((int[])exception);
            }
            if (!iSpssVariable.getName().contains("(+)")) continue;
            if (this.mHashMap.get(iSpssVariable.getName()) != null) {
                iSpssVariable.setName(this.mHashMap.get(string) + "->" + string);
            } else {
                iSpssVariable.setName(string);
            }
            exception = this.mSrcVarList.getSelectedIndices();
            this.mSrcVarList.setModel(this.mSrcVarList.getModel());
            this.mSrcVarList.setSelectedIndices((int[])exception);
        }
        for (ISpssVariable iSpssVariable : iSpssVariableArray = this.mTargetVarList.getSelectedValues()) {
            if (!iSpssVariable.getName().contains("->")) continue;
            try {
                stringArray = iSpssVariable.getName().split("->");
                iSpssVariable.setName(stringArray[1]);
                this.getDialogDataModel().putString(stringArray[1], stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray = this.mTargetVarList.getSelectedIndices();
        this.mTargetVarList.setModel(this.mTargetVarList.getModel());
        this.mTargetVarList.setSelectedIndices(nArray);
    }

    private void fillSourceAndTargetList() {
        this.populateSourceList();
        this.mSrcVarList.getModel().sort();
        if (AddCasesGating.sLOCALLY_UNIQUE_DATASETID_KEY != null) {
            this.populateSourceList(AddCasesGating.sLOCALLY_UNIQUE_DATASETID_KEY);
        } else {
            ErrorDispatcher errorDispatcher = ErrorDispatcher.getErrorDispatcher();
            errorDispatcher.setInterceptErrors(true);
            Vector<Object> vector = new Vector();
            short s = 0;
            if (AddCasesGating.sVARBLOCKS_FROM_ENCRYPTEDFILE != null) {
                vector = AddCasesGating.sVARBLOCKS_FROM_ENCRYPTEDFILE;
            } else {
                s = SysFileProxy.getSysFileProxy().getSysFileVarInfo(AddCasesGating.sFILE_NAME_KEY, vector, AddCasesGating.sMANGLED_PASSWORD);
            }
            if (s != 0) {
                Vector vector2 = errorDispatcher.getInterceptedErrors();
                for (ErrorEventMsg errorEventMsg : vector2) {
                    SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), errorEventMsg.getErrorString() + "\n\n" + errorEventMsg.getInternalMsg(), VersionInfo.getAppVersionString());
                }
                vector2.clear();
            } else {
                for (VariableBlock variableBlock : vector) {
                    Object object;
                    SpssVariable spssVariable = new SpssVariable();
                    spssVariable.setName(variableBlock.getVarName());
                    spssVariable.setType((short)variableBlock.getDiType());
                    spssVariable.setLabel(variableBlock.getVarLabel());
                    this.mNewList.add((ISpssVariable)spssVariable);
                    int n = this.indexInSrcList((ISpssVariable)spssVariable);
                    if (n == -1) {
                        ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement((ISpssVariable)spssVariable, -1);
                        object = spssVariable.getName() + spssVariable.getId().toString();
                        this.mHashMap.put((String)object, false);
                        continue;
                    }
                    object = this.mSrcVarList.getModel().removeElementAt(n);
                    ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement((ISpssVariable)object, 0);
                }
            }
        }
        this.mSrcVarList.getModel().sort();
    }

    private int indexInSrcList(ISpssVariable iSpssVariable) {
        int n = -1;
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable2 = this.mSrcVarList.getModel().getElementAt(i);
            if (!iSpssVariable2.getName().equalsIgnoreCase(iSpssVariable.getName()) || iSpssVariable2.getType() != iSpssVariable.getType()) continue;
            n = i;
            break;
        }
        return n;
    }

    private void populateSourceList() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            if (locallyUniqueId == null || locallyUniqueId.isNull()) {
                return;
            }
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc != null) {
                int n = iSpssDataSrc.columnCount();
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable, locallyUniqueId.asInt());
                    this.mActiveList.add(iSpssVariable);
                    String string = iSpssVariable.getName() + iSpssVariable.getId().toString();
                    this.mHashMap.put(string, false);
                    this.mActiveVarsMap.put(string, false);
                }
            }
        }
    }

    private void populateSourceList(LocallyUniqueId locallyUniqueId) {
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                this.mNewList.add(iSpssVariable);
                int n2 = this.indexInSrcList(iSpssVariable);
                if (n2 == -1) {
                    ((MergeFilesListModel)this.mSrcVarList.getModel()).addElement(iSpssVariable, -1);
                    object = iSpssVariable.getName() + iSpssVariable.getId().toString();
                    this.mHashMap.put((String)object, false);
                    continue;
                }
                object = this.mSrcVarList.getModel().removeElementAt(n2);
                ((MergeFilesListModel)this.mTargetVarList.getModel()).addElement((ISpssVariable)object, 0);
            }
        }
    }

    private JPanel setupSourceListPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ADD_CASES_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getComponentGroupGap();
        n = 10;
        Insets insets = new Insets(n2, n2 * 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mRenameButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTargetListPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mArrowButton, gridBagConstraints, 0, 0, 1, 1, 10, null);
        DialogUtil.addUsingGBL(jPanel2, this.mPairButton, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getArrowButtonInsets());
        Insets insets = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, 10, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ADD_CASES_TARGET_LIST_LABEL");
        jLabel.setLabelFor(this.mTargetVarList);
        int n2 = 23;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, null);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(n - 5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 4, n2, null);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndicateCheck, gridBagConstraints, 1, 5, 1, 1, n2, insets);
        insets.left = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mIndicateSourceText), gridBagConstraints, 1, 6, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_ADD_CASES_SOURCE_ACTIVE_DATASET_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_ADD_CASES_SOURCE_FILE_DATASET_LABEL") + this.mDataSource);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    class FindOpenId {
        private int mSeed = 0;

        FindOpenId(int n) {
            this.mSeed = n;
        }

        public String getNextOpenVarId() {
            String string = "d" + this.mSeed++ + " ";
            while (this.listHasVarName(AddCasesDlg.this.mNewList, string)) {
                string = "d" + this.mSeed++ + " ";
            }
            return string;
        }

        private boolean listHasVarName(ArrayList<ISpssVariable> arrayList, String string) {
            string = string.trim();
            for (ISpssVariable iSpssVariable : arrayList) {
                if (!iSpssVariable.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }
}

