/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.identify_dup_cases;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;

public class IdentifyDupSpssFormatter
implements ISpssVarFormatter {
    private TargetVariableList mVarList;
    private HashMap<Integer, Object> mVarMap = new HashMap();
    private BaseDialog mDialog;
    private HashMap<Integer, Object> mId2NameMap = new HashMap();
    private static final String LOOKUP_SUFFIX = "_name_lookup";

    public IdentifyDupSpssFormatter(BaseDialog baseDialog, TargetVariableList targetVariableList) {
        this.mDialog = baseDialog;
        this.mVarList = targetVariableList;
    }

    @Override
    public String getDisplayText(ISpssVariable iSpssVariable) {
        if (!this.mVarMap.containsKey(iSpssVariable.getId().asInt())) {
            this.mVarMap.put(iSpssVariable.getId().asInt(), " -- " + this.mDialog.getResString("IDS_IDUPC_ASC_SUFFIX_LABEL_ON_TEXT"));
        }
        TargetVariableList targetVariableList = this.getVarList();
        boolean bl = targetVariableList.getModel().getShowVarLabels();
        String string = iSpssVariable.getName();
        String string2 = iSpssVariable.getLabel();
        if (bl && string2.length() > 0) {
            return string2 + " [" + string + "]" + this.mVarMap.get(iSpssVariable.getId().asInt());
        }
        String string3 = (String)this.mVarMap.get(iSpssVariable.getId().asInt());
        String string4 = string3.substring(string3.lastIndexOf(" ") + 1);
        string3 = string4.equalsIgnoreCase(this.mDialog.getResString("IDS_IDUPC_ASC_SUFFIX_LABEL_ON_TEXT")) ? this.mDialog.getResString("IDS_IDUPC_ASC_SUFFIX_CHAR") : this.mDialog.getResString("IDS_IDUPC_DESC_SUFFIX_CHAR");
        return string + string3;
    }

    @Override
    public boolean getShowIcons() {
        return true;
    }

    @Override
    public TargetVariableList getVarList() {
        return this.mVarList;
    }

    public HashMap<Integer, Object> getVarMap() {
        return this.mVarMap;
    }

    public void setVarMap(HashMap<Integer, Object> hashMap) {
        if (hashMap != null) {
            hashMap = this.reconcileVarMap(hashMap);
            this.mVarMap.clear();
            this.mVarMap = hashMap;
            this.updateModel();
        }
    }

    public void updateVarMap() {
        DialogDataModel dialogDataModel = this.getDDM();
        if (dialogDataModel != null) {
            this.mId2NameMap.clear();
            for (Map.Entry<Integer, Object> entry : this.mVarMap.entrySet()) {
                String string = IdentifyDupSpssFormatter.lookupVarName(entry.getKey());
                if (string == null) continue;
                this.mId2NameMap.put(entry.getKey(), string);
            }
            dialogDataModel.putMap(this.mVarList.getIdentifier() + LOOKUP_SUFFIX, this.mId2NameMap);
        } else assert (false);
    }

    public void updateModel() {
    }

    private static String lookupVarName(Object object) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null || !(object instanceof Integer)) {
            return null;
        }
        String string = null;
        int n = iSpssDataSrc.findVarIndex(new LocallyUniqueId(((Integer)object).intValue()));
        if (n > -1) {
            string = iSpssDataSrc.getVariable(n).getName();
        } else assert (false);
        return string;
    }

    private DialogDataModel getDDM() {
        DialogDataModel dialogDataModel = null;
        BaseProcedureDialog baseProcedureDialog = this.findParentDialog(this.mVarList);
        if (baseProcedureDialog != null) {
            dialogDataModel = baseProcedureDialog.getDialogDataModel();
        }
        return dialogDataModel;
    }

    private BaseProcedureDialog findParentDialog(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof BaseProcedureDialog); container = container.getParent()) {
        }
        return container != null ? (BaseProcedureDialog)((Object)container) : null;
    }

    private HashMap<Integer, Object> reconcileVarMap(HashMap<Integer, Object> hashMap) {
        if (!CommandLine.isClementineCaller()) {
            return hashMap;
        }
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return hashMap;
        }
        DialogDataModel dialogDataModel = this.getDDM();
        if (dialogDataModel == null) {
            return hashMap;
        }
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap(this.mVarList.getIdentifier() + LOOKUP_SUFFIX);
        if (hashMap2 == null || hashMap2.isEmpty()) {
            return hashMap;
        }
        HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
        for (Map.Entry<Integer, Object> entry : hashMap.entrySet()) {
            int n;
            if (!hashMap2.containsKey(entry.getKey()) || (n = iSpssDataSrc.findVarIndex(hashMap2.get(entry.getKey()).toString())) <= -1) continue;
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            hashMap3.put(iSpssVariable.getId().asInt(), entry.getValue());
        }
        return hashMap3;
    }
}

