/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.identify_dup_cases;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.GlobalParameterErrorChecking;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.identify_dup_cases.IdentifyDupCasesListModel;
import com.spss.java_client.ui.dialogs.base.data.identify_dup_cases.IdentifyDupSpssFormatter;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdentifyDupCasesDlg
extends BaseProcedureDialog
implements FocusListener,
ItemListener,
ListDataListener,
ListSelectionListener,
KeyListener,
IVarMoveHandler {
    private static final String ALERT_PRI_CASE_REPLACE_MSG = "ERR_IDUPC_ALERT_PRI_CASE_REPLACE_MSG";
    private static final String PRIMARY_LAST = "IDS_IDUPC_PRIMARY_LAST_DEFAULT_TEXT";
    private static final String PRIMARY_FIRST = "IDS_IDUPC_PRIMARY_FIRST_DEFAULT_TEXT";
    private static final String MATCH_SEQUENCE = "IDS_IDUPC_MATCH_SEQUENCE_DEFAULT_TEXT";
    private static final String TRIMMED_ASC_SUFFIX = "IDS_IDUPC_ASC_SUFFIX_LABEL_ON_TEXT";
    private static final String TRIMMED_DESC_SUFFIX = "IDS_IDUPC_DESC_SUFFIX_LABEL_ON_TEXT";
    private static final String EMPTY_STR = "";
    private static final Integer ZERO = 0;
    private static final int TARGET_LIST_MAX_LIMIT = 64;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetDefineCasesByVarList;
    private TargetVariableList mTargetSortGroupsByVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetDefineCasesByScrollPane;
    private JScrollPane mTargetSortGroupsByScrollPane;
    private ArrowButton mArrowDefineCasesByButton;
    private ArrowButton mArrowSortGroupsByButton;
    private JLabel mVarDefineCasesByLabel;
    private JLabel mVarSortGroupsByLabel;
    private JRadioButton mAscendingRadio;
    private JRadioButton mDescendingRadio;
    private JLabel mMatchSortVarsNumberLabel;
    private JCheckBox mPriCaseIndicatorCheck;
    private JCheckBox mFilterByIndicatorValCheck;
    private JCheckBox mMoveMatchCaseTopCheck;
    private JCheckBox mDispFreqForVarsCheck;
    private SpssButtonGroup mPrimaryCaseButtonGroup;
    private SpssButtonGroup mSortCaseButtonGroup;
    private JRadioButton mLastCaseRadio;
    private JRadioButton mFirstCaseRadio;
    private JCheckBox mSeqCountMatchCasesCheck;
    private JLabel mNameColonPriCasesLabel;
    private JLabel mNameColonSeqCountLabel;
    private StringTextField mNamePriCaseTextField;
    private StringTextField mNameSeqCountTextField;
    private JLabel mNoMatchSortVarsLabel;
    private IdentifyDupSpssFormatter mFormatter;
    private int mTargetListIndex;
    private String mPriLastVarName;
    private String mPriFirstVarName;
    private String mSeqCountVarName;
    private String mUserEnteredPriLastText = "";
    private String mUserEnteredSeqCntText = "";
    private String mDropStringForSyntax = "";
    private ListTravArrowButtonFactory mSortGroupsByButton;

    public IdentifyDupCasesDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_IDUPC_IDENTIFY_DUPLICATE_CASES"));
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetDefineCasesByVarList.removeAll();
        this.mTargetSortGroupsByVarList.removeAll();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "data_identify_dup_cases";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_duplicatecases";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.getResString("IDS_IDUPC_IDENTIFY_DUPLICATE_CASES_SYNTAX_TITLE")).append(".");
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY"));
        stringBuffer.append(this.getTargetDefineStrNames(true));
        stringBuffer.append(this.getTargetSortStrNames());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("MATCH FILES"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FILE=*"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/BY"));
        stringBuffer.append(this.getTargetDefineStrNames(false));
        stringBuffer.append("\n");
        if (!this.mDropStringForSyntax.equalsIgnoreCase(EMPTY_STR)) {
            stringBuffer.append(this.mDropStringForSyntax);
        }
        if (this.mMoveMatchCaseTopCheck.isSelected() || this.mSeqCountMatchCasesCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/FIRST="));
            if (this.mFirstCaseRadio.isEnabled() && this.mFirstCaseRadio.isSelected()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriFirstVarName);
            }
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/LAST="));
            if (this.mLastCaseRadio.isEnabled() && this.mLastCaseRadio.isSelected()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriLastVarName);
            }
            stringBuffer.append(".");
        } else if (this.mLastCaseRadio.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/LAST="));
            if (this.mLastCaseRadio.isEnabled()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriLastVarName);
            }
            stringBuffer.append(".");
        } else if (this.mFirstCaseRadio.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/FIRST="));
            if (this.mFirstCaseRadio.isEnabled()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriFirstVarName);
            }
            stringBuffer.append(".");
        }
        stringBuffer.append("\n");
        if (this.mMoveMatchCaseTopCheck.isSelected() || this.mSeqCountMatchCasesCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DO IF"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("("));
            if (this.mFirstCaseRadio.isEnabled() && this.mFirstCaseRadio.isSelected()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriFirstVarName);
            }
            stringBuffer.append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mSeqCountVarName));
            }
            stringBuffer.append("=1-");
            if (this.mLastCaseRadio.isEnabled() && this.mLastCaseRadio.isSelected()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            } else {
                stringBuffer.append(this.mPriLastVarName);
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("ELSE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mSeqCountVarName));
            }
            stringBuffer.append("=");
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                stringBuffer.append(this.mNameSeqCountTextField.getText());
            } else {
                stringBuffer.append(this.mSeqCountVarName);
            }
            stringBuffer.append("+1");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("END IF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("LEAVE "));
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mSeqCountVarName));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("FORMATS "));
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mSeqCountVarName));
            }
            stringBuffer.append(" (f7)");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            if (this.mMoveMatchCaseTopCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("InDupGrp="));
                if (this.mSeqCountMatchCasesCheck.isSelected()) {
                    stringBuffer.append(this.mNameSeqCountTextField.getText());
                } else {
                    stringBuffer.append(this.mSeqCountVarName);
                }
                stringBuffer.append(">0");
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("InDupGrp(D)"));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            stringBuffer.append(SyntaxUtil.getMainCommand("MATCH FILES"));
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FILE=*"));
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DROP="));
            if (!this.mPriCaseIndicatorCheck.isSelected()) {
                stringBuffer.append(this.mPriFirstVarName);
                stringBuffer.append(" ");
                stringBuffer.append(this.mPriLastVarName);
            } else if (this.mLastCaseRadio.isSelected()) {
                stringBuffer.append(this.mPriFirstVarName);
            } else {
                stringBuffer.append(this.mPriLastVarName);
            }
            if (this.mMoveMatchCaseTopCheck.isSelected()) {
                stringBuffer.append(" InDupGrp");
                if (!this.mSeqCountMatchCasesCheck.isSelected()) {
                    stringBuffer.append(" ").append(this.mSeqCountVarName);
                }
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mPriCaseIndicatorCheck.isSelected() || this.mSeqCountMatchCasesCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
            if (this.mPriCaseIndicatorCheck.isSelected()) {
                if (this.mLastCaseRadio.isEnabled() && this.mLastCaseRadio.isSelected()) {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNamePriCaseTextField.getText()));
                    stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)this.getResString("IDS_IDUPC_LAST_MATCH_CASE")));
                } else if (this.mFirstCaseRadio.isEnabled() && this.mFirstCaseRadio.isSelected()) {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNamePriCaseTextField.getText()));
                    stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)this.getResString("IDS_IDUPC_FIRST_MATCH_CASE")));
                }
            }
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                if (this.mPriCaseIndicatorCheck.isSelected()) {
                    stringBuffer.append(" ").append(this.mNameSeqCountTextField.getText());
                } else {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
                }
                stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)this.getResString("IDS_IDUPC_SEQ_COUNT")));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mPriCaseIndicatorCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("VALUE LABELS "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNamePriCaseTextField.getText()));
            stringBuffer.append(" 0 ").append(CharacterUtil.smartQuote((String)this.getResString("IDS_IDUPC_DUPLICATE_CASE"))).append(" 1 ").append(CharacterUtil.smartQuote((String)this.getResString("IDS_IDUPC_PRIMARY_CASE"))).append(SyntaxUtil.terminateSyntax());
        }
        if (this.mPriCaseIndicatorCheck.isSelected() || this.mSeqCountMatchCasesCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL "));
            if (this.mPriCaseIndicatorCheck.isSelected()) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNamePriCaseTextField.getText()));
                stringBuffer.append(" (ORDINAL)");
                if (this.mSeqCountMatchCasesCheck.isSelected()) {
                    stringBuffer.append(" /");
                }
            }
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                if (this.mPriCaseIndicatorCheck.isSelected()) {
                    stringBuffer.append(this.mNameSeqCountTextField.getText());
                } else {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNameSeqCountTextField.getText()));
                }
                stringBuffer.append(" (SCALE)");
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mDispFreqForVarsCheck.isEnabled() && this.mDispFreqForVarsCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("FREQUENCIES"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
            if (this.mPriCaseIndicatorCheck.isSelected()) {
                stringBuffer.append(this.mNamePriCaseTextField.getText());
            }
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                if (this.mPriCaseIndicatorCheck.isSelected()) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.mNameSeqCountTextField.getText());
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mFilterByIndicatorValCheck.isEnabled() && this.mFilterByIndicatorValCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("FILTER "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY "));
            stringBuffer.append(this.mNamePriCaseTextField.getText());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Integer n;
        if (focusEvent.getSource().equals(this.mTargetSortGroupsByVarList)) {
            int[] nArray;
            this.mArrowDefineCasesByButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mArrowDefineCasesByButton.setEnabled(false);
            n = this.mTargetSortGroupsByVarList.getModel().getSize() + this.mTargetDefineCasesByVarList.getModel().getSize();
            this.mNoMatchSortVarsLabel.setText(n.toString());
            if (this.mTargetSortGroupsByVarList.getModel().getSize() > 0) {
                this.mAscendingRadio.setEnabled(true);
                this.mDescendingRadio.setEnabled(true);
            }
            if ((nArray = this.mTargetSortGroupsByVarList.getSelectedIndices()).length == 1) {
                SpssVariable spssVariable = (SpssVariable)this.mTargetSortGroupsByVarList.getModel().getElementAt(this.mTargetListIndex);
                String string = (String)this.mFormatter.getVarMap().get(spssVariable.getId().asInt());
                if (string != null) {
                    String string2 = string.substring(string.lastIndexOf(" ") + 1);
                    if (string2.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                        this.mDescendingRadio.setSelected(false);
                        this.mAscendingRadio.setSelected(true);
                    } else {
                        this.mAscendingRadio.setSelected(false);
                        this.mDescendingRadio.setSelected(true);
                    }
                }
            } else if (nArray.length > 1) {
                this.mAscendingRadio.setSelected(false);
                this.mDescendingRadio.setSelected(false);
                ISpssVariable[] iSpssVariableArray = this.mTargetSortGroupsByVarList.getSelectedValues();
                boolean bl = false;
                String string = null;
                for (int i = 0; i < nArray.length; ++i) {
                    String string3 = (String)this.mFormatter.getVarMap().get(iSpssVariableArray[i].getId().asInt());
                    if (string3 == null) continue;
                    String string4 = string3.substring(string3.lastIndexOf(" ") + 1);
                    if (string4.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                        if (string != null && !string.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                            bl = true;
                        }
                        string = this.getResString(TRIMMED_ASC_SUFFIX);
                        continue;
                    }
                    if (string != null && !string.equalsIgnoreCase(this.getResString(TRIMMED_DESC_SUFFIX))) {
                        bl = true;
                    }
                    string = this.getResString(TRIMMED_DESC_SUFFIX);
                }
                if (!bl) {
                    if (string != null && string.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                        this.mAscendingRadio.setSelected(true);
                        this.mDescendingRadio.setSelected(false);
                    } else {
                        this.mAscendingRadio.setSelected(false);
                        this.mDescendingRadio.setSelected(true);
                    }
                } else {
                    this.mSortCaseButtonGroup.remove(this.mAscendingRadio);
                    this.mSortCaseButtonGroup.remove(this.mDescendingRadio);
                    this.mAscendingRadio.setSelected(false);
                    this.mDescendingRadio.setSelected(false);
                    this.mSortCaseButtonGroup.add(this.mAscendingRadio);
                    this.mSortCaseButtonGroup.add(this.mDescendingRadio);
                }
            }
            if (nArray.length > 0) {
                this.mArrowSortGroupsByButton.setEnabled(true);
            } else {
                this.mArrowSortGroupsByButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                this.mArrowSortGroupsByButton.setEnabled(false);
            }
        }
        if (focusEvent.getSource().equals(this.mTargetDefineCasesByVarList)) {
            n = this.mTargetSortGroupsByVarList.getModel().getSize() + this.mTargetDefineCasesByVarList.getModel().getSize();
            this.mNoMatchSortVarsLabel.setText(n.toString());
            this.mAscendingRadio.setEnabled(false);
            this.mDescendingRadio.setEnabled(false);
            this.mArrowSortGroupsByButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mArrowSortGroupsByButton.setEnabled(false);
            this.mArrowDefineCasesByButton.setEnabled(true);
        }
        if (focusEvent.getSource().equals(this.mSrcVarList)) {
            this.mAscendingRadio.setEnabled(false);
            this.mDescendingRadio.setEnabled(false);
        }
        if (focusEvent.getSource().equals(this.mNamePriCaseTextField)) {
            this.mNamePriCaseTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mNameSeqCountTextField)) {
            this.mNameSeqCountTextField.selectAll();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.mNamePriCaseTextField)) {
            this.updateOkPaste();
        } else if (keyEvent.getSource().equals(this.mNameSeqCountTextField)) {
            this.updateOkPaste();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNamePriCaseTextField) || focusEvent.getSource().equals(this.mNameSeqCountTextField)) {
            // empty if block
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mTargetSortGroupsByVarList)) {
            this.mTargetListIndex = this.mTargetSortGroupsByVarList.getSelectedIndex();
            Integer n = this.mTargetSortGroupsByVarList.getModel().getSize() + this.mTargetDefineCasesByVarList.getModel().getSize();
            this.mNoMatchSortVarsLabel.setText(n.toString());
            if (this.mTargetListIndex > -1) {
                int[] nArray = this.mTargetSortGroupsByVarList.getSelectedIndices();
                if (nArray.length == 1) {
                    SpssVariable spssVariable = (SpssVariable)this.mTargetSortGroupsByVarList.getModel().getElementAt(this.mTargetListIndex);
                    String string = (String)this.mFormatter.getVarMap().get(spssVariable.getId().asInt());
                    if (string != null) {
                        this.mAscendingRadio.setEnabled(true);
                        this.mDescendingRadio.setEnabled(true);
                        String string2 = string.substring(string.lastIndexOf(" ") + 1);
                        if (string2.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                            this.mAscendingRadio.setSelected(true);
                            this.mDescendingRadio.setSelected(false);
                        } else {
                            this.mAscendingRadio.setSelected(false);
                            this.mDescendingRadio.setSelected(true);
                        }
                    }
                } else if (nArray.length > 1) {
                    this.mAscendingRadio.setSelected(false);
                    this.mDescendingRadio.setSelected(false);
                    ISpssVariable[] iSpssVariableArray = this.mTargetSortGroupsByVarList.getSelectedValues();
                    boolean bl = false;
                    String string = null;
                    String string3 = null;
                    for (int i = 0; i < nArray.length; ++i) {
                        string3 = (String)this.mFormatter.getVarMap().get(iSpssVariableArray[i].getId().asInt());
                        if (string3 == null) continue;
                        String string4 = string3.substring(string3.lastIndexOf(" ") + 1);
                        if (string4.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                            if (string != null && !string.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                                bl = true;
                            }
                            string = this.getResString(TRIMMED_ASC_SUFFIX);
                            continue;
                        }
                        if (string != null && !string.equalsIgnoreCase(this.getResString(TRIMMED_DESC_SUFFIX))) {
                            bl = true;
                        }
                        string = this.getResString(TRIMMED_DESC_SUFFIX);
                    }
                    if (string3 != null) {
                        if (!bl) {
                            if (string.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX))) {
                                this.mAscendingRadio.setSelected(true);
                                this.mDescendingRadio.setSelected(false);
                            } else {
                                this.mAscendingRadio.setSelected(false);
                                this.mDescendingRadio.setSelected(true);
                            }
                        } else {
                            this.mSortCaseButtonGroup.remove(this.mAscendingRadio);
                            this.mSortCaseButtonGroup.remove(this.mDescendingRadio);
                            this.mAscendingRadio.setSelected(false);
                            this.mDescendingRadio.setSelected(false);
                            this.mSortCaseButtonGroup.add(this.mAscendingRadio);
                            this.mSortCaseButtonGroup.add(this.mDescendingRadio);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
        if (listDataEvent.getSource() == this.mTargetSortGroupsByVarList.getModel()) {
            Integer n = this.mTargetSortGroupsByVarList.getModel().getSize() + this.mTargetDefineCasesByVarList.getModel().getSize();
            this.mNoMatchSortVarsLabel.setText(n.toString());
            this.mTargetListIndex = this.mTargetSortGroupsByVarList.getSelectedIndex();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
        if (listDataEvent.getSource() == this.mTargetSortGroupsByVarList.getModel()) {
            Integer n = this.mTargetSortGroupsByVarList.getModel().getSize() + this.mTargetDefineCasesByVarList.getModel().getSize();
            this.mNoMatchSortVarsLabel.setText(n.toString());
            if (Integer.parseInt(this.mNoMatchSortVarsLabel.getText()) < 1) {
                this.mAscendingRadio.setEnabled(false);
                this.mDescendingRadio.setEnabled(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mPriCaseIndicatorCheck) {
            this.mLastCaseRadio.setEnabled(bl);
            this.mFirstCaseRadio.setEnabled(bl);
            this.mFilterByIndicatorValCheck.setEnabled(bl);
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                if (CommandLine.isClementineCaller()) {
                    this.mDispFreqForVarsCheck.setEnabled(false);
                } else {
                    this.mDispFreqForVarsCheck.setEnabled(true);
                }
            } else if (CommandLine.isClementineCaller()) {
                this.mDispFreqForVarsCheck.setEnabled(false);
            } else {
                this.mDispFreqForVarsCheck.setEnabled(bl);
            }
            this.mNameColonPriCasesLabel.setEnabled(bl);
            this.mNamePriCaseTextField.setEnabled(bl);
            this.mNamePriCaseTextField.setOpaque(bl);
            this.updateOkPaste();
        } else if (object == this.mSeqCountMatchCasesCheck) {
            if (this.mPriCaseIndicatorCheck.isSelected()) {
                if (CommandLine.isClementineCaller()) {
                    this.mDispFreqForVarsCheck.setEnabled(false);
                } else {
                    this.mDispFreqForVarsCheck.setEnabled(true);
                }
            } else if (CommandLine.isClementineCaller()) {
                this.mDispFreqForVarsCheck.setEnabled(false);
            } else {
                this.mDispFreqForVarsCheck.setEnabled(bl);
            }
            this.mNameColonSeqCountLabel.setEnabled(bl);
            this.mNameSeqCountTextField.setEnabled(bl);
            this.mNameSeqCountTextField.setOpaque(bl);
            if (bl && this.mNameSeqCountTextField.getText() == null) {
                this.getVarNameForSeqCount();
                if (this.mUserEnteredSeqCntText != null) {
                    if (this.mUserEnteredSeqCntText.equalsIgnoreCase(EMPTY_STR)) {
                        this.mNameSeqCountTextField.setText(this.mSeqCountVarName);
                    } else {
                        this.mNameSeqCountTextField.setText(this.mUserEnteredSeqCntText);
                    }
                }
                this.mNameSeqCountTextField.setText(this.mSeqCountVarName);
            }
            this.updateOkPaste();
        } else if (object == this.mMoveMatchCaseTopCheck) {
            this.updateOkPaste();
        } else if (object == this.mAscendingRadio) {
            int[] nArray = this.mTargetSortGroupsByVarList.getSelectedIndices();
            ISpssVariable[] iSpssVariableArray = this.mTargetSortGroupsByVarList.getSelectedValues();
            if (bl && nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.mDescendingRadio.setSelected(false);
                    this.mAscendingRadio.setSelected(true);
                    this.mFormatter.getVarMap().put(iSpssVariableArray[i].getId().asInt(), " -- " + this.getResString(TRIMMED_ASC_SUFFIX));
                    ((IdentifyDupCasesListModel)this.mTargetSortGroupsByVarList.getModel()).fireContentsChanged(iSpssVariableArray[i], nArray[i], nArray[i]);
                }
            }
        } else if (object == this.mDescendingRadio) {
            int[] nArray = this.mTargetSortGroupsByVarList.getSelectedIndices();
            ISpssVariable[] iSpssVariableArray = this.mTargetSortGroupsByVarList.getSelectedValues();
            if (bl && nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.mAscendingRadio.setSelected(false);
                    this.mDescendingRadio.setSelected(true);
                    this.mFormatter.getVarMap().put(iSpssVariableArray[i].getId().asInt(), " -- " + this.getResString(TRIMMED_DESC_SUFFIX));
                    ((IdentifyDupCasesListModel)this.mTargetSortGroupsByVarList.getModel()).fireContentsChanged(iSpssVariableArray[i], nArray[i], nArray[i]);
                }
            }
        } else if (object == this.mLastCaseRadio) {
            if (bl) {
                this.getVarNameForPriCase(true);
                if (this.mUserEnteredPriLastText != null) {
                    if (this.mUserEnteredPriLastText.equalsIgnoreCase(EMPTY_STR)) {
                        this.mNamePriCaseTextField.setText(this.mPriLastVarName);
                    } else {
                        this.mNamePriCaseTextField.setText(this.mUserEnteredPriLastText);
                    }
                }
            }
        } else if (object == this.mFirstCaseRadio && bl) {
            this.getVarNameForPriCase(false);
            if (this.mUserEnteredPriLastText != null) {
                if (this.mUserEnteredPriLastText.equalsIgnoreCase(EMPTY_STR)) {
                    this.mNamePriCaseTextField.setText(this.mPriFirstVarName);
                } else {
                    this.mNamePriCaseTextField.setText(this.mUserEnteredPriLastText);
                }
            }
        }
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        if (GlobalParameterErrorChecking.hasTemporaryTrans((LocallyUniqueId)locallyUniqueId) || GlobalParameterErrorChecking.hasPendingTransformation((LocallyUniqueId)locallyUniqueId)) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_TEMP_XFORMS_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        } else {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (GlobalParameterErrorChecking.isSplitFileON((LocallyUniqueId)locallyUniqueId) && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_IDUPC_ALERT_SPLIT_FILE_RESET_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                bl = false;
            }
            if (GlobalParameterErrorChecking.isFilterON((LocallyUniqueId)locallyUniqueId) && this.mFilterByIndicatorValCheck.isSelected()) {
                if (0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_IDUPC_ALERT_FILTER_RESET_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    bl = false;
                }
            } else if (GlobalParameterErrorChecking.isUSEUsed((LocallyUniqueId)locallyUniqueId) && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_IDUPC_ALERT_USE_CASES_RESET_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                bl = false;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.mPriCaseIndicatorCheck.isSelected()) {
                this.checkTextValidation(this.mNamePriCaseTextField);
                if (this.mNamePriCaseTextField.getText().length() == 0) {
                    return false;
                }
            }
            if (this.mSeqCountMatchCasesCheck.isSelected()) {
                this.checkTextValidation(this.mNameSeqCountTextField);
                if (this.mNameSeqCountTextField.getText().length() == 0) {
                    return false;
                }
            }
            if (iSpssDataSrc.findVarIndex(this.mNamePriCaseTextField.getText()) != -1) {
                bl2 = true;
            }
            if (iSpssDataSrc.findVarIndex(this.mNameSeqCountTextField.getText()) != -1) {
                bl3 = true;
            }
            if (bl2 && bl3) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getResString(ALERT_PRI_CASE_REPLACE_MSG));
                stringBuffer.append("\n ");
                stringBuffer.append(this.mNamePriCaseTextField.getText());
                stringBuffer.append("\n ");
                stringBuffer.append(this.mNameSeqCountTextField.getText());
                if (0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), stringBuffer.toString(), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    bl = false;
                } else {
                    this.mDropStringForSyntax = " /DROP = " + this.mNamePriCaseTextField.getText() + " " + this.mNameSeqCountTextField.getText();
                }
            } else if (bl2) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getResString(ALERT_PRI_CASE_REPLACE_MSG));
                stringBuffer.append("\n ");
                stringBuffer.append(this.mNamePriCaseTextField.getText());
                if (0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), stringBuffer.toString(), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    bl = false;
                } else {
                    this.mDropStringForSyntax = " /DROP = " + this.mNamePriCaseTextField.getText();
                }
            } else if (bl3) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getResString(ALERT_PRI_CASE_REPLACE_MSG));
                stringBuffer.append("\n ");
                stringBuffer.append(this.mNameSeqCountTextField.getText());
                if (0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), stringBuffer.toString(), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    bl = false;
                } else {
                    this.mDropStringForSyntax = " /DROP = " + this.mNameSeqCountTextField.getText();
                }
            }
        }
        return bl && super.okPastePressed();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (variableList.equals(this.mTargetDefineCasesByVarList) || variableList.equals(this.mTargetSortGroupsByVarList)) {
            int n = iSpssVariableArray.length;
            String string = EMPTY_STR;
            if (variableList.equals(this.mTargetSortGroupsByVarList)) {
                if (this.mTargetDefineCasesByVarList.getModel().getSize() == 0) {
                    if ((n += this.mTargetSortGroupsByVarList.getModel().getSize()) > 64) {
                        string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), 64);
                    }
                } else {
                    int n2 = this.mTargetSortGroupsByVarList.getModel().getSize() + iSpssVariableArray.length + this.mTargetDefineCasesByVarList.getModel().getSize();
                    if (n2 > 64) {
                        string = this.getResString("ERR_IDUPC_ALERT_MAX_LIMIT");
                    }
                }
            } else if (variableList.equals(this.mTargetDefineCasesByVarList)) {
                if (this.mTargetSortGroupsByVarList.getModel().getSize() == 0) {
                    if ((n += this.mTargetDefineCasesByVarList.getModel().getSize()) > 64) {
                        string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), 64);
                    }
                } else {
                    int n3 = this.mTargetSortGroupsByVarList.getModel().getSize() + iSpssVariableArray.length + this.mTargetDefineCasesByVarList.getModel().getSize();
                    if (n3 > 64) {
                        string = this.getResString("ERR_IDUPC_ALERT_MAX_LIMIT");
                    }
                }
            }
            if (!string.equals(EMPTY_STR)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetSortGroupsByVarList.getIdentifier()));
        if (this.getDialogDataModel().getString("TOTAL_LABEL") != null) {
            this.mNoMatchSortVarsLabel.setText(this.getDialogDataModel().getString("TOTAL_LABEL"));
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.mFormatter.updateVarMap();
        this.getDialogDataModel().putMap(this.mTargetSortGroupsByVarList.getIdentifier(), this.mFormatter.getVarMap());
        this.getDialogDataModel().putString("TOTAL_LABEL", this.mNoMatchSortVarsLabel.getText());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        Vector<Object> vector = this.setTabTraversal();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
        this.pack();
    }

    private String getTargetDefineStrNames(boolean bl) {
        String string = EMPTY_STR;
        int n = this.mTargetDefineCasesByVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = this.mTargetDefineCasesByVarList.getModel().getElementAt(i).getName();
            string = bl ? string + " " + string2 + "(A)" : string + " " + string2;
        }
        return string;
    }

    private String getTargetSortStrNames() {
        String string = EMPTY_STR;
        int n = this.mTargetSortGroupsByVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = this.mTargetSortGroupsByVarList.getModel().getElementAt(i).getName();
            String string3 = EMPTY_STR;
            SpssVariable spssVariable = (SpssVariable)this.mTargetSortGroupsByVarList.getModel().getElementAt(i);
            String string4 = (String)this.mFormatter.getVarMap().get(spssVariable.getId().asInt());
            if (string4 != null) {
                String string5 = string4.substring(string4.lastIndexOf(" ") + 1);
                string3 = string5.equalsIgnoreCase(this.getResString(TRIMMED_ASC_SUFFIX)) ? "A" : "D";
            }
            string = string + " " + string2 + "(" + string3 + ")";
        }
        return string;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addFocusListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetDefineCasesByVarList = new TargetVariableList();
        this.mTargetDefineCasesByVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetDefineCasesByVarList.getModel().addListDataListener(this);
        this.mTargetDefineCasesByVarList.addFocusListener(this);
        this.mTargetDefineCasesByVarList.setIdentifier("DefineCases");
        this.mTargetDefineCasesByScrollPane = new JScrollPane(this.mTargetDefineCasesByVarList);
        this.mTargetDefineCasesByScrollPane.setPreferredSize(this.mTargetDefineCasesByVarList.getMinimumSize());
        this.mTargetSortGroupsByVarList = new TargetVariableList();
        this.mTargetSortGroupsByVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetSortGroupsByVarList.getModel().addListDataListener(this);
        this.mTargetSortGroupsByVarList.addListSelectionListener(this);
        this.mTargetSortGroupsByVarList.addFocusListener(this);
        this.mTargetSortGroupsByVarList.setIdentifier("SortIden");
        this.mFormatter = new IdentifyDupSpssFormatter(this, this.mTargetSortGroupsByVarList);
        this.mTargetSortGroupsByVarList.setModel(new IdentifyDupCasesListModel(this.mTargetSortGroupsByVarList));
        this.mTargetSortGroupsByVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mTargetSortGroupsByScrollPane = new JScrollPane(this.mTargetSortGroupsByVarList);
        this.mTargetSortGroupsByScrollPane.setPreferredSize(this.mTargetSortGroupsByVarList.getMinimumSize());
        this.mVarMoveHandler = this;
        this.mArrowDefineCasesByButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowDefineCasesByButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowDefineCasesByButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowDefineCasesByButton.registerVariableList(this.mTargetDefineCasesByVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowSortGroupsByButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowSortGroupsByButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowSortGroupsByButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowSortGroupsByButton.registerVariableList(this.mTargetSortGroupsByVarList, SpssArrowButton.ButtonOrientation.left);
        this.mVarDefineCasesByLabel = DialogUtil.createLabel(this, "IDS_IDUPC_DEFINE_MATCHING_CASES_BY_COLON");
        this.mVarDefineCasesByLabel.setLabelFor(this.mTargetDefineCasesByVarList);
        this.mVarSortGroupsByLabel = DialogUtil.createLabel(this, "IDS_IDUPC_SORT_WITHIN_MATCHING_GROUPS_BY_COLON");
        this.mVarSortGroupsByLabel.setLabelFor(this.mTargetSortGroupsByVarList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_ASCENDING_RADIO");
        this.mAscendingRadio = new JRadioButton(toggleButtonAction);
        this.mAscendingRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_DESCENDING_RADIO");
        this.mDescendingRadio = new JRadioButton(toggleButtonAction);
        this.mDescendingRadio.addItemListener(this);
        this.mMatchSortVarsNumberLabel = new JLabel(this.getResString("IDS_IDUPC_MATCH_SORT_VAR_NUMBER_COLON"));
        this.mNoMatchSortVarsLabel = new JLabel(ZERO.toString());
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_PRIMARY_CASES_INDICATOR_CHECK");
        this.mPriCaseIndicatorCheck = new JCheckBox(toggleButtonAction);
        this.mPriCaseIndicatorCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_LAST_CASE_IN_EACH_GROUP_IS_PRIMARY_RADIO");
        this.mLastCaseRadio = new JRadioButton(toggleButtonAction);
        this.mLastCaseRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_FIRST_CASE_IN_EACH_GROUP_IS_PRIMARY_RADIO");
        this.mFirstCaseRadio = new JRadioButton(toggleButtonAction);
        this.mFirstCaseRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_FILTER_BY_INDICATOR_VALUES");
        this.mFilterByIndicatorValCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_SEQUENTIAL_COUNT_OF_MATCHING_CASE");
        this.mSeqCountMatchCasesCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mSeqCountMatchCasesCheck.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPriCaseIndicatorCheck);
        spssButtonGroup.add(this.mSeqCountMatchCasesCheck);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_MOVE_MATCHING_CASES_TO_TOP");
        this.mMoveMatchCaseTopCheck = new JCheckBox(toggleButtonAction);
        this.mMoveMatchCaseTopCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IDUPC_DISPLAY_FREQUENCIES_FOR_CREATED_VARIABLES");
        this.mDispFreqForVarsCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mMoveMatchCaseTopCheck);
        spssButtonGroup2.add(this.mDispFreqForVarsCheck);
        this.mNamePriCaseTextField = new StringTextField();
        this.mNamePriCaseTextField.setColumns(12);
        this.mNamePriCaseTextField.setDocument(new FixedLengthDocument(64));
        this.mNamePriCaseTextField.setAction(new TextFieldAction(this, "PRI_CASES_TEXT"));
        this.mNamePriCaseTextField.addFocusListener(this);
        this.mNamePriCaseTextField.addKeyListener(this);
        this.mNameSeqCountTextField = new StringTextField();
        this.mNameSeqCountTextField.setColumns(12);
        this.mNameSeqCountTextField.setDocument(new FixedLengthDocument(64));
        this.mNameSeqCountTextField.setAction(new TextFieldAction(this, "SEQ_MATCHING_TEXT"));
        this.mNameSeqCountTextField.addFocusListener(this);
        this.mNameSeqCountTextField.addKeyListener(this);
        this.mNameColonPriCasesLabel = DialogUtil.createLabel(this, "IDS_IDUPC_PRI_NAME_COLON");
        this.mNameColonPriCasesLabel.setLabelFor((Component)((Object)this.mNamePriCaseTextField));
        this.mNameColonSeqCountLabel = DialogUtil.createLabel(this, "IDS_IDUPC_SEQ_NAME_COLON");
        this.mNameColonSeqCountLabel.setLabelFor((Component)((Object)this.mNameSeqCountTextField));
        this.mSortGroupsByButton = new ListTravArrowButtonFactory(this.mTargetSortGroupsByVarList, false);
    }

    private void checkTextValidation(StringTextField stringTextField) {
        String string = stringTextField.getText();
        int n = 0;
        if (string.trim().length() == 0) {
            if (string.length() > string.trim().length()) {
                n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            }
        } else {
            n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        }
        this.checkValidateCode(n, stringTextField);
    }

    private void checkValidateCode(int n, StringTextField stringTextField) {
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            if (stringTextField.equals(this.mNamePriCaseTextField)) {
                if (this.mLastCaseRadio.isSelected()) {
                    if (stringTextField.getText().equalsIgnoreCase(this.getResString(PRIMARY_LAST))) {
                        stringTextField.setText(EMPTY_STR);
                    } else {
                        stringTextField.setText(this.mUserEnteredPriLastText);
                    }
                } else if (this.mFirstCaseRadio.isSelected()) {
                    if (stringTextField.getText().equalsIgnoreCase(this.getResString(PRIMARY_LAST))) {
                        stringTextField.setText(EMPTY_STR);
                    } else {
                        stringTextField.setText(this.mUserEnteredPriLastText);
                    }
                }
            } else if (stringTextField.equals(this.mNameSeqCountTextField)) {
                if (stringTextField.getText().equalsIgnoreCase(this.getResString(MATCH_SEQUENCE))) {
                    stringTextField.setText(EMPTY_STR);
                } else {
                    stringTextField.setText(this.mUserEnteredSeqCntText);
                }
            }
            stringTextField.requestFocus();
            return;
        }
        if (!stringTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
            if (stringTextField.equals(this.mNamePriCaseTextField)) {
                this.mUserEnteredPriLastText = stringTextField.getText();
            } else if (stringTextField.equals(this.mNameSeqCountTextField)) {
                this.mUserEnteredSeqCntText = stringTextField.getText();
            }
        }
    }

    private void getVarNameForPriCase(boolean bl) {
        if (bl) {
            String string = this.getResString(PRIMARY_LAST);
            int n = -1;
            for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
                String string2 = this.mSrcVarList.getModel().getElementAt(i).getName();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.trim().substring(string.length());
                if (string3.length() > 0) {
                    try {
                        if (n >= Integer.parseInt(string3)) continue;
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n != -1) continue;
                        n = 0;
                    }
                    continue;
                }
                if (n != -1) continue;
                n = 0;
            }
            this.mPriLastVarName = n > -1 ? string + (n + 1) : string;
        } else {
            String string = this.getResString(PRIMARY_FIRST);
            int n = -1;
            for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
                String string4 = this.mSrcVarList.getModel().getElementAt(i).getName();
                if (!string4.startsWith(string)) continue;
                String string5 = string4.trim().substring(string.length());
                if (string5.length() > 0) {
                    try {
                        if (n >= Integer.parseInt(string5)) continue;
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n != -1) continue;
                        n = 0;
                    }
                    continue;
                }
                if (n != -1) continue;
                n = 0;
            }
            this.mPriFirstVarName = n > -1 ? string + (n + 1) : string;
        }
    }

    private void getVarNameForSeqCount() {
        String string;
        int n = 0;
        String string2 = string = this.getResString(MATCH_SEQUENCE);
        VarListModel varListModel = this.mSrcVarList.getModel();
        while (varListModel.findElementIndexesByName(string2).length > 0) {
            string2 = string + ++n;
        }
        this.mSeqCountVarName = string2;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mNoMatchSortVarsLabel.setText(ZERO.toString());
        this.mAscendingRadio.setSelected(true);
        this.mAscendingRadio.setEnabled(false);
        this.mDescendingRadio.setEnabled(false);
        this.mDescendingRadio.setSelected(false);
        this.mPriCaseIndicatorCheck.setSelected(true);
        this.mLastCaseRadio.setSelected(true);
        this.mNameColonPriCasesLabel.setEnabled(true);
        this.mUserEnteredPriLastText = EMPTY_STR;
        this.mPriLastVarName = this.getResString(PRIMARY_LAST);
        this.mPriFirstVarName = this.getResString(PRIMARY_FIRST);
        this.getVarNameForPriCase(true);
        this.getVarNameForPriCase(false);
        if (this.mLastCaseRadio.isSelected()) {
            this.mNamePriCaseTextField.setText(this.mPriLastVarName);
        } else if (this.mFirstCaseRadio.isSelected()) {
            this.mNamePriCaseTextField.setText(this.mPriFirstVarName);
        }
        this.mUserEnteredSeqCntText = EMPTY_STR;
        this.getVarNameForSeqCount();
        this.mNameSeqCountTextField.setText(this.mSeqCountVarName);
        this.mFilterByIndicatorValCheck.setSelected(false);
        this.mSeqCountMatchCasesCheck.setSelected(false);
        this.mNameColonSeqCountLabel.setEnabled(false);
        this.mNameSeqCountTextField.setEnabled(false);
        this.mNameSeqCountTextField.setOpaque(false);
        this.mMoveMatchCaseTopCheck.setSelected(true);
        this.mDispFreqForVarsCheck.setSelected(true);
        if (CommandLine.isClementineCaller()) {
            this.mMoveMatchCaseTopCheck.setEnabled(false);
            this.mDispFreqForVarsCheck.setEnabled(false);
            this.mMoveMatchCaseTopCheck.setSelected(false);
            this.mDispFreqForVarsCheck.setSelected(false);
        }
        this.mFormatter.getVarMap().clear();
    }

    private void updateOkPaste() {
        if (this.mTargetDefineCasesByVarList.getModel().getSize() > 0) {
            if (this.mPriCaseIndicatorCheck.isSelected() && !this.mNamePriCaseTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                if (this.mSeqCountMatchCasesCheck.isSelected()) {
                    if (!this.mNameSeqCountTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                        this.enableOkPaste(true);
                    } else {
                        this.enableOkPaste(false);
                    }
                } else {
                    this.enableOkPaste(true);
                }
            } else if (this.mSeqCountMatchCasesCheck.isSelected() && !this.mNameSeqCountTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                if (this.mPriCaseIndicatorCheck.isSelected()) {
                    if (!this.mNamePriCaseTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                        this.enableOkPaste(true);
                    } else {
                        this.enableOkPaste(false);
                    }
                } else {
                    this.enableOkPaste(true);
                }
            } else if (this.mMoveMatchCaseTopCheck.isSelected()) {
                boolean bl = true;
                boolean bl2 = true;
                if (this.mPriCaseIndicatorCheck.isSelected() && this.mNamePriCaseTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                    bl = false;
                }
                if (this.mSeqCountMatchCasesCheck.isSelected() && this.mNameSeqCountTextField.getText().equalsIgnoreCase(EMPTY_STR)) {
                    bl2 = false;
                }
                this.enableOkPaste(bl && bl2);
            } else {
                this.enableOkPaste(false);
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowDefineCasesByButton);
        vector.add(this.mArrowSortGroupsByButton);
        vector.add(this.mTargetDefineCasesByVarList);
        vector.add(this.mTargetSortGroupsByVarList);
        vector.add(this.mSortGroupsByButton.getUpArrowButton());
        vector.add(this.mSortGroupsByButton.getDownArrowButton());
        vector.add(this.mSortCaseButtonGroup);
        vector.add(this.mPriCaseIndicatorCheck);
        vector.add(this.mPrimaryCaseButtonGroup);
        vector.add(this.mNamePriCaseTextField);
        vector.add(this.mFilterByIndicatorValCheck);
        vector.add(this.mSeqCountMatchCasesCheck);
        vector.add(this.mNameSeqCountTextField);
        vector.add(this.mMoveMatchCaseTopCheck);
        vector.add(this.mDispFreqForVarsCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_IDUPC_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowDefineCasesByButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarDefineCasesByLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetDefineCasesByScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowSortGroupsByButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        n = 21;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVarSortGroupsByLabel, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetSortGroupsByScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_IDUPC_SORT"));
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets3 = DialogUtil.getStandardControlInsets();
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mAscendingRadio, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mDescendingRadio, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        this.mSortCaseButtonGroup = DialogUtil.createButtonGroup(jPanel2);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        JPanel jPanel3 = this.mSortGroupsByButton.getArrowButtonPanel();
        insets2.set(DialogUtil.getGroupBoxInnerMargin() * 3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 3, 4, 1, 1, n, insets2);
        insets2.set(DialogUtil.getComponentGroupGap() - insets3.bottom * 2, 0, 0, 0);
        JPanel jPanel4 = PanelFactory.getGridPanel(new JComponent[]{this.mMatchSortVarsNumberLabel, this.mNoMatchSortVarsLabel}, EMPTY_STR, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 2, 5, 1, 1, n, insets2);
        JPanel jPanel5 = this.setupVarsCreatePanel();
        titledBorder = new TitledBorder(this.getResString("IDS_IDUPC_VARIABLES_TO_CREATE"));
        jPanel5.setBorder(titledBorder);
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 6, 4, 1, n, insets2);
        JPanel jPanel6 = this.setupMoveDispFreqPanel();
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 7, 4, 1, n, insets2);
    }

    private JPanel setupCaseRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mLastCaseRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFirstCaseRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mPrimaryCaseButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupCaseLabelTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNameColonPriCasesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNamePriCaseTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSeqTextLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNameColonSeqCountLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameSeqCountTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupVarsCreatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPriCaseIndicatorCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel2 = this.setupCaseRadioPanel();
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 6, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel3 = this.setupCaseLabelTextPanel();
        n = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2.set(0, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() - insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin() * 6 + insets.right * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFilterByIndicatorValCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSeqCountMatchCasesCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel4 = this.setupSeqTextLabelPanel();
        n = 21;
        gridBagConstraints.weightx = 1.0;
        insets2.set(0, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() - insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMoveDispFreqPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left + DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMoveMatchCaseTopCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDispFreqForVarsCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }
}

