/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ValueLabelGridRow;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class SuggestSubDialog
extends BaseSubDialog {
    private ScannedVariable mScannedVariable;
    private int mExplanationID;
    private JRadioButton mOrdinalCheck;
    private JRadioButton mNominalCheck;

    public SuggestSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    public SuggestSubDialog(BaseProcedureDialog baseProcedureDialog, ScannedVariable scannedVariable) {
        this(baseProcedureDialog, "", true);
        this.setTitle(this.getResString("IDS_DVP_SUGGEST_TITLE"));
        this.mScannedVariable = scannedVariable;
        this.setupViewPanel();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dvp_suggest";
    }

    @Override
    public boolean continuePressed() {
        ISpssVariable iSpssVariable = this.mScannedVariable.getVariable();
        if (this.mExplanationID == 8) {
            if (this.mOrdinalCheck.isSelected() && iSpssVariable.getMeasurementLevel() != MeasurementLevel.ordinal) {
                iSpssVariable.setMeasurementLevel(MeasurementLevel.ordinal);
            } else if (this.mNominalCheck.isSelected() && iSpssVariable.getMeasurementLevel() != MeasurementLevel.nominal) {
                iSpssVariable.setMeasurementLevel(MeasurementLevel.nominal);
            }
        }
        switch (this.mExplanationID) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                iSpssVariable.setMeasurementLevel(MeasurementLevel.scale);
                break;
            }
            case 0: 
            case 2: {
                iSpssVariable.setMeasurementLevel(MeasurementLevel.nominal);
            }
        }
        return super.continuePressed();
    }

    private void setupViewPanel() {
        Component[] componentArray;
        Cloneable cloneable;
        ISpssVariable iSpssVariable = this.mScannedVariable.getVariable();
        JPanel jPanel = this.getViewPanel();
        JLabel jLabel = new JLabel(this.getResString("IDS_DVP_SUGGEST_VARIABLE_COLON"));
        String string = iSpssVariable.getName();
        StringTextField stringTextField = new StringTextField(string);
        stringTextField.selectAll();
        JLabel jLabel2 = new JLabel(this.getResString("IDS_DVP_SUGGEST_CURR_LEVEL_COLON"));
        MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
        StringTextField stringTextField2 = new StringTextField();
        if (measurementLevel == MeasurementLevel.nominal) {
            stringTextField2.setText(this.getResString("IDS_MEASURE_NOMINAL"));
        } else if (measurementLevel == MeasurementLevel.ordinal) {
            stringTextField2.setText(this.getResString("IDS_MEASURE_ORDINAL"));
        } else if (measurementLevel == MeasurementLevel.scale) {
            stringTextField2.setText(this.getResString("IDS_MEASURE_SCALE"));
        }
        JLabel jLabel3 = new JLabel(this.getResString("IDS_DVP_SUGGEST_SUGGESTED_LEVEL_COLON"));
        StringTextField stringTextField3 = new StringTextField();
        stringTextField.setEditable(false);
        stringTextField2.setEditable(false);
        stringTextField3.setEditable(false);
        stringTextField.setBackground(this.getBackground());
        stringTextField2.setBackground(this.getBackground());
        stringTextField3.setBackground(this.getBackground());
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_MEASURE_ORDINAL");
        this.mOrdinalCheck = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_MEASURE_NOMINAL");
        this.mNominalCheck = new JRadioButton(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNominalCheck);
        spssButtonGroup.add(this.mOrdinalCheck);
        this.mOrdinalCheck.setSelected(true);
        this.mExplanationID = 8;
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        ArrayList<ValueLabelGridRow> arrayList = new ArrayList<ValueLabelGridRow>();
        for (ValueLabelGridRow valueLabelGridRow : this.mScannedVariable.getValueLabelGrid()) {
            if (valueLabelGridRow.isMissing()) continue;
            arrayList.add(valueLabelGridRow);
        }
        int n = arrayList.size();
        double d = Double.MAX_VALUE;
        if (formatType.isStringFormat()) {
            this.mExplanationID = 0;
        } else if (formatType.isCurrencyFormat()) {
            this.mExplanationID = 1;
        } else if (n <= 2) {
            this.mExplanationID = 2;
        } else {
            boolean bl = false;
            for (ValueLabelGridRow object2 : arrayList) {
                ValueLabelGridRow valueLabelGridRow;
                valueLabelGridRow = (OBS)object2.getValue();
                if (valueLabelGridRow == null || valueLabelGridRow.isEmpty()) continue;
                Double d2 = valueLabelGridRow.getNum();
                if (d2 != (double)Math.round(d2)) {
                    this.mExplanationID = 3;
                    bl = true;
                    break;
                }
                if (d2 < 0.0) {
                    this.mExplanationID = 4;
                    bl = true;
                    break;
                }
                if (d2 >= 10000.0) {
                    this.mExplanationID = 5;
                    bl = true;
                    break;
                }
                if (!(d2 < d)) continue;
                d = d2;
            }
            if (!bl) {
                if (n > 100) {
                    this.mExplanationID = 6;
                } else if (d >= 10.0) {
                    this.mExplanationID = 7;
                }
            }
        }
        switch (this.mExplanationID) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                stringTextField3.setText(this.getResString("IDS_MEASURE_SCALE"));
                break;
            }
            case 0: 
            case 2: {
                stringTextField3.setText(this.getResString("IDS_MEASURE_NOMINAL"));
                break;
            }
            default: {
                stringTextField3.setText(this.getResString("IDS_MEASURE_ORDINAL_OR_NOMINAL"));
            }
        }
        JLabel jLabel4 = new JLabel(this.getResString("IDS_DVP_EXPLANATION_COLON"));
        Object object3 = "";
        switch (this.mExplanationID) {
            case 0: {
                object3 = this.getResString("IDS_VAR_IS_A_STRING");
                break;
            }
            case 1: {
                object3 = this.getResString("IDS_VAR_HAS_CURRENCY");
                break;
            }
            case 2: {
                object3 = this.getResString("IDS_VAR_HAS_1_OR_2_VALS");
                break;
            }
            case 3: {
                object3 = this.getResString("IDS_VAR_HAS_SOME_NON_INT_VALS");
                break;
            }
            case 4: {
                object3 = this.getResString("IDS_VAR_HAS_NEGATIVE_VALS");
                break;
            }
            case 5: {
                object3 = this.getResString("IDS_VAR_HAS_SOME_LARGE_VALS");
                break;
            }
            case 6: {
                object3 = this.getResString("IDS_VAR_HAS_MANY_VALS");
                break;
            }
            case 7: {
                object3 = this.getResString("IDS_VAR_HAS_NO_SMALL_VALS");
                break;
            }
            default: {
                object3 = this.getResString("IDS_VAR_HAS_SMALL_NONNEG_INT_VAL");
            }
        }
        JTextArea jTextArea = new JTextArea(string + (String)object3);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(400, 50));
        jTextArea.setPreferredSize(new Dimension(400, 50));
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel5 = new JLabel(new ImageIcon(uRL));
        JTextArea jTextArea2 = new JTextArea(this.getResString("IDS_DVP_SUGGEST_DETAILS"));
        jTextArea2.setEditable(false);
        jTextArea2.setOpaque(false);
        jTextArea2.setFocusable(false);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setLineWrap(true);
        int n2 = 400;
        int n3 = 340;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n3 += 30;
        }
        jTextArea2.setMinimumSize(new Dimension(n2, n3));
        jTextArea2.setPreferredSize(new Dimension(n2, n3));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setMinimumSize(this.mOrdinalCheck.getPreferredSize());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 6, 6, 6);
        gridBagConstraints.fill = 0;
        int n4 = 10;
        if (this.mExplanationID == 8) {
            jTextArea.setText(jTextArea.getText());
            n4 = 24;
            gridBagConstraints.weightx = 0.0;
            cloneable = new Insets(insets2.top, DialogUtil.getComponentGroupGap() * 10, insets2.bottom, insets2.right);
            DialogUtil.addUsingGBL(jPanel2, this.mOrdinalCheck, gridBagConstraints, 0, 0, 1, 1, n4, (Insets)cloneable);
            gridBagConstraints.weightx = 1.0;
            n4 = 23;
            DialogUtil.addUsingGBL(jPanel2, this.mNominalCheck, gridBagConstraints, 1, 0, 1, 1, n4, insets2);
        } else {
            this.mOrdinalCheck.setEnabled(false);
            this.mNominalCheck.setEnabled(false);
            DialogUtil.addUsingGBL(jPanel2, new JLabel(" "), gridBagConstraints, 0, 0, 1, 1, n4, insets2);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        n4 = 23;
        DialogUtil.addUsingGBL(jPanel3, jLabel4, gridBagConstraints, 0, 0, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, jTextArea, gridBagConstraints, 1, 0, 1, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel4, jLabel5, gridBagConstraints, 0, 0, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel4, jTextArea2, gridBagConstraints, 1, 0, 1, 1, n4, insets);
        n4 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)stringTextField), gridBagConstraints, 1, 0, 1, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)stringTextField2), gridBagConstraints, 1, 1, 1, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)stringTextField3), gridBagConstraints, 1, 2, 1, 1, n4, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n4, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 2, 1, n4, insets);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 5, 2, 1, n4, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 6, 2, 1, n4, insets);
        cloneable = new Vector();
        ((Vector)cloneable).add(stringTextField);
        ((Vector)cloneable).add(stringTextField2);
        ((Vector)cloneable).add(stringTextField3);
        ((Vector)cloneable).add(this.mOrdinalCheck);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            ((Vector)cloneable).add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy((Vector<Object>)cloneable, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

