/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SpssVariableNameCellEditor
extends DefaultCellEditor {
    private BaseDialog mParentDlg;
    private JTable mTable;
    private boolean mReadOnly;
    private boolean mDontCancelEditing;

    public SpssVariableNameCellEditor(JTextField jTextField, BaseDialog baseDialog, JTable jTable) {
        super(jTextField);
        this.mParentDlg = baseDialog;
        this.mTable = jTable;
        this.mReadOnly = false;
        this.mDontCancelEditing = false;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !this.mReadOnly && super.isCellEditable(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl = true;
        String string = this.getCellEditorValue().toString();
        if (string.length() > 0) {
            Object object;
            String string2 = null;
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 3 && n < 8) {
                string2 = this.mParentDlg.getResString("ERR_DVP_ATTRIBUTES_ILLEGAL_CHARACTER");
                bl = false;
            } else if (n == 1 || n == 3) {
                string2 = this.mParentDlg.getResString("ERR_DVP_ATTRIBUTES_INVALID_VARNAME");
                bl = false;
            } else if (n == 2) {
                string2 = this.mParentDlg.getResString("ERR_DVP_ATTRIBUTES_SYSTEM_VARNAME");
                bl = false;
            }
            if (bl) {
                object = this.mTable.getModel();
                int n2 = object.getRowCount();
                int n3 = this.mTable.getSelectedRow();
                for (int i = 0; i < n2 && i != n3; ++i) {
                    String string3 = object.getValueAt(i, 0).toString();
                    if (string3.length() <= 0 || !string3.equals(string)) continue;
                    string2 = MessageFormat.format(this.mParentDlg.getResString("ERR_DVP_ATTRIBUTES_SAME_VARNAME"), string3);
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.mDontCancelEditing = true;
                object = string2;
                this.mTable.requestFocus();
                SwingUtilities.invokeLater(new Runnable((String)object){
                    final /* synthetic */ String val$errorStr;
                    {
                        this.val$errorStr = string;
                    }

                    @Override
                    public void run() {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)SpssVariableNameCellEditor.this.mParentDlg, this.val$errorStr, VersionInfo.getAppVersionString());
                        SpssVariableNameCellEditor.this.getComponent().requestFocusInWindow();
                        SpssVariableNameCellEditor.this.mDontCancelEditing = false;
                    }
                });
            }
        }
        return bl && super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (!this.mDontCancelEditing) {
            super.cancelCellEditing();
        }
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }
}

