/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVarsHeaderRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ScannedVarsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_HEADERS = new String[]{"0", "1", "2", "3"};
    private List<ScannedVariable> mScannedVariablesList;
    private List<Integer> mSorterList;
    private List<Integer> mNameSortedList;

    public ScannedVarsTableModel(List<ScannedVariable> list) {
        this.mScannedVariablesList = list;
        this.mNameSortedList = new ArrayList<Integer>();
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_HEADERS[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.mScannedVariablesList.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        int n3 = this.mSorterList != null ? this.mSorterList.get(n) : n;
        ScannedVariable scannedVariable = this.mScannedVariablesList.get(n3);
        if (scannedVariable == null) {
            return object;
        }
        switch (n2) {
            case 0: {
                object = scannedVariable.getUnlabeledIcon();
                break;
            }
            case 1: {
                object = scannedVariable.getMeasurementIcon();
                break;
            }
            case 2: {
                object = scannedVariable.getRoleIcon();
                break;
            }
            default: {
                object = scannedVariable.getVariable().getName();
            }
        }
        return object;
    }

    private List<Integer> makeCleanSorterList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mScannedVariablesList.size(); ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    protected void sortList(ScannedVarsHeaderRenderer.SortOrder sortOrder) {
        this.mSorterList = this.makeCleanSorterList();
        VariableComparator variableComparator = new VariableComparator(sortOrder);
        Collections.sort(this.mSorterList, variableComparator);
        this.fireTableChanged(new TableModelEvent(this));
    }

    private LinkedHashMap sortHashMapByValues(HashMap hashMap, boolean bl) {
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        ArrayList arrayList2 = new ArrayList(hashMap.values());
        Collections.sort(arrayList2);
        Collections.sort(arrayList);
        if (!bl) {
            Collections.reverse(arrayList2);
        }
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        block0: for (Integer n : arrayList2) {
            for (Integer n2 : arrayList) {
                if (!hashMap.get(n2).toString().equals(n.toString())) continue;
                hashMap.remove(n2);
                arrayList.remove(n2);
                linkedHashMap.put(n2, n);
                continue block0;
            }
        }
        return linkedHashMap;
    }

    private class VariableComparator
    implements Comparator {
        private ScannedVarsHeaderRenderer.SortOrder mSortOrder;

        public VariableComparator(ScannedVarsHeaderRenderer.SortOrder sortOrder) {
            this.mSortOrder = sortOrder;
        }

        public int compare(Object object, Object object2) {
            ScannedVariable scannedVariable = (ScannedVariable)ScannedVarsTableModel.this.mScannedVariablesList.get((Integer)object);
            ScannedVariable scannedVariable2 = (ScannedVariable)ScannedVarsTableModel.this.mScannedVariablesList.get((Integer)object2);
            int n = 0;
            switch (this.mSortOrder) {
                case eUnlabeledForward: {
                    n = this.sortByLabeled(scannedVariable, scannedVariable2);
                    break;
                }
                case eUnlabeledReverse: {
                    n = -this.sortByLabeled(scannedVariable, scannedVariable2);
                    break;
                }
                case eMeasurementForward: {
                    n = this.sortByMeasurementLevel(scannedVariable, scannedVariable2);
                    break;
                }
                case eMeasurementReverse: {
                    n = -this.sortByMeasurementLevel(scannedVariable, scannedVariable2);
                    break;
                }
                case eRolesForward: {
                    n = this.sortByRole(scannedVariable, scannedVariable2);
                    break;
                }
                case eRolesReverse: {
                    n = -this.sortByRole(scannedVariable, scannedVariable2);
                    break;
                }
                case eNameForward: {
                    n = this.sortByVarname(scannedVariable, scannedVariable2);
                    break;
                }
                case eNameReverse: {
                    n = -this.sortByVarname(scannedVariable, scannedVariable2);
                }
            }
            if (n == 0 && this.mSortOrder != ScannedVarsHeaderRenderer.SortOrder.eNameForward && this.mSortOrder != ScannedVarsHeaderRenderer.SortOrder.eNameReverse) {
                n = this.sortByVarname(scannedVariable, scannedVariable2);
            }
            return n;
        }

        private int sortByLabeled(ScannedVariable scannedVariable, ScannedVariable scannedVariable2) {
            boolean bl;
            boolean bl2 = scannedVariable.getUnlabeledValuesCount() > 0;
            boolean bl3 = bl = scannedVariable2.getUnlabeledValuesCount() > 0;
            if (bl2 == bl) {
                return 0;
            }
            if (bl2) {
                return 1;
            }
            return -1;
        }

        private int sortByMeasurementLevel(ScannedVariable scannedVariable, ScannedVariable scannedVariable2) {
            return scannedVariable.getVariable().getMeasurementLevel().compareTo((Enum)scannedVariable2.getVariable().getMeasurementLevel());
        }

        private int sortByRole(ScannedVariable scannedVariable, ScannedVariable scannedVariable2) {
            return scannedVariable.getVariable().getRole().compareTo((Enum)scannedVariable2.getVariable().getRole());
        }

        private int sortByVarname(ScannedVariable scannedVariable, ScannedVariable scannedVariable2) {
            return scannedVariable.getVariable().getName().compareTo(scannedVariable2.getVariable().getName());
        }
    }
}

