/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVarsTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ScannedVarsHeaderRenderer
implements TableCellRenderer,
MouseListener {
    protected static String[] HEADER_STRINGS = new String[4];
    private JLabel[] mTableHeaderButtons = new JLabel[]{this.createLabel(HEADER_STRINGS[0]), this.createLabel(HEADER_STRINGS[1]), this.createLabel(HEADER_STRINGS[2]), this.createLabel(HEADER_STRINGS[3])};
    private JTableHeader mTableHeader;
    private int mClickedHeaderIndex;
    private ScannedVarsTableModel mScannedVarsTableModel;
    private SortOrder mSortOrder;
    private static final int VARIABLE_COLUMN = 3;

    public ScannedVarsHeaderRenderer(JTableHeader jTableHeader, ScannedVarsTableModel scannedVarsTableModel) {
        this.mTableHeader = jTableHeader;
        this.mScannedVarsTableModel = scannedVarsTableModel;
        this.mSortOrder = SortOrder.eNone;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = Integer.parseInt(object.toString());
        return this.mTableHeaderButtons[n3];
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        JTable jTable = this.mTableHeader.getTable();
        int n2 = jTable.getSelectedRow();
        String string = "";
        if (n2 >= 0) {
            string = jTable.getValueAt(n2, 3).toString();
        }
        this.mSortOrder = (n = this.mTableHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX())) == this.sortOrderToColumn(this.mSortOrder) ? this.inverseOrder(this.mSortOrder) : this.columnToForwardOrder(n);
        this.mScannedVarsTableModel.sortList(this.mSortOrder);
        if (n2 >= 0) {
            int n3 = jTable.getRowCount();
            for (int i = 0; i < n3; ++i) {
                if (!string.equals(jTable.getValueAt(i, 3))) continue;
                jTable.changeSelection(i, 0, false, false);
                break;
            }
        }
    }

    private int sortOrderToColumn(SortOrder sortOrder) {
        switch (sortOrder) {
            case eUnlabeledForward: 
            case eUnlabeledReverse: {
                return 0;
            }
            case eMeasurementForward: 
            case eMeasurementReverse: {
                return 1;
            }
            case eRolesForward: 
            case eRolesReverse: {
                return 2;
            }
            case eNameForward: 
            case eNameReverse: {
                return 3;
            }
        }
        return -1;
    }

    private SortOrder columnToForwardOrder(int n) {
        switch (n) {
            case 0: {
                return SortOrder.eUnlabeledForward;
            }
            case 1: {
                return SortOrder.eMeasurementForward;
            }
            case 2: {
                return SortOrder.eRolesForward;
            }
        }
        return SortOrder.eNameForward;
    }

    private SortOrder inverseOrder(SortOrder sortOrder) {
        switch (sortOrder) {
            case eUnlabeledForward: {
                return SortOrder.eUnlabeledReverse;
            }
            case eUnlabeledReverse: {
                return SortOrder.eUnlabeledForward;
            }
            case eMeasurementForward: {
                return SortOrder.eMeasurementReverse;
            }
            case eMeasurementReverse: {
                return SortOrder.eMeasurementForward;
            }
            case eRolesForward: {
                return SortOrder.eRolesReverse;
            }
            case eRolesReverse: {
                return SortOrder.eRolesForward;
            }
            case eNameForward: {
                return SortOrder.eNameReverse;
            }
            case eNameReverse: {
                return SortOrder.eNameForward;
            }
        }
        return SortOrder.eNone;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mClickedHeaderIndex = this.mTableHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
        JLabel jLabel = this.mTableHeaderButtons[this.mClickedHeaderIndex];
        jLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.mTableHeader.paintImmediately(this.mTableHeader.getBounds());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mClickedHeaderIndex != -1) {
            JLabel jLabel = this.mTableHeaderButtons[this.mClickedHeaderIndex];
            jLabel.setBorder(BorderFactory.createBevelBorder(0));
            this.mTableHeader.paintImmediately(this.mTableHeader.getBounds());
            this.mClickedHeaderIndex = -1;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createBevelBorder(0));
        return jLabel;
    }

    public static enum SortOrder {
        eNone,
        eNameForward,
        eNameReverse,
        eUnlabeledForward,
        eUnlabeledReverse,
        eMeasurementForward,
        eMeasurementReverse,
        eRolesForward,
        eRolesReverse;

    }
}

