/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ValueLabelGridTableModel;
import java.awt.Component;
import java.awt.font.TextAttribute;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelCellEditor
extends DefaultCellEditor
implements DocumentListener {
    private JTextField mTextField;
    private ValueLabelGridTableModel mValueLabelGridTableModel;
    private JTable mTable;
    private String mValue;

    public LabelCellEditor(JTextField jTextField, ValueLabelGridTableModel valueLabelGridTableModel, JTable jTable) {
        super(jTextField);
        if (ComponentState.isBtdRtlOrLtr() && jTextField != null && jTextField.getDocument() != null) {
            if (ComponentState.getBTD() == 1) {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mTextField = jTextField;
        this.mTextField.getDocument().addDocumentListener(this);
        this.mValueLabelGridTableModel = valueLabelGridTableModel;
        this.mTable = jTable;
    }

    @Override
    public Object getCellEditorValue() {
        if (ComponentState.isBtdRtlOrLtr() && this.mTextField != null && this.mTextField.getText() != null && this.mTextField.getText().length() > 0) {
            return ComponentState.removeBidiDirectionMarks((String)this.mTextField.getText());
        }
        return this.mTextField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.mValue = object.toString();
        if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
            this.mTextField.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
        } else {
            this.mTextField.setText(object.toString());
        }
        this.mTextField.setFont(jTable.getFont());
        return this.mTextField;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n = this.mTable.getEditingRow();
        int n2 = this.mTable.getEditingColumn();
        if (n >= 0 && n2 >= 0) {
            this.mValueLabelGridTableModel.setValueAt(this.mTextField.getText(), n, n2);
            this.mValueLabelGridTableModel.fireTableCellUpdated(n, n2);
            if (!this.mValue.equals(this.mTextField.getText())) {
                this.mValueLabelGridTableModel.setChange(true);
            } else {
                this.mValueLabelGridTableModel.setChange(false);
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        int n = this.mTable.getEditingRow();
        int n2 = this.mTable.getEditingColumn();
        if (n >= 0 && n2 >= 0) {
            this.mValueLabelGridTableModel.setValueAt(this.mTextField.getText(), n, n2);
            this.mValueLabelGridTableModel.fireTableCellUpdated(n, n2);
            if (!this.mValue.equals(this.mTextField.getText())) {
                this.mValueLabelGridTableModel.setChange(true);
            } else {
                this.mValueLabelGridTableModel.setChange(false);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        int n = this.mTable.getEditingRow();
        int n2 = this.mTable.getEditingColumn();
        if (n >= 0 && n2 >= 0) {
            this.mValueLabelGridTableModel.setValueAt(this.mTextField.getText(), n, n2);
            this.mValueLabelGridTableModel.fireTableCellUpdated(n, n2);
        }
    }
}

