/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.SpssVariableNameCellEditor;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.CustomAttributeArrayDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class DefineVariablePropertiesAttributesSubDialog
extends BaseSubDialog
implements IButtonEditListener,
FocusListener,
ListSelectionListener {
    static final String IDS_DVP_ATTRIBUTES_ADD_BUTTON = "IDS_DVP_ATTRIBUTES_ADD_BUTTON";
    static final String IDS_DVP_ATTRIBUTES_DELETE_BUTTON = "IDS_DVP_ATTRIBUTES_DELETE_BUTTON";
    private JButton mAddButton;
    private JButton mDeleteButton;
    private JLabel mSpssVariableNameLabel;
    private PlainTable mCustomAttributeTable;
    private ISpssVariable mSpssVariable;
    private CustomVarAttributeTableModel mCustomVarAttributeTableModel;
    private Vector<CustomVariableAttributes> mTableData;
    private CustomAttributeCellEditor mCustomAttributeCellEditor;
    private SpssVariableNameCellEditor mVarNameCellEditor;

    public DefineVariablePropertiesAttributesSubDialog(BaseProcedureDialog baseProcedureDialog, ISpssVariable iSpssVariable) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_DVP_ATTRIBUTES_TITLE"), true);
        this.mSpssVariable = iSpssVariable;
        if (ComponentState.isBtdRtlOrLtr() && this.mSpssVariable.getName() != null && this.mSpssVariable.getName().length() > 0) {
            this.mSpssVariableNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)this.mSpssVariable.getName()));
        } else {
            this.mSpssVariableNameLabel.setText(this.mSpssVariable.getName());
        }
        this.loadTableWithCustomAttribute();
        this.pack();
    }

    @Override
    public void buttonPressed(long l, int n) {
        CustomVariableAttributes customVariableAttributes;
        String string;
        int n2 = this.mCustomAttributeTable.getSelectedRow();
        if (n2 >= 0 && (string = (customVariableAttributes = this.mTableData.get(n2)).mCustomVarAttributeName).length() > 0) {
            this.stopCellEditing();
            CustomAttributeArrayDlg customAttributeArrayDlg = new CustomAttributeArrayDlg((JDialog)((Object)this.mParentDlg), customVariableAttributes.getMCustomVarAttributeValues(), string);
            ((Dialog)((Object)customAttributeArrayDlg)).setVisible(true);
            this.mCustomVarAttributeTableModel.fireTableDataChanged();
        }
    }

    @Override
    public boolean continuePressed() {
        boolean bl = false;
        boolean bl2 = this.stopCellEditing();
        if (bl2) {
            this.saveCustomAttributeInVariable();
            bl = super.continuePressed();
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_custom_attrs_dlg";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = true;
        for (int n : nArray = this.mCustomAttributeTable.getSelectedRows()) {
            String string = this.mCustomAttributeTable.getValueAt(n, 0).toString();
            if (string == null || !string.startsWith("$")) continue;
            bl = false;
            break;
        }
        this.mDeleteButton.setEnabled(bl);
        this.mVarNameCellEditor.setReadOnly(!bl);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_DVP_ATTRIBUTES_CUSTOM_ATTRIBUTES_LABEL");
        jLabel.setLabelFor(this.mCustomAttributeTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSpssVariableNameLabel, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mCustomAttributeTable);
        jScrollPane.setPreferredSize(this.mCustomAttributeTable.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 2, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCustomAttributeTable);
        vector.add(this.mAddButton);
        vector.add(this.mDeleteButton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void initVars() {
        this.mSpssVariableNameLabel = new JLabel();
        this.mTableData = new Vector();
        this.mCustomVarAttributeTableModel = new CustomVarAttributeTableModel();
        this.mCustomAttributeTable = new PlainTable(this.mCustomVarAttributeTableModel);
        this.mCustomAttributeTable.setDefaultRenderer(Object.class, new CustomAttributeCellRenderer());
        this.mCustomAttributeCellEditor = new CustomAttributeCellEditor(0);
        TableColumn tableColumn = this.mCustomAttributeTable.getColumnModel().getColumn(1);
        this.mCustomAttributeCellEditor.setReadOnlyEdit(false);
        tableColumn.setCellEditor(this.mCustomAttributeCellEditor);
        this.mCustomAttributeCellEditor.addButtonListener(this);
        this.mCustomAttributeTable.getSelectionModel().setSelectionMode(0);
        this.mCustomAttributeTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        tableColumn = this.mCustomAttributeTable.getColumnModel().getColumn(0);
        StringTextField stringTextField = new StringTextField();
        this.mVarNameCellEditor = new SpssVariableNameCellEditor((JTextField)((Object)stringTextField), this, this.mCustomAttributeTable);
        tableColumn.setCellEditor(this.mVarNameCellEditor);
        this.mCustomAttributeTable.getColumnModel().getColumn(0).setMinWidth(100);
        this.mCustomAttributeTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.mCustomAttributeTable.setMinimumSize(new Dimension(300, 200));
        this.mCustomAttributeTable.setAutoResizeMode(3);
        this.mCustomAttributeTable.setRowSelectionAllowed(false);
        this.mCustomAttributeTable.setRowHeight(this.mCustomAttributeTable.getRowHeight() + 4);
        this.mCustomAttributeTable.addFocusListener(this);
        this.mCustomAttributeTable.getTableHeader().setFont(this.mCustomAttributeTable.getFont().deriveFont(1));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_DVP_ATTRIBUTES_ADD_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DefineVariablePropertiesAttributesSubDialog.this.stopCellEditing();
                if (bl) {
                    DefineVariablePropertiesAttributesSubDialog.this.mCustomVarAttributeTableModel.addNewElement();
                    final int n = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getRowCount();
                    if (n > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.changeSelection(n - 1, 0, false, false);
                                DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.editCellAt(n - 1, 0);
                                DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.requestFocusInWindow();
                            }
                        });
                    }
                }
            }
        };
        this.mAddButton = new JButton(toggleButtonAction);
        this.mAddButton.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_DVP_ATTRIBUTES_DELETE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray;
                boolean bl = DefineVariablePropertiesAttributesSubDialog.this.stopCellEditing();
                if (bl && (nArray = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getSelectedRows()).length > 0) {
                    String string = (String)DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getValueAt(nArray[0], 0);
                    String string2 = DefineVariablePropertiesAttributesSubDialog.this.mSpssVariable.getName();
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)DefineVariablePropertiesAttributesSubDialog.this.mParentDlg), MessageFormat.format(DefineVariablePropertiesAttributesSubDialog.this.getResString("ERR_DVP_ATTRIBUTES_DELETE_BUTTON_WARNING"), string, string2), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n != 3 && n != -1) {
                        DefineVariablePropertiesAttributesSubDialog.this.mCustomVarAttributeTableModel.deleteElement(nArray);
                        int n2 = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getRowCount();
                        if (nArray[0] < n2 - 1) {
                            DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.changeSelection(nArray[0], 0, false, false);
                            DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.editCellAt(nArray[0], 0);
                        }
                    }
                }
            }
        };
        this.mDeleteButton = new JButton(toggleButtonAction);
        this.mDeleteButton.addFocusListener(this);
    }

    private boolean stopCellEditing() {
        boolean bl = true;
        if (this.mCustomAttributeTable.getCellEditor() != null) {
            bl = this.mCustomAttributeTable.getCellEditor().stopCellEditing();
        }
        return bl;
    }

    private void loadTableWithCustomAttribute() {
        IDatasourceAttributes iDatasourceAttributes = this.mSpssVariable.getAttributes();
        if (iDatasourceAttributes != null) {
            TreeMap treeMap = new TreeMap(iDatasourceAttributes.attributes());
            int n = treeMap.size();
            CustomVarAttributeTableModel customVarAttributeTableModel = (CustomVarAttributeTableModel)this.mCustomAttributeTable.getModel();
            for (String string : treeMap.keySet()) {
                customVarAttributeTableModel.addNewElement(string, (Vector)treeMap.get(string));
            }
            if (n > 0) {
                this.mCustomAttributeTable.changeSelection(0, 0, false, false);
            }
        }
    }

    private void saveCustomAttributeInVariable() {
        DatasourceAttributes datasourceAttributes = new DatasourceAttributes();
        for (CustomVariableAttributes customVariableAttributes : this.mTableData) {
            String string = customVariableAttributes.getMCustomVarAttributeName();
            if (string.length() <= 0) continue;
            datasourceAttributes.put(string, customVariableAttributes.getMCustomVarAttributeValues());
        }
        this.mSpssVariable.setAttributes((IDatasourceAttributes)datasourceAttributes);
    }

    class CustomAttributeCellEditor
    extends ButtonEditCtrl {
        public CustomAttributeCellEditor(int n) {
            super(n);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (n2 == 1) {
                boolean bl2 = object.toString().equals(DefineVariablePropertiesAttributesSubDialog.this.getResString("IDS_DVP_ATTRIBUTES_ARRAY"));
                String string = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getValueAt(n, 0).toString();
                boolean bl3 = string != null && string.startsWith("$");
                this.setReadOnlyEdit(bl2 || bl3);
                this.mTextField.setForeground(bl3 ? SystemColor.gray : SystemColor.black);
            }
            return component;
        }
    }

    class CustomAttributeCellRenderer
    extends DefaultTableCellRenderer {
        CustomAttributeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            String string = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getValueAt(n, 0).toString();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                string = ComponentState.removeBidiDirectionMarks((String)string);
            }
            boolean bl3 = string != null && string.startsWith("$");
            this.setForeground(bl3 ? SystemColor.gray : SystemColor.black);
            this.setBackground(jTable.getBackground());
            return this;
        }
    }

    class CustomVariableAttributes {
        private String mCustomVarAttributeName;
        private Vector<String> mCustomVarAttributeValues;

        public CustomVariableAttributes() {
            this.mCustomVarAttributeName = "";
            this.mCustomVarAttributeValues = new Vector();
        }

        public CustomVariableAttributes(String string, Vector<String> vector) {
            this.mCustomVarAttributeName = string;
            this.mCustomVarAttributeValues = vector;
        }

        public String getMCustomVarAttributeName() {
            return this.mCustomVarAttributeName;
        }

        public void setMCustomVarAttributeName(String string) {
            this.mCustomVarAttributeName = string;
        }

        public Vector<String> getMCustomVarAttributeValues() {
            return this.mCustomVarAttributeValues;
        }

        public void setMCustomVarAttributeValues(Vector<String> vector) {
            this.mCustomVarAttributeValues = vector;
        }
    }

    class CustomVarAttributeTableModel
    extends AbstractTableModel {
        private String[] mColumnNames;

        CustomVarAttributeTableModel() {
            this.mColumnNames = new String[]{DefineVariablePropertiesAttributesSubDialog.this.getResString("IDS_DVP_ATTRIBUTES_NAME"), DefineVariablePropertiesAttributesSubDialog.this.getResString("IDS_DVP_ATTRIBUTES_VALUE")};
        }

        public void addNewElement() {
            CustomVariableAttributes customVariableAttributes = new CustomVariableAttributes();
            DefineVariablePropertiesAttributesSubDialog.this.mTableData.add(customVariableAttributes);
            int n = DefineVariablePropertiesAttributesSubDialog.this.mTableData.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void addNewElement(String string, Vector<String> vector) {
            CustomVariableAttributes customVariableAttributes = new CustomVariableAttributes();
            customVariableAttributes.setMCustomVarAttributeName(string);
            customVariableAttributes.setMCustomVarAttributeValues(vector);
            DefineVariablePropertiesAttributesSubDialog.this.mTableData.add(customVariableAttributes);
            int n = DefineVariablePropertiesAttributesSubDialog.this.mTableData.size() - 1;
            this.fireTableRowsInserted(n, n);
            DefineVariablePropertiesAttributesSubDialog.this.setTabTraversalOrder();
        }

        public void deleteElement(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                DefineVariablePropertiesAttributesSubDialog.this.mTableData.remove(nArray[i]);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return DefineVariablePropertiesAttributesSubDialog.this.mTableData.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColumnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CustomVariableAttributes customVariableAttributes = (CustomVariableAttributes)DefineVariablePropertiesAttributesSubDialog.this.mTableData.get(n);
            if (n2 == 0) {
                return customVariableAttributes.getMCustomVarAttributeName();
            }
            TableColumn tableColumn = DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeTable.getColumnModel().getColumn(1);
            tableColumn.setCellEditor(DefineVariablePropertiesAttributesSubDialog.this.mCustomAttributeCellEditor);
            Vector<String> vector = customVariableAttributes.getMCustomVarAttributeValues();
            if (vector.size() == 0) {
                return "";
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            return DefineVariablePropertiesAttributesSubDialog.this.getResString("IDS_DVP_ATTRIBUTES_ARRAY");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            CustomVariableAttributes customVariableAttributes = (CustomVariableAttributes)DefineVariablePropertiesAttributesSubDialog.this.mTableData.get(n);
            String string = customVariableAttributes.getMCustomVarAttributeName();
            return string == null || string.length() == 0 || string.charAt(0) != '$' || n2 != 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CustomVariableAttributes customVariableAttributes = (CustomVariableAttributes)DefineVariablePropertiesAttributesSubDialog.this.mTableData.get(n);
            if (n2 == 0) {
                customVariableAttributes.setMCustomVarAttributeName(object.toString());
            } else if (customVariableAttributes.getMCustomVarAttributeValues().size() <= 1) {
                Vector<String> vector = new Vector<String>();
                vector.add(object.toString());
                customVariableAttributes.setMCustomVarAttributeValues(vector);
            }
        }
    }
}

