/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_var_properties;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.DefineVariablePropertiesDlg;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefVarPropsGatingDialog
extends BaseProcedureDialog
implements ActionListener,
ListDataListener,
DocumentListener,
IFrequencyScannerListener {
    private SrcVariableList mSrcVariableList;
    private TargetVariableList mVariableList;
    private IntTextField mNumberOfCasesEdit;
    private IntTextField mNumberOfValuesEdit;
    private JCheckBox mNumberOfCasesCheck;
    private JCheckBox mNumberOfValuesCheck;
    private JFrame mFrame;
    private Vector<Object> mTabOrder;

    public DefVarPropsGatingDialog(JFrame jFrame) {
        super(jFrame, "", DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_VAR_PROPERTIES_TITLE"));
        this.setVisible(true);
        this.mFrame = jFrame;
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "data_define_var_property";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dvp_gating";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.mNumberOfCasesCheck.isSelected();
        this.mNumberOfCasesEdit.setEnabled(bl);
        this.mNumberOfCasesEdit.setOpaque(bl);
        bl = this.mNumberOfValuesCheck.isSelected();
        this.mNumberOfValuesEdit.setEnabled(bl);
        this.mNumberOfValuesEdit.setOpaque(bl);
        this.updateContinueButton();
    }

    @Override
    public boolean okPastePressed() {
        VarListModel varListModel = this.mVariableList.getModel();
        int n = varListModel.getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (int i = 0; i < n; ++i) {
            iSpssVariableArray[i] = varListModel.getElementAt(i);
        }
        long l = -1L;
        if (this.mNumberOfCasesCheck.isSelected()) {
            l = Long.parseLong(this.mNumberOfCasesEdit.getText().trim());
        }
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
        Vector<LocallyUniqueId> vector = new Vector<LocallyUniqueId>();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            vector.add(iSpssVariable.getId());
        }
        long l2 = l == -1L ? 1000000L : l;
        CoreFrequencies coreFrequencies = new CoreFrequencies();
        coreFrequencies.run(locallyUniqueId, vector, 500, l2);
        FrequenciesScanner frequenciesScanner = new FrequenciesScanner(coreFrequencies, SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), "Scanning Cases");
        frequenciesScanner.registerScannerListener(this);
        this.dispose();
        frequenciesScanner.startScanning();
        return true;
    }

    @Override
    protected boolean canBeRecalled() {
        super.canBeRecalled();
        return false;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateContinueButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateContinueButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateContinueButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        int n;
        this.mFrame.setCursor(Cursor.getPredefinedCursor(3));
        VarListModel varListModel = this.mVariableList.getModel();
        int n2 = varListModel.getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n2];
        for (n = 0; n < n2; ++n) {
            iSpssVariableArray[n] = varListModel.getElementAt(n);
        }
        n = -1;
        if (this.mNumberOfValuesCheck.isSelected()) {
            n = Integer.parseInt(this.mNumberOfValuesEdit.getText().trim());
        }
        DefineVariablePropertiesDlg defineVariablePropertiesDlg = new DefineVariablePropertiesDlg(this.mFrame, iSpssVariableArray, n, coreFrequencies);
        ProcedureDlgMgr.getMgr().addProcedureDialog("data_define_var_property_main", defineVariablePropertiesDlg);
        defineVariablePropertiesDlg.getScannedVariablesTable().addRowSelectionInterval(0, 0);
        this.mFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        this.getOkButton().setText(ResUtil.getCommonDlgString("IDS_CONTINUE"));
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void init() {
        Component[] componentArray;
        super.init();
        this.initVars();
        this.setDefaults();
        this.mSrcVariableList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.setSelectedIndex(0);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DVP_GATING_VARIABLES_COLON");
        jLabel2.setLabelFor(this.mSrcVariableList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_DVP_GATING_VARS_TO_SCAN_COLON");
        jLabel3.setLabelFor(this.mVariableList);
        this.enableOkPaste(false);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_DVP_GATING_USE"));
        jTextArea.setRows(3);
        jTextArea.setFont(jLabel2.getFont());
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(350, 100));
        jTextArea.setPreferredSize(new Dimension(350, 200));
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mVariableList, SpssArrowButton.ButtonOrientation.left);
        arrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        JScrollPane jScrollPane2 = new JScrollPane(this.mVariableList);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        this.mVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVariableList.getFixedCellHeight() * 11 + 2));
        jScrollPane2.setPreferredSize(this.mVariableList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getStandardDialogInsets();
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 7, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, arrowButton, gridBagConstraints, 2, 1, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 3, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 3, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets4 = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 6, 3, 1, n, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mNumberOfCasesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mNumberOfCasesEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mNumberOfValuesCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mNumberOfValuesEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mTabOrder.add(this.mSrcVariableList);
        this.mTabOrder.add(arrowButton);
        this.mTabOrder.add(this.mVariableList);
        this.mTabOrder.add(this.mNumberOfCasesCheck);
        this.mTabOrder.add(this.mNumberOfValuesCheck);
        this.mTabOrder.add(this.mNumberOfCasesEdit);
        this.mTabOrder.add(this.mNumberOfValuesEdit);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            this.mTabOrder.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        DialogUtil.normalizeLabelWidths(jPanel);
        this.pack();
        this.mSrcVariableList.requestFocus();
    }

    private void setDefaults() {
        this.mNumberOfValuesCheck.setSelected(true);
        this.mNumberOfCasesCheck.setSelected(false);
        this.mNumberOfValuesEdit.setText("200");
        this.mNumberOfCasesEdit.setEnabled(false);
        this.mNumberOfCasesEdit.setOpaque(false);
        this.mNumberOfCasesCheck.addActionListener(this);
        this.mNumberOfValuesCheck.addActionListener(this);
        this.mVariableList.getModel().addListDataListener(this);
        this.mNumberOfCasesEdit.getDocument().addDocumentListener(this);
        this.mNumberOfValuesEdit.getDocument().addDocumentListener(this);
    }

    private void initVars() {
        this.mTabOrder = new Vector();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_DVP_GATING_CASES_LIMIT");
        this.mNumberOfCasesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DVP_GATING_VALUES_LIMIT");
        this.mNumberOfValuesCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNumberOfCasesCheck);
        spssButtonGroup.add(this.mNumberOfValuesCheck);
        this.mNumberOfCasesEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mNumberOfValuesEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mNumberOfCasesEdit.setColumns(6);
        this.mNumberOfValuesEdit.setColumns(6);
        this.mVariableList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
    }

    private void updateContinueButton() {
        boolean bl = true;
        if (this.mNumberOfCasesCheck.isSelected()) {
            boolean bl2 = bl = this.mNumberOfCasesEdit.getText().trim().length() > 0;
        }
        if (bl && this.mNumberOfValuesCheck.isSelected()) {
            bl = this.mNumberOfValuesEdit.getText().trim().length() > 0;
        }
        this.enableOkPaste(bl && this.mVariableList.getModel().getSize() > 0);
    }
}

