/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.define_dates;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.IDataCache;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.dialogs.base.data.define_dates.DateType;
import com.spss.java_client.ui.dialogs.base.data.define_dates.DateVariable;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class DefineDatesDlg
extends BaseProcedureDialog
implements ListSelectionListener,
DocumentListener {
    private static final String DEFINE_DATES_SOURCE_LIST_KEY = "DEFINE_DATES_SOURCE_LIST";
    private JPanel mDatePanel;
    private JTextArea mPeriodLabel;
    private PlainList mVarList;
    private Map<String, DateType> mDateMap;
    private JLabel mPeriodicityLabel;
    private int mTextFieldCount;
    private IntTextField[] mDateFields;
    private DateVariable[] mDateVars;
    private String mNotDated;
    private String mCustom;
    private HashMap<Integer, Integer> mSearchMap;
    private int mSelectedIndex;
    private int mInitIdx;
    private Set<String> mShortTermDateVariables;

    public DefineDatesDlg(JFrame jFrame) {
        super(jFrame, true, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_DATES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEmptyFields();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkEmptyFields();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkEmptyFields();
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        Object e = this.mVarList.getSelectedValue();
        if (e != null && e.toString().length() > 0) {
            int n = this.mVarList.getSelectedIndex();
            String string = e.toString();
            if (n != this.getIndexOfItem(this.mNotDated) && n != this.getIndexOfItem(this.mCustom)) {
                DateType dateType = this.mDateMap.get(string);
                this.mDateVars = dateType.getVariables();
                for (int i = 0; i < this.mDateVars.length; ++i) {
                    DateVariable dateVariable = this.mDateVars[i];
                    int n2 = Integer.parseInt(this.mDateFields[i].getText());
                    if (dateVariable.isValidValue(n2)) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(this.getResString("ERR_INVALID_FIRST_CASE"), dateVariable.getUserName()), VersionInfo.getAppVersionString());
                    bl = false;
                    break;
                }
                if (bl && string.equals(this.getResString("IDS_YEARS_QUARTERS_MONTHS")) && bl && !this.isMonthQuarterConsistent()) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MONTH_QUARTER_MSG"), VersionInfo.getAppVersionString());
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        int n = this.mVarList.getSelectedIndex();
        Object e = this.mVarList.getModel().getElementAt(n);
        if (e != null && (string = e.toString()).toString().length() > 0) {
            if (string.equals(this.getResString("IDS_YEARS"))) {
                stringBuffer.append("DATE Y " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_YEARS_QUARTERS"))) {
                stringBuffer.append("DATE Q " + this.mDateFields[1].getText() + " 4 Y " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_YEARS_MONTH"))) {
                stringBuffer.append("DATE M " + this.mDateFields[1].getText() + " 12 Y " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_YEARS_QUARTERS_MONTHS"))) {
                stringBuffer.append("DATE M " + this.mDateFields[2].getText() + " 12 Q " + this.mDateFields[1].getText() + " 4 Y " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_DAYS"))) {
                stringBuffer.append("DATE D " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_WEEKS_DAYS"))) {
                stringBuffer.append("DATE D " + this.mDateFields[1].getText() + " 7 W " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_WEEKS_WORKDAYS_5"))) {
                stringBuffer.append("DATE D " + this.mDateFields[1].getText() + " 5 W " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_WEEKS_WORKDAYS_6"))) {
                stringBuffer.append("DATE D " + this.mDateFields[1].getText() + " 6 W " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_HOURS"))) {
                stringBuffer.append("DATE H " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_DAYS_HOURS"))) {
                stringBuffer.append("DATE H " + this.mDateFields[1].getText() + " 24 D " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_DAYS_WORKHOURS_8"))) {
                stringBuffer.append("DATE H " + this.mDateFields[1].getText() + " 8 D " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_WEEK_DAYS_HOURS"))) {
                stringBuffer.append("DATE W H " + this.mDateFields[2].getText() + " 24 D " + this.mDateFields[1].getText());
            } else if (string.equals(this.getResString("IDS_WEEK_WORKDAYS_HOURS"))) {
                stringBuffer.append("DATE W H " + this.mDateFields[2].getText() + " 8 D " + this.mDateFields[1].getText() + " 5");
            } else if (string.equals(this.getResString("IDS_MINUTES"))) {
                stringBuffer.append("DATE MI " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_HOURS_MINUTES"))) {
                stringBuffer.append("DATE H " + this.mDateFields[0].getText() + " MI " + this.mDateFields[1].getText() + " 60");
            } else if (string.equals(this.getResString("IDS_DAYS_HOURS_MINUTES"))) {
                stringBuffer.append("DATE D " + this.mDateFields[0].getText() + " H " + this.mDateFields[1].getText() + " 24 MI " + this.mDateFields[2].getText() + " 60");
            } else if (string.equals(this.getResString("IDS_SECONDS"))) {
                stringBuffer.append("DATE S " + this.mDateFields[0].getText());
            } else if (string.equals(this.getResString("IDS_MINUTES_SECONDS"))) {
                stringBuffer.append("DATE MI " + this.mDateFields[0].getText() + " S " + this.mDateFields[1].getText() + " 60");
            } else if (string.equals(this.getResString("IDS_HOURS_MINUTES_SECONDS"))) {
                stringBuffer.append("DATE S " + this.mDateFields[2].getText() + " 60 MI " + this.mDateFields[1].getText() + " 60 H " + this.mDateFields[0].getText());
            } else if (string.equals(this.mNotDated)) {
                stringBuffer.append("DATE NONE");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        String string;
        this.mVarList.requestFocus();
        this.mVarList.setSelectedIndex(this.mInitIdx);
        if (this.mVarList.getModel().getSize() == this.mInitIdx + 1) {
            this.mVarList.ensureIndexIsVisible(this.mInitIdx);
        } else {
            this.mVarList.ensureIndexIsVisible(this.mInitIdx + 1);
        }
        Object e = this.mVarList.getSelectedValue();
        if (e != null && (string = e.toString()).toString().length() > 0) {
            if (string.equals(this.mNotDated) || string.equals(this.mCustom)) {
                this.mDatePanel.removeAll();
                this.mDatePanel.repaint();
            } else {
                this.changePanel(this.mDateMap.get(string));
                this.setDateFieldValues(this.getDateVarNames(this.mInitIdx));
            }
        }
    }

    @Override
    public String getIActionKey() {
        return "data_define_dates";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_datt";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.mVarList.getSelectedIndex();
        if (this.mVarList.getModel().getSize() - 1 == n) {
            this.mVarList.ensureIndexIsVisible(n);
        } else {
            this.mVarList.ensureIndexIsVisible(n + 1);
        }
        String string = this.mVarList.getSelectedValue().toString();
        if (string.toString().length() > 0) {
            if (string.equals(this.mNotDated) || string.equals(this.mCustom)) {
                this.mDatePanel.removeAll();
                this.mDateFields = null;
                this.setTabPolicy();
                this.mDatePanel.repaint();
            } else {
                this.changePanel(this.mDateMap.get(string));
            }
        }
        this.checkEmptyFields();
    }

    @Override
    protected void loadDialogState() {
        String string;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mSelectedIndex = dialogDataModel.getInteger("selection") != null ? dialogDataModel.getInteger("selection") : ((string = this.getSelectionFromTrendsInfo()) == null ? this.getIndexOfItem(this.mNotDated) : this.getIndexOfItem(string));
        this.mInitIdx = this.mSelectedIndex;
        this.mVarList.setSelectedIndex(this.mSelectedIndex);
        if (this.mVarList.getModel().getSize() - 1 == this.mSelectedIndex) {
            this.mVarList.ensureIndexIsVisible(this.mSelectedIndex);
        } else {
            this.mVarList.ensureIndexIsVisible(this.mSelectedIndex + 1);
        }
        if (this.mSelectedIndex != this.getIndexOfItem(this.mNotDated) && this.mSelectedIndex != this.getIndexOfItem(this.mCustom)) {
            this.setDateFieldValues(this.getDateVarNames(this.mSelectedIndex));
        }
        this.setPeriodicityLabel();
        this.setTabPolicy();
        this.checkEmptyFields();
        this.setVisible(true);
    }

    private String getSelectionFromTrendsInfo() {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        int n = iTrendsInfo.getNDateVars();
        if (n == 0) {
            return null;
        }
        Set<String> set = this.mDateMap.keySet();
        for (String string : set) {
            int n2;
            DateVariable[] dateVariableArray;
            DateType dateType = this.mDateMap.get(string);
            if (dateType == null || (dateVariableArray = dateType.getVariables()).length != n) continue;
            for (n2 = 0; n2 < dateVariableArray.length && (iTrendsInfo.getDateVarString(n2) + "_").equals(dateVariableArray[n2].getVariableName()) && iTrendsInfo.getDateVarPeriodicity(n2) == dateVariableArray[n2].getPeriodicity(); ++n2) {
            }
            if (n2 != n) continue;
            return string;
        }
        return null;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (this.mVarList.getSelectedIndex() != this.getIndexOfItem(this.mCustom)) {
            dialogDataModel.putInteger("selection", this.mVarList.getSelectedIndex());
        }
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        this.getOkButton().setEnabled(true);
        jPanel.remove(this.getPasteButton());
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.initSearchIndexMap();
        this.initDateMap();
        this.initShortTermDateVariables();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mNotDated = this.getResString("IDS_NOT_DATED");
        this.mCustom = this.getResString("IDS_CUSTOM");
        this.mVarList = new PlainList(DEFINE_DATES_SOURCE_LIST_KEY);
        this.mVarList.setSelectionMode(0);
        this.mVarList.setSerializable(false);
        this.mVarList.addListSelectionListener(this);
        this.mVarList.setMinimumSize(this.mVarList.getPreferredSize());
        this.mPeriodicityLabel = new JLabel("");
    }

    private String getFirstCaseValues(int n) {
        ISpssDataSrc iSpssDataSrc = null;
        iSpssDataSrc = this.getDataSource();
        IDataCache iDataCache = iSpssDataSrc.getCacheMgr();
        String string = "";
        OBS oBS = iDataCache.getCellValue(0L, n);
        if (oBS != null) {
            if (oBS.isEmpty()) {
                // empty if block
            }
            if (oBS.isString()) {
                string = iDataCache.getCellValue(0L, n).getString().trim();
            } else {
                int n2 = (int)iDataCache.getCellValue(0L, n).getNum();
                string = Integer.toString(n2);
            }
        }
        return string;
    }

    private String[] getDateVarNames(int n) {
        DateType dateType = this.mDateMap.get(this.mVarList.getModel().getElementAt(n));
        DateVariable[] dateVariableArray = dateType.getVariables();
        String[] stringArray = new String[dateVariableArray.length];
        for (int i = 0; i < dateVariableArray.length; ++i) {
            stringArray[i] = dateVariableArray[i].getVariableName();
        }
        return stringArray;
    }

    private void setDateFieldValues(String[] stringArray) {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        ISpssDataSrc iSpssDataSrc = null;
        iSpssDataSrc = this.getDataSource();
        IDataCache iDataCache = iSpssDataSrc.getCacheMgr();
        int n = iTrendsInfo.getNDateVars();
        if (n != 0 && !iTrendsInfo.getDateVarType(0).equals((Object)ITrendsInfo.DateVarTypes.e_CYCKEY)) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = iSpssDataSrc.findVarIndex(stringArray[i]);
                if (n2 == -1) {
                    this.mDateFields[i].setText("");
                    continue;
                }
                OBS oBS = iDataCache.getCellValue(0L, n2);
                if (oBS == null || oBS.isEmpty()) continue;
                int n3 = (int)iDataCache.getCellValue(0L, n2).getNum();
                this.mDateFields[i].setText(Integer.toString(n3));
            }
        }
    }

    private ISpssDataSrc getDataSource() {
        LocallyUniqueId locallyUniqueId = null;
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private ITrendsInfo getTrendsInfo() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        return iTrendsInfo;
    }

    private int getIndexOfItem(String string) {
        for (int i = 0; i < this.mVarList.getModel().getSize(); ++i) {
            if (!this.mVarList.getModel().getElementAt(i).equals(string)) continue;
            return i;
        }
        return this.mVarList.getModel().getSize() - 1;
    }

    private String[] getLabels() {
        String[] stringArray = this.mVarList.getSelectedValue().toString().split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains("(")) continue;
            int n = stringArray[i].indexOf("(");
            stringArray[i] = stringArray[i].substring(0, n);
        }
        return stringArray;
    }

    private void setPeriodicityLabel() {
        String string = "";
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        int n = iTrendsInfo.getNDateVars();
        String string2 = this.mVarList.getSelectedValue().toString();
        if (string2.equals(this.mCustom)) {
            ISpssDataSrc iSpssDataSrc = this.getDataSource();
            for (int i = 0; i < n; ++i) {
                int n2 = iTrendsInfo.getDateVarDSIndex(i);
                String string3 = iSpssDataSrc.getVariable(n2).getName();
                string3 = string3.substring(0, string3.length() - 1);
                String string4 = this.getFirstCaseValues(n2);
                int n3 = iTrendsInfo.getDateVarPeriodicity(i);
                string = i == 0 ? string + string3 + "(" + string4 + ")" : string + string3 + "(" + string4 + ";" + n3 + ")";
            }
        } else if (string2.equals(this.mNotDated)) {
            string = this.getResString("IDS_NONE_LABEL");
        } else {
            DateType dateType = this.mDateMap.get(string2);
            DateVariable[] dateVariableArray = dateType.getVariables();
            for (int i = 0; i < dateVariableArray.length; ++i) {
                if (i == 0) {
                    string = string + dateVariableArray[i].getUserName();
                    string = string + "(";
                    string = this.mDateFields[i].getText().equals("") ? string + "?" : string + this.mDateFields[i].getText();
                    string = string + ")";
                    continue;
                }
                string = string + dateVariableArray[i].getUserName();
                string = string + "(";
                string = this.mDateFields[i].getText().equals("") ? string + "?" : string + this.mDateFields[i].getText();
                string = string + ";";
                string = string + dateVariableArray[i].getPeriodicity();
                string = string + ")";
            }
        }
        this.mPeriodicityLabel.setText(string);
    }

    private boolean checkInitialValue() {
        for (int i = 0; i < this.mTextFieldCount; ++i) {
            int n = Integer.parseInt(this.mDateFields[i].getText());
            if (this.mDateVars[i].isValidValue(n)) continue;
            return true;
        }
        return false;
    }

    private void checkEmptyFields() {
        String string = this.mVarList.getSelectedValue().toString();
        if (string.equals(this.mNotDated) || string.equals(this.mCustom)) {
            this.enableOkPaste(true);
        } else {
            for (int i = 0; i < this.mTextFieldCount; ++i) {
                if (this.mDateFields[i].getText().equals("")) {
                    this.enableOkPaste(false);
                    break;
                }
                this.enableOkPaste(true);
            }
        }
    }

    private boolean canHaveZeroValue() {
        for (int i = 0; i < this.mDateVars.length; ++i) {
            if (this.canAcceptZeroValue(this.mDateVars[i].getUserLabel()) || Integer.parseInt(this.mDateFields[i].getText()) != 0) continue;
            return false;
        }
        return true;
    }

    private boolean isMonthQuarterConsistent() {
        int n = Integer.parseInt(this.mDateFields[2].getText());
        boolean bl = false;
        switch (Integer.parseInt(this.mDateFields[1].getText())) {
            case 1: {
                if (n <= 0 || n >= 4) break;
                bl = true;
            }
            case 2: {
                if (n <= 3 || n >= 7) break;
                bl = true;
            }
            case 3: {
                if (n <= 6 || n >= 10) break;
                bl = true;
            }
            case 4: {
                if (n <= 9 || n >= 13) break;
                bl = true;
            }
        }
        return bl;
    }

    private void initDateMap() {
        this.mDateMap = new HashMap<String, DateType>();
        int n = 0;
        String string = this.getResString("IDS_YEARS");
        String string2 = this.getResString("IDS_YEARS_QUARTERS");
        String string3 = this.getResString("IDS_YEARS_MONTH");
        String string4 = this.getResString("IDS_YEARS_QUARTERS_MONTHS");
        String string5 = this.getResString("IDS_DAYS");
        String string6 = this.getResString("IDS_WEEKS_DAYS");
        String string7 = this.getResString("IDS_WEEKS_WORKDAYS_5");
        String string8 = this.getResString("IDS_WEEKS_WORKDAYS_6");
        String string9 = this.getResString("IDS_HOURS");
        String string10 = this.getResString("IDS_DAYS_HOURS");
        String string11 = this.getResString("IDS_DAYS_WORKHOURS_8");
        String string12 = this.getResString("IDS_WEEK_DAYS_HOURS");
        String string13 = this.getResString("IDS_WEEK_WORKDAYS_HOURS");
        String string14 = this.getResString("IDS_MINUTES");
        String string15 = this.getResString("IDS_HOURS_MINUTES");
        String string16 = this.getResString("IDS_DAYS_HOURS_MINUTES");
        String string17 = this.getResString("IDS_SECONDS");
        String string18 = this.getResString("IDS_MINUTES_SECONDS");
        String string19 = this.getResString("IDS_HOURS_MINUTES_SECONDS");
        DateType dateType = new DateType(new DateVariable[]{new YearDateVariable(0)});
        this.mDateMap.put(string, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new QuarterDateVariable(4)});
        this.mDateMap.put(string2, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string2);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new MonthDateVariable(12)});
        this.mDateMap.put(string3, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string3);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new QuarterDateVariable(4), new MonthDateVariable(12)});
        this.mDateMap.put(string4, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string4);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0)});
        this.mDateMap.put(string5, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string5);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(7)});
        this.mDateMap.put(string6, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string6);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(5)});
        this.mDateMap.put(string7, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string7);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(6)});
        this.mDateMap.put(string8, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string8);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0)});
        this.mDateMap.put(string9, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string9);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(24)});
        this.mDateMap.put(string10, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string10);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(8)});
        this.mDateMap.put(string11, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string11);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(7), new HourDateVariable(24)});
        this.mDateMap.put(string12, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string12);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(5), new HourDateVariable(8)});
        this.mDateMap.put(string13, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string13);
        dateType = new DateType(new DateVariable[]{new MinuteDateVariable(0)});
        this.mDateMap.put(string14, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string14);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0), new MinuteDateVariable(60)});
        this.mDateMap.put(string15, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string15);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(24), new MinuteDateVariable(60)});
        this.mDateMap.put(string16, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string16);
        dateType = new DateType(new DateVariable[]{new SecondDateVariable(0)});
        this.mDateMap.put(string17, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string17);
        dateType = new DateType(new DateVariable[]{new MinuteDateVariable(0), new SecondDateVariable(60)});
        this.mDateMap.put(string18, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string18);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0), new MinuteDateVariable(60), new SecondDateVariable(60)});
        this.mDateMap.put(string19, dateType);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, string19);
        this.mDateMap.put(this.mNotDated, null);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, this.mNotDated);
        this.mDateMap.put(this.mCustom, null);
        ((DefaultListModel)this.mVarList.getModel()).add(n++, this.mCustom);
    }

    private void changePanel(DateType dateType) {
        this.mDatePanel.removeAll();
        DateVariable[] dateVariableArray = dateType.getVariables();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        this.mTextFieldCount = dateVariableArray.length;
        DialogUtil.addUsingGBL(this.mDatePanel, this.mPeriodLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        this.mDateFields = new IntTextField[this.mTextFieldCount];
        for (int i = 0; i < this.mTextFieldCount; ++i) {
            this.mDateFields[i] = new IntTextField();
            this.mDateFields[i].setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        }
        Dimension dimension = this.getLabelSize();
        for (int i = 0; i < dateVariableArray.length; ++i) {
            JLabel jLabel;
            if (i == dateVariableArray.length - 1) {
                gridBagConstraints.weighty = 1.0;
            }
            JLabel jLabel2 = new JLabel(dateVariableArray[i].getUserLabel());
            jLabel2.setPreferredSize(dimension);
            jLabel2.setMinimumSize(dimension);
            jLabel2.setMaximumSize(dimension);
            insets = new Insets(n, n / 2, 0, n / 2);
            DialogUtil.addUsingGBL(this.mDatePanel, jLabel2, gridBagConstraints, 0, i + 1, 1, 1, n2, insets);
            int n3 = dateVariableArray[i].getPeriodicity();
            this.mDateFields[i].setMinimumSize(this.mDateFields[i].getPreferredSize());
            this.mDateFields[i].setColumns(4);
            this.mDateFields[i].getDocument().addDocumentListener(this);
            this.mDateFields[i].setText(dateVariableArray[i].getDefaultValue());
            gridBagConstraints.gridwidth = 1;
            insets = new Insets(n, 0, 0, 0);
            DialogUtil.addUsingGBL(this.mDatePanel, (JComponent)this.mDateFields[i], gridBagConstraints, 1, i + 1, 1, 1, n2, insets);
            if (n3 == 0) {
                jLabel = new JLabel("");
                continue;
            }
            jLabel = new JLabel(String.valueOf(dateVariableArray[i].getPeriodicity()));
            Insets insets2 = new Insets(n, 4 * n, 0, 0);
            DialogUtil.addUsingGBL(this.mDatePanel, jLabel, gridBagConstraints, 2, i + 1, 1, 1, n2, insets2);
        }
        this.mDatePanel.validate();
        this.mDatePanel.repaint();
        this.setTabPolicy();
    }

    private Dimension getLabelSize() {
        String[] stringArray = new String[]{this.getResString("IDS_YEAR_LABEL"), this.getResString("IDS_QUARTER_LABEL"), this.getResString("IDS_MONTH_LABEL"), this.getResString("IDS_WEEK_LABEL"), this.getResString("IDS_DAY_LABEL"), this.getResString("IDS_HOUR_LABEL"), this.getResString("IDS_MINUTE_LABEL"), this.getResString("IDS_MINUTE_LABEL"), this.getResString("IDS_SECOND_LABEL")};
        int n = 0;
        int n2 = 20;
        JLabel jLabel = new JLabel("");
        for (int i = 0; i < stringArray.length; ++i) {
            jLabel.setText(stringArray[i]);
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            int n3 = fontMetrics.stringWidth(jLabel.getText());
            if (n3 <= n) continue;
            n = n3;
        }
        return new Dimension(n += 10, n2);
    }

    private boolean canAcceptZeroValue(String string) {
        return this.mShortTermDateVariables.contains(string);
    }

    private JPanel setupDatePanel() {
        this.mPeriodLabel = new JTextArea(this.getResString("IDS_HIGH_PERIOD_LABEL"));
        this.mPeriodLabel.setLineWrap(true);
        this.mPeriodLabel.setWrapStyleWord(true);
        this.mPeriodLabel.setBorder(null);
        this.mPeriodLabel.setOpaque(false);
        this.mPeriodLabel.setFocusable(false);
        this.mDatePanel = PanelFactory.getEmptyPanel(this.getResString("IDS_FIRST_CASE_IS"));
        int n = 200;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 250;
        }
        this.mDatePanel.setMinimumSize(new Dimension(n, 140));
        this.mDatePanel.setPreferredSize(new Dimension(n, 140));
        this.mDatePanel.setMaximumSize(new Dimension(n, 140));
        return this.mDatePanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CASES_ARE");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mVarList);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setSize(new Dimension(180, 200));
        jViewport.setViewPosition(new Point(0, 10));
        jViewport.setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(180, 200));
        jLabel.setLabelFor(this.mVarList);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        int n3 = DialogUtil.getComponentGroupGap();
        insets = new Insets(n2, n3, 0, 0);
        gridBagConstraints.weighty = 0.0;
        n = 19;
        DialogUtil.addUsingGBL(jPanel, this.setupDatePanel(), gridBagConstraints, 1, 0, 1, 4, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(this.getResString("IDS_CURRENT_DATES_LABEL"), 10);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 6, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mPeriodicityLabel, gridBagConstraints, 0, 7, 2, 1, n, null);
    }

    private void setTabPolicy() {
        this.setFocusTraversalPolicy(new DefineDatesFocusPolicy());
    }

    private void initSearchIndexMap() {
        this.mSearchMap = new HashMap();
        this.mSearchMap.put(2, 0);
        this.mSearchMap.put(234, 1);
        this.mSearchMap.put(2412, 2);
        this.mSearchMap.put(23412, 3);
        this.mSearchMap.put(6, 4);
        this.mSearchMap.put(567, 5);
        this.mSearchMap.put(565, 6);
        this.mSearchMap.put(566, 7);
        this.mSearchMap.put(7, 8);
        this.mSearchMap.put(6724, 9);
        this.mSearchMap.put(678, 10);
        this.mSearchMap.put(56724, 11);
        this.mSearchMap.put(5678, 12);
        this.mSearchMap.put(8, 13);
        this.mSearchMap.put(7860, 14);
        this.mSearchMap.put(67860, 15);
        this.mSearchMap.put(9, 16);
        this.mSearchMap.put(8960, 17);
        this.mSearchMap.put(78960, 18);
        this.mSearchMap.put(0, 19);
        this.mSearchMap.put(1, 20);
    }

    private void initShortTermDateVariables() {
        this.mShortTermDateVariables = new HashSet<String>();
        this.mShortTermDateVariables.add(this.getResString("IDS_HOUR_LABEL"));
        this.mShortTermDateVariables.add(this.getResString("IDS_MINUTE_LABEL"));
        this.mShortTermDateVariables.add(this.getResString("IDS_SECOND_LABEL"));
    }

    private class SecondDateVariable
    extends DateVariable {
        public SecondDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_SECOND_LABEL"), DefineDatesDlg.this.getResString("IDS_SECOND"), "0", "SECOND_", n);
        }
    }

    private class MinuteDateVariable
    extends DateVariable {
        public MinuteDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_MINUTE_LABEL"), DefineDatesDlg.this.getResString("IDS_MINUTE"), "0", "MINUTE_", n);
        }
    }

    private class HourDateVariable
    extends DateVariable {
        public HourDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_HOUR_LABEL"), DefineDatesDlg.this.getResString("IDS_HOUR"), "0", "HOUR_", n);
        }
    }

    private class DayDateVariable
    extends DateVariable {
        public DayDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_DAY_LABEL"), DefineDatesDlg.this.getResString("IDS_DAY"), "1", "DAY_", n);
        }
    }

    private class WeekDateVariable
    extends DateVariable {
        public WeekDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_WEEK_LABEL"), DefineDatesDlg.this.getResString("IDS_WEEK"), "1", "WEEK_", n);
        }
    }

    private class MonthDateVariable
    extends DateVariable {
        public MonthDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_MONTH_LABEL"), DefineDatesDlg.this.getResString("IDS_MONTH"), "1", "MONTH_", n);
        }
    }

    private class QuarterDateVariable
    extends DateVariable {
        public QuarterDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_QUARTER_LABEL"), DefineDatesDlg.this.getResString("IDS_QUARTER"), "1", "QUARTER_", n);
        }
    }

    private class YearDateVariable
    extends DateVariable {
        public YearDateVariable(int n) {
            super(DefineDatesDlg.this.getResString("IDS_YEAR_LABEL"), DefineDatesDlg.this.getResString("IDS_YEAR"), "1900", "YEAR_", n);
        }
    }

    public class DefineDatesFocusPolicy
    extends FocusTraversalPolicy {
        private List<Component> mComponents = new ArrayList<Component>();

        public DefineDatesFocusPolicy() {
            this.buildComponentList();
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            this.buildComponentList();
            int n = this.mComponents.indexOf(component);
            n = n == this.mComponents.size() - 1 ? 0 : ++n;
            Component component2 = this.mComponents.get(n);
            if (component2.isEnabled()) {
                return component2;
            }
            return this.getComponentAfter(container, component2);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            this.buildComponentList();
            int n = this.mComponents.indexOf(component);
            n = n == 0 ? this.mComponents.size() - 1 : --n;
            Component component2 = this.mComponents.get(n);
            if (component2.isEnabled()) {
                return component2;
            }
            return this.getComponentAfter(container, component2);
        }

        @Override
        public Component getFirstComponent(Container container) {
            this.buildComponentList();
            return this.mComponents.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            this.buildComponentList();
            return this.mComponents.get(0);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            this.buildComponentList();
            return this.mComponents.get(0);
        }

        private void buildComponentList() {
            int n;
            this.mComponents.clear();
            this.mComponents.add(DefineDatesDlg.this.mVarList);
            if (DefineDatesDlg.this.mDateFields != null && DefineDatesDlg.this.mDateFields.length != 0) {
                IntTextField[] intTextFieldArray = DefineDatesDlg.this.mDateFields;
                n = intTextFieldArray.length;
                for (int i = 0; i < n; ++i) {
                    IntTextField intTextField = intTextFieldArray[i];
                    this.mComponents.add((Component)intTextField);
                }
            }
            int n2 = DefineDatesDlg.this.mCmdButtonPanel.getComponentCount();
            for (n = 0; n < n2; ++n) {
                this.mComponents.add(DefineDatesDlg.this.mCmdButtonPanel.getComponent(n));
            }
        }
    }
}

