/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.copy_data_properties;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesAbstractPage;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class CopyDataPropertiesWelcomePage
extends CopyDataPropertiesAbstractPage
implements ItemListener {
    private JRadioButton mActiveDatasetButton;
    private JButton mBrowseButton;
    private List<LocallyUniqueId> mDatasetIds;
    private Vector<String> mDatasetTitles;
    HashMap<String, LocallyUniqueId> mMapOfDatasetTitlesToDatasetIds;
    private FileTextField mFilePathField;
    private JList mOpenDatasetList;
    private JRadioButton mOpenDatasetsButton;
    private JRadioButton mOpenExternalButton;
    private List<ISpssVariable> mRemoteFileVariables;
    private LocallyUniqueId mSelectedDataSet;
    private DialogFocusTraversalPolicy mPolicy;
    private boolean mNextPageFirstTime = true;
    private String mPassword;

    public CopyDataPropertiesWelcomePage(CopyDataPropertiesDlg copyDataPropertiesDlg) {
        super("step1", "IDS_COPY_DATA_PROPERTRIES_STEP1_TITLE", copyDataPropertiesDlg);
    }

    public String getExternalFilename() {
        return this.mFilePathField.getText();
    }

    @Override
    public String getNextPage() {
        if (this.mNextPageFirstTime) {
            this.getDialog().getChooseSourcePage().setDefaultStates();
            this.mNextPageFirstTime = false;
        }
        this.getDialog().getChooseSourcePage().setDefaults();
        return "step2";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cdpstart";
    }

    public List<ISpssVariable> getRemoteFileVariables() {
        return this.mRemoteFileVariables;
    }

    public LocallyUniqueId getSelectedDataSet() {
        return this.mSelectedDataSet;
    }

    @Override
    public boolean hasNextPage() {
        return this.mOpenDatasetsButton.isSelected() ? !this.mDatasetTitles.isEmpty() && this.mOpenDatasetList.getSelectedIndex() != -1 : true;
    }

    public boolean isActiveDatasetButtonSelected() {
        return this.mActiveDatasetButton.isSelected();
    }

    @Override
    public boolean isLastPage() {
        return this.mOpenDatasetsButton.isSelected() ? !this.mDatasetTitles.isEmpty() && this.mOpenDatasetList.getSelectedIndex() != -1 : true;
    }

    public boolean isOpenDatasetsButtonSelected() {
        return this.mOpenDatasetsButton.isSelected();
    }

    public boolean isOpenExternalDatasetButtonSelected() {
        return this.mOpenExternalButton.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() == this.mOpenDatasetsButton) {
                this.mOpenDatasetList.setEnabled(true);
                this.mFilePathField.setEnabled(false);
                this.mFilePathField.setOpaque(false);
                this.mBrowseButton.setEnabled(false);
                this.getDialog().enableNext(this.mOpenDatasetList.getSelectedIndex() != -1);
                this.getDialog().enableFinish(false);
            } else if (itemEvent.getItem() == this.mOpenExternalButton) {
                this.mOpenDatasetList.setEnabled(false);
                this.mFilePathField.setEnabled(true);
                this.mFilePathField.setOpaque(true);
                this.mBrowseButton.setEnabled(true);
                this.getDialog().enableNext(true);
                this.getDialog().enableFinish(true);
            } else {
                this.mOpenDatasetList.setEnabled(false);
                this.mFilePathField.setEnabled(false);
                this.mFilePathField.setOpaque(false);
                this.mBrowseButton.setEnabled(false);
                this.getDialog().enableNext(true);
                this.getDialog().enableFinish(false);
                this.mSelectedDataSet = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean validate() {
        if (!this.mOpenExternalButton.isSelected()) {
            return true;
        }
        this.mRemoteFileVariables = new ArrayList<ISpssVariable>();
        if (this.mFilePathField.getText().equals("") && !this.openRemoteFile()) {
            return false;
        }
        String string = this.mFilePathField.getText();
        Vector<Object> vector = new Vector();
        DocUtil.DataEncryptionTestResults dataEncryptionTestResults = DocUtil.testOpenEncryptedData(((CopyDataPropertiesDlg)this.mWizardDialog).getParentFrame(), string);
        boolean bl = dataEncryptionTestResults.isCanContinue();
        if (bl) {
            short s = 0;
            if (dataEncryptionTestResults.getVarBlocks() != null) {
                vector = dataEncryptionTestResults.getVarBlocks();
            } else {
                s = SysFileProxy.getSysFileProxy().getSysFileVarInfo(string, vector);
            }
            if (s != 0) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.getDialog()), String.format(this.getResString("ERR_FILE_OPENING_ERROR_MSG"), string), VersionInfo.getAppVersionString());
                return false;
            }
            this.mPassword = dataEncryptionTestResults.getMangledPassword();
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            Iterator<Object> iterator = vector.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                VariableBlock variableBlock = (VariableBlock)iterator.next();
                ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                ISpssVariable iSpssVariable = iSpssDataSrc.makeVariable(variableBlock.getDiType(), returnIndex);
                iSpssVariable.setName(variableBlock.getVarName());
                iSpssVariable.setLabel(variableBlock.getVarLabel());
                iSpssVariable.setMeasurementLevel(variableBlock.getVarLevel());
                this.mRemoteFileVariables.add(iSpssVariable);
            }
        }
        if (dataEncryptionTestResults.isPasswordDlgOKPressed()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.getDialog()), String.format(this.getResString("ERR_FILE_OPENING_ERROR_MSG"), string), VersionInfo.getAppVersionString());
        }
        return false;
    }

    @Override
    protected void aboutToShowPanel() {
        if (this.mDatasetTitles.isEmpty()) {
            this.mOpenExternalButton.requestFocus();
        } else {
            this.mOpenDatasetsButton.requestFocus();
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
    }

    @Override
    protected void initVars() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        IDataDocument iDataDocument = dataMgr.findDataDocument(locallyUniqueId);
        this.mDatasetIds = new ArrayList<LocallyUniqueId>();
        this.mDatasetTitles = new Vector();
        this.mMapOfDatasetTitlesToDatasetIds = new HashMap();
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            if (!(spssFrame instanceof DataFrame) || ((DataFrame)spssFrame).getDatasetId() == locallyUniqueId) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            LocallyUniqueId locallyUniqueId2 = dataFrame.getDatasetId();
            this.mDatasetIds.add(locallyUniqueId2);
            IDataDocument iDataDocument2 = dataMgr.findDataDocument(locallyUniqueId2);
            String string = iDataDocument2.getDocName() + " [" + iDataDocument2.getDatasetName() + "]";
            this.mDatasetTitles.add(string);
            this.mMapOfDatasetTitlesToDatasetIds.put(string, locallyUniqueId2);
            Collections.sort(this.mDatasetTitles);
        }
        this.mOpenDatasetsButton = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_OPEN_DATASET"));
        this.mOpenExternalButton = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_OPEN_EXTERNAL_DATASET"));
        this.mActiveDatasetButton = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_ACTIVE_DATASET"));
        this.mOpenDatasetsButton.addItemListener(this);
        this.mOpenExternalButton.addItemListener(this);
        this.mActiveDatasetButton.addItemListener(this);
        if (iDataDocument != null) {
            this.mActiveDatasetButton.setText(this.mActiveDatasetButton.getText() + " ( " + iDataDocument.getDocName() + " [" + iDataDocument.getDatasetName() + "]" + " )");
        }
        this.mOpenDatasetList = new JList<String>(this.mDatasetTitles);
        this.mOpenDatasetList.setSelectionMode(0);
        this.mOpenDatasetList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CopyDataPropertiesWelcomePage.this.mOpenDatasetList.getSelectedIndex();
                if (n != -1) {
                    CopyDataPropertiesWelcomePage.this.getDialog().enableNext(true);
                    CopyDataPropertiesWelcomePage.this.mSelectedDataSet = CopyDataPropertiesWelcomePage.this.mMapOfDatasetTitlesToDatasetIds.get(CopyDataPropertiesWelcomePage.this.mOpenDatasetList.getSelectedValue().toString());
                } else {
                    CopyDataPropertiesWelcomePage.this.getDialog().enableNext(false);
                    CopyDataPropertiesWelcomePage.this.mSelectedDataSet = null;
                }
            }
        });
        this.mFilePathField = new FileTextField();
        this.mFilePathField.setDocument(new FixedLengthDocument(30000));
        this.mFilePathField.setColumns(0);
        this.mFilePathField.setFocusable(true);
        this.mBrowseButton = new JButton(new ToggleButtonAction(this.getDialog(), "IDS_BROWSE_BUTTON"));
        this.mBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CopyDataPropertiesWelcomePage.this.openRemoteFile();
            }
        });
        if (this.mDatasetTitles.isEmpty()) {
            this.mOpenDatasetsButton.setEnabled(false);
        }
        if (iDataDocument == null || iDataDocument.isDocumentEmpty()) {
            this.mActiveDatasetButton.setEnabled(false);
        }
        this.setTabTraversalOrder();
    }

    protected boolean openRemoteFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_SPSS_DATAFILE_FILTER"), this.getResString("IDS_SPSS_DATAFILE_EXT"));
        remoteFileChooser.setApproveButtonText(this.getResString("IDS_SPSS_DATAFILE_OPEN"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this.getDialog()));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            this.mFilePathField.setText(remoteFileChooser.getSelectedFilePath());
            return true;
        }
        return false;
    }

    @Override
    protected void setDefaults() {
        boolean bl = this.mDatasetTitles.isEmpty();
        this.mOpenDatasetsButton.setSelected(!bl);
        this.mOpenExternalButton.setSelected(bl);
        this.mOpenDatasetList.setEnabled(!bl);
        this.mFilePathField.setEnabled(bl);
        this.mFilePathField.setOpaque(bl);
        this.mBrowseButton.setEnabled(bl);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupSelectDataSourcePanel(), gridBagConstraints, 0, 0, 1, 1, 23, null);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP1_WELCOME")), gridBagConstraints, 1, 0, 1, 1, 23, insets);
        insets = (Insets)insets.clone();
        insets.top = DialogUtil.getComponentGroupGap();
        insets.bottom = 0;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP1_MESSAGE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(280, 115));
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(imageIcon), gridBagConstraints, 0, 1, 1, 1, 10, insets);
        return jPanel;
    }

    protected JPanel setupSelectDataSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CHOOSE_SOURCE")));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetsButton, gridBagConstraints, 0, 0, 2, 1, 19, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOpenExternalButton, gridBagConstraints, 0, 2, 2, 1, 19, insets);
        DialogUtil.addUsingGBL(jPanel, this.mActiveDatasetButton, gridBagConstraints, 0, 4, 2, 1, 19, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets.left = DialogUtil.getComponentGroupGap() * 2;
        insets.bottom = DialogUtil.getComponentGroupGap() * 2;
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(this.mOpenDatasetList), gridBagConstraints, 0, 1, 1, 1, 19, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.top = DialogUtil.getComponentGroupGap() - 4;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathField), gridBagConstraints, 0, 3, 1, 1, 19, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.left = DialogUtil.getStandardControlInsets().left;
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 3, 1, 1, 19, insets);
        this.setDefaults();
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOpenDatasetsButton);
        spssButtonGroup.add(this.mOpenExternalButton);
        spssButtonGroup.add(this.mActiveDatasetButton);
        vector.add(spssButtonGroup);
        vector.add(this.mFilePathField);
        vector.add(this.mBrowseButton);
        Vector<Object> vector2 = ((CopyDataPropertiesDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    public String getPassword() {
        return this.mPassword;
    }
}

