/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.copy_data_properties;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.IExtension;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.messages.sysfilemsg.SystemFileSetsResponse;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesAbstractPage;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class CopyDataPropertiesDatasetPage
extends CopyDataPropertiesAbstractPage
implements ItemListener {
    private JCheckBox mCustomAttributesCheckbox;
    private JRadioButton mCustomAttributesMerge;
    private JRadioButton mCustomAttributesReplace;
    private JCheckBox mDocumentsCheckbox;
    private JRadioButton mDocumentsMerge;
    private JRadioButton mDocumentsReplace;
    private JCheckBox mFileLabel;
    private JCheckBox mMultipleResponseSetsCheckbox;
    private JRadioButton mMultipleResponseSetsMerge;
    private JRadioButton mMultipleResponseSetsReplace;
    private int mNoOfBoxesChecked;
    private JCheckBox mVariableSetsCheckbox;
    private JRadioButton mVariableSetsMerge;
    private JRadioButton mVariableSetsReplace;
    private JCheckBox mWeightSpecification;
    private DialogFocusTraversalPolicy mPolicy;

    public CopyDataPropertiesDatasetPage(CopyDataPropertiesDlg copyDataPropertiesDlg) {
        super("step4", "IDS_COPY_DATA_PROPERTRIES_STEP4_TITLE", copyDataPropertiesDlg);
    }

    public boolean areCustomAttributesToReplace() {
        return this.mCustomAttributesReplace.isSelected();
    }

    public boolean areDocumentsToReplace() {
        return this.mDocumentsReplace.isSelected();
    }

    public boolean areMultipleResponseSetsToReplace() {
        return this.mMultipleResponseSetsReplace.isSelected();
    }

    public boolean areVariableSetsToReplace() {
        return this.mVariableSetsReplace.isSelected();
    }

    @Override
    public String getNextPage() {
        return "step5";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cdpdatasetprop";
    }

    public int getNoOfBoxesChecked() {
        return this.mNoOfBoxesChecked;
    }

    public boolean isCustomAttributesEnabledAndSelected() {
        return this.mCustomAttributesCheckbox.isSelected() && this.mCustomAttributesCheckbox.isEnabled();
    }

    public boolean isDocumentsEnabledAndSelected() {
        return this.mDocumentsCheckbox.isSelected() && this.mDocumentsCheckbox.isEnabled();
    }

    public boolean isFileLabelEnabledAndSelected() {
        return this.mFileLabel.isSelected() && this.mFileLabel.isEnabled();
    }

    public boolean isMultipleResponseSetsEnabledAndSelected() {
        return this.mMultipleResponseSetsCheckbox.isSelected() && this.mMultipleResponseSetsCheckbox.isEnabled();
    }

    public boolean isVariableSetsEnabledAndSelected() {
        return this.mVariableSetsCheckbox.isSelected() && this.mVariableSetsCheckbox.isEnabled();
    }

    public boolean isWeightSpecificationEnabledAndSelected() {
        return this.mWeightSpecification.isSelected() && this.mWeightSpecification.isEnabled();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && ((JCheckBox)itemEvent.getSource()).isEnabled()) {
            ++this.mNoOfBoxesChecked;
        } else if (itemEvent.getStateChange() == 2 && ((JCheckBox)itemEvent.getSource()).isEnabled()) {
            --this.mNoOfBoxesChecked;
        }
        this.checkConditionsAndEnableFinish();
    }

    @Override
    protected void aboutToHidePanel() {
        this.getDialog().getFinishPage().setDefaults();
    }

    @Override
    protected void aboutToShowPanel() {
        this.checkConditionsAndEnableFinish();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
    }

    @Override
    protected void initVars() {
        this.mMultipleResponseSetsCheckbox = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_MULTIPLE_RESPONSE_SETS"));
        this.mMultipleResponseSetsReplace = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_REPLACE_RADIO"));
        this.mMultipleResponseSetsMerge = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_MERGE_RADIO"));
        this.mMultipleResponseSetsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1 && CopyDataPropertiesDatasetPage.this.mMultipleResponseSetsCheckbox.isEnabled();
                CopyDataPropertiesDatasetPage.this.mMultipleResponseSetsReplace.setEnabled(bl);
                CopyDataPropertiesDatasetPage.this.mMultipleResponseSetsMerge.setEnabled(bl);
            }
        });
        this.mVariableSetsCheckbox = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_VARIABLE_SETS"));
        this.mVariableSetsReplace = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_REPLACE_RADIO"));
        this.mVariableSetsMerge = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_MERGE_RADIO"));
        this.mVariableSetsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1 && CopyDataPropertiesDatasetPage.this.mVariableSetsCheckbox.isEnabled();
                CopyDataPropertiesDatasetPage.this.mVariableSetsReplace.setEnabled(bl);
                CopyDataPropertiesDatasetPage.this.mVariableSetsMerge.setEnabled(bl);
            }
        });
        this.mDocumentsCheckbox = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_DATASET_DOCUMENTS"));
        this.mDocumentsReplace = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_REPLACE_RADIO"));
        this.mDocumentsMerge = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_MERGE_RADIO"));
        this.mDocumentsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1 && CopyDataPropertiesDatasetPage.this.mDocumentsCheckbox.isEnabled();
                CopyDataPropertiesDatasetPage.this.mDocumentsReplace.setEnabled(bl);
                CopyDataPropertiesDatasetPage.this.mDocumentsMerge.setEnabled(bl);
            }
        });
        this.mCustomAttributesCheckbox = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_DATASET_CUSTOM_ATTRIBUTES"));
        this.mCustomAttributesReplace = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_REPLACE_RADIO"));
        this.mCustomAttributesMerge = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_MERGE_RADIO"));
        this.mCustomAttributesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1 && CopyDataPropertiesDatasetPage.this.mCustomAttributesCheckbox.isEnabled();
                CopyDataPropertiesDatasetPage.this.mCustomAttributesReplace.setEnabled(bl);
                CopyDataPropertiesDatasetPage.this.mCustomAttributesMerge.setEnabled(bl);
            }
        });
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mMultipleResponseSetsCheckbox);
        spssButtonGroup.add(this.mVariableSetsCheckbox);
        spssButtonGroup.add(this.mDocumentsCheckbox);
        spssButtonGroup.add(this.mCustomAttributesCheckbox);
        this.mWeightSpecification = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_WEIGHT_SPECIFICATION"));
        this.mFileLabel = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_FILE_LABEL"));
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mWeightSpecification);
        spssButtonGroup2.add(this.mFileLabel);
        this.mMultipleResponseSetsCheckbox.addItemListener(this);
        this.mVariableSetsCheckbox.addItemListener(this);
        this.mDocumentsCheckbox.addItemListener(this);
        this.mCustomAttributesCheckbox.addItemListener(this);
        this.mWeightSpecification.addItemListener(this);
        this.mFileLabel.addItemListener(this);
        this.setTabTraversalOrder();
    }

    @Override
    protected void setDefaults() {
        if (this.getDialog().getWelcomePage().isActiveDatasetButtonSelected()) {
            this.mMultipleResponseSetsCheckbox.setEnabled(false);
            this.mMultipleResponseSetsReplace.setEnabled(false);
            this.mMultipleResponseSetsMerge.setEnabled(false);
            this.mVariableSetsCheckbox.setEnabled(false);
            this.mVariableSetsReplace.setEnabled(false);
            this.mVariableSetsMerge.setEnabled(false);
            this.mDocumentsCheckbox.setEnabled(false);
            this.mDocumentsReplace.setEnabled(false);
            this.mDocumentsMerge.setEnabled(false);
            this.mCustomAttributesCheckbox.setEnabled(false);
            this.mCustomAttributesReplace.setEnabled(false);
            this.mCustomAttributesMerge.setEnabled(false);
            this.mWeightSpecification.setEnabled(false);
            this.mFileLabel.setEnabled(false);
        } else {
            this.mMultipleResponseSetsCheckbox.setEnabled(this.areMultipleResponseSetsValid());
            this.mMultipleResponseSetsReplace.setEnabled(this.areMultipleResponseSetsValid());
            this.mMultipleResponseSetsMerge.setEnabled(this.areMultipleResponseSetsValid());
            this.mVariableSetsCheckbox.setEnabled(this.areVariableSetsValid());
            this.mVariableSetsReplace.setEnabled(this.mVariableSetsCheckbox.isSelected() && this.mVariableSetsCheckbox.isEnabled());
            this.mVariableSetsMerge.setEnabled(this.mVariableSetsCheckbox.isSelected() && this.mVariableSetsCheckbox.isEnabled());
            this.mDocumentsCheckbox.setEnabled(this.areDocumentsValid());
            this.mDocumentsReplace.setEnabled(this.areDocumentsValid());
            this.mDocumentsMerge.setEnabled(this.areDocumentsValid());
            this.mCustomAttributesCheckbox.setEnabled(this.areCustomAttributesValid());
            this.mCustomAttributesReplace.setEnabled(this.areCustomAttributesValid());
            this.mCustomAttributesMerge.setEnabled(this.areCustomAttributesValid());
            this.mWeightSpecification.setEnabled(this.isWeightSpecificationValid());
            this.mFileLabel.setEnabled(this.isFileLabelValid());
        }
    }

    public void setDefaultStates() {
        this.mMultipleResponseSetsReplace.setSelected(true);
        this.mVariableSetsReplace.setSelected(true);
        this.mDocumentsReplace.setSelected(true);
        this.mCustomAttributesReplace.setSelected(true);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupPropertiesToCopyPanel(), gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardDialogInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 0, 1, 2, 23, DialogUtil.getStandardDialogInsets());
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP4_WELCOME")), gridBagConstraints, 0, 0, 2, 1, 21, null);
        Insets insets = new Insets(DialogUtil.getStandardDialogInsets().top, 0, DialogUtil.getStandardDialogInsets().bottom, 0);
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP4_WELCOME2")), gridBagConstraints, 0, 1, 2, 1, 21, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP4_MESSAGE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(280, 90));
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 2, 1, 1, 21, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(imageIcon), gridBagConstraints, 0, 2, 1, 1, 23, null);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMultipleResponseSetsCheckbox);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mMultipleResponseSetsReplace);
        spssButtonGroup.add(this.mMultipleResponseSetsMerge);
        vector.add(spssButtonGroup);
        vector.add(this.mVariableSetsCheckbox);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mVariableSetsReplace);
        spssButtonGroup.add(this.mVariableSetsMerge);
        vector.add(spssButtonGroup);
        vector.add(this.mDocumentsCheckbox);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDocumentsReplace);
        spssButtonGroup.add(this.mDocumentsMerge);
        vector.add(spssButtonGroup);
        vector.add(this.mCustomAttributesCheckbox);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCustomAttributesReplace);
        spssButtonGroup.add(this.mCustomAttributesMerge);
        vector.add(spssButtonGroup);
        vector.add(this.mWeightSpecification);
        vector.add(this.mFileLabel);
        Vector<Object> vector2 = ((CopyDataPropertiesDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private boolean areCustomAttributesValid() {
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            IDatasourceAttributes iDatasourceAttributes = iSpssDataSrc.getAttributes();
            return iDatasourceAttributes != null && iDatasourceAttributes.size() > 0;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        DatasourceAttributes datasourceAttributes = new DatasourceAttributes();
        sysFileProxy.getFileAttributesInfo(this.getDialog().getWelcomePage().getExternalFilename(), datasourceAttributes, this.getDialog().getWelcomePage().getPassword());
        return datasourceAttributes.size() > 0;
    }

    private boolean areDocumentsValid() {
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            IExtension iExtension = iSpssDataSrc.getExtension(ExtensionType.kDocument);
            return iExtension != null && iExtension.length() > 0L;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        Vector vector = new Vector();
        sysFileProxy.getSysDocumentInfo(this.getDialog().getWelcomePage().getExternalFilename(), vector, this.getDialog().getWelcomePage().getPassword());
        return vector.size() > 0;
    }

    private boolean areMultipleResponseSetsValid() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc2 = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            Vector vector = iSpssDataSrc2.getVariableSets(ISpssDataSrc.VarSetsType.kMultipleResponseSets);
            for (IVariableSet iVariableSet : vector) {
                boolean bl = true;
                for (String string : iVariableSet.getVariableNames()) {
                    if (iSpssDataSrc.findVarIndex(string) != -1) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        Vector vector = new Vector();
        sysFileProxy.getSysSetVarInfo(this.getDialog().getWelcomePage().getExternalFilename(), vector, 1, this.getDialog().getWelcomePage().getPassword());
        SrcVariableList srcVariableList = this.getDialog().getChooseSourcePage().getSelectedSourceList();
        ISpssVariable[] iSpssVariableArray = srcVariableList.getSelectedValues();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            arrayList.add(iSpssVariable.getName());
        }
        for (SystemFileSetsResponse.SetBlock setBlock : vector) {
            int n = 1;
            for (VariableBlock variableBlock : setBlock.mVarList) {
                String string = variableBlock.getVarName();
                if (arrayList.contains(string)) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            return true;
        }
        return false;
    }

    private boolean areVariableSetsValid() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc2 = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            Vector vector = iSpssDataSrc2.getVariableSets(ISpssDataSrc.VarSetsType.kVariableSet);
            for (IVariableSet iVariableSet : vector) {
                if (iVariableSet.getName().equals(CoreResUtil.getString((String)"IDS_VSETS_ALLVARIABLES"))) continue;
                boolean bl = true;
                for (String string : iVariableSet.getVariableNames()) {
                    if (iSpssDataSrc.findVarIndex(string) != -1 || this.isSourceCreateItemSelected(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        Vector vector = new Vector();
        sysFileProxy.getSysSetVarInfo(this.getDialog().getWelcomePage().getExternalFilename(), vector, 0, this.getDialog().getWelcomePage().getPassword());
        for (SystemFileSetsResponse.SetBlock setBlock : vector) {
            if (setBlock.mVarName.equals(CoreResUtil.getString((String)"IDS_VSETS_ALLVARIABLES"))) continue;
            boolean bl = true;
            for (VariableBlock variableBlock : setBlock.mVarList) {
                if (iSpssDataSrc.findVarIndex(variableBlock.getVarName()) != -1 || this.isSourceCreateItemSelected(variableBlock.getVarName())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceCreateItemSelected(String string) {
        boolean bl = false;
        SrcVariableList srcVariableList = this.getDialog().getChooseSourcePage().getSelectedSourceList();
        int[] nArray = srcVariableList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            ISpssVariable iSpssVariable = srcVariableList.getModel().getElementAt(nArray[i]);
            if (iSpssVariable == null || !string.equalsIgnoreCase(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void checkConditionsAndEnableFinish() {
        boolean bl;
        boolean bl2 = bl = this.mNoOfBoxesChecked == 0;
        if (!this.getDialog().getChooseSourcePage().isApplyDatasetPropertiesOnlyRadioSelected()) {
            bl = bl && !this.getDialog().getVariablesPage().areAnyCheckboxesSelected();
        }
        this.getDialog().enableNext(!bl);
        this.getDialog().enableFinish(!bl);
    }

    private boolean isFileLabelValid() {
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            return iSpssDataSrc.getLabel() != null && iSpssDataSrc.getLabel().length() > 0;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        String[] stringArray = new String[1];
        sysFileProxy.getFileLabelInfo(this.getDialog().getWelcomePage().getExternalFilename(), stringArray, this.getDialog().getWelcomePage().getPassword());
        return stringArray[0] != null && stringArray[0].length() > 0;
    }

    private boolean isWeightSpecificationValid() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            ISpssDataSrc iSpssDataSrc2 = DataMgr.getDataMgr().getDataSource(this.getDialog().getWelcomePage().getSelectedDataSet());
            LocallyUniqueId locallyUniqueId2 = iSpssDataSrc2.getWeightVarId();
            return locallyUniqueId2 != null && iSpssDataSrc.findVarIndex(locallyUniqueId2) != -1;
        }
        SysFileProxy sysFileProxy = SysFileProxy.getSysFileProxy();
        VariableBlock variableBlock = new VariableBlock();
        sysFileProxy.getWeightVarInfo(this.getDialog().getWelcomePage().getExternalFilename(), variableBlock, this.getDialog().getWelcomePage().getPassword());
        return variableBlock.getVarName().length() > 0 && iSpssDataSrc.findVarIndex(variableBlock.getVarName()) != -1;
    }

    private JPanel setupPropertiesToCopyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DATASET_PROPERTIES_TO_COPY")));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultipleResponseSetsCheckbox, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mMultipleResponseSetsReplace, gridBagConstraints, 1, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mMultipleResponseSetsMerge, gridBagConstraints, 2, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mVariableSetsCheckbox, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mVariableSetsReplace, gridBagConstraints, 1, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mVariableSetsMerge, gridBagConstraints, 2, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDocumentsCheckbox, gridBagConstraints, 0, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDocumentsReplace, gridBagConstraints, 1, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mDocumentsMerge, gridBagConstraints, 2, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCustomAttributesCheckbox, gridBagConstraints, 0, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCustomAttributesReplace, gridBagConstraints, 1, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCustomAttributesMerge, gridBagConstraints, 2, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 4, 3, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mWeightSpecification, gridBagConstraints, 0, 5, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 6, 1, 1, 21, DialogUtil.getStandardControlInsets());
        return jPanel;
    }
}

