/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.copy_data_properties;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesAbstractPage;
import com.spss.java_client.ui.dialogs.base.data.copy_data_properties.CopyDataPropertiesDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VariableInfoWindow;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CopyDataPropertiesChooseSourcePage
extends CopyDataPropertiesAbstractPage
implements ItemListener {
    private SrcVariableList mActiveDatasetList;
    private JLabel mActiveDatasetLabel;
    private JScrollPane mActiveDatasetPane;
    private int[] mActiveDatasetSelectedIndicesForMatchingRadio;
    private int[] mActiveDatasetSelectedIndicesForSingleRadio;
    private Rectangle mActiveDatasetVisibleRectForMatchingRadio;
    private Rectangle mActiveDatasetVisibleRectForSingleRadio;
    private JRadioButton mApplyDatasetPropertiesOnlyRadio;
    private JTextArea mApplyMessage;
    private JRadioButton mApplyToMatchingRadio;
    private JRadioButton mApplyToSingleRadio;
    private JCheckBox mCreateNewIfNotExistCheckbox;
    private JLabel mSelectedActiveVariablesLabel;
    private JLabel mSelectedVariablesLabel;
    private SourceDatasetVariable mSourceDataset;
    private ISpssVariable[] mSourceDatasetSelectedIndicesForMatchingRadio;
    private ISpssVariable[] mSourceDatasetSelectedIndicesForSingleRadio;
    private JScrollPane mSourceDatsetPane;
    private Rectangle mSourceDatsetVisibleRectForMatchingRadio;
    private Rectangle mSourceDatsetVisibleRectForSingleRadio;
    private JLabel mVariablesToCreateLabel;
    private DialogFocusTraversalPolicy mPolicy;
    private int mSelectedRadioBtnIdx;
    private boolean mNextPageClickedFirstTime = true;
    private boolean mUIStabilized = false;

    public CopyDataPropertiesChooseSourcePage(CopyDataPropertiesDlg copyDataPropertiesDlg) {
        super("step2", "IDS_COPY_DATA_PROPERTRIES_STEP2_TITLE", copyDataPropertiesDlg);
    }

    public String getActiveVariablesStringList() {
        return this.getVariablesStringList(this.mActiveDatasetList);
    }

    public SrcVariableList getSelectedSourceList() {
        return this.mSourceDataset;
    }

    @Override
    public String getNextPage() {
        if (this.mApplyDatasetPropertiesOnlyRadio.isSelected()) {
            return "step4";
        }
        return "step3";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cdpvariables";
    }

    public int getNoOfVariablesToApplyProperties() {
        if (this.mApplyDatasetPropertiesOnlyRadio.isSelected()) {
            return 0;
        }
        if (this.mApplyToSingleRadio.isSelected()) {
            return Integer.parseInt(this.mSelectedActiveVariablesLabel.getText().substring(this.getResString("IDS_SELECTED_VARIABLES").length()));
        }
        return Integer.parseInt(this.mSelectedActiveVariablesLabel.getText().substring(this.getResString("IDS_MATHCING_VARIABLES").length()));
    }

    public int getNoOfVariablesToCreate() {
        if (this.mApplyToSingleRadio.isSelected() || this.mApplyDatasetPropertiesOnlyRadio.isSelected()) {
            return 0;
        }
        return Integer.parseInt(this.mVariablesToCreateLabel.getText().substring(this.getResString("IDS_VARIABLES_TO_CREATE").length()));
    }

    public String getSourceVariablesStringList() {
        return this.getVariablesStringList(this.mSourceDataset);
    }

    public boolean isApplyDatasetPropertiesOnlyRadioSelected() {
        return this.mApplyDatasetPropertiesOnlyRadio.isSelected();
    }

    public boolean isApplyToMatchingRadioSelected() {
        return this.mApplyToMatchingRadio.isSelected();
    }

    public boolean isApplyToSingleRadioSelected() {
        return this.mApplyToSingleRadio.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() == this.mApplyToMatchingRadio) {
                this.selectApplyToMatchingRadio();
            } else if (itemEvent.getItem() == this.mCreateNewIfNotExistCheckbox && this.mApplyToMatchingRadio.isSelected()) {
                this.deSelectApplyToMatchingRadio();
                this.selectApplyToMatchingRadio();
            } else if (itemEvent.getItem() == this.mApplyToSingleRadio) {
                this.selectApplyToSingleRadio();
            } else if (itemEvent.getItem() == this.mApplyDatasetPropertiesOnlyRadio) {
                this.selectApplyDatasetPropertiesOnlyRadio();
            }
        } else if (itemEvent.getItem() == this.mApplyToMatchingRadio) {
            this.deSelectApplyToMatchingRadio();
        } else if (itemEvent.getItem() == this.mCreateNewIfNotExistCheckbox && this.mApplyToMatchingRadio.isSelected()) {
            this.deSelectApplyToMatchingRadio();
            this.selectApplyToMatchingRadio();
        } else if (itemEvent.getItem() == this.mApplyToSingleRadio) {
            this.deSelectApplyToSingleRadio();
        } else if (itemEvent.getItem() == this.mApplyDatasetPropertiesOnlyRadio) {
            this.deSelectApplyDatasetPropertiesOnlyRadio();
        }
    }

    @Override
    public boolean validate() {
        if (this.mNextPageClickedFirstTime) {
            this.getDialog().getVariablesPage().setDefaults();
            this.getDialog().getDatasetPage().setDefaultStates();
            this.getDialog().getFinishPage().setDefaults();
            this.mNextPageClickedFirstTime = false;
        }
        this.getDialog().getDatasetPage().setDefaults();
        if (this.mApplyDatasetPropertiesOnlyRadio.isSelected() || this.getNoOfVariablesToApplyProperties() + this.getNoOfVariablesToCreate() > 0 && this.areAnySourceVariablesSelected()) {
            return true;
        }
        if (this.mApplyDatasetPropertiesOnlyRadio.isEnabled()) {
            if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.getDialog()), this.getResString("ERR_NO_VARIABLES_SELECTED_APPLY_DATASET_PROPERTIES_ERROR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                this.mApplyDatasetPropertiesOnlyRadio.setSelected(true);
                return true;
            }
            return false;
        }
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.getDialog()), this.getResString("ERR_NO_VARIABLES_SELECTED_ERROR_MSG"), VersionInfo.getAppVersionString());
        return false;
    }

    @Override
    public boolean validateOnBack() {
        this.mUIStabilized = false;
        return super.validateOnBack();
    }

    public boolean willNewVariablesBeCreated() {
        return !this.mVariablesToCreateLabel.getText().endsWith(" 0");
    }

    @Override
    protected void aboutToShowPanel() {
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mUIStabilized = true;
        switch (this.mSelectedRadioBtnIdx) {
            case 1: {
                this.mApplyToMatchingRadio.setSelected(true);
                this.mApplyToMatchingRadio.doClick();
                break;
            }
            case 2: {
                this.mApplyToSingleRadio.setSelected(true);
                this.mApplyToSingleRadio.doClick();
                break;
            }
            case 3: {
                this.mApplyDatasetPropertiesOnlyRadio.setSelected(true);
                this.mApplyDatasetPropertiesOnlyRadio.doClick();
                break;
            }
            default: {
                if (this.mApplyToMatchingRadio.isEnabled()) {
                    this.mApplyToMatchingRadio.setSelected(true);
                    this.mApplyToMatchingRadio.doClick();
                    break;
                }
                if (this.mApplyToSingleRadio.isEnabled()) {
                    this.mApplyToSingleRadio.setSelected(true);
                    this.mApplyToSingleRadio.doClick();
                    break;
                }
                this.mApplyDatasetPropertiesOnlyRadio.setSelected(true);
                this.mApplyDatasetPropertiesOnlyRadio.doClick();
            }
        }
        if (this.getDialog().getWelcomePage().isActiveDatasetButtonSelected()) {
            this.mCreateNewIfNotExistCheckbox.setSelected(false);
            this.mCreateNewIfNotExistCheckbox.setEnabled(false);
        }
        LocallyUniqueId locallyUniqueId = this.getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mApplyToSingleRadio.setEnabled(iSpssDataSrc.columnCount() > 0);
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
        ToolTipManager.sharedInstance().mouseExited(new MouseEvent(this.mSourceDataset, 1, 0L, 0, -1, -1, 0, false));
    }

    @Override
    protected void initVars() {
        this.mApplyToMatchingRadio = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_APPLY_TO_MATCHING_RADIO"));
        this.mApplyToSingleRadio = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_APPLY_FROM_SINGLE_RADIO"));
        this.mApplyDatasetPropertiesOnlyRadio = new JRadioButton(new ToggleButtonAction(this.getDialog(), "IDS_APPLY_DATASET_PROPERTIES_ONLY_RADIO"));
        this.mCreateNewIfNotExistCheckbox = new JCheckBox(new ToggleButtonAction(this.getDialog(), "IDS_CREATE_NEW_IF_NOT_EXIST_CHECKBOX"));
        this.mApplyToMatchingRadio.addItemListener(this);
        this.mApplyToSingleRadio.addItemListener(this);
        this.mApplyDatasetPropertiesOnlyRadio.addItemListener(this);
        this.mCreateNewIfNotExistCheckbox.addItemListener(this);
        this.mApplyMessage = this.getDialog().getWelcomePage().isActiveDatasetButtonSelected() ? new JTextArea(this.getResString("IDS_APPLY_FROM_SINGLE_MESSAGE")) : new JTextArea(this.getResString("IDS_CREATE_NEW_IF_NOT_EXIST_CHECKBOX_MESSAGE"));
        this.mApplyMessage.setLineWrap(true);
        this.mApplyMessage.setWrapStyleWord(true);
        this.mApplyMessage.setBorder(null);
        this.mApplyMessage.setOpaque(false);
        this.mApplyMessage.setFocusable(false);
        this.mApplyMessage.setMinimumSize(new Dimension(280, 30));
        this.mSourceDataset = new SourceDatasetVariable();
        this.mSourceDataset.setDragSupported(false);
        this.mActiveDatasetList = new SrcVariableList();
        this.mActiveDatasetList.setDragSupported(false);
        this.mActiveDatasetList.setAutoLoad(false);
        this.mSourceDataset.setContextMenuFlags(1);
        this.mActiveDatasetList.setContextMenuFlags(1);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CopyDataPropertiesChooseSourcePage.this.mApplyToSingleRadio.isSelected()) {
                    CopyDataPropertiesChooseSourcePage.this.setLabelsWhenApplyToSingleRadioSelected();
                } else if (CopyDataPropertiesChooseSourcePage.this.mApplyToMatchingRadio.isSelected()) {
                    CopyDataPropertiesChooseSourcePage.this.setLabelsWhenApplyToMatchingRadioSelected();
                }
            }
        };
        ListSelectionListener listSelectionListener2 = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CopyDataPropertiesChooseSourcePage.this.mApplyToSingleRadio.isSelected()) {
                    CopyDataPropertiesChooseSourcePage.this.setLabelsWhenApplyToSingleRadioSelected2();
                } else if (CopyDataPropertiesChooseSourcePage.this.mApplyToMatchingRadio.isSelected()) {
                    CopyDataPropertiesChooseSourcePage.this.setLabelsWhenApplyToMatchingRadioSelected();
                }
            }
        };
        this.mSourceDataset.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.mActiveDatasetList.getSelectionModel().addListSelectionListener(listSelectionListener2);
        this.mActiveDatasetLabel = DialogUtil.createLabel(this.getDialog(), "IDS_MATCHING_ACTIVE_DATASET");
        this.mSelectedActiveVariablesLabel = new JLabel(this.getResString("IDS_MATHCING_VARIABLES"));
        this.mVariablesToCreateLabel = new JLabel(this.getResString("IDS_VARIABLES_TO_CREATE"));
        this.mSelectedVariablesLabel = new JLabel(this.getResString("IDS_SELECTED_VARIABLES"));
        this.mActiveDatasetLabel.setLabelFor(this.mActiveDatasetList);
        this.setTabTraversalOrder();
    }

    @Override
    protected void setDefaults() {
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            this.mApplyToMatchingRadio.setEnabled(true);
            this.mCreateNewIfNotExistCheckbox.setEnabled(true);
            this.mApplyToSingleRadio.setEnabled(true);
            this.mApplyDatasetPropertiesOnlyRadio.setEnabled(true);
        } else if (this.getDialog().getWelcomePage().isOpenExternalDatasetButtonSelected()) {
            this.mApplyToMatchingRadio.setEnabled(true);
            this.mCreateNewIfNotExistCheckbox.setEnabled(true);
            this.mApplyToSingleRadio.setEnabled(true);
            this.mApplyDatasetPropertiesOnlyRadio.setEnabled(true);
        } else {
            this.mApplyToMatchingRadio.setEnabled(false);
            this.mCreateNewIfNotExistCheckbox.setEnabled(false);
            this.mApplyToSingleRadio.setEnabled(true);
            this.mApplyToSingleRadio.setSelected(true);
            this.mApplyDatasetPropertiesOnlyRadio.setEnabled(false);
        }
        if (this.mApplyToMatchingRadio.isEnabled() && this.mApplyToMatchingRadio.isSelected()) {
            this.selectApplyToMatchingRadio();
        } else if (this.mApplyToSingleRadio.isEnabled() && this.mApplyToSingleRadio.isSelected()) {
            this.selectApplyToSingleRadio();
        } else if (this.mApplyDatasetPropertiesOnlyRadio.isEnabled() && this.mApplyDatasetPropertiesOnlyRadio.isSelected()) {
            this.selectApplyDatasetPropertiesOnlyRadio();
        }
        this.removeSavedListSettings();
    }

    public void setDefaultStates() {
        this.mApplyToMatchingRadio.removeItemListener(this);
        this.mApplyToSingleRadio.removeItemListener(this);
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            this.mApplyToMatchingRadio.setSelected(true);
        } else if (this.getDialog().getWelcomePage().isOpenExternalDatasetButtonSelected()) {
            this.mApplyToMatchingRadio.setSelected(true);
        } else {
            this.mApplyToSingleRadio.setSelected(true);
        }
        this.mApplyToMatchingRadio.addItemListener(this);
        this.mApplyToSingleRadio.addItemListener(this);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mApplyMessage, gridBagConstraints, 0, 0, 2, 1, 19, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getVarListWidth() / 2, DialogUtil.getComponentGroupGap(), DialogUtil.getVarListWidth() / 4);
        DialogUtil.addUsingGBL(jPanel, this.setupSourceDatasetPanel(), gridBagConstraints, 0, 1, 1, 1, 10, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getVarListWidth() / 4, DialogUtil.getComponentGroupGap(), DialogUtil.getVarListWidth() / 2);
        DialogUtil.addUsingGBL(jPanel, this.setupActiveDatasetPanel(), gridBagConstraints, 1, 1, 1, 1, 10, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP2_WELCOME")), gridBagConstraints, 0, 0, 2, 1, 19, insets);
        DialogUtil.addUsingGBL(jPanel, this.mApplyToMatchingRadio, gridBagConstraints, 0, 1, 2, 1, 19, insets);
        DialogUtil.addUsingGBL(jPanel, this.mApplyToSingleRadio, gridBagConstraints, 0, 3, 2, 1, 19, insets);
        DialogUtil.addUsingGBL(jPanel, this.mApplyDatasetPropertiesOnlyRadio, gridBagConstraints, 0, 4, 2, 1, 19, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_COPY_DATA_PROPERTRIES_STEP2_MESSAGE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(280, 45));
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 5, 1, 1, 10, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(imageIcon), gridBagConstraints, 0, 5, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        insets = (Insets)insets.clone();
        insets.left = DialogUtil.getComponentGroupGap() * 2;
        DialogUtil.addUsingGBL(jPanel, this.mCreateNewIfNotExistCheckbox, gridBagConstraints, 0, 2, 2, 1, 19, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mApplyToMatchingRadio);
        spssButtonGroup.add(this.mApplyToSingleRadio);
        spssButtonGroup.add(this.mApplyDatasetPropertiesOnlyRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mCreateNewIfNotExistCheckbox);
        vector.add(this.mSourceDataset);
        vector.add(this.mActiveDatasetList);
        Vector<Object> vector2 = ((CopyDataPropertiesDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private boolean areAnySourceVariablesSelected() {
        return this.mSourceDataset.getSelectedIndices().length > 0;
    }

    private void deSelectApplyDatasetPropertiesOnlyRadio() {
    }

    private void deSelectApplyToMatchingRadio() {
        this.mSourceDatasetSelectedIndicesForMatchingRadio = this.mSourceDataset.getSelectedValues();
        this.mSourceDatsetVisibleRectForMatchingRadio = this.mSourceDatsetPane.getViewport().getVisibleRect();
        this.mActiveDatasetSelectedIndicesForMatchingRadio = this.mActiveDatasetList.getSelectedIndices();
        this.mActiveDatasetVisibleRectForMatchingRadio = this.mActiveDatasetPane.getViewport().getVisibleRect();
    }

    private void deSelectApplyToSingleRadio() {
        this.mSourceDatasetSelectedIndicesForSingleRadio = this.mSourceDataset.getSelectedValues();
        this.mSourceDatsetVisibleRectForSingleRadio = this.mSourceDatsetPane.getViewport().getVisibleRect();
        this.mActiveDatasetSelectedIndicesForSingleRadio = this.mActiveDatasetList.getSelectedIndices();
        this.mActiveDatasetVisibleRectForSingleRadio = this.mActiveDatasetPane.getViewport().getVisibleRect();
    }

    private LocallyUniqueId getActiveDatasetId() {
        return SpssMgr.getSpssMgr().getActiveClientDatasetId();
    }

    private List<ISpssVariable> getVariablesFromDataset(LocallyUniqueId locallyUniqueId) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            arrayList.add(iSpssDataSrc.getVariable(i));
        }
        return arrayList;
    }

    private String getVariablesStringList(VariableList variableList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ISpssVariable iSpssVariable : variableList.getSelectedValues()) {
            stringBuilder.append(iSpssVariable.getName()).append(" ");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private boolean match(ISpssVariable iSpssVariable, ISpssVariable iSpssVariable2) {
        if (iSpssVariable.getType() > 0 && iSpssVariable2.getType() > 0) {
            return iSpssVariable.getType() == iSpssVariable2.getType() && iSpssVariable.getName().equalsIgnoreCase(iSpssVariable2.getName());
        }
        return iSpssVariable.getName().equalsIgnoreCase(iSpssVariable2.getName());
    }

    private void removeSavedListSettings() {
        this.mSourceDatasetSelectedIndicesForSingleRadio = null;
        this.mActiveDatasetSelectedIndicesForSingleRadio = null;
        this.mSourceDatsetVisibleRectForSingleRadio = null;
        this.mActiveDatasetVisibleRectForSingleRadio = null;
        this.mSourceDatasetSelectedIndicesForMatchingRadio = null;
        this.mSourceDatsetVisibleRectForMatchingRadio = null;
        this.mActiveDatasetSelectedIndicesForMatchingRadio = null;
        this.mActiveDatasetVisibleRectForMatchingRadio = null;
    }

    private void selectApplyDatasetPropertiesOnlyRadio() {
        this.mSelectedRadioBtnIdx = 3;
        this.mApplyMessage.setText(this.getResString("IDS_APPLY_DATASET_PROPERTIES_ONLY_MESSAGE"));
        this.mCreateNewIfNotExistCheckbox.setEnabled(false);
        this.mSourceDataset.setEnabled(false);
        this.mActiveDatasetList.setEnabled(false);
        this.mSourceDataset.getModel().removeAll();
        this.mSourceDataset.removeAllVarFilters();
        this.mActiveDatasetList.getModel().removeAll();
        this.mSelectedActiveVariablesLabel.setText(" ");
        this.mVariablesToCreateLabel.setText(" ");
        this.mSelectedVariablesLabel.setText(" ");
        this.mActiveDatasetLabel.setText(this.getResString("IDS_ACTIVE_VARIABLES"));
    }

    private void selectApplyToMatchingRadio() {
        List<Object> list;
        if (this.mUIStabilized) {
            this.mSelectedRadioBtnIdx = 1;
        }
        if (this.mCreateNewIfNotExistCheckbox.isSelected()) {
            this.mApplyMessage.setText(this.getResString("IDS_CREATE_NEW_IF_NOT_EXIST_CHECKBOX_MESSAGE"));
        } else {
            this.mApplyMessage.setText(this.getResString("IDS_APPLY_TO_MATCHING_RADIO_MESSAGE"));
        }
        List<ISpssVariable> list2 = this.getVariablesFromDataset(this.getActiveDatasetId());
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            list = this.getVariablesFromDataset(this.getDialog().getWelcomePage().getSelectedDataSet());
        } else {
            list = new ArrayList<ISpssVariable>();
            list.addAll(this.getDialog().getWelcomePage().getRemoteFileVariables());
        }
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : list) {
            for (ISpssVariable iSpssVariable2 : list2) {
                if (!this.match(iSpssVariable, iSpssVariable2)) continue;
                arrayList.add(iSpssVariable);
                arrayList2.add(iSpssVariable2);
            }
        }
        if (arrayList.isEmpty()) {
            if (this.mCreateNewIfNotExistCheckbox.isEnabled()) {
                this.mCreateNewIfNotExistCheckbox.setSelected(true);
            }
            this.mCreateNewIfNotExistCheckbox.setEnabled(false);
        } else {
            if (!this.mUIStabilized) {
                this.mCreateNewIfNotExistCheckbox.setSelected(false);
            }
            this.mCreateNewIfNotExistCheckbox.setEnabled(true);
        }
        this.mSourceDataset.getModel().removeAll();
        this.mSourceDataset.removeAllVarFilters();
        this.mActiveDatasetList.getModel().removeAll();
        this.mSourceDataset.setSelectionMode(2);
        this.mSourceDataset.setEnabled(true);
        this.mActiveDatasetList.setEnabled(false);
        for (ISpssVariable iSpssVariable : arrayList2) {
            this.mActiveDatasetList.getModel().addElement(iSpssVariable, false);
        }
        this.mActiveDatasetList.getModel().sort();
        if (this.mCreateNewIfNotExistCheckbox.isSelected()) {
            for (ISpssVariable iSpssVariable : list) {
                this.mSourceDataset.getModel().addElement(iSpssVariable, false);
            }
        } else {
            for (ISpssVariable iSpssVariable : arrayList) {
                this.mSourceDataset.getModel().addElement(iSpssVariable, false);
            }
        }
        if (this.mSourceDatasetSelectedIndicesForMatchingRadio != null) {
            this.mSourceDataset.setSelection(this.mSourceDatasetSelectedIndicesForMatchingRadio);
            this.mSourceDatsetPane.getViewport().scrollRectToVisible(this.mSourceDatsetVisibleRectForMatchingRadio);
            this.mActiveDatasetList.setSelectedIndices(this.mActiveDatasetSelectedIndicesForMatchingRadio);
            this.mActiveDatasetPane.getViewport().scrollRectToVisible(this.mActiveDatasetVisibleRectForMatchingRadio);
        } else if (!arrayList.isEmpty()) {
            this.mSourceDataset.setSelectionInterval(0, this.mSourceDataset.getModel().getSize() - 1);
        }
        this.setLabelsWhenApplyToMatchingRadioSelected();
    }

    private void selectApplyToSingleRadio() {
        this.mSelectedRadioBtnIdx = 2;
        this.mApplyMessage.setText(this.getResString("IDS_APPLY_FROM_SINGLE_MESSAGE"));
        this.mCreateNewIfNotExistCheckbox.setEnabled(false);
        this.mSourceDataset.getModel().removeAll();
        this.mSourceDataset.removeAllVarFilters();
        this.mActiveDatasetList.getModel().removeAll();
        this.mSourceDataset.setSelectionMode(0);
        this.mActiveDatasetList.setSelectionMode(2);
        this.mSourceDataset.setEnabled(true);
        this.mActiveDatasetList.setEnabled(false);
        if (this.getDialog().getWelcomePage().isActiveDatasetButtonSelected()) {
            this.mSourceDataset.loadFromActiveDataset();
        } else if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            this.mSourceDataset.loadFromDataset(this.getDialog().getWelcomePage().getSelectedDataSet());
        } else {
            for (ISpssVariable iSpssVariable : this.getDialog().getWelcomePage().getRemoteFileVariables()) {
                this.mSourceDataset.getModel().addElement(iSpssVariable, false);
            }
        }
        if (this.mSourceDatasetSelectedIndicesForSingleRadio != null) {
            this.mSourceDataset.setSelection(this.mSourceDatasetSelectedIndicesForSingleRadio);
        }
        if (this.mSourceDatsetVisibleRectForSingleRadio != null) {
            this.mSourceDatsetPane.getViewport().scrollRectToVisible(this.mSourceDatsetVisibleRectForSingleRadio);
        }
        if (this.mActiveDatasetSelectedIndicesForSingleRadio != null) {
            this.mActiveDatasetList.setSelectedIndices(this.mActiveDatasetSelectedIndicesForSingleRadio);
        }
        if (this.mActiveDatasetVisibleRectForSingleRadio != null) {
            this.mActiveDatasetPane.getViewport().scrollRectToVisible(this.mActiveDatasetVisibleRectForSingleRadio);
        }
        this.setLabelsWhenApplyToSingleRadioSelected();
    }

    /*
     * WARNING - void declaration
     */
    private void setLabelsWhenApplyToMatchingRadioSelected() {
        void var5_7;
        List<Object> list;
        List<ISpssVariable> list2 = this.getVariablesFromDataset(this.getActiveDatasetId());
        if (this.getDialog().getWelcomePage().isOpenDatasetsButtonSelected()) {
            list = this.getVariablesFromDataset(this.getDialog().getWelcomePage().getSelectedDataSet());
        } else {
            list = new ArrayList<ISpssVariable>();
            list.addAll(this.getDialog().getWelcomePage().getRemoteFileVariables());
        }
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : list) {
            for (ISpssVariable iSpssVariable2 : list2) {
                if (!this.match(iSpssVariable, iSpssVariable2)) continue;
                arrayList.add(iSpssVariable);
            }
        }
        this.mActiveDatasetLabel.setText(this.getResString("IDS_MATCHING_ACTIVE_DATASET"));
        ISpssVariable[] iSpssVariableArray = this.mSourceDataset.getSelectedValues();
        boolean n = false;
        int n2 = 0;
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (arrayList.contains(iSpssVariable)) {
                ++var5_7;
                continue;
            }
            ++n2;
        }
        this.mSelectedActiveVariablesLabel.setText(this.getResString("IDS_MATHCING_VARIABLES") + (int)var5_7);
        this.mVariablesToCreateLabel.setText(this.getResString("IDS_VARIABLES_TO_CREATE") + n2);
        this.mSelectedVariablesLabel.setText(this.getResString("IDS_SELECTED_VARIABLES") + iSpssVariableArray.length);
    }

    private void setLabelsWhenApplyToSingleRadioSelected() {
        this.mActiveDatasetLabel.setText(this.getResString("IDS_ACTIVE_VARIABLES"));
        this.mSelectedVariablesLabel.setText(this.getResString("IDS_SELECTED_VARIABLES") + this.mSourceDataset.getSelectedIndices().length);
        this.mSelectedActiveVariablesLabel.setText(this.getResString("IDS_SELECTED_VARIABLES") + this.mActiveDatasetList.getSelectedIndices().length);
        this.mVariablesToCreateLabel.setText(" ");
        if (this.mSourceDataset.getSelectedIndices().length == 1) {
            SrcVariableList srcVariableList;
            ISpssVariable iSpssVariable = this.mSourceDataset.getModel().getElementAt(this.mSourceDataset.getSelectedIndices()[0]);
            if (this.mActiveDatasetList.getSelectedIndices().length > 0) {
                srcVariableList = this.mActiveDatasetList.getModel().getElementAt(this.mActiveDatasetList.getSelectedIndices()[0]);
                if (iSpssVariable.getType() == srcVariableList.getType()) {
                    this.mActiveDatasetList.setEnabled(true);
                    return;
                }
            }
            this.mActiveDatasetList.removeAll();
            srcVariableList = new SrcVariableList();
            srcVariableList.loadFromActiveDataset();
            for (int i = 0; i < srcVariableList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable2 = srcVariableList.getModel().getElementAt(i);
                if (iSpssVariable.getType() != iSpssVariable2.getType()) continue;
                this.mActiveDatasetList.getModel().addElement(iSpssVariable2);
            }
            if (this.mActiveDatasetList.getModel().getSize() > 0) {
                this.mActiveDatasetList.setEnabled(true);
            }
        }
    }

    private void setLabelsWhenApplyToSingleRadioSelected2() {
        this.mActiveDatasetLabel.setText(this.getResString("IDS_ACTIVE_VARIABLES"));
        this.mSelectedVariablesLabel.setText(this.getResString("IDS_SELECTED_VARIABLES") + this.mSourceDataset.getSelectedIndices().length);
        this.mSelectedActiveVariablesLabel.setText(this.getResString("IDS_SELECTED_VARIABLES") + this.mActiveDatasetList.getSelectedIndices().length);
        this.mVariablesToCreateLabel.setText(" ");
    }

    private JPanel setupActiveDatasetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mActiveDatasetPane = new JScrollPane(this.mActiveDatasetList);
        this.mActiveDatasetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mActiveDatasetList.getFixedCellHeight() * 9 + 2));
        this.mActiveDatasetPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mActiveDatasetLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mSelectedActiveVariablesLabel, gridBagConstraints, 0, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mVariablesToCreateLabel, gridBagConstraints, 0, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mActiveDatasetPane, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupSourceDatasetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mSourceDatsetPane = new JScrollPane(this.mSourceDataset);
        this.mSourceDataset.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSourceDataset.getFixedCellHeight() * 9 + 2));
        this.mSourceDatsetPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        JLabel jLabel = DialogUtil.createLabel(this.getDialog(), "IDS_COPY_DATA_SOURCE_VARIABLES");
        jLabel.setLabelFor(this.mSourceDataset);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mSelectedVariablesLabel, gridBagConstraints, 0, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, new JLabel(" "), gridBagConstraints, 0, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSourceDatsetPane, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    class SourceDatasetVariable
    extends SrcVariableList {
        SourceDatasetVariable() {
        }

        @Override
        protected void initializeVarInfoWindow(int n) {
            ISpssVariable iSpssVariable;
            ISpssDataSrc iSpssDataSrc = null;
            LocallyUniqueId locallyUniqueId = null;
            if (CopyDataPropertiesChooseSourcePage.this.getDialog().getWelcomePage().isOpenExternalDatasetButtonSelected()) {
                iSpssVariable = CopyDataPropertiesChooseSourcePage.this.mSourceDataset.getModel().getElementAt(n);
            } else {
                locallyUniqueId = CopyDataPropertiesChooseSourcePage.this.getDialog().getWelcomePage().getSelectedDataSet();
                iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                iSpssVariable = this.getModel().getElementAt(n);
            }
            if (locallyUniqueId != null && iSpssDataSrc.findVarIndex(iSpssVariable.getId()) == -1) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_VAR_NOT_PRESENT_IN_DATASET"), iSpssVariable.getName());
                SpssAlertOptionPane.showInformationMessageDialog(this, string, VersionInfo.getAppVersionString());
            } else if (sVarInfoDlgMap.isEmpty()) {
                this.createVarInfoDialog(n);
            } else if (!sVarInfoDlgMap.containsKey(this)) {
                this.createVarInfoDialog(n);
            } else {
                VariableInfoWindow variableInfoWindow = (VariableInfoWindow)sVarInfoDlgMap.get(this);
                variableInfoWindow.setVisible(true);
            }
        }
    }
}

