/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.ContentValidatorFileChooser;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.uitools.util.SwingItem;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class SelectDatasetWizardPage
extends AbstractWizardPage
implements ActionListener,
ItemListener {
    public static final String PAGE_ID = "SelectDatasets";
    static final String EXTERNAL_DATA_FILE_RADIO_KEY = "IDS_EXTERNAL_DATAFILE_RADIO";
    static final String OPEN_DATASET_KEY = "IDS_OPEN_DATASET_RADIO";
    private BaseWizardDialog mParentDialog;
    private JRadioButton mOpenDatasetsRadio;
    private JRadioButton mExternalDatasetRadio;
    private JList mOpenDatasetsList;
    private StringTextField mExternalDatasetEdit;
    private JButton mBrowseButton;

    public SelectDatasetWizardPage(BaseWizardDialog baseWizardDialog) {
        super(PAGE_ID, "Select Datasets", baseWizardDialog, true);
        this.mParentDialog = baseWizardDialog;
    }

    @Override
    public void init() {
        this.initComponents();
        this.initPanel();
    }

    private void initComponents() {
        this.mOpenDatasetsRadio = new JRadioButton(this.mWizardDialog.getResString("IDS_CD_OPEN_DATASETS_RADIO"));
        this.mOpenDatasetsRadio.addItemListener(this);
        this.mExternalDatasetRadio = new JRadioButton(this.mWizardDialog.getResString("IDS_CD_EXTERNAL_DATAFILE_RADIO"));
        this.mExternalDatasetRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOpenDatasetsRadio);
        spssButtonGroup.add(this.mExternalDatasetRadio);
        this.mOpenDatasetsList = new JList<Object>(this.getDataSetList().toArray());
        this.mOpenDatasetsList.setVisibleRowCount(3);
        this.mExternalDatasetEdit = new StringTextField(50);
        this.mBrowseButton = new JButton(this.mWizardDialog.getResString("IDS_CD_BROWSE_BUTTON"));
        this.mBrowseButton.addActionListener(this);
        boolean bl = this.mOpenDatasetsList.getModel().getSize() != 0;
        this.mOpenDatasetsRadio.setEnabled(bl);
        this.mOpenDatasetsRadio.setSelected(bl);
        this.mExternalDatasetRadio.setSelected(!bl);
        this.enableComponents();
    }

    private void initPanel() {
        JPanel jPanel = this.getPanel();
        int n = UIManager.getIcon("RadioButton.icon").getIconWidth() + this.mOpenDatasetsRadio.getIconTextGap();
        int n2 = 5;
        double[] dArray = new double[]{n, -1.0, -2.0};
        double[] dArray2 = new double[]{-2.0, n2, -2.0, -1.0, n2, -2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(4);
        tableLayout.setVGap(4);
        jPanel.setLayout((LayoutManager)tableLayout);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_CD_SELECT_A_DATASET_LABEL"));
        JScrollPane jScrollPane = new JScrollPane(this.mOpenDatasetsList);
        jPanel.add((Component)jLabel, " 0, 0, 2, 0");
        jPanel.add((Component)this.mOpenDatasetsRadio, " 0, 2, 2, 2");
        jPanel.add((Component)jScrollPane, " 1, 3, 2, 3");
        jPanel.add((Component)this.mExternalDatasetRadio, " 0, 5, 2, 5");
        jPanel.add((Component)((Object)this.mExternalDatasetEdit), " 1, 6, 1, 6");
        jPanel.add((Component)this.mBrowseButton, " 2, 6, 2, 6");
    }

    private ArrayList<SwingItem<DataFrame>> getDataSetList() {
        ArrayList<SwingItem<DataFrame>> arrayList = new ArrayList<SwingItem<DataFrame>>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        for (int i = 0; i < spssFrameArray.length; ++i) {
            if (!(spssFrameArray[i] instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrameArray[i];
            String string = dataFrame.getCoreDocument().getDocName();
            this.getVarInfo(dataFrame.getDataView());
            String string2 = dataFrame.getDatasetName();
            String string3 = string + " [" + string2 + "]";
            if (SpssFrameMgr.getSpssFrameMgr().isDesignated(dataFrame)) continue;
            arrayList.add((SwingItem<DataFrame>)new SwingItem(string3, (Object)dataFrame));
        }
        return arrayList;
    }

    private Vector<VariableBlock> getVarInfo(DataView dataView) {
        ISpssDataSrc iSpssDataSrc = dataView.getDataSrc();
        Vector<VariableBlock> vector = new Vector<VariableBlock>();
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            vector.add(new VariableBlock(iSpssVariable.getName(), iSpssVariable.getLabel(), (int)iSpssVariable.getType(), iSpssVariable.getMeasurementLevel(), iSpssVariable.getFormat().getFormatType()));
        }
        return vector;
    }

    private Vector<VariableBlock> getVarInfo(String string) {
        Vector<VariableBlock> vector = new Vector<VariableBlock>();
        short s = SysFileProxy.getSysFileProxy().getSysFileVarInfo(string, vector);
        return vector;
    }

    private Map<String, VariableBlock> getVarMap(Vector<VariableBlock> vector) {
        HashMap<String, VariableBlock> hashMap = new HashMap<String, VariableBlock>();
        for (VariableBlock variableBlock : vector) {
            hashMap.put(variableBlock.getVarName(), variableBlock);
        }
        return hashMap;
    }

    private Vector<VariableBlock> getCurrentDataViewVarInfo() {
        DataView dataView = ((DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC)).getDataView();
        return this.getVarInfo(dataView);
    }

    private Vector<VariableBlock> getOpenDatasetVarInfo() {
        int n = this.mOpenDatasetsList.getSelectedIndex();
        SwingItem swingItem = (SwingItem)this.mOpenDatasetsList.getSelectedValue();
        return this.getVarInfo(((DataFrame)swingItem.getData()).getDataView());
    }

    private Vector<VariableBlock> getExternalDatasetVarInfo() {
        String string = this.mExternalDatasetEdit.getText();
        return this.getVarInfo(string);
    }

    @Override
    protected void aboutToShowPanel() {
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void aboutToHidePanel() {
        Vector<VariableBlock> vector = this.getCurrentDataViewVarInfo();
        if (this.mOpenDatasetsRadio.isSelected()) {
            Vector<VariableBlock> vector2 = this.getOpenDatasetVarInfo();
        } else {
            Vector<VariableBlock> vector3 = this.getExternalDatasetVarInfo();
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mOpenDatasetsRadio);
        vector.add(this.mOpenDatasetsList);
        vector.add(this.mExternalDatasetRadio);
        vector.add(this.mExternalDatasetEdit);
        vector.add(this.mBrowseButton);
        vector.addAll(this.mParentDialog.getCmdButtonComponents());
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.mParentDialog.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        dialogFocusTraversalPolicy.getDefaultComponent((Container)((Object)this.mParentDialog)).requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            ContentValidatorFileChooser contentValidatorFileChooser = new ContentValidatorFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            RefFileFilter refFileFilter = new RefFileFilter("SPSS (*.sav)", ".sav");
            contentValidatorFileChooser.setDialogTitle("Choose File");
            contentValidatorFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            contentValidatorFileChooser.setAcceptAllFileFilterUsed(true);
            contentValidatorFileChooser.setFileFilter((FileFilter)refFileFilter, true);
            int n = contentValidatorFileChooser.showOpenDialog((Component)((Object)this.mParentDialog));
            if (n == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)contentValidatorFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mExternalDatasetEdit.setText(contentValidatorFileChooser.getSelectedFilePath());
                this.getVarInfo(contentValidatorFileChooser.getSelectedFilePath());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == this.mOpenDatasetsRadio || itemEvent.getItem() == this.mExternalDatasetRadio) {
            this.enableComponents();
        }
    }

    private void enableComponents() {
        boolean bl = this.mOpenDatasetsRadio.isSelected();
        this.mOpenDatasetsList.setEnabled(bl);
        this.mExternalDatasetEdit.setEnabled(!bl);
        this.mBrowseButton.setEnabled(!bl);
    }

    @Override
    public String getNextPage() {
        return "CompareDictionaries";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }
}

