/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDataSetsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CompareDatasetsOutputTab
extends BaseProcedureTab
implements ItemListener,
DocumentListener {
    static final int TABLE_LIMIT_MAX = 10000;
    static final String FLAG_MISMATCH_CHECK = "IDS_FLAG_MISMATCH_CHECK";
    static final String MATCH_DATASET_CHECK = "IDS_MATCH_DATASET_CHECK";
    static final String MISMATCH_DATASET_CHECK = "IDS_MISMATCH_DATASET_CHECK";
    static final String TABLE_LIMIT_CHECK = "IDS_TABLE_LIMIT_CHECK";
    static final String FLAG_MISMATCH_EDIT = "IDS_FLAG_MISMATCH_EDIT";
    static final String MATCH_DATASET_EDIT = "IDS_MATCH_DATASET_EDIT";
    static final String MISMATCH_DATASET_EDIT = "IDS_MISMATCH_DATASET_EDIT";
    static final String TABLE_LIMIT_EDIT = "IDS_TABLE_LIMIT";
    private final String DEFAULT_FLAG_MISMATCH_NAME = "CasesCompare";
    private final String DEFAULT_TABLE_LIMIT = "100";
    private JCheckBox mFlagMismatchCheck;
    private JLabel mFlagMismatchNameLabel;
    private StringTextField mFlagMismatchNameEdit;
    private JCheckBox mMatchDatasetCheck;
    private JLabel mMatchDatasetNameLabel;
    private StringTextField mMatchDatasetNameEdit;
    private JCheckBox mMismatchDatasetCheck;
    private JLabel mMismatchDatasetNameLabel;
    private StringTextField mMismatchDatasetNameEdit;
    private JCheckBox mTableLimitCheck;
    private JLabel mMaxNumMismatchLabel;
    private IntTextField mTableLimitEdit;
    private String mVarNameOK;
    private String mDatasetNameYes;

    public CompareDatasetsOutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_compare_datasets_output";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!(itemEvent.getItem() instanceof JCheckBox)) {
            return;
        }
        JCheckBox jCheckBox = (JCheckBox)itemEvent.getItem();
        JLabel jLabel = null;
        StringTextField stringTextField = null;
        if (jCheckBox == this.mFlagMismatchCheck) {
            jLabel = this.mFlagMismatchNameLabel;
            stringTextField = this.mFlagMismatchNameEdit;
        } else if (jCheckBox == this.mMatchDatasetCheck) {
            jLabel = this.mMatchDatasetNameLabel;
            stringTextField = this.mMatchDatasetNameEdit;
        } else if (jCheckBox == this.mMismatchDatasetCheck) {
            jLabel = this.mMismatchDatasetNameLabel;
            stringTextField = this.mMismatchDatasetNameEdit;
        } else if (jCheckBox == this.mTableLimitCheck) {
            jLabel = this.mMaxNumMismatchLabel;
            stringTextField = this.mTableLimitEdit;
        }
        boolean bl = jCheckBox.isSelected();
        if (jLabel != null && stringTextField != null) {
            jLabel.setEnabled(bl);
            ((JComponent)((Object)stringTextField)).setEnabled(bl);
            if (bl) {
                ((JComponent)((Object)stringTextField)).requestFocusInWindow();
            }
            ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
        }
    }

    public String getTabSyntaxPart1(DialogDataModel dialogDataModel) {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SAVE"));
        Boolean bl = dialogDataModel.getBoolean(FLAG_MISMATCH_CHECK);
        if (bl != null) {
            stringBuffer.append(" FLAGMISMATCHES=");
            stringBuffer.append(bl != false ? "YES" : "NO");
            if (bl.booleanValue()) {
                string = dialogDataModel.getString(FLAG_MISMATCH_EDIT);
                stringBuffer.append(" VARNAME=");
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(" FLAGMISMATCHES=YES");
            stringBuffer.append(" VARNAME=");
            stringBuffer.append("CasesCompare");
        }
        if ((bl = dialogDataModel.getBoolean(MATCH_DATASET_CHECK)) != null) {
            stringBuffer.append(" MATCHDATASET=");
            stringBuffer.append(bl != false ? "YES" : "NO");
            if (bl.booleanValue()) {
                string = dialogDataModel.getString(MATCH_DATASET_EDIT);
                stringBuffer.append(" MATCHNAME=");
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(" MATCHDATASET=NO");
        }
        if ((bl = dialogDataModel.getBoolean(MISMATCH_DATASET_CHECK)) != null) {
            stringBuffer.append(" MISMATCHDATASET=");
            stringBuffer.append(bl != false ? "YES" : "NO");
            if (bl.booleanValue()) {
                string = dialogDataModel.getString(MISMATCH_DATASET_EDIT);
                stringBuffer.append(" MISMATCHNAME=");
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(" MISMATCHDATASET=NO");
        }
        return stringBuffer.toString();
    }

    public String getTabSyntaxPart2(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        Boolean bl = dialogDataModel.getBoolean(TABLE_LIMIT_CHECK);
        stringBuffer.append(" CASETABLE=YES");
        if (bl != null) {
            if (bl.booleanValue()) {
                String string = dialogDataModel.getString(TABLE_LIMIT_EDIT);
                stringBuffer.append(" TABLELIMIT=");
                stringBuffer.append(string.length() > 0 ? string : "NONE");
            } else {
                stringBuffer.append(" TABLELIMIT=NONE");
            }
        } else {
            stringBuffer.append(" TABLELIMIT=");
            stringBuffer.append("100");
        }
        return stringBuffer.toString();
    }

    public boolean isCopyMatchDataset() {
        return this.mMatchDatasetCheck.isSelected();
    }

    public boolean isCopyMismatchDataset() {
        return this.mMismatchDatasetCheck.isSelected();
    }

    public String getCopyMatchesFieldName() {
        return this.mMatchDatasetNameEdit.getText();
    }

    public String getCopyMisMatchesFieldName() {
        return this.mMismatchDatasetNameEdit.getText();
    }

    @Override
    protected boolean validateTab() {
        String string;
        if (!this.validateFlagMismatchNameField()) {
            return false;
        }
        if (this.mMatchDatasetCheck.isSelected() && !this.validateDatasetName(string = this.mMatchDatasetNameEdit.getText(), this.mMatchDatasetNameEdit)) {
            return false;
        }
        if (this.mMismatchDatasetCheck.isSelected() && !this.validateDatasetName(string = this.mMismatchDatasetNameEdit.getText(), this.mMismatchDatasetNameEdit)) {
            return false;
        }
        if (this.mTableLimitCheck.isSelected() && !this.mTableLimitEdit.checkRange()) {
            this.selectAllAndFocus((JTextField)this.mTableLimitEdit);
            return false;
        }
        return true;
    }

    protected boolean canEnableOkPaste() {
        return !(this.mFlagMismatchCheck.isSelected() && this.mFlagMismatchNameEdit.getText().length() <= 0 || this.mMatchDatasetCheck.isSelected() && this.mMatchDatasetNameEdit.getText().length() <= 0 || this.mMismatchDatasetCheck.isSelected() && this.mMismatchDatasetNameEdit.getText().length() <= 0 || this.mTableLimitCheck.isSelected() && this.mTableLimitEdit.getText().length() <= 0);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, n2, insets.bottom, insets.right);
        JPanel jPanel = this.setupSavedPanel();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mTableLimitCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.top, n2 * 3, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.mMaxNumMismatchLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets2.left = insets.left;
        DialogUtil.addUsingGBL(this, (JComponent)this.mTableLimitEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.setTabTraversal();
    }

    private JPanel setupSavedPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mParent.getResString("IDS_OUTPUT_SVD_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mFlagMismatchCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMatchDatasetCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMismatchDatasetCheck, gridBagConstraints, 0, 5, 2, 1, n, insets2);
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFlagMismatchNameLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMatchDatasetNameLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMismatchDatasetNameLabel, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFlagMismatchNameEdit), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMatchDatasetNameEdit), gridBagConstraints, 1, 4, 1, 1, n, insets2);
        insets2.bottom += DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMismatchDatasetNameEdit), gridBagConstraints, 1, 6, 1, 1, n, insets2);
        return jPanel;
    }

    private void initVars() {
        this.mFlagMismatchCheck = new JCheckBox(new ToggleButtonAction(this.mParent, FLAG_MISMATCH_CHECK));
        this.mFlagMismatchCheck.addItemListener(this);
        this.mFlagMismatchNameEdit = new StringTextField(15);
        this.mFlagMismatchNameEdit.setAction(new TextFieldAction(this.mParent, FLAG_MISMATCH_EDIT));
        this.mFlagMismatchNameEdit.getDocument().addDocumentListener(this);
        this.mMatchDatasetCheck = new JCheckBox(new ToggleButtonAction(this.mParent, MATCH_DATASET_CHECK));
        this.mMatchDatasetCheck.addItemListener(this);
        this.mMatchDatasetNameEdit = new StringTextField(15);
        this.mMatchDatasetNameEdit.setAction(new TextFieldAction(this.mParent, MATCH_DATASET_EDIT));
        this.mMatchDatasetNameEdit.getDocument().addDocumentListener(this);
        this.mMismatchDatasetCheck = new JCheckBox(new ToggleButtonAction(this.mParent, MISMATCH_DATASET_CHECK));
        this.mMismatchDatasetCheck.addItemListener(this);
        this.mMismatchDatasetNameEdit = new StringTextField(15);
        this.mMismatchDatasetNameEdit.setAction(new TextFieldAction(this.mParent, MISMATCH_DATASET_EDIT));
        this.mMismatchDatasetNameEdit.getDocument().addDocumentListener(this);
        this.mFlagMismatchNameLabel = DialogUtil.createLabel(this.mParent, "IDS_OUTPUT_NAME_LABEL", 0);
        this.mFlagMismatchNameLabel.setLabelFor((Component)((Object)this.mFlagMismatchNameEdit));
        this.mMatchDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_OUTPUT_NAME_LABEL", 1);
        this.mMatchDatasetNameLabel.setLabelFor((Component)((Object)this.mMatchDatasetNameEdit));
        this.mMismatchDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_OUTPUT_NAME_LABEL", 2);
        this.mMismatchDatasetNameLabel.setLabelFor((Component)((Object)this.mMismatchDatasetNameEdit));
        this.mTableLimitCheck = new JCheckBox(new ToggleButtonAction(this.mParent, TABLE_LIMIT_CHECK));
        this.mTableLimitCheck.addItemListener(this);
        this.mMaxNumMismatchLabel = DialogUtil.createLabel(this.mParent, "IDS_MAX_NUM_MISMATCH_LABEL");
        this.mTableLimitEdit = new IntTextField(1, 10000, true);
        this.mTableLimitEdit.setAllowMinMax(true, true);
        this.mTableLimitEdit.setSkipValidationOnFocusLost(true);
        this.mTableLimitEdit.setAction((Action)new TextFieldAction(this.mParent, TABLE_LIMIT_EDIT));
        this.mMaxNumMismatchLabel.setLabelFor((Component)this.mTableLimitEdit);
        this.mTableLimitEdit.getDocument().addDocumentListener(this);
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mFlagMismatchCheck);
        this.addToComponentOrder(this.mFlagMismatchNameEdit);
        this.addToComponentOrder(this.mMatchDatasetCheck);
        this.addToComponentOrder(this.mMatchDatasetNameEdit);
        this.addToComponentOrder(this.mMismatchDatasetCheck);
        this.addToComponentOrder(this.mMismatchDatasetNameEdit);
        this.addToComponentOrder(this.mTableLimitCheck);
        this.addToComponentOrder(this.mTableLimitEdit);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private void setDefaults() {
        this.mFlagMismatchCheck.setSelected(true);
        this.mMatchDatasetCheck.setSelected(false);
        this.mMismatchDatasetCheck.setSelected(false);
        this.mFlagMismatchNameLabel.setEnabled(true);
        this.mFlagMismatchNameEdit.setEnabled(true);
        this.mFlagMismatchNameEdit.setText("CasesCompare");
        this.mMatchDatasetNameLabel.setEnabled(false);
        this.mMatchDatasetNameEdit.setEnabled(false);
        this.mMismatchDatasetNameLabel.setEnabled(false);
        this.mMismatchDatasetNameEdit.setEnabled(false);
        this.mTableLimitCheck.setSelected(true);
        this.mMaxNumMismatchLabel.setEnabled(true);
        this.mTableLimitEdit.setEnabled(true);
        this.mTableLimitEdit.setText("100");
    }

    private String getUniqueDefaultDatasetName(String string) {
        String string2 = string;
        if (DatasetNameValidator.hasDatasetName((String)string)) {
            for (int i = 1; i < 100; ++i) {
                String string3 = string + "_" + i;
                if (DatasetNameValidator.hasDatasetName((String)string3)) continue;
                string2 = string3;
                break;
            }
        }
        return string2;
    }

    private boolean validateFlagMismatchNameField() {
        if (this.mFlagMismatchCheck.isSelected()) {
            String string = this.mFlagMismatchNameEdit.getText();
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            boolean bl = DialogUtil.showBadSpssVarNameWarning(n, this.mParent);
            if (!bl) {
                this.selectAllAndFocus((JTextField)((Object)this.mFlagMismatchNameEdit));
                return false;
            }
            if (this.isVariableExistInActivedataset(string)) {
                if (string.equalsIgnoreCase(this.mVarNameOK)) {
                    return true;
                }
                String string2 = this.mParent.getResString("IDS_OUTPUT_VAR_IS_USED_MSG");
                int n2 = SpssAlertOptionPane.showConfirmDialog(this, string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (n2 == 3 || n2 == -1) {
                    if (n2 == 3) {
                        this.selectAllAndFocus((JTextField)((Object)this.mFlagMismatchNameEdit));
                    }
                    return false;
                }
                if (n2 == 0) {
                    this.mVarNameOK = string;
                }
            }
        }
        return true;
    }

    private boolean isVariableExistInActivedataset(String string) {
        ISpssDataSrc iSpssDataSrc;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId != null && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId)) != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                if (!iSpssVariable.getName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean validateDatasetName(String string, StringTextField stringTextField) {
        String string2 = ((CompareDataSetsDlg)this.mParent).getActiveDatasetName();
        String string3 = ((CompareDataSetsDlg)this.mParent).getCompareDatasetName();
        if (string.equalsIgnoreCase(string2) || string3 != null && string.equalsIgnoreCase(string3)) {
            String string4 = this.mParent.getResString("IDS_OUTPUT_DATASET_IS_SELECTED_MSG");
            SpssAlertOptionPane.showErrorMessageDialog((Window)this.mParent, string4, VersionInfo.getAppVersionString());
            this.selectAllAndFocus((JTextField)((Object)stringTextField));
            return false;
        }
        if (!string.equalsIgnoreCase(this.mDatasetNameYes)) {
            int n = DatasetNameValidator.validateDatasetName((String)string, (Component)this);
            if (n == 1) {
                this.mDatasetNameYes = string;
            } else {
                this.selectAllAndFocus((JTextField)((Object)stringTextField));
                return false;
            }
        }
        return true;
    }

    private boolean isVariableExist(String string, VarListModel varListModel) {
        boolean bl = false;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void selectAllAndFocus(JTextField jTextField) {
        jTextField.requestFocusInWindow();
        jTextField.selectAll();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

