/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class CompareDatasetsGating
extends BaseGatingDialog
implements ItemListener,
DocumentListener,
ListSelectionListener {
    Vector<LocallyUniqueId> mLocallyUniqueIDs;
    private static final String SAVE_BROWSE_KEY = "IDS_ADD_VARIABLES_BROWSE";
    private static final String ADD_VARIABLES_EXTERNAL_RADIO_KEY = "IDS_ADD_VARIABLES_EXTERNAL_RADIO";
    private static final String ADD_VARIABLES_OPEN_DATASET_RADIO_KEY = "IDS_ADD_VARIABLES_OPEN_DATASET_RADIO";
    private FileTextField mFileNameText;
    private JRadioButton mOpenDataSetRadioButton;
    private JRadioButton mExternalSorceRadioButton;
    private PlainList mList;
    private JButton mBrowseButton;
    private SpssButtonGroup mButtonGroup;
    private Hashtable<String, String> mFileDatasetNames;
    static String sFileNameKey;
    static String sFileBasedDataSetName;
    static LocallyUniqueId sLocallyUniqueDatasetIdKey;
    static Vector<ISpssVariable> mMatchingVars;
    static Vector<ISpssVariable> mUnMatchingVarsActiveDataset;
    static Vector<ISpssVariable> mUnMatchingVarsOtherDataset;
    static String sMANGLED_PASSWORD;
    static Vector<VariableBlock> sVARBLOCKS_FROM_ENCRYPTEDFILE;

    public CompareDatasetsGating(JFrame jFrame) throws HeadlessException {
        super(jFrame, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        DataMgr dataMgr = DataMgr.getDataMgr();
        IDataDocument iDataDocument = dataMgr.findDataDocument(locallyUniqueId);
        this.setTitle(this.getResString("IDS_COMPARE_DATASETS_GATING_TITLE") + " " + iDataDocument.getDocName() + "[" + iDataDocument.getDatasetName() + "]");
        this.setLocationRelativeTo(this.getParent());
        this.clearStaticInfo();
        this.pack();
    }

    private void clearStaticInfo() {
        sFileNameKey = null;
        sLocallyUniqueDatasetIdKey = null;
        mMatchingVars = new Vector();
        mUnMatchingVarsActiveDataset = new Vector();
        mUnMatchingVarsOtherDataset = new Vector();
        sMANGLED_PASSWORD = null;
        sVARBLOCKS_FROM_ENCRYPTEDFILE = null;
    }

    @Override
    public String getNextProcDlgActionKey() {
        return "data_compare_dataset_continue_gating";
    }

    @Override
    public String getIActionKey() {
        return "data_compare_dataset";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_compare_to";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mOpenDataSetRadioButton.isSelected()) {
            this.mFileNameText.setEnabled(false);
            this.mFileNameText.setOpaque(false);
            this.mBrowseButton.setEnabled(false);
            this.mList.setEnabled(true);
            this.mList.setOpaque(true);
            if (this.mList.getModel().getSize() > 0 && !this.mList.isSelectionEmpty()) {
                this.mDefineButton.setEnabled(true);
            } else {
                this.mDefineButton.setEnabled(false);
            }
        }
        if (this.mExternalSorceRadioButton.isSelected()) {
            this.mFileNameText.setEnabled(true);
            this.mFileNameText.setOpaque(true);
            this.mBrowseButton.setEnabled(true);
            this.mList.setEnabled(false);
            this.mList.setOpaque(false);
            if (this.mFileNameText.getText().length() > 0) {
                this.mDefineButton.setEnabled(true);
            } else {
                this.mDefineButton.setEnabled(false);
            }
        }
    }

    @Override
    protected void loadDialogState() {
        this.setVisible(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mExternalSorceRadioButton.isSelected() && this.mFileNameText.getDocument().getLength() > 0) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.mList.isSelectionEmpty() && this.mOpenDataSetRadioButton.isSelected()) {
            this.mDefineButton.setEnabled(true);
        } else {
            this.mDefineButton.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean continuePressed() {
        if (this.mOpenDataSetRadioButton.isSelected()) {
            sLocallyUniqueDatasetIdKey = this.mLocallyUniqueIDs.get(this.mList.getSelectedIndex());
            sFileNameKey = this.mFileDatasetNames.get(this.mList.getSelectedValue().toString());
            boolean bl = this.initStaticInfo();
            if (!bl) {
                return false;
            }
        }
        if (!this.mExternalSorceRadioButton.isSelected()) return true;
        DocUtil.DataEncryptionTestResults dataEncryptionTestResults = DocUtil.testOpenEncryptedData(this.getParentFrame(), this.mFileNameText.getText());
        boolean bl = dataEncryptionTestResults.isCanContinue();
        if (bl) {
            boolean bl2 = this.initStaticInfo(dataEncryptionTestResults.getVarBlocks());
            if (bl2) {
                sFileNameKey = this.mFileNameText.getText();
                sLocallyUniqueDatasetIdKey = null;
                sFileBasedDataSetName = DataDocument.getNextFreeDatasetName();
                sMANGLED_PASSWORD = dataEncryptionTestResults.getMangledPassword();
                sVARBLOCKS_FROM_ENCRYPTEDFILE = dataEncryptionTestResults.getVarBlocks();
                return true;
            }
            this.clearStaticInfo();
            return false;
        }
        if (dataEncryptionTestResults.isPasswordDlgOKPressed() && dataEncryptionTestResults.getErrorMsg() != null) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), dataEncryptionTestResults.getErrorMsg(), VersionInfo.getAppVersionString());
            this.mFileNameText.requestFocus();
            this.mFileNameText.selectAll();
        }
        this.clearStaticInfo();
        return false;
    }

    public static boolean isCompareDataFileBased() {
        return sLocallyUniqueDatasetIdKey == null;
    }

    private boolean initStaticInfo() {
        return this.initStaticInfo(null);
    }

    private boolean initStaticInfo(Vector<VariableBlock> vector) {
        int n;
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        boolean bl = false;
        Vector<ISpssVariable> vector2 = null;
        Vector<ISpssVariable> vector3 = null;
        if (iSpssDataSrc != null) {
            vector2 = this.getActiveVariablesList(iSpssDataSrc);
            vector3 = this.getOtherVariablesList(vector);
            if (vector3 != null && vector2 != null && vector3.size() > 0 && vector2.size() > 0) {
                for (n = vector2.size() - 1; n >= 0; --n) {
                    ISpssVariable iSpssVariable = vector2.get(n);
                    int n2 = this.findMatchVarInList(vector3, iSpssVariable);
                    if (n2 < 0) continue;
                    mMatchingVars.add(iSpssVariable);
                    vector2.remove(n);
                    vector3.remove(n2);
                }
            }
        } else {
            bl = true;
        }
        mMatchingVars = mMatchingVars != null && mMatchingVars.size() > 0 ? mMatchingVars : null;
        mUnMatchingVarsActiveDataset = vector2 != null && vector2.size() > 0 ? vector2 : null;
        mUnMatchingVarsOtherDataset = vector3 != null && vector3.size() > 0 ? vector3 : null;
        int n3 = n = !bl && mMatchingVars != null ? 1 : 0;
        if (n == 0) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_COMPARE_DATASETS_GATING_NOTHING_TO_COMPARE_MSG"), VersionInfo.getAppVersionString());
            this.mFileNameText.requestFocus();
            this.mFileNameText.selectAll();
            this.clearStaticInfo();
        }
        return n != 0;
    }

    private int findMatchVarInList(Vector<ISpssVariable> vector, ISpssVariable iSpssVariable) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl;
            ISpssVariable iSpssVariable2 = vector.get(i);
            boolean bl2 = bl = iSpssVariable2.getType() == 0 && iSpssVariable.getType() == 0 || iSpssVariable2.getType() >= 1 && iSpssVariable.getType() >= 1;
            if (!iSpssVariable2.getName().equalsIgnoreCase(iSpssVariable.getName()) || !bl) continue;
            n = i;
            break;
        }
        return n;
    }

    private Vector<ISpssVariable> getActiveVariablesList(ISpssDataSrc iSpssDataSrc) {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (iSpssVariable == null) continue;
            vector.add(iSpssVariable);
        }
        return vector.size() > 0 ? vector : null;
    }

    private Vector<ISpssVariable> getOtherVariablesList(Vector<VariableBlock> vector) {
        Vector<Object> vector2 = null;
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            if (sLocallyUniqueDatasetIdKey != null) {
                vector2 = this.populateSourceList(sLocallyUniqueDatasetIdKey);
            } else {
                vector2 = new Vector();
                if (vector != null) {
                    for (VariableBlock variableBlock : vector) {
                        ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                        ISpssVariable iSpssVariable = iSpssDataSrc.makeVariable(variableBlock.getDiType(), returnIndex);
                        iSpssVariable.setName(variableBlock.getVarName());
                        iSpssVariable.setLabel(variableBlock.getVarLabel());
                        vector2.addElement(iSpssVariable);
                    }
                }
            }
        }
        return vector2 != null && vector2.size() > 0 ? vector2 : null;
    }

    private Vector<ISpssVariable> populateSourceList(LocallyUniqueId locallyUniqueId) {
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            return null;
        }
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                vector.addElement(iSpssVariable);
            }
        }
        return vector;
    }

    @Override
    protected void init() {
        super.init();
        this.mFileDatasetNames = new Hashtable();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        int n2 = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupExportPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void doLoadRemote() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_COMPARE_DATASETS_BASE_FILE_DESC"), this.getResString("IDS_COMPARE_DATASETS_BASE_FILE_EXT"));
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_COMPARE_DATASETS_OPEN_FILE_TITLE"));
        int n = remoteFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            this.mFileNameText.setText(remoteFileChooser.getSelectedFilePath());
        }
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_COMPARE_DATASETS_GATING_TOP_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOpenDataSetRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        int n2 = DialogUtil.getComponentGroupGap();
        jScrollPane.setPreferredSize(new Dimension(30 * n2, 10 * n2));
        Insets insets2 = new Insets(0, 3 * n2, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mExternalSorceRadioButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameText), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        insets2 = new Insets(-3, 6, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        this.mBrowseButton.addItemListener(this);
        JLabel jLabel = new JLabel(this.getResString("IDS_COMPARE_DATASETS_GATING_BOTTOM_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 6, 2, 1, n, null);
        gridBagConstraints.gridy = 1;
        return jPanel;
    }

    private void initVars() {
        this.mFileNameText = new FileTextField();
        this.mFileNameText.setColumns(30);
        this.mFileNameText.setFocusable(true);
        this.mFileNameText.getDocument().addDocumentListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ADD_VARIABLES_EXTERNAL_RADIO_KEY);
        this.mExternalSorceRadioButton = new JRadioButton(toggleButtonAction);
        this.mExternalSorceRadioButton.addItemListener(this);
        this.mButtonGroup.add(this.mExternalSorceRadioButton);
        toggleButtonAction = new ToggleButtonAction(this, ADD_VARIABLES_OPEN_DATASET_RADIO_KEY);
        this.mOpenDataSetRadioButton = new JRadioButton(toggleButtonAction);
        this.mOpenDataSetRadioButton.addItemListener(this);
        this.mButtonGroup.add(this.mOpenDataSetRadioButton);
        toggleButtonAction = new ToggleButtonAction(this, SAVE_BROWSE_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareDatasetsGating.this.doLoadRemote();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        DataMgr dataMgr = DataMgr.getDataMgr();
        this.mLocallyUniqueIDs = new Vector();
        if (spssFrameArray != null) {
            for (SpssFrame spssFrame : spssFrameArray) {
                DataFrame dataFrame;
                IDataDocument iDataDocument;
                if (spssFrame.docType() != DocType.DE_DOC || spssFrame == SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC) || (iDataDocument = dataMgr.findDataDocument((dataFrame = (DataFrame)spssFrame).getDatasetId())).getDatasetName().length() == 0) continue;
                String string = iDataDocument.getDocName() + "[" + iDataDocument.getDatasetName() + "]";
                defaultListModel.addElement(string);
                this.mFileDatasetNames.put(string, iDataDocument.getDatasetName());
                this.mLocallyUniqueIDs.add(((DataFrame)spssFrame).getDatasetId());
            }
        }
        this.mList = new PlainList(defaultListModel, "", PlainList.DragType.eNoAutoDrag);
        this.mList.setSelectionMode(0);
        this.mList.addListSelectionListener(this);
        this.setDefault();
    }

    private void setDefault() {
        if (this.mList.getModel().getSize() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompareDatasetsGating.this.mOpenDataSetRadioButton.requestFocus();
                    CompareDatasetsGating.this.mOpenDataSetRadioButton.setSelected(true);
                    CompareDatasetsGating.this.mOpenDataSetRadioButton.setEnabled(true);
                }
            });
            this.mList.setEnabled(true);
            this.mFileNameText.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompareDatasetsGating.this.mExternalSorceRadioButton.requestFocus();
                    CompareDatasetsGating.this.mExternalSorceRadioButton.setSelected(true);
                    CompareDatasetsGating.this.mOpenDataSetRadioButton.setEnabled(false);
                }
            });
            this.mList.setEnabled(false);
            this.mOpenDataSetRadioButton.setEnabled(false);
            this.mFileNameText.setEnabled(true);
            this.mBrowseButton.setEnabled(true);
        }
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mList);
        vector.add(this.mFileNameText);
        vector.add(this.mBrowseButton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    static {
        sLocallyUniqueDatasetIdKey = null;
        mMatchingVars = new Vector();
        mUnMatchingVarsActiveDataset = new Vector();
        mUnMatchingVarsOtherDataset = new Vector();
    }
}

