/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDataSetsDlg;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsGating;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsUnmatchedFieldsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CompareDatasetsCompareTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener {
    private static final String SRC_VAR_LIST = "IDS_KNN_VARIABLE_SRC_VARLIST";
    static final String FEATURE_TARGET_LIST_KEY = "IDS_KNN_VARIABLE_FEATURE_TARGET_LIST";
    static final String TARGET_LIST_KEY = "IDS_KNN_VARIABLE_TARGET_LIST";
    static final String CASE_IDENTIFICATION_KEY = "IDS_KNN_VARIABLE_CASE_IDENTIFICATION_TARGET_LIST_KEY";
    static final String FOCAL_CASE_IDENTIFIER_KEY = "IDS_KNN_VARIABLE_FOCAL_CASE_IDENTIFIER_TARGET_LIST_KEY";
    private SrcVariableList mVariableSrcList;
    private JLabel mSrcListLabel;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mFieldsToCompareVarList;
    private JScrollPane mFieldsToCompareVarListScrollPane;
    private TargetVariableList mCaseIDsVarList;
    private JScrollPane mCaseIDsVarListScrollPane;
    private ArrowButton mFieldsToCompareArrowButton;
    private ArrowButton mCaseIDsArrowButton;
    private JCheckBox mSortCasesCheckBox;
    private JButton mUnmatchedFieldsButton;
    private JLabel mUnmatchedActiveLabel;
    private JLabel mUnmatchedCompareLabel;

    public CompareDatasetsCompareTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mVariableSrcList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
        this.enableControls();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
        this.enableControls();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        ((CompareDataSetsDlg)this.mParent).enabledOkPaste();
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this.mCaseIDsVarList != null && this.mCaseIDsVarList.getModel().getSize() > 0;
        this.mSortCasesCheckBox.setEnabled(bl);
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    protected boolean canEnableOkPaste() {
        return this.mFieldsToCompareVarList.getModel().getSize() > 0;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_compare_datasets";
    }

    public VarListModel getTargetListModel() {
        return this.mFieldsToCompareVarList.getModel();
    }

    public VarListModel getSrcListModel() {
        return this.mVariableSrcList.getModel();
    }

    public VarListModel getFeatureListModel() {
        return this.mCaseIDsVarList.getModel();
    }

    public String getTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getVarListSyntax("  /VARIABLES ", this.mFieldsToCompareVarList);
        if (string != null && string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        if (this.mCaseIDsVarList.getModel().getSize() > 0 && (string = this.getVarListSyntax("  /CASEID ", this.mCaseIDsVarList)) != null && string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getVarListSyntax(String string, TargetVariableList targetVariableList) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (targetVariableList.getModel().getSize() != 0) {
            for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                if (iSpssVariable == null) continue;
                stringBuffer2.append(iSpssVariable.getName());
                stringBuffer2.append(" ");
            }
        }
        stringBuffer2.toString().trim();
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    boolean hasCategoricalTarget() {
        ISpssVariable iSpssVariable;
        MeasurementLevel measurementLevel;
        boolean bl = false;
        VarListModel varListModel = this.getTargetListModel();
        if (varListModel.getSize() == 1 && ((measurementLevel = (iSpssVariable = varListModel.getElementAt(0)).getDisplayMeasurementLevel()) == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal)) {
            return true;
        }
        return bl;
    }

    @Override
    public void reset() {
        super.reset();
        this.mFieldsToCompareVarList.getModel().removeAll();
        this.mCaseIDsVarList.getModel().removeAll();
        this.setDefaults();
    }

    public boolean setEnabledOkPaste() {
        boolean bl = false;
        if (this.mCaseIDsVarList.getModel().getSize() > 0) {
            bl = true;
        }
        ((CompareDataSetsDlg)this.mParent).enableOkPaste(bl);
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Dimension dimension = this.mSrcScrollPane.getPreferredSize();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(this, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(5, 0, 5, 0);
        DialogUtil.addUsingGBL(this, this.mUnmatchedFieldsButton, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.mUnmatchedActiveLabel, gridBagConstraints, 0, 6, 1, 1, n, null);
        insets.set(5, 0, 15, 0);
        DialogUtil.addUsingGBL(this, this.mUnmatchedCompareLabel, gridBagConstraints, 0, 7, 1, 1, n, null);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_CDS_FIELDS_TO_COMPARE_LIST_LABEL");
        jLabel.setLabelFor(this.mFieldsToCompareVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mFieldsToCompareArrowButton, gridBagConstraints, 1, 2, 1, 1, 10, insets);
        gridBagConstraints.fill = 2;
        insets.set(1, insets2.left, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mFieldsToCompareVarListScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_CDS_CASE_ID_LIST_LABEL");
        jLabel2.setLabelFor(this.mCaseIDsVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mCaseIDsArrowButton, gridBagConstraints, 1, 4, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(this, this.mCaseIDsVarListScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left - 2, n2, 0);
        DialogUtil.addUsingGBL(this, this.mSortCasesCheckBox, gridBagConstraints, 2, 5, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariableSrcList);
        vector.add(this.mFieldsToCompareArrowButton);
        vector.add(this.mCaseIDsArrowButton);
        vector.add(this.mFieldsToCompareVarList);
        vector.add(this.mCaseIDsVarList);
        vector.add(this.mSortCasesCheckBox);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    private void setDefaults() {
        this.loadMatchingVariablesFromGatingDialog();
        this.mVariableSrcList.setSelectedIndex(0);
        this.mFieldsToCompareArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mFieldsToCompareArrowButton.setEnabled(true);
        this.mCaseIDsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSortCasesCheckBox.setSelected(true);
    }

    private void initVars() {
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableSrcList.getModel().addListDataListener(this);
        this.mVariableSrcList.setIdentifier(SRC_VAR_LIST);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_CDS_COMPARE_SRC_LABEL");
        this.mSrcListLabel.setLabelFor(this.mVariableSrcList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_CDS_UNMATCHED_FIELDS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareDatasetsUnmatchedFieldsDlg compareDatasetsUnmatchedFieldsDlg = new CompareDatasetsUnmatchedFieldsDlg((JDialog)CompareDatasetsCompareTab.this.mParent, CompareDatasetsGating.mUnMatchingVarsActiveDataset, CompareDatasetsGating.mUnMatchingVarsOtherDataset);
                compareDatasetsUnmatchedFieldsDlg.setVisible(true);
            }
        };
        this.mUnmatchedFieldsButton = new JButton(toggleButtonAction);
        this.mUnmatchedActiveLabel = DialogUtil.createLabel(this.mParent, "IDS_CDS_UNMATCHED_ACTIVE_LABEL");
        this.mUnmatchedCompareLabel = DialogUtil.createLabel(this.mParent, "IDS_CDS_UNMATCHED_COMPARE_LABEL");
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mFieldsToCompareVarList = new TargetVariableList();
        this.mFieldsToCompareVarList.getModel().addListDataListener(this);
        this.mFieldsToCompareVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFieldsToCompareVarList.setIdentifier(TARGET_LIST_KEY);
        this.mFieldsToCompareVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFieldsToCompareVarList.getFixedCellHeight() * 5));
        this.mFieldsToCompareVarListScrollPane = new JScrollPane(this.mFieldsToCompareVarList);
        this.mFieldsToCompareVarListScrollPane.setPreferredSize(this.mFieldsToCompareVarList.getMinimumSize());
        this.mCaseIDsVarList = new TargetVariableList();
        this.mCaseIDsVarList.getModel().addListDataListener(this);
        this.mCaseIDsVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCaseIDsVarList.setIdentifier(FEATURE_TARGET_LIST_KEY);
        this.mCaseIDsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCaseIDsVarList.getFixedCellHeight() * 5));
        this.mCaseIDsVarListScrollPane = new JScrollPane(this.mCaseIDsVarList);
        this.mCaseIDsVarListScrollPane.setPreferredSize(this.mCaseIDsVarList.getMinimumSize());
        this.mFieldsToCompareArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFieldsToCompareArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFieldsToCompareArrowButton.registerVariableList(this.mFieldsToCompareVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseIDsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseIDsArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseIDsArrowButton.registerVariableList(this.mCaseIDsVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParent, "IDS_CDS_SORT_CASES_CHECKBOX_LABEL");
        this.mSortCasesCheckBox = new JCheckBox(toggleButtonAction2);
        this.mSortCasesCheckBox.addItemListener(this);
        this.loadMatchingVariablesFromGatingDialog();
    }

    private void loadMatchingVariablesFromGatingDialog() {
        this.mVariableSrcList.getModel().removeAll();
        if (CompareDatasetsGating.mMatchingVars != null && CompareDatasetsGating.mMatchingVars.size() > 0) {
            for (ISpssVariable iSpssVariable : CompareDatasetsGating.mMatchingVars) {
                this.mVariableSrcList.getModel().addElement(iSpssVariable);
            }
        }
        int n = CompareDatasetsGating.mUnMatchingVarsActiveDataset != null && CompareDatasetsGating.mUnMatchingVarsActiveDataset.size() > 0 ? CompareDatasetsGating.mUnMatchingVarsActiveDataset.size() : 0;
        int n2 = CompareDatasetsGating.mUnMatchingVarsOtherDataset != null && CompareDatasetsGating.mUnMatchingVarsOtherDataset.size() > 0 ? CompareDatasetsGating.mUnMatchingVarsOtherDataset.size() : 0;
        String string = MessageFormat.format(this.mParent.getResString("IDS_CDS_UNMATCHED_ACTIVE_LABEL"), n);
        this.mUnmatchedActiveLabel.setText(string);
        String string2 = MessageFormat.format(this.mParent.getResString("IDS_CDS_UNMATCHED_COMPARE_LABEL"), n2);
        this.mUnmatchedCompareLabel.setText(string2);
        if (n <= 0 && n2 <= 0) {
            this.mUnmatchedFieldsButton.setEnabled(false);
        }
    }

    public boolean isSortCases() {
        return this.mSortCasesCheckBox.isEnabled() && this.mSortCasesCheckBox.isSelected() && this.mCaseIDsVarList.getModel().getSize() > 0;
    }

    public String getSortCasesSytnax() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSortCases() && (string = this.getVarListSyntax("SORT CASES BY", this.mCaseIDsVarList)) != null && string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    class ConstextTextArea
    extends JTextArea {
        ConstextTextArea(String string) {
            super(string);
            if (this.accessibleContext == null) {
                this.accessibleContext = this.getAccessibleContext();
                this.accessibleContext.setAccessibleName(string);
                this.accessibleContext.setAccessibleDescription(string);
            }
        }

        public void setAccessibleContextName(String string) {
            this.accessibleContext.setAccessibleName(string);
        }

        public void setAccessibleContextDescription(String string) {
            this.accessibleContext.setAccessibleDescription(string);
        }
    }
}

