/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.CheckBoxList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class CompareDatasetsAttributesTab
extends BaseProcedureTab
implements ItemListener {
    static final String ATTR_DONT_COMPARE_RADIO = "IDS_ATTR_DONT_COMPARE_RADIO";
    static final String ATTR_COMPARE_RADIO = "IDS_ATTR_COMPARE_RADIO";
    static final String ATTR_ITEM_VALUELABELS_ID = "valueLabels";
    static final String ATTR_ITEM_CUSTOM_ID = "attributes";
    private JRadioButton mDontCompareDDRadio;
    private JRadioButton mCompareDDRadio;
    private JLabel mCheckboxListLabel;
    private CheckBoxList mCheckboxList;
    private SpssButtonGroup mButtonGroup;
    private DefaultListModel mAttributeModel;

    public CompareDatasetsAttributesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_compare_datasets_attributes";
    }

    public boolean doCompareDataDictionaries() {
        return !this.mDontCompareDDRadio.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mCompareDDRadio.isSelected();
        this.mCheckboxListLabel.setEnabled(bl);
        this.mCheckboxList.setEnabled(bl);
    }

    public String getTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/OUTPUT"));
        Boolean bl = dialogDataModel.getBoolean(ATTR_DONT_COMPARE_RADIO);
        String string = this.getVarPropertiesSyntaxValue();
        if (bl != null) {
            stringBuffer.append(" VARPROPERTIES=");
            if (bl.booleanValue() || string.length() == 0) {
                stringBuffer.append("NONE");
            } else {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(" VARPROPERTIES=NONE");
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    protected boolean canEnableOkPaste() {
        return true;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_ATTR_INFO_LABEL");
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, n, insets.bottom, insets.right);
        int n2 = 23;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(this, this.mDontCompareDDRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2.set(insets.top, n, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mCompareDDRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        insets2.left += n * 2;
        DialogUtil.addUsingGBL(this, this.mCheckboxListLabel, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        JScrollPane jScrollPane = new JScrollPane(this.mCheckboxList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 5, 1, 1, n2, insets2);
        jScrollPane.setMinimumSize(new Dimension(200, 125));
        jScrollPane.setPreferredSize(new Dimension(200, 125));
        this.setTabTraversal();
    }

    private void initVars() {
        this.mDontCompareDDRadio = new JRadioButton(new ToggleButtonAction(this.mParent, ATTR_DONT_COMPARE_RADIO));
        this.mDontCompareDDRadio.addItemListener(this);
        this.mCompareDDRadio = new JRadioButton(new ToggleButtonAction(this.mParent, ATTR_COMPARE_RADIO));
        this.mCompareDDRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mDontCompareDDRadio);
        this.mButtonGroup.add(this.mCompareDDRadio);
        this.mCheckboxList = new CheckBoxList();
        this.mAttributeModel = new DefaultListModel();
        this.mCheckboxListLabel = DialogUtil.createLabel(this.mParent, "IDS_ATTR_LIST_LABEL");
        this.mCheckboxList.setModel(this.mAttributeModel);
        this.mCheckboxListLabel.setLabelFor(this.mCheckboxList);
        this.initAttributeList();
    }

    private void setDefaults() {
        this.mDontCompareDDRadio.setSelected(true);
        this.mCheckboxList.setEnabled(false);
        this.mCheckboxListLabel.setEnabled(false);
        for (int i = 0; i < this.mAttributeModel.size(); ++i) {
            AttributeItem attributeItem = (AttributeItem)this.mAttributeModel.get(i);
            String string = attributeItem.getAttributeId();
            boolean bl = string.equalsIgnoreCase("measure") || string.equalsIgnoreCase(ATTR_ITEM_VALUELABELS_ID) || string.equalsIgnoreCase("missing") || string.equalsIgnoreCase("role");
            attributeItem.setSelected(bl);
        }
    }

    private void setTabTraversal() {
        this.mComponentOrder.clear();
        this.addToComponentOrder(this.mButtonGroup);
        this.addToComponentOrder(this.mCheckboxList);
        for (Component component : this.mParent.getCmdButtonPanel().getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private void initAttributeList() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            VarViewTable varViewTable = (VarViewTable)dataFrame.getDataView().getDataTable(1);
            VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
            Vector<String> vector = varViewTableModel.getDisplayedAttributes();
            for (String string : vector) {
                String string2;
                if (string.startsWith("$") || string.startsWith("@") || string.equals("type") || string.equals("name") || string.equals("decimals")) continue;
                if (string.equals("values")) {
                    string = ATTR_ITEM_VALUELABELS_ID;
                    string2 = this.mParent.getResString("IDS_ATTR_VALUELABELS");
                } else {
                    string2 = VarViewTableModel.columnIdToColumnName(string);
                }
                this.mAttributeModel.addElement(new AttributeItem(string, string2));
            }
            this.mAttributeModel.addElement(new AttributeItem(ATTR_ITEM_CUSTOM_ID, this.mParent.getResString("IDS_ATTR_CUSTOM")));
        }
    }

    private String getVarPropertiesSyntaxValue() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.mAttributeModel.size(); ++i) {
            AttributeItem attributeItem = (AttributeItem)this.mAttributeModel.getElementAt(i);
            if (attributeItem.isSelected()) {
                string = attributeItem.getAttributeId().equalsIgnoreCase("alignment") ? string + "ALIGN" : string + attributeItem.getAttributeId().toUpperCase();
                if (i >= this.mAttributeModel.size() - 1) continue;
                string = string + " ";
                continue;
            }
            bl = false;
        }
        return bl ? "ALL" : string;
    }

    private class AttributeItem
    extends JCheckBox {
        private String attributeId;

        AttributeItem(String string, String string2) {
            super(string2);
            this.attributeId = string;
        }

        String getAttributeId() {
            return this.attributeId;
        }
    }
}

