/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.compare_files;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsAttributesTab;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsCompareTab;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsGating;
import com.spss.java_client.ui.dialogs.base.data.compare_files.CompareDatasetsOutputTab;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.util.CharacterUtil;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CompareDataSetsDlg
extends BaseTabbedDialog {
    public static final String DATASETNAME_COMPARE1 = "Compare1";
    private CompareDatasetsCompareTab mCompareTab;
    private CompareDatasetsAttributesTab mAttributesTab;
    private CompareDatasetsOutputTab mOutputTab;

    public CompareDataSetsDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMPARE_DATASETS_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    public static void setSelectionText(JComponent jComponent) {
        CompareDataSetsDlg.setSelectionText(jComponent, 0);
    }

    public static void setSelectionText(final JComponent jComponent, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setSelectionStart(n);
            ((JTextField)jComponent).setSelectionEnd(((JTextField)jComponent).getText().length());
        }
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        super.reset();
    }

    @Override
    public void saveDialogState() {
    }

    public ISpssDataSrc getActiveDataSrc() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        return DataMgr.getDataMgr().getDataSource(locallyUniqueId);
    }

    public String getActiveDatasetName() {
        String string = null;
        ISpssDataSrc iSpssDataSrc = this.getActiveDataSrc();
        if (iSpssDataSrc != null) {
            string = iSpssDataSrc.getDatasetName();
        }
        return string;
    }

    public String getCompareDatasetName() {
        String string = null;
        string = this.isCompareDataFileBased() ? (this.mCompareTab.isSortCases() ? CompareDatasetsGating.sFileBasedDataSetName : null) : CompareDatasetsGating.sFileNameKey;
        return string;
    }

    public String getCompareFilePath() {
        return this.isCompareDataFileBased() && CompareDatasetsGating.sFileNameKey != null ? CompareDatasetsGating.sFileNameKey : null;
    }

    public boolean isCompareDataFileBased() {
        return CompareDatasetsGating.isCompareDataFileBased();
    }

    @Override
    public boolean canPrependActivateSyntax() {
        return false;
    }

    @Override
    public String generateSyntax() {
        boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.getCompareDatasetName();
        String string2 = this.getCompareFilePath();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = this.getActiveDatasetName();
        if (string3 == null || string3.length() == 0) {
            stringBuffer.append("DATASET NAME Compare1");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        String string4 = string3 = string3 == null || string3.length() == 0 ? DATASETNAME_COMPARE1 : string3;
        if (this.isCopyMisMatchesFieldName()) {
            this.appendCopyMatchesSyntax(stringBuffer, true);
        }
        if (this.isCopyMatchesFieldName()) {
            this.appendCopyMatchesSyntax(stringBuffer, false);
        }
        String string5 = this.mCompareTab.getSortCasesSytnax();
        String string6 = "\nDATASET ACTIVATE ";
        boolean bl2 = string5 != null;
        boolean bl3 = bl = bl2 && this.isCompareDataFileBased();
        if (bl2) {
            if (bl) {
                stringBuffer.append("\nGET FILE= ").append(CharacterUtil.smartQuote((String)string2));
                if (CompareDatasetsGating.sMANGLED_PASSWORD != null) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("PASSWORD=")).append(CharacterUtil.smartQuote((String)CompareDatasetsGating.sMANGLED_PASSWORD));
                }
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append("\nDATASET NAME " + string);
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            stringBuffer.append(string6).append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(string5);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(string6).append(string3).append(" WINDOW=ASIS");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(string5);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            stringBuffer.append(string6).append(string3);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("\nCOMPARE DATASETS"));
        String string7 = "\n  /COMPDATASET = ";
        String string8 = !this.isCompareDataFileBased() || bl ? string : CharacterUtil.smartQuote((String)string2);
        stringBuffer.append(SyntaxUtil.getSubCommand(string7)).append(string8);
        if (CompareDatasetsGating.sMANGLED_PASSWORD != null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("PASSWORD=")).append(CharacterUtil.smartQuote((String)CompareDatasetsGating.sMANGLED_PASSWORD));
        }
        stringBuffer.append(this.mCompareTab.getTabSyntax(dialogDataModel));
        stringBuffer.append(this.mOutputTab.getTabSyntaxPart1(dialogDataModel));
        stringBuffer.append(this.mAttributesTab.getTabSyntax(dialogDataModel));
        stringBuffer.append(this.mOutputTab.getTabSyntaxPart2(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (bl) {
            stringBuffer.append("\nDATASET CLOSE ").append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    private void appendCopyMatchesSyntax(StringBuffer stringBuffer, boolean bl) {
        String string;
        String string2 = string = bl ? this.getCopyMisMatchesFieldName() : this.getCopyMatchesFieldName();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nDATASET DECLARE ");
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    private String getCopyMatchesFieldName() {
        return this.mOutputTab.getCopyMatchesFieldName();
    }

    private String getCopyMisMatchesFieldName() {
        return this.mOutputTab.getCopyMisMatchesFieldName();
    }

    private boolean isCopyMatchesFieldName() {
        return this.mOutputTab.isCopyMatchDataset();
    }

    private boolean isCopyMisMatchesFieldName() {
        return this.mOutputTab.isCopyMismatchDataset();
    }

    public void enabledOkPaste() {
        boolean bl = this.mCompareTab != null && this.mCompareTab.canEnableOkPaste() && this.mAttributesTab != null && this.mAttributesTab.canEnableOkPaste() && this.mOutputTab != null && this.mOutputTab.canEnableOkPaste();
        super.enableOkPaste(bl);
    }

    @Override
    public boolean okPastePressed() {
        if (!this.mCompareTab.validateTab()) {
            return false;
        }
        if (!this.mAttributesTab.validateTab()) {
            return false;
        }
        if (!this.mOutputTab.validateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String getIActionKey() {
        return "data_compare_dataset";
    }

    public CompareDatasetsCompareTab getCompareTab() {
        return this.mCompareTab;
    }

    public CompareDatasetsAttributesTab getAttributesTab() {
        return this.mAttributesTab;
    }

    public CompareDatasetsOutputTab getOutputTab() {
        return this.mOutputTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void init() {
        super.init();
        this.mCompareTab = new CompareDatasetsCompareTab(this);
        this.addTab(this.getResString("IDS_COMPARE_TAB_TITLE"), this.mCompareTab);
        this.mAttributesTab = new CompareDatasetsAttributesTab(this);
        this.addTab(this.getResString("IDS_ATTRIBUTES_TAB_TITLE"), this.mAttributesTab);
        this.mOutputTab = new CompareDatasetsOutputTab(this);
        this.addTab(this.getResString("IDS_OUTPUT_TAB_TITLE"), this.mOutputTab);
        this.pack();
    }
}

