/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.aggregate;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AggregateNameLabel
extends BaseSubDialog
implements FocusListener {
    static final String EMPTY_STR = "";
    private JLabel mNameLabel;
    private JLabel mLabel;
    private StringTextField mNameTxt;
    private StringTextField mLabelTxt;
    private StringTextField mVariableDescTxt;
    private GridBagConstraints mGridConstraints;
    private AggregateDlg mParent;

    public AggregateNameLabel(AggregateDlg aggregateDlg) {
        super(aggregateDlg, aggregateDlg.getResString("IDS_AD_NAMELABEL_TITLE"), true);
        this.mParent = aggregateDlg;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_aggr_namelbl";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mNameTxt) {
            this.mNameTxt.selectAll();
        }
        if (focusEvent.getSource() == this.mLabelTxt) {
            this.mLabelTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        if (this.mNameTxt.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_BADVAR_BAD_LENGTH_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
            this.mNameTxt.requestFocus();
            return false;
        }
        boolean bl = this.checkTextValidation(this.mNameTxt);
        if (bl) {
            PlainList plainList = this.mParent.getPlainList();
            AggregateDlg.ListData listData = (AggregateDlg.ListData)this.mParent.getPlainList().getSelectedValue();
            String string = listData.getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < plainList.getModel().getSize(); ++i) {
                AggregateDlg.ListData listData2 = (AggregateDlg.ListData)plainList.getModel().getElementAt(i);
                String string2 = listData2.getName();
                arrayList.add(string2);
            }
            arrayList.remove(string);
            if (arrayList.contains(this.mNameTxt.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_BADVAR_DUPLICATE_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
                this.mNameTxt.requestFocus();
                return false;
            }
            return true;
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupNameLabelPanel();
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 0, 1, 1, n, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mNameLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_AD_VARIABLE_NAME");
        this.mNameTxt = new StringTextField(10);
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameTxt));
        TextFieldAction textFieldAction = new TextFieldAction(this.mParentDlg, "IDS_AD_VARIABLE_NAME_TXT");
        this.mNameTxt.setAction(textFieldAction);
        this.mNameTxt.addFocusListener(this);
        this.mLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_AD_VARIABLE_LABEL");
        this.mLabelTxt = new StringTextField(10);
        this.mLabel.setLabelFor((Component)((Object)this.mLabelTxt));
        textFieldAction = new TextFieldAction(this.mParentDlg, "IDS_AD_VARIABLE_LABEL_TXT");
        this.mLabelTxt.setAction(textFieldAction);
        this.mLabelTxt.addFocusListener(this);
        this.mVariableDescTxt = new StringTextField();
        this.mVariableDescTxt.setBorder(BorderFactory.createEmptyBorder());
        textFieldAction = new TextFieldAction(this.mParentDlg, "IDS_AD_VARIABLE_DESC_TXT");
        this.mVariableDescTxt.setAction(textFieldAction);
        this.mVariableDescTxt.setEditable(false);
        this.mVariableDescTxt.setOpaque(false);
        this.mGridConstraints = new GridBagConstraints();
    }

    private JPanel setupNameLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 10;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getComponentGroupGap();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(0, n3, n2 * 2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVariableDescTxt), this.mGridConstraints, 1, 0, 3, 1, n, insets2);
        n = 23;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(insets.left, n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameTxt), this.mGridConstraints, 1, 1, 3, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 0;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLabel, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(insets.left, n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelTxt), this.mGridConstraints, 1, 2, 3, 1, n, insets2);
        return jPanel;
    }

    private boolean checkTextValidation(StringTextField stringTextField) {
        boolean bl = false;
        int n = VarNameValidator.validateSPSSName((String)stringTextField.getText(), (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            bl = false;
            stringTextField.selectAll();
            stringTextField.requestFocus();
        } else {
            bl = true;
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNameTxt);
        vector.add(this.mLabelTxt);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

