/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data.aggregate;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateFormatter;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateFunction;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateListCellRenderer;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateMatchingNamesAlert;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateNameLabel;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class AggregateDlg
extends BaseProcedureDialog
implements ListDataListener,
ListSelectionListener,
ActionListener,
FocusListener,
ItemListener,
DocumentListener,
IPlainListVarMoveHandler {
    private static final String DEFAULT_NAME_TXT = "IDS_AD_NAME_DEFAULT_TXT";
    private static final short PERCENTAGES = 0;
    private static final short FRACTIONS = 1;
    private static final short COUNTS = 2;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mBreakTargetList;
    private PlainList mSummariesTargetList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mBreakScrollPane;
    private JScrollPane mSummariesScrollPane;
    private ArrowButton mBreakArrowButton;
    private ComponentsArrowButton mSummariesArrowButton;
    private JLabel mBreakLabel;
    private JLabel mSummariesLabel;
    private JButton mFunctionButton;
    private JButton mNameLabelButton;
    private JCheckBox mNoOfCasesCheckbox;
    private JLabel mNameLabel;
    private StringTextField mNameTxt;
    private JRadioButton mAddVariablesRadio;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDatafileRadio;
    private SpssButtonGroup mSaveButtonGrp;
    private JCheckBox mFileSortedCheckbox;
    private JCheckBox mSortFileCheckbox;
    private JLabel mDatasetNameLabel;
    private StringTextField mDatasetNameTxt;
    private GridBagConstraints mGridConstraints;
    private JButton mFileButton;
    private FileTextField mFileTxt;
    private String mFileStr;
    private boolean mFileExist = true;

    public AggregateDlg(JFrame jFrame) {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_AD_AGGREGATE_DATA"));
        StringBuilder stringBuilder = new StringBuilder(this.getDefaultDirPath());
        char c = stringBuilder.charAt(0) == '/' ? (char)'/' : (char)File.separatorChar;
        stringBuilder.append(c);
        stringBuilder.append(this.getResString("IDS_AD_DEFAULT_FILE"));
        this.mFileTxt.setText(stringBuilder.toString());
    }

    @Override
    public String generateSyntax() {
        String string;
        boolean bl = false;
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("AGGREGATE")).append("\n");
        String string22 = dialogDataModel.getString("IDS_AD_NAME_TXT");
        if (dialogDataModel.getBoolean("IDS_AD_ADD_VARIABLES") == null && dialogDataModel.getBoolean("IDS_AD_CREATE_DATASET") == null && dialogDataModel.getBoolean("IDS_AD_WRITE_DATAFILE") == null) {
            dialogDataModel.putBoolean("IDS_AD_ADD_VARIABLES", true);
        }
        if (dialogDataModel.getBoolean("IDS_AD_NO_OF_CASES") == null || !dialogDataModel.getBoolean("IDS_AD_NO_OF_CASES").booleanValue()) {
            dialogDataModel.putString("IDS_AD_NAME_TXT", null);
        }
        LinkedHashMap<String, String> linkedHashMap = this.getResourceSyntaxMap();
        LinkedHashMap<String, String> linkedHashMap2 = this.getSyntaxMap();
        String string3 = null;
        for (Map.Entry<String, String> object2 : linkedHashMap.entrySet()) {
            Boolean bl2 = dialogDataModel.getBoolean(object2.getKey());
            String string4 = dialogDataModel.getString(object2.getKey());
            if (string4 != null) {
                for (Map.Entry<String, String> entry : linkedHashMap2.entrySet()) {
                    if (!object2.getValue().equals(entry.getKey()) || !object2.getKey().equals("IDS_AD_NAME_TXT")) continue;
                    stringBuffer.append("\n");
                    stringBuffer.append("  /").append(dialogDataModel.getString("IDS_AD_NAME_TXT")).append("=N");
                }
            }
            if (bl2 == null || !bl2.booleanValue()) continue;
            for (Map.Entry<String, String> entry : linkedHashMap2.entrySet()) {
                int n;
                String string5;
                int n2;
                String string6;
                if (!object2.getValue().equals(entry.getKey())) continue;
                if (object2.getKey().equals("IDS_AD_ADD_VARIABLES")) {
                    string6 = entry.getValue();
                    stringBuffer.append(SyntaxUtil.getSubCommand(string6));
                    stringBuffer.append("*");
                    stringBuffer.append(" MODE=ADDVARIABLES");
                    if (AggregateMatchingNamesAlert.sIsOverwriteButtonPressed) {
                        stringBuffer.append(" OVERWRITEVARS=YES");
                        AggregateMatchingNamesAlert.sIsOverwriteButtonPressed = false;
                    }
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/BREAK="));
                    stringBuffer.append(this.mBreakTargetList.getVariablesStringList());
                    String string8 = this.getVariablesStringList();
                    if (!string8.equals("")) {
                        stringBuffer.append("\n");
                        stringBuffer.append("  ");
                        stringBuffer.append(string8);
                    }
                } else if (object2.getKey().equals("IDS_AD_CREATE_DATASET")) {
                    string6 = entry.getValue();
                    stringBuffer.append(SyntaxUtil.getSubCommand(string6));
                    string2 = dialogDataModel.getString("IDS_AD_DATASET_NAME_TXT");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string2));
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/BREAK="));
                    stringBuffer.append(this.mBreakTargetList.getVariablesStringList());
                    String string9 = this.getVariablesStringList();
                    if (string9.length() > 0) {
                        stringBuffer.append("\n");
                        stringBuffer.append("  ");
                        stringBuffer.append(string9);
                    }
                    n2 = stringBuffer.indexOf("AGGREGATE");
                    stringBuffer.insert(n2, SyntaxUtil.getMainCommand("DATASET DECLARE").toString() + SyntaxUtil.getMainCommandParamters(string2) + SyntaxUtil.terminateSyntax());
                    bl = true;
                } else if (object2.getKey().equals("IDS_AD_WRITE_DATAFILE")) {
                    string6 = entry.getValue();
                    stringBuffer.append(SyntaxUtil.getSubCommand(string6));
                    string3 = dialogDataModel.getString("IDS_AD_FILE_TXT");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string3));
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/BREAK="));
                    stringBuffer.append(this.mBreakTargetList.getVariablesStringList());
                    String n3 = this.getVariablesStringList();
                    if (n3.length() > 0) {
                        stringBuffer.append("\n");
                        stringBuffer.append("  ");
                        stringBuffer.append(n3);
                    }
                }
                if (object2.getKey().equals("IDS_AD_FILE_SORTED")) {
                    string6 = entry.getValue();
                    int string52 = stringBuffer.indexOf("/BREAK");
                    stringBuffer.insert(string52, string6 + "\n  ");
                }
                if (!object2.getKey().equals("IDS_AD_SORT_FILE") || (string5 = this.mBreakTargetList.getVariablesStringList()) == null || string5.trim().length() <= 0) continue;
                string6 = entry.getValue();
                n2 = stringBuffer.indexOf(string6);
                if (n2 == -1) {
                    n = stringBuffer.indexOf("/BREAK");
                    stringBuffer.insert(n, string6 + "\n  ");
                    int n3 = stringBuffer.indexOf("AGGREGATE");
                    stringBuffer.insert(n3, SyntaxUtil.getMainCommand("SORT CASES").toString() + SyntaxUtil.getMainCommandParamters("BY ") + string5 + SyntaxUtil.terminateSyntax());
                    continue;
                }
                n = stringBuffer.indexOf("AGGREGATE");
                stringBuffer.insert(n, SyntaxUtil.getMainCommand("SORT CASES").toString() + SyntaxUtil.getMainCommandParamters("BY ") + string5 + SyntaxUtil.terminateSyntax());
            }
        }
        dialogDataModel.putString("IDS_AD_NAME_TXT", string22);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile(string3);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if (bl && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("\nDATASET ACTIVATE ").append(string2);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        ((DefaultListModel)this.mSummariesTargetList.getModel()).removeAllElements();
        this.mBreakTargetList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
        this.mDatasetNameTxt.setText("");
        this.mNameTxt.setText(this.getResString(DEFAULT_NAME_TXT));
        this.mFileSortedCheckbox.setSelected(false);
        this.mSortFileCheckbox.setSelected(false);
        this.mFileTxt.setText("");
        StringBuilder stringBuilder = new StringBuilder(this.getDefaultDirPath());
        char c = stringBuilder.charAt(0) == '/' ? (char)'/' : (char)File.separatorChar;
        stringBuilder.append(c);
        stringBuilder.append(this.getResString("IDS_AD_DEFAULT_FILE"));
        this.mFileTxt.setText(stringBuilder.toString());
        this.mSummariesTargetList.removeAll();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "data_aggregate";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_aggr";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
        this.mSortFileCheckbox.setEnabled(this.mBreakTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
        this.mSortFileCheckbox.setEnabled(this.mBreakTargetList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mSortFileCheckbox.setEnabled(this.mBreakTargetList.getModel().getSize() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() instanceof SrcVariableList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mBreakTargetList.clearSelection();
                this.mSummariesTargetList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mFunctionButton.setEnabled(false);
                this.mNameLabelButton.setEnabled(false);
            } else {
                this.stateOfArrowButtons(false);
            }
        } else if (listSelectionEvent.getSource() == this.mSummariesTargetList) {
            if (this.mSummariesTargetList.getSelectedIndex() != -1) {
                this.mBreakTargetList.clearSelection();
                this.mSrcVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mSummariesTargetList);
            int[] nArray = this.mSummariesTargetList.getSelectedIndices();
            if (nArray.length == 1) {
                this.mFunctionButton.setEnabled(true);
                this.mNameLabelButton.setEnabled(true);
            } else if (nArray.length > 1) {
                this.mFunctionButton.setEnabled(true);
                this.mNameLabelButton.setEnabled(false);
            } else {
                this.mFunctionButton.setEnabled(false);
                this.mNameLabelButton.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource() == this.mBreakTargetList && this.mBreakTargetList.getSelectedIndex() != -1) {
            this.mSummariesTargetList.clearSelection();
            this.mSrcVarList.clearSelection();
            this.mBreakArrowButton.setEnabled(true);
            this.mFunctionButton.setEnabled(false);
            this.mNameLabelButton.setEnabled(false);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof SrcVariableList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.stateOfArrowButtons(true);
                this.mFunctionButton.setEnabled(false);
                this.mNameLabelButton.setEnabled(false);
                this.mBreakTargetList.clearSelection();
                this.mSummariesTargetList.clearSelection();
            } else {
                this.stateOfArrowButtons(false);
            }
        } else if (focusEvent.getSource() == this.mSummariesTargetList) {
            if (this.mSummariesTargetList.getSelectedIndex() != -1) {
                this.mBreakTargetList.clearSelection();
                this.mSrcVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mSummariesTargetList);
            int[] nArray = this.mSummariesTargetList.getSelectedIndices();
            if (nArray.length == 1) {
                this.mFunctionButton.setEnabled(true);
                this.mNameLabelButton.setEnabled(true);
            } else if (nArray.length > 1) {
                this.mFunctionButton.setEnabled(true);
                this.mNameLabelButton.setEnabled(false);
            } else {
                this.mFunctionButton.setEnabled(false);
                this.mNameLabelButton.setEnabled(false);
            }
        } else if (focusEvent.getSource() == this.mBreakTargetList && this.mBreakTargetList.getSelectedIndex() != -1) {
            this.mBreakArrowButton.setEnabled(true);
            this.mSummariesTargetList.clearSelection();
            this.mSrcVarList.clearSelection();
            this.mFunctionButton.setEnabled(false);
            this.mNameLabelButton.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mDatasetNameTxt) {
            this.mDatasetNameTxt.selectAll();
        } else if (focusEvent.getSource() == this.mNameTxt) {
            this.mNameTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return !(jList == this.mBreakTargetList && jList2 == this.mSummariesTargetList || jList == this.mSummariesTargetList && jList2 == this.mBreakTargetList);
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        if (jList == this.mSrcVarList && plainList == this.mSummariesTargetList) {
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            for (ISpssVariable iSpssVariable : (ISpssVariable[])objectArray) {
                ListData listData = new ListData(iSpssVariable);
                if (iSpssVariable.getType() != 0) {
                    listData.setDataResourceString("IDS_AD_FIRST");
                }
                listData.setVarName(iSpssVariable.getName());
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), listData.displayVal(listData.getDataResourceString()), new ISpssVariable[0]));
                listData.setSecondDisplaypart(this.getSecondDisplayValue(listData.getVarName(), listData.getDataResourceString(), listData));
                listData.setName(listData.getFirstDisplayPart());
                objectArray2[n] = listData;
                ++n;
            }
            if (this.mAddVariablesRadio.isSelected()) {
                this.deleteEmptyListObjects();
            }
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        return true;
    }

    public PlainList getPlainlist() {
        return this.mSummariesTargetList;
    }

    @Override
    public boolean okPastePressed() {
        Vector<String> vector = new Vector<String>();
        int n = this.countMatchingSummariesVarNames(vector);
        if (n > 0) {
            new AggregateMatchingNamesAlert(this, this.getResString("IDS_AD_MATCHING_NAMES_ALERT_TITLE"), n, vector);
            if (AggregateMatchingNamesAlert.sIsAlertContinuePressed) {
                this.makeFirstDisplayPartUnique(vector);
                this.makeBreakNameUnique(this.mNameTxt.getText());
                AggregateMatchingNamesAlert.sIsAlertContinuePressed = false;
                return false;
            }
            if (!AggregateMatchingNamesAlert.sIsOverwriteButtonPressed) {
                return false;
            }
        }
        if (this.mNoOfCasesCheckbox.isSelected() && this.mNameTxt.getText().length() == 0) {
            return this.checkVarNameValidation(this.mNameTxt) && super.okPastePressed();
        }
        if (this.mNoOfCasesCheckbox.isSelected() && this.mNameTxt.getText().length() >= 1) {
            boolean bl = this.checkVarNameValidation(this.mNameTxt);
            if (bl && this.mCreateDatasetRadio.isSelected() && this.mDatasetNameTxt.getText().length() >= 1) {
                return this.checkTextValidation(this.mDatasetNameTxt) && super.okPastePressed();
            }
            if (bl && this.mCreateDatasetRadio.isSelected() && this.mDatasetNameTxt.getText().length() == 0) {
                return this.checkTextValidation(this.mDatasetNameTxt) && super.okPastePressed();
            }
            return bl && super.okPastePressed();
        }
        if (this.mCreateDatasetRadio.isSelected() && this.mDatasetNameTxt.getText().length() == 0) {
            return this.checkTextValidation(this.mDatasetNameTxt) && super.okPastePressed();
        }
        if (this.mCreateDatasetRadio.isSelected() && this.mDatasetNameTxt.getText().length() >= 1) {
            return this.checkTextValidation(this.mDatasetNameTxt) && super.okPastePressed();
        }
        if (this.mFileStr == null) {
            this.mFileStr = this.mFileTxt.getText();
        }
        this.mFileExist = this.aggregateFileExists(this.mFileStr);
        if (this.mWriteDatafileRadio.isSelected() && this.mFileExist) {
            int n2;
            CharSequence charSequence;
            Object[] objectArray = new Object[]{this.getResString("IDS_AD_REPLACE_EXISTING_FILE_QUESTION_YES_OPTION"), this.getResString("IDS_AD_REPLACE_EXISTING_FILE_QUESTION_NO_OPTION")};
            if (this.mFileStr == null) {
                charSequence = new StringBuilder(this.getDefaultDirPath());
                char c = ((StringBuilder)charSequence).charAt(0) == '/' ? (char)'/' : (char)File.separatorChar;
                ((StringBuilder)charSequence).append(c);
                ((StringBuilder)charSequence).append(this.getResString("IDS_AD_DEFAULT_FILE"));
                this.mFileStr = ((StringBuilder)charSequence).toString();
            }
            return (n2 = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), (String)(charSequence = String.format(this.getResString("ERR_AD_REPLACE_EXISTING_FILE"), this.mFileStr)), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, objectArray[1])) != -1 && n2 != 1 && super.okPastePressed();
        }
        return super.okPastePressed();
    }

    private boolean isBreakNameUnique(String string) {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(iSpssDataSrc.getVariable(i).getName())) continue;
                return false;
            }
        }
        return true;
    }

    private void makeBreakNameUnique(String string) {
        if (!this.isBreakNameUnique(string)) {
            String string2 = string;
            int n = string2.lastIndexOf("_");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (string.matches(string2 + "_[\\d]+")) {
                ISpssDataSrc iSpssDataSrc = this.getDataSrc();
                if (iSpssDataSrc != null) {
                    int n2;
                    String string3 = "";
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int n3 = iSpssDataSrc.columnCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string3 = iSpssDataSrc.getVariable(n2).getName();
                        if (string3.matches(string2 + "_[\\d]+")) {
                            int n4 = Integer.parseInt(string3.substring(string2.length() + 1));
                            arrayList.add(n4);
                            continue;
                        }
                        if (!string3.equals(string2)) continue;
                        arrayList.add(-1);
                    }
                    if (arrayList.size() > 0) {
                        Collections.sort(arrayList);
                        n2 = (Integer)arrayList.get(0);
                        if (n2 != -1) {
                            this.mNameTxt.setText(string2);
                            return;
                        }
                        while (true) {
                            if (arrayList.contains(n2)) {
                                ++n2;
                                continue;
                            }
                            if (n2 != 0) break;
                            ++n2;
                        }
                        this.mNameTxt.setText(string2 + "_" + n2);
                        return;
                    }
                    if (arrayList.size() == 0) {
                        this.mNameTxt.setText(string2);
                    } else if (string3.equals(string2)) {
                        this.mNameTxt.setText(string2 + "_1");
                    } else {
                        this.mNameTxt.setText(string2);
                    }
                }
            } else {
                String string4 = string + "_1";
                if (this.isBreakNameUnique(string4)) {
                    this.mNameTxt.setText(string4);
                } else {
                    this.makeBreakNameUnique(string4);
                }
            }
        }
    }

    private ISpssDataSrc getDataSrc() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ISpssDataSrc iSpssDataSrc = null;
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void makeFirstDisplayPartUnique(Vector<String> vector) {
        PlainList plainList = this.getPlainlist();
        int n = plainList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            for (String string : vector) {
                ListData listData = (ListData)plainList.getModel().getElementAt(i);
                int n2 = listData.getFirstDisplayPart().indexOf(" ", 0);
                String string2 = "";
                String string3 = "";
                if (n2 != -1) {
                    string2 = listData.getFirstDisplayPart().substring(0, n2);
                    string3 = listData.getFirstDisplayPart().substring(n2 + 1);
                }
                if (listData.getFirstDisplayPart().equals(string)) {
                    listData.setFirstDisplayPart(this.getFirstDisplayValue1(listData.getFirstDisplayPart()));
                    this.deleteEmptyListObjects();
                    continue;
                }
                if (!string2.equals(string)) continue;
                listData.setFirstDisplayPart(this.getFirstDisplayValue1(string2));
                listData.setFirstDisplayPart(listData.getFirstDisplayPart() + " " + string3);
                this.deleteEmptyListObjects();
            }
        }
    }

    private int countMatchingSummariesVarNames(Vector<String> vector) {
        int n = 0;
        if (!this.mAddVariablesRadio.isSelected()) {
            return n;
        }
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc != null) {
                int n2 = iSpssDataSrc.columnCount();
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < this.mSummariesTargetList.getModel().getSize(); ++j) {
                        ListData listData = (ListData)this.mSummariesTargetList.getModel().getElementAt(j);
                        int n3 = listData.getFirstDisplayPart().indexOf(" ", 0);
                        String string = "";
                        if (n3 != -1) {
                            string = listData.getFirstDisplayPart().substring(0, n3);
                        }
                        if (listData.getFirstDisplayPart().equals(iSpssDataSrc.getVariable(i).getName())) {
                            ++n;
                            vector.add(listData.getFirstDisplayPart());
                            continue;
                        }
                        if (!iSpssDataSrc.getVariable(i).getName().equals(string)) continue;
                        ++n;
                        vector.add(string);
                    }
                }
            }
        }
        if (!this.isBreakNameUnique(this.mNameTxt.getText())) {
            vector.add(this.mNameTxt.getText());
            ++n;
        }
        return n;
    }

    private boolean aggregateFileExists(String string) {
        boolean bl = false;
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            boolean bl2;
            Object object;
            if (string == null) {
                return false;
            }
            if (!string.startsWith("\\\\") && ((String)(object = string)).length() > 0) {
                string = object;
            }
            object = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            ((RemoteFileChooser)object).setSelectedFile((File)new RefFile(string));
            RemoteFileStatus remoteFileStatus = ((RemoteFileChooser)object).validateServerFile(string);
            boolean bl3 = bl2 = !remoteFileStatus.errorOccurred();
            if (bl2) {
                bl = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
            }
        } else {
            File file = new File(this.mFileStr);
            bl = file.exists();
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
        int[] nArray = new int[this.mSummariesTargetList.getSelectedIndices().length];
        if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
            Object object;
            if (this.mSummariesTargetList.getSelectedValues().length == 1) {
                object = (ListData)this.mSummariesTargetList.getModel().getElementAt(this.mSummariesTargetList.getSelectedIndex());
                String string = ((ListData)object).getVarName();
                for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
                    if (!string.equals(this.mSrcVarList.getModel().getElementAt(i).getName())) continue;
                    this.mSrcVarList.setSelectedIndex(i);
                }
                ((DefaultListModel)this.mSummariesTargetList.getModel()).removeElement(object);
            } else {
                int n = 0;
                int[] nArray2 = this.mSummariesTargetList.getSelectedIndices();
                int n2 = nArray2.length;
                for (int i = n2 - 1; i >= 0; --i) {
                    ListData listData = (ListData)((DefaultListModel)this.mSummariesTargetList.getModel()).getElementAt(nArray2[i]);
                    String string = listData.getVarName();
                    for (int j = 0; j < this.mSrcVarList.getModel().getSize(); ++j) {
                        if (!string.equals(this.mSrcVarList.getModel().getElementAt(j).getName())) continue;
                        nArray[n] = j;
                        ++n;
                        break;
                    }
                    ((DefaultListModel)this.mSummariesTargetList.getModel()).removeElement(listData);
                }
                this.mSrcVarList.setSelectedIndices(nArray);
            }
            object = this.mSrcVarList;
            SwingUtilities.invokeLater(new Runnable((VariableList)object){
                final /* synthetic */ VariableList val$varList;
                {
                    this.val$varList = variableList;
                }

                @Override
                public void run() {
                    this.val$varList.requestFocus();
                }
            });
        } else {
            DefaultListModel defaultListModel = (DefaultListModel)this.mSummariesTargetList.getModel();
            ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
            this.mSrcVarList.clearSelection();
            int n = this.mSummariesTargetList.getModel().getSize();
            int n3 = n + iSpssVariableArray.length - 1;
            this.mSummariesTargetList.clearSelection();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                ListData listData = new ListData(iSpssVariable);
                if (iSpssVariable.getType() != 0) {
                    listData.setDataResourceString("IDS_AD_FIRST");
                }
                listData.setVarName(iSpssVariable.getName());
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), listData.displayVal(listData.getDataResourceString()), iSpssVariable));
                listData.setSecondDisplaypart(this.getSecondDisplayValue(listData.getVarName(), listData.getDataResourceString(), listData));
                listData.setName(listData.getFirstDisplayPart());
                defaultListModel.addElement(listData);
            }
            if (this.mAddVariablesRadio.isSelected()) {
                this.deleteEmptyListObjects();
            }
            this.mSummariesTargetList.addSelectionInterval(n, n3);
            this.mSummariesTargetList.ensureIndexIsVisible(n3);
            final PlainList plainList = this.mSummariesTargetList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    plainList.requestFocus();
                }
            });
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && object == this.mAddVariablesRadio) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameTxt.setEnabled(false);
            this.mDatasetNameTxt.setOpaque(false);
            this.mFileButton.setEnabled(false);
            this.mFileTxt.setEnabled(false);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (itemEvent.getStateChange() == 1 && object == this.mCreateDatasetRadio) {
            this.mDatasetNameLabel.setEnabled(true);
            this.mDatasetNameTxt.setEnabled(true);
            this.mDatasetNameTxt.setOpaque(true);
            this.mFileButton.setEnabled(false);
            this.mFileTxt.setEnabled(false);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (itemEvent.getStateChange() == 1 && object == this.mWriteDatafileRadio) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameTxt.setEnabled(false);
            this.mDatasetNameTxt.setOpaque(false);
            this.mFileButton.setEnabled(true);
            this.mFileTxt.setEnabled(true);
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (object == this.mNoOfCasesCheckbox && this.mNoOfCasesCheckbox.isSelected()) {
            this.mNameTxt.setEnabled(true);
            this.mNameTxt.setOpaque(true);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (object == this.mNoOfCasesCheckbox && !this.mNoOfCasesCheckbox.isSelected()) {
            this.mNameTxt.setEnabled(false);
            this.mNameTxt.setOpaque(false);
            this.enableOkPaste(this.canEnableOkPaste());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public PlainList getPlainList() {
        return this.mSummariesTargetList;
    }

    public void paint(Graphics graphics) {
        if (this.mFileStr != null) {
            this.mFileTxt.setText(this.mFileStr);
        }
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        String string;
        super.loadDialogState();
        this.validateSerializableLists();
        if (this.mSummariesTargetList.getModel().getSize() >= 1 || this.mNoOfCasesCheckbox.isSelected()) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
        if (this.mCreateDatasetRadio.isSelected()) {
            this.mDatasetNameLabel.setEnabled(true);
            this.mDatasetNameTxt.setEnabled(true);
            this.mDatasetNameTxt.setOpaque(true);
        } else if (this.mWriteDatafileRadio.isSelected()) {
            this.mFileButton.setEnabled(true);
            this.mFileTxt.setEnabled(true);
        }
        if (this.mNoOfCasesCheckbox.isSelected()) {
            this.mNameTxt.setEnabled(true);
            this.mNameTxt.setOpaque(true);
        }
        if ((string = this.getDialogDataModel().getString("IDS_AD_FILE_TXT")) != null) {
            this.mFileTxt.setText(string);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void validateSerializableLists() {
        for (int i = this.mSummariesTargetList.getModel().getSize() - 1; i >= 0; --i) {
            String string;
            String string2;
            ListData listData = (ListData)this.mSummariesTargetList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(listData.getVarName());
            ISpssVariable iSpssVariable = listData.getMVariable();
            if (n == -1) {
                boolean bl = iSpssDataSrc.isVariableInCurrentSet(listData.getMVariable());
                if (!bl) {
                    ((DefaultListModel)this.mSummariesTargetList.getModel()).removeElementAt(i);
                    continue;
                }
                listData.setVarName(iSpssVariable.getName());
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), listData.displayVal(listData.getDataResourceString()), new ISpssVariable[0]));
                string2 = listData.displayVal(listData.getDataResourceString());
                string = string2 + "(" + listData.getVarName() + ")";
                listData.setSecondDisplaypart(string);
                if (!this.mAddVariablesRadio.isSelected()) continue;
                this.deleteEmptyListObjects();
                continue;
            }
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n);
            if (iSpssVariable2.getType() == listData.getMVarType()) continue;
            listData.setMVarType(iSpssVariable2.getType());
            if (iSpssVariable2.getType() != 0) {
                listData.setDataResourceString("IDS_AD_FIRST");
            } else if (iSpssVariable2.getType() == 0) {
                listData.setDataResourceString("IDS_AD_MEAN");
            }
            listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), listData.displayVal(listData.getDataResourceString()), new ISpssVariable[0]));
            string2 = listData.displayVal(listData.getDataResourceString());
            string = string2 + "(" + listData.getVarName() + ")";
            listData.setSecondDisplaypart(string);
            if (!this.mAddVariablesRadio.isSelected()) continue;
            this.deleteEmptyListObjects();
        }
        this.mSummariesTargetList.repaint();
        this.enableOkPaste(this.canEnableOkPaste());
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSummariesTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSummariesTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSummariesTargetList, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        this.mSrcScrollPane.setPreferredSize(this.mSrcScrollPane.getMinimumSize());
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.addListSelectionListener(this);
        this.mBreakTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mBreakTargetList.setIdentifier("TargetListIdentifier");
        this.mBreakScrollPane = new JScrollPane(this.mBreakTargetList);
        this.mBreakTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mBreakTargetList.getFixedCellHeight() * 2 + 2));
        this.mBreakScrollPane.setPreferredSize(this.mBreakTargetList.getMinimumSize());
        this.mBreakTargetList.setMaxLimitOfList(100);
        this.mBreakTargetList.getModel().addListDataListener(this);
        this.mBreakTargetList.addFocusListener(this);
        this.mBreakTargetList.addListSelectionListener(this);
        this.mVarMoveHandler = new AggregateVarMoveHandler();
        this.mBreakArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mBreakArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mBreakArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mBreakArrowButton.registerVariableList(this.mBreakTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mSummariesTargetList = new PlainList("IDS_AD_PLAINLIST", PlainList.DragType.eAutoDragCopy);
        this.mSummariesScrollPane = new JScrollPane(this.mSummariesTargetList);
        this.mSummariesTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSummariesTargetList.getFixedCellHeight() * 6 + 2));
        this.mSummariesScrollPane.setPreferredSize(this.mSummariesTargetList.getMinimumSize());
        AggregateFormatter aggregateFormatter = new AggregateFormatter(this.mSummariesTargetList);
        this.mSummariesTargetList.setCellRenderer(new AggregateListCellRenderer(aggregateFormatter));
        this.mSummariesTargetList.getModel().addListDataListener(this);
        this.mSummariesTargetList.addListSelectionListener(this);
        this.mSummariesArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSummariesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSummariesArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSummariesArrowButton.registerComponents(this.mSummariesTargetList, SpssArrowButton.ButtonOrientation.left);
        ActionListener[] actionListenerArray = this.mSummariesArrowButton.getActionListeners();
        this.mSummariesTargetList.addFocusListener(this);
        this.mSrcVarList.addFocusListener(this);
        for (ActionListener actionListener : actionListenerArray) {
            this.mSummariesArrowButton.removeActionListener(actionListener);
        }
        this.mSummariesArrowButton.addActionListener(this);
        this.mBreakLabel = DialogUtil.createLabel(this, "IDS_AD_BREAK_VARIABLE");
        this.mBreakLabel.setLabelFor(this.mBreakTargetList);
        this.mSummariesLabel = DialogUtil.createLabel(this, "IDS_AD_SUMMARIES_VARIABLE");
        this.mSummariesLabel.setLabelFor(this.mSummariesTargetList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_AD_NO_OF_CASES");
        this.mNoOfCasesCheckbox = new JCheckBox(toggleButtonAction);
        this.mNoOfCasesCheckbox.addItemListener(this);
        this.mNameTxt = new StringTextField(10);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_AD_NAME");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameTxt));
        TextFieldAction textFieldAction = new TextFieldAction(this, "IDS_AD_NAME_TXT");
        this.mNameTxt.setAction(textFieldAction);
        this.mNameTxt.setText(this.getResString(DEFAULT_NAME_TXT));
        this.mNameTxt.getDocument().addDocumentListener(this);
        this.mNameTxt.addFocusListener(this);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_AD_FUNCTION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateDlg.this.runFunctionSubDlg();
            }
        };
        this.mFunctionButton = new JButton(toggleButtonAction2);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_AD_NAME_LABEL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateDlg.this.runNameLabelSubDlg();
            }
        };
        this.mNameLabelButton = new JButton(toggleButtonAction3);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.mFunctionButton);
        jPanel.add(this.mNameLabelButton);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_AD_ADD_VARIABLES");
        this.mAddVariablesRadio = new JRadioButton(toggleButtonAction4);
        this.mAddVariablesRadio.addItemListener(this);
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, "IDS_AD_CREATE_DATASET");
        this.mCreateDatasetRadio = new JRadioButton(toggleButtonAction5);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mDatasetNameTxt = new StringTextField(10);
        this.mDatasetNameLabel = DialogUtil.createLabel(this, "IDS_AD_DATASET_NAME");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameTxt));
        TextFieldAction textFieldAction2 = new TextFieldAction(this, "IDS_AD_DATASET_NAME_TXT");
        this.mDatasetNameTxt.setAction(textFieldAction2);
        this.mDatasetNameTxt.addFocusListener(this);
        this.mDatasetNameTxt.getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction(this, "IDS_AD_WRITE_DATAFILE");
        this.mWriteDatafileRadio = new JRadioButton(toggleButtonAction6);
        this.mWriteDatafileRadio.addItemListener(this);
        this.mSaveButtonGrp = new SpssButtonGroup();
        this.mSaveButtonGrp.add(this.mAddVariablesRadio);
        this.mSaveButtonGrp.add(this.mCreateDatasetRadio);
        this.mSaveButtonGrp.add(this.mWriteDatafileRadio);
        ToggleButtonAction toggleButtonAction7 = new ToggleButtonAction(this, "IDS_AD_FILE_SORTED");
        this.mFileSortedCheckbox = new JCheckBox(toggleButtonAction7);
        ToggleButtonAction toggleButtonAction8 = new ToggleButtonAction(this, "IDS_AD_SORT_FILE");
        this.mSortFileCheckbox = new JCheckBox(toggleButtonAction8);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mFileSortedCheckbox);
        spssButtonGroup.add(this.mSortFileCheckbox);
        StringBuilder stringBuilder = new StringBuilder(this.getDefaultDirPath());
        if (stringBuilder.length() != 0) {
            char c = stringBuilder.charAt(0) == '/' ? (char)'/' : (char)File.separatorChar;
            stringBuilder.append(c);
        }
        stringBuilder.append(this.getResString("IDS_AD_DEFAULT_FILE"));
        this.mFileTxt = new FileTextField();
        this.mFileTxt.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTxt.setColumns(30);
        this.mFileTxt.setText(stringBuilder.toString());
        TextFieldAction textFieldAction3 = new TextFieldAction(this, "IDS_AD_FILE_TXT");
        this.mFileTxt.setAction(textFieldAction3);
        ToggleButtonAction toggleButtonAction9 = new ToggleButtonAction(this, "IDS_AD_FILE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                RefFileFilter refFileFilter = new RefFileFilter(AggregateDlg.this.getResString("IDS_AD_FILTER_DESCRIPTION"), AggregateDlg.this.getResString("IDS_AD_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setDialogTitle(AggregateDlg.this.getResString("IDS_AD_FILE_DIALOG_TITLE"));
                int n = remoteFileChooser.showSaveDialog((Component)((Object)AggregateDlg.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    AggregateDlg.this.mFileStr = remoteFileChooser.getSelectedFilePath();
                    if (!AggregateDlg.this.mFileStr.endsWith(AggregateDlg.this.getResString("IDS_AD_FILE_EXTENSION"))) {
                        AggregateDlg.this.mFileStr = AggregateDlg.this.mFileStr + AggregateDlg.this.getResString("IDS_AD_FILE_EXTENSION");
                    }
                    AggregateDlg.this.mFileTxt.setText(AggregateDlg.this.mFileStr);
                    boolean bl = false;
                    if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                        boolean bl2;
                        RemoteFileSysUtil remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
                        RemoteFileStatus remoteFileStatus = remoteFileSysUtil.validateFile(AggregateDlg.this.mFileStr);
                        boolean bl3 = bl2 = !remoteFileStatus.errorOccurred();
                        if (bl2) {
                            bl = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
                        }
                    } else {
                        bl = remoteFileChooser.getSelectedFile().exists();
                    }
                    AggregateDlg.this.mFileExist = bl;
                }
            }
        };
        this.mFileButton = new JButton(toggleButtonAction9);
        this.mGridConstraints = new GridBagConstraints();
        this.mPlainListVarMoveHandler = this;
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mNoOfCasesCheckbox.setSelected(false);
        this.mNameTxt.setEnabled(false);
        this.mNameTxt.setOpaque(false);
        this.mAddVariablesRadio.setSelected(true);
        this.mDatasetNameLabel.setEnabled(false);
        this.mDatasetNameTxt.setEnabled(false);
        this.mDatasetNameTxt.setOpaque(false);
        this.mFileButton.setEnabled(false);
        this.mFileTxt.setEnabled(false);
        this.mFileTxt.setEditable(false);
        this.mFunctionButton.setEnabled(false);
        this.mNameLabelButton.setEnabled(false);
        this.mSortFileCheckbox.setEnabled(this.mBreakTargetList.getModel().getSize() > 0);
    }

    private String getDefaultDirPath() {
        return FileLocationsUtil.getDataFilesDirectoryPath();
    }

    private String getFirstDisplayValue(String string, String string2, ISpssVariable ... iSpssVariableArray) {
        int n;
        ListData listData;
        String string3 = string + "_" + string2.toLowerCase();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.mAddVariablesRadio.isSelected() && iSpssVariableArray.length > 0) {
            ISpssVariable iSpssVariable = iSpssVariableArray[0];
            listData = new ListData(iSpssVariable);
            listData.setVarName(iSpssVariable.getName());
            listData.setFirstDisplayPart(iSpssVariable.getName());
            listData.setSecondDisplaypart("");
            listData.setName(listData.getFirstDisplayPart());
            ((DefaultListModel)this.mSummariesTargetList.getModel()).addElement(listData);
        }
        for (n = 0; n < this.mSummariesTargetList.getModel().getSize(); ++n) {
            listData = (ListData)this.mSummariesTargetList.getModel().getElementAt(n);
            String string4 = listData.getFirstDisplayPart();
            if (string4.matches(string3 + "_[\\d]+")) {
                int n2 = Integer.parseInt(string4.substring(string3.length() + 1));
                arrayList.add(n2);
                continue;
            }
            if (string4.matches(string3 + "_[\\d]+" + "[ ]" + "[']" + "[a-zA-Z1-9!@#$%^&*()<>?,./{}\\[\\]]+" + "[']")) {
                String string5 = string4.substring(string3.length() + 1);
                int n3 = string5.indexOf("'");
                String string6 = string5.substring(0, n3 - 1);
                int n4 = Integer.parseInt(string6);
                arrayList.add(n4);
                continue;
            }
            if (string4.matches(string3 + "[ ]" + "[']" + "[a-zA-Z1-9!@#$%^&*()<>?,./{}\\[\\]]+" + "[']")) {
                arrayList.add(-1);
                continue;
            }
            if (!string4.equals(string3)) continue;
            arrayList.add(-1);
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            n = (Integer)arrayList.get(0);
            if (n != -1) {
                return string3;
            }
            while (true) {
                if (arrayList.contains(n)) {
                    ++n;
                    continue;
                }
                if (n != 0) break;
                ++n;
            }
            return string3 + "_" + n;
        }
        if (arrayList.size() == 0) {
            return string3;
        }
        return string3;
    }

    private String getFirstDisplayValue1(String string) {
        Object object;
        int n;
        String string2 = string;
        String string3 = "";
        int n2 = string.lastIndexOf("_");
        if (n2 != -1) {
            string3 = string2.substring(0, n2);
        }
        if (string.matches(string3 + "_[\\d]+")) {
            string2 = string2.substring(0, n2);
        }
        String string4 = "";
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.mAddVariablesRadio.isSelected()) {
            for (n = 0; n < this.mSrcVarList.getModel().getSize(); ++n) {
                object = this.mSrcVarList.getModel().getElementAt(n);
                ListData listData = new ListData((ISpssVariable)object);
                listData.setVarName(object.getName());
                listData.setFirstDisplayPart(object.getName());
                listData.setSecondDisplaypart("");
                listData.setName(listData.getFirstDisplayPart());
                ((DefaultListModel)this.mSummariesTargetList.getModel()).addElement(listData);
            }
        }
        for (n = 0; n < this.mSummariesTargetList.getModel().getSize(); ++n) {
            object = (ListData)this.mSummariesTargetList.getModel().getElementAt(n);
            string4 = ((ListData)object).getFirstDisplayPart();
            if (string4.matches(string2 + "_[\\d]+")) {
                int n3 = Integer.parseInt(string4.substring(string2.length() + 1));
                arrayList.add(n3);
                continue;
            }
            if (string4.matches(string2 + "_[\\d]+" + "[ ]" + "[']" + "[a-zA-Z1-9!@#$%^&*()<>?,./{}\\[\\]]+" + "[']")) {
                String string5 = string4.substring(string2.length() + 1);
                int n4 = string5.indexOf("'");
                String string6 = string5.substring(0, n4 - 1);
                int n5 = Integer.parseInt(string6);
                arrayList.add(n5);
                continue;
            }
            if (string4.matches(string2 + "[ ]" + "[']" + "[a-zA-Z1-9!@#$%^&*()<>?,./{}\\[\\]]+" + "[']")) {
                arrayList.add(-1);
                continue;
            }
            if (!string4.equals(string2)) continue;
            arrayList.add(-1);
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            n = (Integer)arrayList.get(0);
            if (n != -1) {
                return string2;
            }
            while (true) {
                if (arrayList.contains(n)) {
                    ++n;
                    continue;
                }
                if (n != 0) break;
                ++n;
            }
            return string2 + "_" + n;
        }
        if (arrayList.size() == 0) {
            return string2;
        }
        if (string4.equals(string2)) {
            return string2 + "_1";
        }
        return string2;
    }

    private void deleteEmptyListObjects() {
        for (int i = this.mSummariesTargetList.getModel().getSize() - 1; i >= 0; --i) {
            ListData listData = (ListData)this.mSummariesTargetList.getModel().getElementAt(i);
            if (!listData.getSecondDisplaypart().equals("")) continue;
            ((DefaultListModel)this.mSummariesTargetList.getModel()).removeElement(listData);
        }
    }

    private String getSecondDisplayValue(String string, String string2, ListData listData) {
        return listData.displayVal(string2).toUpperCase() + "(" + string + ")";
    }

    private boolean checkVarNameValidation(StringTextField stringTextField) {
        boolean bl = true;
        int n = VarNameValidator.validateSPSSName((String)stringTextField.getText(), (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            stringTextField.selectAll();
            stringTextField.requestFocus();
            bl = false;
        }
        return bl;
    }

    private boolean checkTextValidation(StringTextField stringTextField) {
        boolean bl = true;
        int n = DatasetNameValidator.validateDatasetName((String)stringTextField.getText(), (Component)((Object)this));
        if (n != 1) {
            stringTextField.selectAll();
            stringTextField.requestFocus();
            bl = false;
        }
        return bl;
    }

    private String getVariablesStringList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mSummariesTargetList.getModel();
        String string = "";
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            ListData listData = (ListData)defaultListModel.getElementAt(i);
            string = i == 0 ? string + "/" + listData.getFirstDisplayPart() + "=" + listData.getSecondDisplaypart() + " " : string + "\n  /" + listData.getFirstDisplayPart() + "=" + listData.getSecondDisplaypart() + " ";
        }
        if (string.length() != 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private boolean canEnableOkPaste() {
        boolean bl = false;
        if (this.mAddVariablesRadio.isSelected()) {
            if (this.mNoOfCasesCheckbox.isSelected()) {
                if (this.mNameTxt.getText().length() >= 1) {
                    bl = true;
                }
            } else if (this.mSummariesTargetList.getModel().getSize() >= 1) {
                bl = true;
            }
        } else if (this.mCreateDatasetRadio.isSelected()) {
            if (this.mNoOfCasesCheckbox.isSelected()) {
                if (this.mNameTxt.getText().length() >= 1 && this.mDatasetNameTxt.getText().length() >= 1) {
                    bl = true;
                }
            } else if (this.mSummariesTargetList.getModel().getSize() >= 1 && this.mDatasetNameTxt.getText().length() >= 1) {
                bl = true;
            }
        } else if (this.mWriteDatafileRadio.isSelected()) {
            if (this.mNoOfCasesCheckbox.isSelected()) {
                if (this.mNameTxt.getText().length() >= 1) {
                    bl = true;
                }
            } else if (this.mSummariesTargetList.getModel().getSize() >= 1) {
                bl = true;
            }
        }
        return bl;
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupBreakVariablesPanel();
        JPanel jPanel3 = this.setupAggregatedVariablesPanel();
        JPanel jPanel4 = this.setupSavePanel();
        JPanel jPanel5 = this.setupOptionsPanel();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        int n = 23;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_AD_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel6, jLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weightx = 0.6;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel6, this.mSrcScrollPane, this.mGridConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel6, this.mGridConstraints, 0, 0, 1, 3, n, null);
        this.mGridConstraints.weightx = 0.4;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 1, 0, 1, 1, n, null);
        Insets insets = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 1, 1, 1, 2, n, insets);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mGridConstraints, 0, 3, 2, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, this.mGridConstraints, 0, 4, 2, 1, n, insets);
    }

    private JPanel setupBreakVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mBreakLabel, this.mGridConstraints, 1, 0, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        insets2.set(insets.top, insets.left + n2 * 2 + 1, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBreakArrowButton, this.mGridConstraints, 0, 1, 1, 1, 10, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        insets2.set(0, 0, 0, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mBreakScrollPane, this.mGridConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupAggregatedVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_AD_AGGREGATED_VARS_TITLE")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesLabel, this.mGridConstraints, 1, 0, 4, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSummariesArrowButton, this.mGridConstraints, 0, 1, 1, 1, 10, insets);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        insets2.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesScrollPane, this.mGridConstraints, 1, 1, 4, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFunctionButton, this.mGridConstraints, 1, 2, 2, 1, n, insets2);
        insets2.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNameLabelButton, this.mGridConstraints, 3, 2, 2, 1, n, insets2);
        JPanel jPanel2 = this.setupNumberOfCasesPanel();
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 3, 5, 1, n, null);
        return jPanel;
    }

    private JPanel setupNumberOfCasesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(n2, insets.left, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNoOfCasesCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(n2, n2 * 4, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, this.mGridConstraints, 1, 0, 1, 1, 22, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(n2, n2 * 2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameTxt), this.mGridConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupSavePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_AD_SAVE_TITLE")));
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAddVariablesRadio, this.mGridConstraints, 0, 0, 2, 1, n, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDatasetRadio, this.mGridConstraints, 0, 1, 2, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        insets2.set(n2, n2 * 6, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, this.mGridConstraints, 0, 2, 1, 1, 10, insets2);
        this.mGridConstraints.weightx = 1.0;
        insets2.set(n2, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameTxt), this.mGridConstraints, 1, 2, 1, 1, 21, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mWriteDatafileRadio, this.mGridConstraints, 0, 3, 2, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(n2, n2 * 6, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, this.mGridConstraints, 0, 4, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(n2 + insets.left, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTxt), this.mGridConstraints, 1, 4, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_AD_OPTIONS_TITLE")));
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFileSortedCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSortFileCheckbox, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private LinkedHashMap<String, String> getResourceSyntaxMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_AD_ADD_VARIABLES", "*");
        linkedHashMap.put("IDS_AD_CREATE_DATASET", "'value'");
        linkedHashMap.put("IDS_AD_WRITE_DATAFILE", "'file'");
        linkedHashMap.put("IDS_AD_FILE_SORTED", "filesorted");
        linkedHashMap.put("IDS_AD_SORT_FILE", "sortedfile");
        linkedHashMap.put("IDS_AD_NUMBER_OF_CASES", "noc");
        linkedHashMap.put("IDS_AD_NAME_TXT", "'name'");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> getSyntaxMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("*", "/OUTFILE=");
        linkedHashMap.put("'value'", "/OUTFILE=");
        linkedHashMap.put("'file'", "/OUTFILE=");
        linkedHashMap.put("filesorted", "/PRESORTED");
        linkedHashMap.put("sortedfile", "/PRESORTED");
        linkedHashMap.put("noc", "=N");
        linkedHashMap.put("'name'", "");
        return linkedHashMap;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mBreakArrowButton);
        vector.add(this.mSummariesArrowButton);
        vector.add(this.mBreakTargetList);
        vector.add(this.mSummariesTargetList);
        vector.add(this.mFunctionButton);
        vector.add(this.mNameLabelButton);
        vector.add(this.mNoOfCasesCheckbox);
        vector.add(this.mNameTxt);
        vector.add(this.mSaveButtonGrp);
        vector.add(this.mDatasetNameTxt);
        vector.add(this.mFileButton);
        vector.add(this.mFileSortedCheckbox);
        vector.add(this.mSortFileCheckbox);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void runFunctionSubDlg() {
        PlainList plainList = this.getPlainlist();
        int[] nArray = plainList.getSelectedIndices();
        this.clearDDM();
        if (nArray.length == 1) {
            ListData listData = (ListData)plainList.getModel().getElementAt(plainList.getSelectedIndex());
            if (listData.getMVariable().getType() != 0) {
                this.getDialogDataModel().putBoolean("STRING", true);
            } else {
                this.getDialogDataModel().putBoolean("STRING", false);
            }
            String string = listData.getVarName();
            String string2 = listData.getSecondDisplaypart();
            int n = string2.indexOf("(");
            String string3 = string2.substring(0, n);
            String string4 = listData.getResourceString(string3);
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            dialogDataModel.putBoolean(string4, true);
            if (string4.equals("IDS_AD_PFC_ABOVE") || string4.equals("IDS_AD_PFC_BELOW")) {
                if (!this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
                    dialogDataModel.putString("IDS_AD_PFC_VALUE_TXT", listData.getValue());
                } else if (this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
                    String string5 = listData.getValue();
                    String string6 = string5.substring(1, string5.length() - 1);
                    dialogDataModel.putString("IDS_AD_PFC_VALUE_TXT", string6);
                }
            } else if (string4.equals("IDS_AD_PFC_INSIDE") || string4.equals("IDS_AD_PFC_OUTSIDE")) {
                if (!this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
                    dialogDataModel.putString("IDS_AD_PFC_LOW_TXT", listData.getLow());
                    dialogDataModel.putString("IDS_AD_PFC_HIGH_TXT", listData.getHigh());
                } else if (this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
                    String string7 = listData.getLow();
                    String string8 = string7.substring(1, string7.length() - 1);
                    dialogDataModel.putString("IDS_AD_PFC_LOW_TXT", string8);
                    string7 = listData.getHigh();
                    string8 = string7.substring(1, string7.length() - 1);
                    dialogDataModel.putString("IDS_AD_PFC_HIGH_TXT", string8);
                }
            }
            super.runSubDialog(new AggregateFunction(this));
            this.updateSingleListDataObject(plainList, listData, string);
            dialogDataModel.putBoolean("STRING", null);
            dialogDataModel.putBoolean("STRINGD", null);
            dialogDataModel.putBoolean("NONE", null);
            AggregateFunction.sIsContinueButtonPressed = false;
        } else {
            String string;
            Object object;
            int n3;
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            for (int n3 : nArray) {
                object = (ListData)plainList.getModel().getElementAt(n3);
                if (((ListData)object).getMVariable().getType() != 0) {
                    ++n2;
                }
                string = ((ListData)object).getSecondDisplaypart();
                int n4 = string.indexOf("(");
                String string9 = string.substring(0, n4);
                vector.add(string9);
            }
            Object object2 = vector.iterator();
            int n5 = 0;
            String string10 = null;
            n3 = 0;
            while (object2.hasNext()) {
                if (n5 == 0) {
                    string10 = (String)object2.next();
                    ++n5;
                    continue;
                }
                object = (String)object2.next();
                if (((String)object).equals(string10)) continue;
                n3 = 1;
                break;
            }
            if (n3 != 0) {
                this.getDialogDataModel().putBoolean("NONE", true);
                if (nArray.length == n2) {
                    this.getDialogDataModel().putBoolean("STRING", true);
                } else if (n2 == 0) {
                    this.getDialogDataModel().putBoolean("STRING", false);
                } else {
                    this.getDialogDataModel().putBoolean("STRINGD", true);
                }
                DialogDataModel dialogDataModel = this.getDialogDataModel();
                dialogDataModel.putBoolean("IDS_AD_MEAN", true);
                super.runSubDialog(new AggregateFunction(this));
                this.updateListDataObjects(plainList, nArray);
                dialogDataModel.putBoolean("STRING", null);
                dialogDataModel.putBoolean("STRINGD", null);
                dialogDataModel.putBoolean("NONE", null);
                AggregateFunction.sIsContinueButtonPressed = false;
            } else {
                DialogDataModel dialogDataModel = this.getDialogDataModel();
                object = (ListData)plainList.getModel().getElementAt(0);
                string = (String)vector.get(0);
                String string11 = ((ListData)object).getResourceString(string);
                if (nArray.length == n2) {
                    this.getDialogDataModel().putBoolean("NONE", false);
                    this.getDialogDataModel().putBoolean("STRING", true);
                    dialogDataModel.putBoolean(string11, true);
                } else if (n2 == 0) {
                    this.getDialogDataModel().putBoolean("NONE", false);
                    this.getDialogDataModel().putBoolean("STRING", false);
                    dialogDataModel.putBoolean(string11, true);
                } else if (string11.equals("IDS_AD_PFC_ABOVE") || string11.equals("IDS_AD_PFC_BELOW") || string11.equals("IDS_AD_PFC_INSIDE") || string11.equals("IDS_AD_PFC_OUTSIDE")) {
                    this.getDialogDataModel().putBoolean("NONE", true);
                    this.getDialogDataModel().putBoolean("STRINGD", true);
                    dialogDataModel.putBoolean(string11, false);
                } else {
                    this.getDialogDataModel().putBoolean("NONE", false);
                    this.getDialogDataModel().putBoolean("STRINGD", true);
                    dialogDataModel.putBoolean(string11, true);
                }
                if (string11.equals("IDS_AD_PFC_ABOVE") || string11.equals("IDS_AD_PFC_BELOW")) {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        ListData listData = (ListData)plainList.getModel().getElementAt(nArray[i]);
                        if (listData.getMVariable().getType() == 0) {
                            dialogDataModel.putString("IDS_AD_PFC_VALUE_TXT", listData.getValue());
                            continue;
                        }
                        String string12 = listData.getValue();
                        String string13 = string12.substring(1, string12.length() - 1);
                        dialogDataModel.putString("IDS_AD_PFC_VALUE_TXT", string13);
                    }
                } else if (string11.equals("IDS_AD_PFC_INSIDE") || string11.equals("IDS_AD_PFC_OUTSIDE")) {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        ListData listData = (ListData)plainList.getModel().getElementAt(nArray[i]);
                        if (listData.getMVariable().getType() == 0) {
                            dialogDataModel.putString("IDS_AD_PFC_LOW_TXT", listData.getLow());
                            dialogDataModel.putString("IDS_AD_PFC_HIGH_TXT", listData.getHigh());
                            continue;
                        }
                        String string14 = listData.getLow();
                        String string15 = string14.substring(1, string14.length() - 1);
                        dialogDataModel.putString("IDS_AD_PFC_LOW_TXT", string15);
                        string14 = listData.getHigh();
                        string15 = string14.substring(1, string14.length() - 1);
                        dialogDataModel.putString("IDS_AD_PFC_HIGH_TXT", string15);
                    }
                }
                super.runSubDialog(new AggregateFunction(this));
                this.updateListDataObjects(plainList, nArray);
                dialogDataModel.putBoolean("STRING", null);
                dialogDataModel.putBoolean("STRINGD", null);
                dialogDataModel.putBoolean("NONE", null);
                AggregateFunction.sIsContinueButtonPressed = false;
            }
        }
    }

    private void updateListDataObjects(PlainList plainList, int[] nArray) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (AggregateFunction.sIsContinueButtonPressed) {
            if (dialogDataModel.getBoolean("IDS_AD_MEDIAN") != null && dialogDataModel.getBoolean("IDS_AD_MEDIAN").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string2 = listData.displayVal("IDS_AD_MEDIAN");
                    String string3 = string2 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_MEDIAN");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string2, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string3);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MEAN") != null && dialogDataModel.getBoolean("IDS_AD_MEAN").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string4 = listData.displayVal("IDS_AD_MEAN");
                    String string5 = string4 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_MEAN");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string4, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string5);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_DEVIATION") != null && dialogDataModel.getBoolean("IDS_AD_DEVIATION").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string6 = listData.displayVal("IDS_AD_DEVIATION");
                    String string7 = string6 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_DEVIATION");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string6, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string7);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_SUM") != null && dialogDataModel.getBoolean("IDS_AD_SUM").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string8 = listData.displayVal("IDS_AD_SUM");
                    String string9 = string8 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_SUM");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string8, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string9);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_FIRST") != null && dialogDataModel.getBoolean("IDS_AD_FIRST").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string10 = listData.displayVal("IDS_AD_FIRST");
                    String string11 = string10 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_FIRST");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string10, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string11);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_LAST") != null && dialogDataModel.getBoolean("IDS_AD_LAST").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string12 = listData.displayVal("IDS_AD_LAST");
                    String string13 = string12 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_LAST");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string12, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string13);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MAXIMUM") != null && dialogDataModel.getBoolean("IDS_AD_MAXIMUM").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string14 = listData.displayVal("IDS_AD_MAXIMUM");
                    String string15 = string14 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_MAXIMUM");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string14, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string15);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MINIMUM") != null && dialogDataModel.getBoolean("IDS_AD_MINIMUM").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string16 = listData.displayVal("IDS_AD_MINIMUM");
                    String string17 = string16 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_MINIMUM");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string16, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string17);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_WEIGHTED") != null && dialogDataModel.getBoolean("IDS_AD_WEIGHTED").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string18 = listData.displayVal("IDS_AD_WEIGHTED");
                    String string19 = string18 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_WEIGHTED");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string18, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string19);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_WEIGHTEDMISSING") != null && dialogDataModel.getBoolean("IDS_AD_WEIGHTEDMISSING").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string20 = listData.displayVal("IDS_AD_WEIGHTEDMISSING");
                    String string21 = string20 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_WEIGHTEDMISSING");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string20, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string21);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_UNWEIGHTED") != null && dialogDataModel.getBoolean("IDS_AD_UNWEIGHTED").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string22 = listData.displayVal("IDS_AD_UNWEIGHTED");
                    String string23 = string22 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_UNWEIGHTED");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string22, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string23);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_UNWEIGHTEDMISSING") != null && dialogDataModel.getBoolean("IDS_AD_UNWEIGHTEDMISSING").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    String string24 = listData.displayVal("IDS_AD_UNWEIGHTEDMISSING");
                    String string25 = string24 + "(" + string + ")";
                    listData.setDataResourceString("IDS_AD_UNWEIGHTEDMISSING");
                    listData.setValue(null);
                    listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string24, new ISpssVariable[0]));
                    listData.setSecondDisplaypart(string25);
                    if (!this.mAddVariablesRadio.isSelected()) continue;
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_ABOVE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_ABOVE").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    this.updateAboveBelow(dialogDataModel, listData, string, "IDS_AD_PFC_ABOVE", "IDS_AD_PFC_VALUE_TXT");
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_BELOW") != null && dialogDataModel.getBoolean("IDS_AD_PFC_BELOW").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    this.updateAboveBelow(dialogDataModel, listData, string, "IDS_AD_PFC_BELOW", "IDS_AD_PFC_VALUE_TXT");
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_INSIDE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_INSIDE").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    this.updateInsideOutside(dialogDataModel, listData, string, "IDS_AD_PFC_INSIDE", "IDS_AD_PFC_LOW_TXT", "IDS_AD_PFC_HIGH_TXT");
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_OUTSIDE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_OUTSIDE").booleanValue()) {
                for (int n : nArray) {
                    ListData listData = (ListData)plainList.getModel().getElementAt(n);
                    this.updatePFCType(listData);
                    String string = listData.getVarName();
                    this.updateInsideOutside(dialogDataModel, listData, string, "IDS_AD_PFC_OUTSIDE", "IDS_AD_PFC_LOW_TXT", "IDS_AD_PFC_HIGH_TXT");
                }
            }
            plainList.repaint();
            this.clearDDM();
        }
    }

    private void updateSingleListDataObject(PlainList plainList, ListData listData, String string) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.updatePFCType(listData);
        if (AggregateFunction.sIsContinueButtonPressed) {
            if (dialogDataModel.getBoolean("IDS_AD_MEDIAN") != null && dialogDataModel.getBoolean("IDS_AD_MEDIAN").booleanValue()) {
                String string2 = listData.displayVal("IDS_AD_MEDIAN");
                String string3 = string2 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_MEDIAN");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string2, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string3);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MEAN") != null && dialogDataModel.getBoolean("IDS_AD_MEAN").booleanValue()) {
                String string4 = listData.displayVal("IDS_AD_MEAN");
                String string5 = string4 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_MEAN");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string4, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string5);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_DEVIATION") != null && dialogDataModel.getBoolean("IDS_AD_DEVIATION").booleanValue()) {
                String string6 = listData.displayVal("IDS_AD_DEVIATION");
                String string7 = string6 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_DEVIATION");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string6, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string7);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_SUM") != null && dialogDataModel.getBoolean("IDS_AD_SUM").booleanValue()) {
                String string8 = listData.displayVal("IDS_AD_SUM");
                String string9 = string8 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_SUM");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string8, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string9);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_FIRST") != null && dialogDataModel.getBoolean("IDS_AD_FIRST").booleanValue()) {
                String string10 = listData.displayVal("IDS_AD_FIRST");
                String string11 = string10 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_FIRST");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string10, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string11);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_LAST") != null && dialogDataModel.getBoolean("IDS_AD_LAST").booleanValue()) {
                String string12 = listData.displayVal("IDS_AD_LAST");
                String string13 = string12 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_LAST");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string12, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string13);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MAXIMUM") != null && dialogDataModel.getBoolean("IDS_AD_MAXIMUM").booleanValue()) {
                String string14 = listData.displayVal("IDS_AD_MAXIMUM");
                String string15 = string14 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_MAXIMUM");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string14, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string15);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_MINIMUM") != null && dialogDataModel.getBoolean("IDS_AD_MINIMUM").booleanValue()) {
                String string16 = listData.displayVal("IDS_AD_MINIMUM");
                String string17 = string16 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_MINIMUM");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string16, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string17);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_WEIGHTED") != null && dialogDataModel.getBoolean("IDS_AD_WEIGHTED").booleanValue()) {
                String string18 = listData.displayVal("IDS_AD_WEIGHTED");
                String string19 = string18 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_WEIGHTED");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string18, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string19);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_WEIGHTEDMISSING") != null && dialogDataModel.getBoolean("IDS_AD_WEIGHTEDMISSING").booleanValue()) {
                String string20 = listData.displayVal("IDS_AD_WEIGHTEDMISSING");
                String string21 = string20 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_WEIGHTEDMISSING");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string20, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string21);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_UNWEIGHTED") != null && dialogDataModel.getBoolean("IDS_AD_UNWEIGHTED").booleanValue()) {
                String string22 = listData.displayVal("IDS_AD_UNWEIGHTED");
                String string23 = string22 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_UNWEIGHTED");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string22, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string23);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_UNWEIGHTEDMISSING") != null && dialogDataModel.getBoolean("IDS_AD_UNWEIGHTEDMISSING").booleanValue()) {
                String string24 = listData.displayVal("IDS_AD_UNWEIGHTEDMISSING");
                String string25 = string24 + "(" + string + ")";
                listData.setDataResourceString("IDS_AD_UNWEIGHTEDMISSING");
                listData.setValue(null);
                listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string24, new ISpssVariable[0]));
                listData.setSecondDisplaypart(string25);
                if (this.mAddVariablesRadio.isSelected()) {
                    this.deleteEmptyListObjects();
                }
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_ABOVE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_ABOVE").booleanValue()) {
                this.updateAboveBelow(dialogDataModel, listData, string, "IDS_AD_PFC_ABOVE", "IDS_AD_PFC_VALUE_TXT");
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_BELOW") != null && dialogDataModel.getBoolean("IDS_AD_PFC_BELOW").booleanValue()) {
                this.updateAboveBelow(dialogDataModel, listData, string, "IDS_AD_PFC_BELOW", "IDS_AD_PFC_VALUE_TXT");
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_INSIDE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_INSIDE").booleanValue()) {
                this.updateInsideOutside(dialogDataModel, listData, string, "IDS_AD_PFC_INSIDE", "IDS_AD_PFC_LOW_TXT", "IDS_AD_PFC_HIGH_TXT");
            } else if (dialogDataModel.getBoolean("IDS_AD_PFC_OUTSIDE") != null && dialogDataModel.getBoolean("IDS_AD_PFC_OUTSIDE").booleanValue()) {
                this.updateInsideOutside(dialogDataModel, listData, string, "IDS_AD_PFC_OUTSIDE", "IDS_AD_PFC_LOW_TXT", "IDS_AD_PFC_HIGH_TXT");
            }
            plainList.repaint();
            this.clearDDM();
        }
    }

    private void updatePFCType(ListData listData) {
        boolean bl;
        boolean bl2 = this.getDialogDataModel().getBoolean("IDS_AD_PERCENTAGES") != null && this.getDialogDataModel().getBoolean("IDS_AD_PERCENTAGES") != false;
        boolean bl3 = bl = this.getDialogDataModel().getBoolean("IDS_AD_FRACTIONS") != null && this.getDialogDataModel().getBoolean("IDS_AD_FRACTIONS") != false;
        short s = bl2 ? (short)0 : (bl ? (short)1 : 2);
        listData.setPFCType(s);
    }

    private void updateAboveBelow(DialogDataModel dialogDataModel, ListData listData, String string, String string2, String string3) {
        String string4 = listData.displayVal(string2);
        if (!this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
            listData.setValue(dialogDataModel.getString(string3));
        } else {
            listData.setValue("'" + dialogDataModel.getString(string3) + "'");
        }
        listData.setDataResourceString(string2);
        String string5 = string4 + "(" + string + " " + listData.getValue() + ")";
        listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string4, new ISpssVariable[0]));
        listData.setSecondDisplaypart(string5);
        if (this.mAddVariablesRadio.isSelected()) {
            this.deleteEmptyListObjects();
        }
    }

    private void updateInsideOutside(DialogDataModel dialogDataModel, ListData listData, String string, String string2, String string3, String string4) {
        String string5 = listData.displayVal(string2);
        if (!this.getDialogDataModel().getBoolean("STRING").booleanValue()) {
            listData.setLow(dialogDataModel.getString(string3));
            listData.setHigh(dialogDataModel.getString(string4));
        } else {
            listData.setLow("'" + dialogDataModel.getString(string3) + "'");
            listData.setHigh("'" + dialogDataModel.getString(string4) + "'");
        }
        listData.setDataResourceString(string2);
        String string6 = string5 + "(" + string + " " + listData.getLow() + " " + listData.getHigh() + ")";
        listData.setFirstDisplayPart(this.getFirstDisplayValue(listData.getVarName(), string5, new ISpssVariable[0]));
        listData.setSecondDisplaypart(string6);
        if (this.mAddVariablesRadio.isSelected()) {
            this.deleteEmptyListObjects();
        }
    }

    private void clearDDM() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putBoolean("IDS_AD_MEAN", null);
        dialogDataModel.putBoolean("IDS_AD_MEDIAN", null);
        dialogDataModel.putBoolean("IDS_AD_DEVIATION", null);
        dialogDataModel.putBoolean("IDS_AD_SUM", null);
        dialogDataModel.putBoolean("IDS_AD_FIRST", null);
        dialogDataModel.putBoolean("IDS_AD_MAXIMUM", null);
        dialogDataModel.putBoolean("IDS_AD_MINIMUM", null);
        dialogDataModel.putBoolean("IDS_AD_LAST", null);
        dialogDataModel.putBoolean("IDS_AD_WEIGHTED", null);
        dialogDataModel.putBoolean("IDS_AD_WEIGHTEDMISSING", null);
        dialogDataModel.putBoolean("IDS_AD_UNWEIGHTED", null);
        dialogDataModel.putBoolean("IDS_AD_UNWEIGHTEDMISSING", null);
        dialogDataModel.putBoolean("IDS_AD_PFC_ABOVE", null);
        dialogDataModel.putBoolean("IDS_AD_PFC_BELOW", null);
        dialogDataModel.putBoolean("IDS_AD_PFC_INSIDE", null);
        dialogDataModel.putBoolean("IDS_AD_PFC_OUTSIDE", null);
        dialogDataModel.putString("IDS_AD_PFC_VALUE_TXT", null);
        dialogDataModel.putString("IDS_AD_PFC_LOW_TXT", null);
        dialogDataModel.putString("IDS_AD_PFC_HIGH_TXT", null);
    }

    private void runNameLabelSubDlg() {
        String string;
        PlainList plainList = this.getPlainlist();
        ListData listData = (ListData)plainList.getModel().getElementAt(plainList.getSelectedIndex());
        String string2 = listData.getFirstDisplayPart();
        String string3 = listData.getSecondDisplaypart();
        if (string3.contains("PGT") || string3.contains("PLT") || string3.contains("PIN") || string3.contains("POUT") || string3.contains("FGT") || string3.contains("FLT") || string3.contains("FIN") || string3.contains("FOUT")) {
            int n = string3.indexOf("(");
            String string4 = string3.substring(n + 1, string3.indexOf(")", n));
            string3 = string3.replace(string4, UIToolResUtil.addLocale((String)string4));
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        int n = string2.indexOf("'");
        if (n == -1) {
            dialogDataModel.putString("IDS_AD_VARIABLE_NAME_TXT", string2);
            dialogDataModel.putString("IDS_AD_VARIABLE_DESC_TXT", string3);
            dialogDataModel.putString("IDS_AD_VARIABLE_LABEL_TXT", null);
        } else {
            string = string2.substring(n + 1, string2.length() - 1);
            dialogDataModel.putString("IDS_AD_VARIABLE_NAME_TXT", string2.substring(0, n - 1));
            dialogDataModel.putString("IDS_AD_VARIABLE_LABEL_TXT", string);
            dialogDataModel.putString("IDS_AD_VARIABLE_DESC_TXT", string3);
        }
        this.runSubDialog(new AggregateNameLabel(this));
        dialogDataModel = this.getDialogDataModel();
        listData.setName(dialogDataModel.getString("IDS_AD_VARIABLE_NAME_TXT"));
        listData.setTop(dialogDataModel.getString("IDS_AD_VARIABLE_DESC_TXT"));
        listData.setLabel(dialogDataModel.getString("IDS_AD_VARIABLE_LABEL_TXT"));
        if (listData.getLabel() == null || listData.getLabel().equals("")) {
            listData.setFirstDisplayPart(listData.getName());
        } else {
            string = CharacterUtil.smartQuote((String)listData.getLabel());
            listData.setFirstDisplayPart(listData.getName() + " " + string);
        }
        listData.setSecondDisplaypart(listData.getSecondDisplaypart());
        plainList.repaint();
        dialogDataModel.putString("IDS_AD_VARIABLE_NAME_TXT", null);
        dialogDataModel.putString("IDS_AD_VARIABLE_DESC_TXT", null);
        dialogDataModel.putString("IDS_AD_VARIABLE_LABEL_TXT", null);
    }

    private void stateOfArrowButton(PlainList plainList) {
        if (plainList == this.mSummariesTargetList) {
            this.mSummariesArrowButton.setEnabled(this.mSummariesTargetList.getModel().getSize() > 0 && this.mSummariesTargetList.getSelectedIndex() != -1);
            this.mSummariesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
    }

    private void stateOfArrowButtons(boolean bl) {
        this.mSummariesArrowButton.setEnabled(bl);
        this.mSummariesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    public class ListData
    implements SerializableObject {
        ISpssVariable mVariable;
        short mVarType;
        String mVarName;
        String mFirstDisplayPart = "";
        String mSecondDisplaypart = "";
        String mDataResourceString = "";
        String mFunctionValue = "";
        String mFunctionLow = "";
        String mFunctionHigh = "";
        String mNameLabelTop = "";
        String mNameLabelName = "";
        String mNameLabelLabel = "";
        short mPFCType = 0;

        ListData(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
            this.mVarName = iSpssVariable.getName();
            if (this.mVariable.getType() != 0) {
                this.mDataResourceString = "IDS_AD_FIRST";
                this.mVarType = this.mVariable.getType();
            } else {
                this.mDataResourceString = "IDS_AD_MEAN";
                this.mVarType = this.mVariable.getType();
            }
        }

        public String getDataResourceString() {
            return this.mDataResourceString;
        }

        public void setDataResourceString(String string) {
            this.mDataResourceString = string;
        }

        public String getFirstDisplayPart() {
            return this.mFirstDisplayPart;
        }

        public void setFirstDisplayPart(String string) {
            this.mFirstDisplayPart = string;
        }

        public String getSecondDisplaypart() {
            return this.mSecondDisplaypart;
        }

        public void setSecondDisplaypart(String string) {
            this.mSecondDisplaypart = string;
        }

        public String getVarName() {
            return this.mVarName;
        }

        public void setVarName(String string) {
            this.mVarName = string;
        }

        public String getHigh() {
            return this.mFunctionHigh;
        }

        public void setHigh(String string) {
            this.mFunctionHigh = string;
        }

        public String getLow() {
            return this.mFunctionLow;
        }

        public void setLow(String string) {
            this.mFunctionLow = string;
        }

        public String getValue() {
            return this.mFunctionValue;
        }

        public void setValue(String string) {
            this.mFunctionValue = string;
        }

        public String getLabel() {
            return this.mNameLabelLabel;
        }

        public void setLabel(String string) {
            this.mNameLabelLabel = string;
        }

        public String getName() {
            return this.mNameLabelName;
        }

        public void setName(String string) {
            this.mNameLabelName = string;
        }

        public String getTop() {
            return this.mNameLabelTop;
        }

        public void setTop(String string) {
            this.mNameLabelTop = string;
        }

        public ISpssVariable getMVariable() {
            return this.mVariable;
        }

        public void setMVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public short getMVarType() {
            return this.mVarType;
        }

        public void setMVarType(short s) {
            this.mVarType = s;
        }

        public short getPFCType() {
            return this.mPFCType;
        }

        public void setPFCType(short s) {
            this.mPFCType = s;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateDlg$ListData";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mVarName = objectInputStream.readUTF();
            this.mDataResourceString = objectInputStream.readUTF();
            this.mVarType = (short)objectInputStream.readInt();
            this.mFirstDisplayPart = objectInputStream.readUTF();
            this.mSecondDisplaypart = objectInputStream.readUTF();
            this.mFunctionValue = objectInputStream.readUTF();
            this.mFunctionLow = objectInputStream.readUTF();
            this.mFunctionHigh = objectInputStream.readUTF();
            this.mNameLabelTop = objectInputStream.readUTF();
            this.mNameLabelName = objectInputStream.readUTF();
            this.mNameLabelLabel = objectInputStream.readUTF();
            this.mPFCType = (short)objectInputStream.readInt();
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mVarName);
            objectOutputStream.writeUTF(this.mDataResourceString);
            objectOutputStream.writeInt(this.mVarType);
            objectOutputStream.writeUTF(this.mFirstDisplayPart);
            objectOutputStream.writeUTF(this.mSecondDisplaypart);
            objectOutputStream.writeUTF(this.mFunctionValue);
            objectOutputStream.writeUTF(this.mFunctionLow);
            objectOutputStream.writeUTF(this.mFunctionHigh);
            objectOutputStream.writeUTF(this.mNameLabelTop);
            objectOutputStream.writeUTF(this.mNameLabelName);
            objectOutputStream.writeUTF(this.mNameLabelLabel);
            objectOutputStream.writeInt(this.mPFCType);
            return true;
        }

        public String displayVal(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("IDS_AD_MEAN", "MEAN");
            hashMap.put("IDS_AD_MEDIAN", "MEDIAN");
            hashMap.put("IDS_AD_DEVIATION", "SD");
            hashMap.put("IDS_AD_SUM", "SUM");
            hashMap.put("IDS_AD_FIRST", "FIRST");
            hashMap.put("IDS_AD_LAST", "LAST");
            hashMap.put("IDS_AD_MAXIMUM", "MAX");
            hashMap.put("IDS_AD_MINIMUM", "MIN");
            hashMap.put("IDS_AD_WEIGHTED", "N");
            hashMap.put("IDS_AD_WEIGHTEDMISSING", "NMISS");
            hashMap.put("IDS_AD_UNWEIGHTED", "NU");
            hashMap.put("IDS_AD_UNWEIGHTEDMISSING", "NUMISS");
            hashMap.put("IDS_AD_PFC_ABOVE", this.mPFCType == 0 ? "PGT" : (this.mPFCType == 1 ? "FGT" : "CGT"));
            hashMap.put("IDS_AD_PFC_BELOW", this.mPFCType == 0 ? "PLT" : (this.mPFCType == 1 ? "FLT" : "CLT"));
            hashMap.put("IDS_AD_PFC_INSIDE", this.mPFCType == 0 ? "PIN" : (this.mPFCType == 1 ? "FIN" : "CIN"));
            hashMap.put("IDS_AD_PFC_OUTSIDE", this.mPFCType == 0 ? "POUT" : (this.mPFCType == 1 ? "FOUT" : "COUT"));
            for (String string2 : hashMap.keySet()) {
                if (!string2.equals(string)) continue;
                return (String)hashMap.get(string2);
            }
            return null;
        }

        public String getResourceString(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("MEAN", "IDS_AD_MEAN");
            hashMap.put("MEDIAN", "IDS_AD_MEDIAN");
            hashMap.put("SD", "IDS_AD_DEVIATION");
            hashMap.put("SUM", "IDS_AD_SUM");
            hashMap.put("FIRST", "IDS_AD_FIRST");
            hashMap.put("LAST", "IDS_AD_LAST");
            hashMap.put("MAX", "IDS_AD_MAXIMUM");
            hashMap.put("MIN", "IDS_AD_MINIMUM");
            hashMap.put("N", "IDS_AD_WEIGHTED");
            hashMap.put("NMISS", "IDS_AD_WEIGHTEDMISSING");
            hashMap.put("NU", "IDS_AD_UNWEIGHTED");
            hashMap.put("NUMISS", "IDS_AD_UNWEIGHTEDMISSING");
            hashMap.put("PGT", "IDS_AD_PFC_ABOVE");
            hashMap.put("PLT", "IDS_AD_PFC_BELOW");
            hashMap.put("PIN", "IDS_AD_PFC_INSIDE");
            hashMap.put("POUT", "IDS_AD_PFC_OUTSIDE");
            hashMap.put("FGT", "IDS_AD_PFC_ABOVE");
            hashMap.put("FLT", "IDS_AD_PFC_BELOW");
            hashMap.put("FIN", "IDS_AD_PFC_INSIDE");
            hashMap.put("FOUT", "IDS_AD_PFC_OUTSIDE");
            hashMap.put("CGT", "IDS_AD_PFC_ABOVE");
            hashMap.put("CLT", "IDS_AD_PFC_BELOW");
            hashMap.put("CIN", "IDS_AD_PFC_INSIDE");
            hashMap.put("COUT", "IDS_AD_PFC_OUTSIDE");
            for (String string2 : hashMap.keySet()) {
                if (!string2.equals(string)) continue;
                return (String)hashMap.get(string2);
            }
            return null;
        }
    }

    class AggregateVarMoveHandler
    implements IVarMoveHandler {
        AggregateVarMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            boolean bl = true;
            if (variableList.equals(AggregateDlg.this.mBreakTargetList)) {
                ISpssVariable[] iSpssVariableArray2;
                AggregateDlg.this.enableOkPaste(AggregateDlg.this.canEnableOkPaste());
                for (ISpssVariable iSpssVariable : iSpssVariableArray2 = AggregateDlg.this.mSrcVarList.getSelectedValues()) {
                    for (int i = 0; i < AggregateDlg.this.mSummariesTargetList.getModel().getSize(); ++i) {
                        ListData listData = (ListData)AggregateDlg.this.mSummariesTargetList.getModel().getElementAt(i);
                        if (!listData.getVarName().equalsIgnoreCase(iSpssVariable.getName())) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)AggregateDlg.this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        AggregateDlg.this.mSrcVarList.setSelection(iSpssVariableArray);
                        bl = false;
                        break;
                    }
                    if (!bl) break;
                }
            }
            return bl;
        }
    }
}

