/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class WeightCasesDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener {
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private JRadioButton mDoNotWeightCasesRadio;
    private JRadioButton mWeightCasesByRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private JLabel mFrequencyVariableLabel;
    private JLabel mCurrentStatusLabel;

    public WeightCasesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_WC_WEIGHT_CASES"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("WEIGHT"));
        if (this.mWeightCasesByRadio.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY ") + this.getTargetVariableName());
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "data_weight_cases";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_weig";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this.mWeightCasesByRadio) && bl) {
            this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            if (this.mTargetVarList.getModel().getSize() > 0) {
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                this.mArrowButton.setEnabled(true);
                this.enableOkPaste(bl);
            } else {
                this.enableOkPaste(!bl);
                this.mArrowButton.setEnabled(bl && this.mSrcVarList.getSelectedIndices().length == 1);
            }
            this.mFrequencyVariableLabel.setEnabled(bl);
            this.mTargetVarList.setEnabled(bl);
            this.mTargetVarList.setOpaque(true);
        } else if (object.equals(this.mDoNotWeightCasesRadio) && bl) {
            this.enableOkPaste(bl);
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mFrequencyVariableLabel.setEnabled(!bl);
            this.mArrowButton.setEnabled(!bl);
            this.mTargetVarList.setEnabled(!bl);
            this.mTargetVarList.setOpaque(false);
            this.mArrowButton.unRegisterVariableList(this.mSrcVarList);
        }
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupSrcList(jPanel);
        JPanel jPanel2 = this.setupWeightCasesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCurrentStatusLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_WC_DO_NOT_WEIGHT_CASES");
        this.mDoNotWeightCasesRadio = new JRadioButton(toggleButtonAction);
        this.mDoNotWeightCasesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_WC_WEIGHT_CASES_BY");
        this.mWeightCasesByRadio = new JRadioButton(toggleButtonAction);
        this.mWeightCasesByRadio.addItemListener(this);
        this.mFrequencyVariableLabel = DialogUtil.createLabel(this, "IDS_WC_FREQUENCY_VARIABLE_LABEL");
        this.mFrequencyVariableLabel.setLabelFor(this.mTargetVarList);
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getWeightVarIndex();
        this.mCurrentStatusLabel = n == -1 ? new JLabel(this.getResString("IDS_WC_CURRENT_STATUS_LABEL") + this.getResString("IDS_WC_STATUS_DO_NOT_WEIGHT_CASES")) : new JLabel(this.getResString("IDS_WC_CURRENT_STATUS_LABEL") + this.getResString("IDS_WC_STATUS_WEIGHT_CASES_BY") + iSpssDataSrc.getVariable(n).getName());
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
        this.mDoNotWeightCasesRadio.setSelected(true);
        this.mFrequencyVariableLabel.setEnabled(false);
        this.mTargetVarList.setEnabled(false);
        this.mArrowButton.setEnabled(false);
        this.enableOkPaste(true);
    }

    private void setupSrcList(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        int n = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_WC_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 2, n, null);
    }

    private JPanel setupWeightCasesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JPanel jPanel2 = this.setupRadioPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupTargetListPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupRadioPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDoNotWeightCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mWeightCasesByRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupTargetListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 20;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 0, 0, 1, 2, n, insets);
        n = 23;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFrequencyVariableLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getComponentGroupGap());
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private String getTargetVariableName() {
        String string = "";
        if (this.mTargetVarList.getModel().getSize() > 0) {
            SpssVariable spssVariable = (SpssVariable)this.mTargetVarList.getModel().getElementAt(0);
            string = spssVariable.getName();
        }
        return string;
    }
}

