/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TransposeDlg
extends BaseProcedureDialog
implements ListDataListener {
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mNameVarList;
    private ArrowButton mVariableArrowButton;
    private ArrowButton mNameVariableArrowButton;

    public TransposeDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TRANSPOSE"));
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_flip";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = new StringBuffer(SyntaxUtil.startSyntax().toString());
        stringBuffer.append(SyntaxUtil.getMainCommand("FLIP"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES=").toString()).append(this.mTargetVarList.getVariablesStringList()).append("\n");
        if (this.mNameVarList.getModel().getSize() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/NEWNAMES=")).append(this.mNameVarList.getVariablesStringList()).append("\n");
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        String string = DataDocument.getNextFreeDatasetName();
        stringBuffer.append("DATASET NAME ").append(string).append(" WINDOW=FRONT.\n");
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "data_transpose";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mNameVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public boolean okPastePressed() {
        int n;
        boolean bl = super.okPastePressed();
        if (bl && this.mSrcVarList.getModel().getSize() != 0 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_TRANSPOSE_OKPASTE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
            return false;
        }
        return bl;
    }

    protected void updateOkAndPaste() {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TRANSPOSE_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mVariableArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mTargetVarList);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(n2, 0, 0, 0);
        jLabel2 = DialogUtil.createLabel(this, "IDS_NAME_VARIABLE_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        n = 20;
        jScrollPane = new JScrollPane(this.mNameVarList);
        jScrollPane.setPreferredSize(this.mNameVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mNameVarList);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mNameVariableArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        this.pack();
        this.updateOkAndPaste();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.setIdentifier("TransposeSrcList");
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setIdentifier("TransposeDepList");
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mNameVarList = new TargetVariableList(targetListType);
        this.mNameVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mNameVarList.setIdentifier("TransposeNameList");
        this.mNameVarList.getModel().addListDataListener(this);
        this.mVariableArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNameVariableArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mNameVariableArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mNameVariableArrowButton.registerVariableList(this.mNameVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVariableArrowButton);
        vector.add(this.mNameVariableArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNameVarList);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }
}

