/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SplitFileDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private SrcVariableList mSrcList;
    private TargetVariableList mTargetList;
    private ArrowButton mArrowButton;
    private JLabel mGroupsBasedOnLabel;
    private JRadioButton mAnalyzeRadioButton;
    private JRadioButton mCompareRadioButton;
    private JRadioButton mOrganizeRadioButton;
    private JRadioButton mSortFileRadioButton;
    private JRadioButton mFileSortedRadioButton;
    private GridBagConstraints mConstraints;
    private JTextArea mCurrentStatusTextArea;

    public SplitFileDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, DataResBundle.getDefaultResourceBundleName(), DataResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SPLITFILE_DIALOG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (this.mSortFileRadioButton.isEnabled() && this.mSortFileRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY "));
            stringBuffer.append(this.mTargetList.getVariablesStringList());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("SPLIT FILE"));
        if (this.mAnalyzeRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else if (this.mCompareRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("LAYERED BY "));
            stringBuffer.append(this.mTargetList.getVariablesStringList());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else if (this.mOrganizeRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("SEPARATE BY "));
            stringBuffer.append(this.mTargetList.getVariablesStringList());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_spli";
    }

    @Override
    public String getIActionKey() {
        return "data_split_file";
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        if (this.mOrganizeRadioButton.isSelected() || this.mCompareRadioButton.isSelected()) {
            this.mGroupsBasedOnLabel.setEnabled(true);
            this.mArrowButton.setEnabled(true);
            this.mTargetList.setEnabled(true);
            this.mTargetList.setOpaque(true);
            this.mSortFileRadioButton.setEnabled(true);
            this.mFileSortedRadioButton.setEnabled(true);
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        boolean bl = iSpssDataSrc.getSplitqSeparate();
        if (n == 0) {
            this.mCurrentStatusTextArea.setText(this.getResString("IDS_SPLITFILE_CURRENT_STATUS_LABEL"));
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                LocallyUniqueId locallyUniqueId2 = iSpssDataSrc.getSplitVarID(i);
                if (locallyUniqueId2 == null) continue;
                stringBuffer.append(iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(locallyUniqueId2)).getName()).append(" ");
            }
            String string = stringBuffer.toString();
            if (bl) {
                this.mCurrentStatusTextArea.setText(this.getResString("IDS_SPLITFILE_ORGANIZE_CURRENT_STATUS_LABEL") + string);
            } else {
                this.mCurrentStatusTextArea.setText(this.getResString("IDS_SPLITFILE_COMPARE_CURRENT_STATUS_LABEL") + string);
            }
        }
        if (this.mSrcList.getModel().getSize() > 0) {
            this.mSrcList.setSelectedIndex(0);
            this.mSrcList.requestFocus();
        }
        if (!this.isShowing()) {
            this.setVisible(true);
        }
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canOkPasteEnabled());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canOkPasteEnabled());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCompareRadioButton || itemEvent.getSource() == this.mOrganizeRadioButton) {
            this.enableOkPaste(this.canOkPasteEnabled());
        } else {
            this.enableOkPaste(true);
        }
        this.enableDisableTargetList();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mConstraints = new GridBagConstraints();
        this.mSrcList = new SrcVariableList();
        this.mSrcList.setShowVarLabels(true, false);
        this.mGroupsBasedOnLabel = DialogUtil.createLabel(this, "IDS_SPLITFILE_GROUPS_BASED_ON_LABEL");
        this.mTargetList = new TargetVariableList();
        this.mTargetList.getModel().addListDataListener(this);
        this.mTargetList.setMaxLimitOfList(8);
        this.mGroupsBasedOnLabel.setLabelFor(this.mTargetList);
        this.mArrowButton = new ArrowButton();
        this.mArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mAnalyzeRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SPLITFILE_ANALYZE_RADIOBUTTON"));
        this.mCompareRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SPLITFILE_COMPARE_RADIOBUTTON"));
        this.mOrganizeRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SPLITFILE_ORGANIZE_RADIOBUTTON"));
        this.mSortFileRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SPLITFILE_SORT_FILE_RADIOBUTTON"));
        this.mFileSortedRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SPLITFILE_FILE_SORTED_RADIOBUTTON"));
        this.mAnalyzeRadioButton.addItemListener(this);
        this.mCompareRadioButton.addItemListener(this);
        this.mOrganizeRadioButton.addItemListener(this);
        this.mCurrentStatusTextArea = new JTextArea(this.getResString("IDS_SPLITFILE_CURRENT_STATUS_LABEL"));
        this.mCurrentStatusTextArea.setLineWrap(true);
        this.mCurrentStatusTextArea.setWrapStyleWord(true);
        this.mCurrentStatusTextArea.setRows(3);
        this.mCurrentStatusTextArea.setOpaque(false);
        this.mCurrentStatusTextArea.setEditable(false);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAnalyzeRadioButton);
        spssButtonGroup.add(this.mCompareRadioButton);
        spssButtonGroup.add(this.mOrganizeRadioButton);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mSortFileRadioButton);
        spssButtonGroup2.add(this.mFileSortedRadioButton);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(spssButtonGroup);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        vector.add(spssButtonGroup2);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSrcList.loadFromActiveDataset();
        this.mAnalyzeRadioButton.setSelected(true);
        this.mSortFileRadioButton.setSelected(true);
        this.mTargetList.getModel().removeAll();
        this.mGroupsBasedOnLabel.setEnabled(false);
        this.mArrowButton.setEnabled(false);
        this.mTargetList.setEnabled(false);
        this.mTargetList.setOpaque(false);
        this.mSortFileRadioButton.setEnabled(false);
        this.mFileSortedRadioButton.setEnabled(false);
        this.mSrcList.requestFocus();
        this.mSrcList.setSelectedIndex(0);
        this.enableOkPaste(true);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, 0);
        int n3 = DialogUtil.getComponentGroupGap();
        JComponent[] jComponentArray = new JComponent[]{this.mAnalyzeRadioButton, this.mCompareRadioButton, this.mOrganizeRadioButton};
        JComponent[] jComponentArray2 = new JComponent[]{this.mSortFileRadioButton, this.mFileSortedRadioButton};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        JPanel jPanel4 = this.setupGroupsBasedOnPanel();
        JPanel jPanel5 = PanelFactory.getBasicPanel(jComponentArray2, PanelFactory.PanelType.yaxis, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, this.mConstraints, 0, 0, 1, 3, n, insets);
        this.mConstraints.fill = 2;
        this.mConstraints.weighty = 0.0;
        insets.set(n2, n3, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, this.mConstraints, 1, 0, 1, 1, n, insets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel4, this.mConstraints, 1, 1, 1, 1, n, null);
        this.mConstraints.weighty = 0.0;
        insets.set(n3, n3, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, jPanel5, this.mConstraints, 1, 2, 1, 1, n, insets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        insets.set(n3, n2, 0, n2);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel6, this.mCurrentStatusTextArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel6, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    private JPanel setupGroupsBasedOnPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mGroupsBasedOnLabel, this.mConstraints, 1, 0, 1, 1, n, insets2);
        this.mConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, this.mConstraints, 0, 1, 1, 1, 10, DialogUtil.getArrowButtonInsets());
        insets2.set(insets.top, 0, 0, n2);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private boolean canOkPasteEnabled() {
        return !this.mCompareRadioButton.isSelected() && !this.mOrganizeRadioButton.isSelected() || this.mTargetList.getModel().getSize() != 0;
    }

    private void enableDisableTargetList() {
        if (this.mCompareRadioButton.isSelected() || this.mOrganizeRadioButton.isSelected()) {
            this.mGroupsBasedOnLabel.setEnabled(true);
            this.mArrowButton.setEnabled(true);
            this.mTargetList.setEnabled(true);
            this.mTargetList.setOpaque(true);
            this.mSortFileRadioButton.setEnabled(true);
            this.mFileSortedRadioButton.setEnabled(true);
        } else {
            this.mGroupsBasedOnLabel.setEnabled(false);
            this.mArrowButton.setEnabled(false);
            this.mTargetList.setEnabled(false);
            this.mTargetList.setOpaque(false);
            this.mSortFileRadioButton.setEnabled(false);
            this.mFileSortedRadioButton.setEnabled(false);
        }
    }

    @Override
    public boolean okPastePressed() {
        return this.validateDialog() && super.okPastePressed();
    }

    private boolean validateDialog() {
        boolean bl = true;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
            if (iSpssDataSrc != null && iSpssDataSrc.findVarIndex("Imputation_") != -1) {
                if (this.mAnalyzeRadioButton.isSelected()) {
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this), this.getResString("ERR_SPLITFILE_ALERT_MI_ANALYZE_ALL"), VersionInfo.getAppVersionString(), 0);
                    if (n == 1) {
                        this.mSrcList.setSelectedIndex(0);
                        this.mSrcList.requestFocus();
                        bl = false;
                    }
                } else if (this.mCompareRadioButton.isSelected() || this.mOrganizeRadioButton.isSelected()) {
                    String string = this.mTargetList.getVariablesStringList().toUpperCase();
                    if (!string.contains("Imputation_".toUpperCase())) {
                        Object[] objectArray = new String[]{ResUtil.getCommonDlgString("IDS_CONTINUE"), ResUtil.getCommonDlgString("IDS_RETURN_TO_DIALOG")};
                        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_SPLITFILE_ALERT_MI_YES_GROUP_NOT_SELECTED"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
                        if (n == 1) {
                            this.mSrcList.setSelectedIndex(0);
                            this.mSrcList.requestFocus();
                            return false;
                        }
                    } else if (this.mOrganizeRadioButton.isSelected()) {
                        Object[] objectArray = new String[]{ResUtil.getCommonDlgString("IDS_CONTINUE"), ResUtil.getCommonDlgString("IDS_RETURN_TO_DIALOG")};
                        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_SPLITFILE_ALERT_MI_NO_GROUP_NOT_SELECTED"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
                        if (n == 1) {
                            this.mCompareRadioButton.requestFocus();
                            return false;
                        }
                    }
                }
            }
        }
        return bl;
    }
}

